# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import rqd_pb2 as rqd__pb2


class RqdInterfaceStub(object):
    """Interface for issuing commands to an RQD instance.

    -------- Services --------]

    Implemented by the Rqd server. Called by cuebot and tools.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetRunFrame = channel.unary_unary(
                '/rqd.RqdInterface/GetRunFrame',
                request_serializer=rqd__pb2.RqdStaticGetRunFrameRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticGetRunFrameResponse.FromString,
                )
        self.GetRunningFrameStatus = channel.unary_unary(
                '/rqd.RqdInterface/GetRunningFrameStatus',
                request_serializer=rqd__pb2.RqdStaticGetRunningFrameStatusRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticGetRunningFrameStatusResponse.FromString,
                )
        self.KillRunningFrame = channel.unary_unary(
                '/rqd.RqdInterface/KillRunningFrame',
                request_serializer=rqd__pb2.RqdStaticKillRunningFrameRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticKillRunningFrameResponse.FromString,
                )
        self.LaunchFrame = channel.unary_unary(
                '/rqd.RqdInterface/LaunchFrame',
                request_serializer=rqd__pb2.RqdStaticLaunchFrameRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticLaunchFrameResponse.FromString,
                )
        self.Lock = channel.unary_unary(
                '/rqd.RqdInterface/Lock',
                request_serializer=rqd__pb2.RqdStaticLockRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticLockResponse.FromString,
                )
        self.LockAll = channel.unary_unary(
                '/rqd.RqdInterface/LockAll',
                request_serializer=rqd__pb2.RqdStaticLockAllRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticLockAllResponse.FromString,
                )
        self.NimbyOff = channel.unary_unary(
                '/rqd.RqdInterface/NimbyOff',
                request_serializer=rqd__pb2.RqdStaticNimbyOffRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticNimbyOffResponse.FromString,
                )
        self.NimbyOn = channel.unary_unary(
                '/rqd.RqdInterface/NimbyOn',
                request_serializer=rqd__pb2.RqdStaticNimbyOnRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticNimbyOnResponse.FromString,
                )
        self.RebootIdle = channel.unary_unary(
                '/rqd.RqdInterface/RebootIdle',
                request_serializer=rqd__pb2.RqdStaticRebootIdleRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticRebootIdleResponse.FromString,
                )
        self.RebootNow = channel.unary_unary(
                '/rqd.RqdInterface/RebootNow',
                request_serializer=rqd__pb2.RqdStaticRebootNowRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticRebootNowResponse.FromString,
                )
        self.ReportStatus = channel.unary_unary(
                '/rqd.RqdInterface/ReportStatus',
                request_serializer=rqd__pb2.RqdStaticReportStatusRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticReportStatusResponse.FromString,
                )
        self.RestartRqdIdle = channel.unary_unary(
                '/rqd.RqdInterface/RestartRqdIdle',
                request_serializer=rqd__pb2.RqdStaticRestartIdleRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticRestartIdleResponse.FromString,
                )
        self.RestartRqdNow = channel.unary_unary(
                '/rqd.RqdInterface/RestartRqdNow',
                request_serializer=rqd__pb2.RqdStaticRestartNowRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticRestartNowResponse.FromString,
                )
        self.ShutdownRqdIdle = channel.unary_unary(
                '/rqd.RqdInterface/ShutdownRqdIdle',
                request_serializer=rqd__pb2.RqdStaticShutdownIdleRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticShutdownIdleResponse.FromString,
                )
        self.ShutdownRqdNow = channel.unary_unary(
                '/rqd.RqdInterface/ShutdownRqdNow',
                request_serializer=rqd__pb2.RqdStaticShutdownNowRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticShutdownNowResponse.FromString,
                )
        self.Unlock = channel.unary_unary(
                '/rqd.RqdInterface/Unlock',
                request_serializer=rqd__pb2.RqdStaticUnlockRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticUnlockResponse.FromString,
                )
        self.UnlockAll = channel.unary_unary(
                '/rqd.RqdInterface/UnlockAll',
                request_serializer=rqd__pb2.RqdStaticUnlockAllRequest.SerializeToString,
                response_deserializer=rqd__pb2.RqdStaticUnlockAllResponse.FromString,
                )


class RqdInterfaceServicer(object):
    """Interface for issuing commands to an RQD instance.

    -------- Services --------]

    Implemented by the Rqd server. Called by cuebot and tools.
    """

    def GetRunFrame(self, request, context):
        """[Deprecated] Return the RunFrame by id
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetRunningFrameStatus(self, request, context):
        """Return the RunningFrameStatus report
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def KillRunningFrame(self, request, context):
        """Kill the running frame by frame id
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LaunchFrame(self, request, context):
        """Launch a new running frame
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Lock(self, request, context):
        """Lock a number of cores
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LockAll(self, request, context):
        """Lock all
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def NimbyOff(self, request, context):
        """Disable NIMBY on host
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def NimbyOn(self, request, context):
        """Enable NIMBY on host
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RebootIdle(self, request, context):
        """Reboot the host when it becomes idle
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RebootNow(self, request, context):
        """[Deprecated] Reboot the host now
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReportStatus(self, request, context):
        """Return the HostReport
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RestartRqdIdle(self, request, context):
        """[Deprecated] Restart the rqd process when it becomes idle
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RestartRqdNow(self, request, context):
        """[Deprecated] Restart rqd process now
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ShutdownRqdIdle(self, request, context):
        """[Deprecated] Turn off rqd when it becomes idle
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ShutdownRqdNow(self, request, context):
        """Stop rqd now
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Unlock(self, request, context):
        """Unlock a number of cores
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UnlockAll(self, request, context):
        """Unlock all cores
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RqdInterfaceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetRunFrame': grpc.unary_unary_rpc_method_handler(
                    servicer.GetRunFrame,
                    request_deserializer=rqd__pb2.RqdStaticGetRunFrameRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticGetRunFrameResponse.SerializeToString,
            ),
            'GetRunningFrameStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.GetRunningFrameStatus,
                    request_deserializer=rqd__pb2.RqdStaticGetRunningFrameStatusRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticGetRunningFrameStatusResponse.SerializeToString,
            ),
            'KillRunningFrame': grpc.unary_unary_rpc_method_handler(
                    servicer.KillRunningFrame,
                    request_deserializer=rqd__pb2.RqdStaticKillRunningFrameRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticKillRunningFrameResponse.SerializeToString,
            ),
            'LaunchFrame': grpc.unary_unary_rpc_method_handler(
                    servicer.LaunchFrame,
                    request_deserializer=rqd__pb2.RqdStaticLaunchFrameRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticLaunchFrameResponse.SerializeToString,
            ),
            'Lock': grpc.unary_unary_rpc_method_handler(
                    servicer.Lock,
                    request_deserializer=rqd__pb2.RqdStaticLockRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticLockResponse.SerializeToString,
            ),
            'LockAll': grpc.unary_unary_rpc_method_handler(
                    servicer.LockAll,
                    request_deserializer=rqd__pb2.RqdStaticLockAllRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticLockAllResponse.SerializeToString,
            ),
            'NimbyOff': grpc.unary_unary_rpc_method_handler(
                    servicer.NimbyOff,
                    request_deserializer=rqd__pb2.RqdStaticNimbyOffRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticNimbyOffResponse.SerializeToString,
            ),
            'NimbyOn': grpc.unary_unary_rpc_method_handler(
                    servicer.NimbyOn,
                    request_deserializer=rqd__pb2.RqdStaticNimbyOnRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticNimbyOnResponse.SerializeToString,
            ),
            'RebootIdle': grpc.unary_unary_rpc_method_handler(
                    servicer.RebootIdle,
                    request_deserializer=rqd__pb2.RqdStaticRebootIdleRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticRebootIdleResponse.SerializeToString,
            ),
            'RebootNow': grpc.unary_unary_rpc_method_handler(
                    servicer.RebootNow,
                    request_deserializer=rqd__pb2.RqdStaticRebootNowRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticRebootNowResponse.SerializeToString,
            ),
            'ReportStatus': grpc.unary_unary_rpc_method_handler(
                    servicer.ReportStatus,
                    request_deserializer=rqd__pb2.RqdStaticReportStatusRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticReportStatusResponse.SerializeToString,
            ),
            'RestartRqdIdle': grpc.unary_unary_rpc_method_handler(
                    servicer.RestartRqdIdle,
                    request_deserializer=rqd__pb2.RqdStaticRestartIdleRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticRestartIdleResponse.SerializeToString,
            ),
            'RestartRqdNow': grpc.unary_unary_rpc_method_handler(
                    servicer.RestartRqdNow,
                    request_deserializer=rqd__pb2.RqdStaticRestartNowRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticRestartNowResponse.SerializeToString,
            ),
            'ShutdownRqdIdle': grpc.unary_unary_rpc_method_handler(
                    servicer.ShutdownRqdIdle,
                    request_deserializer=rqd__pb2.RqdStaticShutdownIdleRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticShutdownIdleResponse.SerializeToString,
            ),
            'ShutdownRqdNow': grpc.unary_unary_rpc_method_handler(
                    servicer.ShutdownRqdNow,
                    request_deserializer=rqd__pb2.RqdStaticShutdownNowRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticShutdownNowResponse.SerializeToString,
            ),
            'Unlock': grpc.unary_unary_rpc_method_handler(
                    servicer.Unlock,
                    request_deserializer=rqd__pb2.RqdStaticUnlockRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticUnlockResponse.SerializeToString,
            ),
            'UnlockAll': grpc.unary_unary_rpc_method_handler(
                    servicer.UnlockAll,
                    request_deserializer=rqd__pb2.RqdStaticUnlockAllRequest.FromString,
                    response_serializer=rqd__pb2.RqdStaticUnlockAllResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'rqd.RqdInterface', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class RqdInterface(object):
    """Interface for issuing commands to an RQD instance.

    -------- Services --------]

    Implemented by the Rqd server. Called by cuebot and tools.
    """

    @staticmethod
    def GetRunFrame(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/GetRunFrame',
            rqd__pb2.RqdStaticGetRunFrameRequest.SerializeToString,
            rqd__pb2.RqdStaticGetRunFrameResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetRunningFrameStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/GetRunningFrameStatus',
            rqd__pb2.RqdStaticGetRunningFrameStatusRequest.SerializeToString,
            rqd__pb2.RqdStaticGetRunningFrameStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def KillRunningFrame(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/KillRunningFrame',
            rqd__pb2.RqdStaticKillRunningFrameRequest.SerializeToString,
            rqd__pb2.RqdStaticKillRunningFrameResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LaunchFrame(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/LaunchFrame',
            rqd__pb2.RqdStaticLaunchFrameRequest.SerializeToString,
            rqd__pb2.RqdStaticLaunchFrameResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Lock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/Lock',
            rqd__pb2.RqdStaticLockRequest.SerializeToString,
            rqd__pb2.RqdStaticLockResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LockAll(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/LockAll',
            rqd__pb2.RqdStaticLockAllRequest.SerializeToString,
            rqd__pb2.RqdStaticLockAllResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def NimbyOff(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/NimbyOff',
            rqd__pb2.RqdStaticNimbyOffRequest.SerializeToString,
            rqd__pb2.RqdStaticNimbyOffResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def NimbyOn(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/NimbyOn',
            rqd__pb2.RqdStaticNimbyOnRequest.SerializeToString,
            rqd__pb2.RqdStaticNimbyOnResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RebootIdle(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/RebootIdle',
            rqd__pb2.RqdStaticRebootIdleRequest.SerializeToString,
            rqd__pb2.RqdStaticRebootIdleResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RebootNow(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/RebootNow',
            rqd__pb2.RqdStaticRebootNowRequest.SerializeToString,
            rqd__pb2.RqdStaticRebootNowResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ReportStatus(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/ReportStatus',
            rqd__pb2.RqdStaticReportStatusRequest.SerializeToString,
            rqd__pb2.RqdStaticReportStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RestartRqdIdle(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/RestartRqdIdle',
            rqd__pb2.RqdStaticRestartIdleRequest.SerializeToString,
            rqd__pb2.RqdStaticRestartIdleResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RestartRqdNow(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/RestartRqdNow',
            rqd__pb2.RqdStaticRestartNowRequest.SerializeToString,
            rqd__pb2.RqdStaticRestartNowResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ShutdownRqdIdle(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/ShutdownRqdIdle',
            rqd__pb2.RqdStaticShutdownIdleRequest.SerializeToString,
            rqd__pb2.RqdStaticShutdownIdleResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ShutdownRqdNow(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/ShutdownRqdNow',
            rqd__pb2.RqdStaticShutdownNowRequest.SerializeToString,
            rqd__pb2.RqdStaticShutdownNowResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Unlock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/Unlock',
            rqd__pb2.RqdStaticUnlockRequest.SerializeToString,
            rqd__pb2.RqdStaticUnlockResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UnlockAll(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RqdInterface/UnlockAll',
            rqd__pb2.RqdStaticUnlockAllRequest.SerializeToString,
            rqd__pb2.RqdStaticUnlockAllResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)


class RunningFrameStub(object):
    """Implemented by the Rqd server. Called by cuebot and tools.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Kill = channel.unary_unary(
                '/rqd.RunningFrame/Kill',
                request_serializer=rqd__pb2.RunningFrameKillRequest.SerializeToString,
                response_deserializer=rqd__pb2.RunningFrameKillResponse.FromString,
                )
        self.Status = channel.unary_unary(
                '/rqd.RunningFrame/Status',
                request_serializer=rqd__pb2.RunningFrameStatusRequest.SerializeToString,
                response_deserializer=rqd__pb2.RunningFrameStatusResponse.FromString,
                )


class RunningFrameServicer(object):
    """Implemented by the Rqd server. Called by cuebot and tools.
    """

    def Kill(self, request, context):
        """Kill the provided running frame
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Status(self, request, context):
        """Get the status of the running frame
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RunningFrameServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Kill': grpc.unary_unary_rpc_method_handler(
                    servicer.Kill,
                    request_deserializer=rqd__pb2.RunningFrameKillRequest.FromString,
                    response_serializer=rqd__pb2.RunningFrameKillResponse.SerializeToString,
            ),
            'Status': grpc.unary_unary_rpc_method_handler(
                    servicer.Status,
                    request_deserializer=rqd__pb2.RunningFrameStatusRequest.FromString,
                    response_serializer=rqd__pb2.RunningFrameStatusResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'rqd.RunningFrame', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class RunningFrame(object):
    """Implemented by the Rqd server. Called by cuebot and tools.
    """

    @staticmethod
    def Kill(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RunningFrame/Kill',
            rqd__pb2.RunningFrameKillRequest.SerializeToString,
            rqd__pb2.RunningFrameKillResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Status(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rqd.RunningFrame/Status',
            rqd__pb2.RunningFrameStatusRequest.SerializeToString,
            rqd__pb2.RunningFrameStatusResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)