"""Added Boards table

Revision ID: 123b2cca325f
Revises: 88feb1b31a1f
Create Date: 2024-02-20 23:00:47.808587

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '123b2cca325f'
down_revision: Union[str, None] = '88feb1b31a1f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('boards',
    sa.Column('board_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.Column('ip_address', sa.String(), nullable=False),
    sa.Column('fw_version', sa.String(), nullable=False),
    sa.Column('last_seen', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.PrimaryKeyConstraint('board_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('boards')
    # ### end Alembic commands ###
