"""Initial database creation

Revision ID: 2dc275252e0e
Revises: 
Create Date: 2024-01-28 16:25:31.644671

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '2dc275252e0e'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('machine_types',
    sa.Column('type_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('type_name', sa.String(), nullable=False),
    sa.Column('type_timeout_min', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('type_id'),
    sa.UniqueConstraint('type_name')
    )
    op.create_index('idx_machine_types_type_name_unique', 'machine_types', ['type_name'], unique=True)
    op.create_table('roles',
    sa.Column('role_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('role_name', sa.String(), nullable=False),
    sa.Column('authorize_all', sa.Boolean(), nullable=False),
    sa.Column('reserved', sa.Boolean(), nullable=False),
    sa.Column('maintenance', sa.Boolean(), nullable=False),
    sa.Column('backend_admin', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('role_id'),
    sa.UniqueConstraint('role_name')
    )
    op.create_index('idx_roles_role_name_unique', 'roles', ['role_name'], unique=True)
    op.create_table('machines',
    sa.Column('machine_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('machine_name', sa.String(), nullable=False),
    sa.Column('machine_type_id', sa.Integer(), nullable=True),
    sa.Column('machine_hours', sa.Float(), nullable=False),
    sa.Column('blocked', sa.Boolean(), nullable=False),
    sa.Column('last_seen', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['machine_type_id'], ['machine_types.type_id'], ),
    sa.PrimaryKeyConstraint('machine_id'),
    sa.UniqueConstraint('machine_name')
    )
    op.create_index('idx_machines_machine_name_unique', 'machines', ['machine_name'], unique=True)
    op.create_table('users',
    sa.Column('user_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('surname', sa.String(), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=False),
    sa.Column('card_UUID', sa.String(), nullable=True),
    sa.Column('disabled', sa.Boolean(), nullable=False),
    sa.Column('deleted', sa.Boolean(), nullable=False),
    sa.Column('password_hash', sa.String(length=128), nullable=True),
    sa.Column('email', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles.role_id'], ),
    sa.PrimaryKeyConstraint('user_id'),
    sa.UniqueConstraint('card_UUID')
    )
    op.create_index('idx_users_card_UUID_unique', 'users', ['card_UUID'], unique=True)
    op.create_table('authorizations',
    sa.Column('authorization_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ),
    sa.PrimaryKeyConstraint('authorization_id'),
    sa.UniqueConstraint('user_id', 'machine_id', name='uix_1')
    )
    op.create_table('maintenances',
    sa.Column('maintenance_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('hours_between', sa.Float(), nullable=False),
    sa.Column('description', sa.String(), nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.Column('attachment', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.PrimaryKeyConstraint('maintenance_id')
    )
    op.create_table('unknown_cards',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('card_UUID', sa.String(), nullable=False),
    sa.Column('timestamp', sa.Float(), nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('uses',
    sa.Column('use_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.Column('start_timestamp', sa.Float(), nullable=False),
    sa.Column('last_seen', sa.Float(), nullable=False),
    sa.Column('end_timestamp', sa.Float(), nullable=True),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ),
    sa.PrimaryKeyConstraint('use_id')
    )
    op.create_table('interventions',
    sa.Column('intervention_id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('maintenance_id', sa.Integer(), nullable=False),
    sa.Column('machine_id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('timestamp', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['machine_id'], ['machines.machine_id'], ),
    sa.ForeignKeyConstraint(['maintenance_id'], ['maintenances.maintenance_id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ),
    sa.PrimaryKeyConstraint('intervention_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('interventions')
    op.drop_table('uses')
    op.drop_table('unknown_cards')
    op.drop_table('maintenances')
    op.drop_table('authorizations')
    op.drop_index('idx_users_card_UUID_unique', table_name='users')
    op.drop_table('users')
    op.drop_index('idx_machines_machine_name_unique', table_name='machines')
    op.drop_table('machines')
    op.drop_index('idx_roles_role_name_unique', table_name='roles')
    op.drop_table('roles')
    op.drop_index('idx_machine_types_type_name_unique', table_name='machine_types')
    op.drop_table('machine_types')
    # ### end Alembic commands ###
