# Generated by Django 1.11.13 on 2018-08-31 08:43

from django.db import migrations
import djangocms_text_ckeditor.fields


def convert_agreements(apps, schema_editor):
    for model_name in ('LeprikonSite', 'SubjectType', 'Subject'):
        Model = apps.get_model('leprikon', model_name)
        for obj in Model.objects.exclude(agreement=''):
            obj.agreement = '\n'.join(
                '<p>%s</p>' % line for line in obj.agreement.split('\n')
            )
            obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0019_department'),
    ]

    operations = [
        migrations.AlterField(
            model_name='leprikonsite',
            name='agreement',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='registration agreement'),
        ),
        migrations.AlterField(
            model_name='subject',
            name='agreement',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='registration agreement'),
        ),
        migrations.AlterField(
            model_name='subjecttype',
            name='agreement',
            field=djangocms_text_ckeditor.fields.HTMLField(blank=True, default='', verbose_name='registration agreement'),
        ),
        migrations.RunPython(convert_agreements),
    ]
