# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-02-11 04:57
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import djangocms_text_ckeditor.fields


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0024_subjectregistration_note"),
    ]

    operations = [
        migrations.CreateModel(
            name="Agreement",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=50, unique=True, verbose_name="name")),
                ("order", models.IntegerField(blank=True, default=0, verbose_name="order")),
                ("heading", models.CharField(blank=True, default="", max_length=50, verbose_name="heading")),
                (
                    "agreement",
                    djangocms_text_ckeditor.fields.HTMLField(blank=True, default="", verbose_name="agreement"),
                ),
            ],
            options={
                "verbose_name": "legal agreement",
                "verbose_name_plural": "legal agreements",
                "ordering": ("order",),
            },
        ),
        migrations.CreateModel(
            name="AgreementOption",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=50, verbose_name="name")),
                ("order", models.IntegerField(blank=True, default=0, verbose_name="order")),
                ("required", models.BooleanField(default=False, verbose_name="required")),
                ("option", djangocms_text_ckeditor.fields.HTMLField(verbose_name="option")),
                (
                    "agreement",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="options",
                        to="leprikon.Agreement",
                        verbose_name="agreement",
                    ),
                ),
            ],
            options={
                "verbose_name": "agreement option",
                "verbose_name_plural": "agreement options",
                "ordering": ("order",),
            },
        ),
        migrations.RenameField(
            model_name="leprikonsite",
            old_name="registration_agreement",
            new_name="old_registration_agreement",
        ),
        migrations.RenameField(
            model_name="subject",
            old_name="agreement",
            new_name="old_registration_agreement",
        ),
        migrations.RenameField(
            model_name="subjecttype",
            old_name="agreement",
            new_name="old_registration_agreement",
        ),
        migrations.AlterField(
            model_name="leprikonsite",
            name="old_registration_agreement",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True,
                default="",
                help_text="This agreement will be removed in future version. Please, use registration agreements below.",
                verbose_name="old registration agreement",
            ),
        ),
        migrations.AlterField(
            model_name="subject",
            name="old_registration_agreement",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True,
                default="",
                help_text="This agreement will be removed in future version. Please, use registration agreements below.",
                verbose_name="old registration agreement",
            ),
        ),
        migrations.AlterField(
            model_name="subjecttype",
            name="old_registration_agreement",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True,
                default="",
                help_text="This agreement will be removed in future version. Please, use registration agreements below.",
                verbose_name="old registration agreement",
            ),
        ),
        migrations.AddField(
            model_name="leprikonsite",
            name="registration_agreements",
            field=models.ManyToManyField(
                blank=True,
                help_text="Add legal agreements for the registration form.",
                related_name="+",
                to="leprikon.Agreement",
                verbose_name="registration agreements",
            ),
        ),
        migrations.AddField(
            model_name="subject",
            name="registration_agreements",
            field=models.ManyToManyField(
                blank=True,
                help_text="Add additional legal agreements specific for this subject.",
                related_name="+",
                to="leprikon.Agreement",
                verbose_name="additional legal agreements",
            ),
        ),
        migrations.AddField(
            model_name="subjectregistration",
            name="agreement_options",
            field=models.ManyToManyField(blank=True, to="leprikon.AgreementOption", verbose_name="legal agreements"),
        ),
        migrations.AddField(
            model_name="subjecttype",
            name="registration_agreements",
            field=models.ManyToManyField(
                blank=True,
                help_text="Add additional legal agreements specific to this activity type.",
                related_name="+",
                to="leprikon.Agreement",
                verbose_name="additional legal agreements",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="agreementoption",
            unique_together=set([("agreement", "name")]),
        ),
    ]
