# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-06-01 08:22
from __future__ import unicode_literals

from decimal import Decimal
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import djangocms_text_ckeditor.fields
import leprikon.models.fields
import leprikon.models.activities
import multiselectfield.db.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("leprikon", "0059_transactions_data"),
    ]

    operations = [
        migrations.RenameField(model_name="SubjectPayment", old_name="received_by", new_name="accounted_by"),
        migrations.RenameField(model_name="SubjectPayment", old_name="payment_type", new_name="transaction_type"),
        migrations.RenameModel(old_name="SubjectPayment", new_name="Transaction"),
        migrations.CreateModel(
            name="Donation",
            fields=[],
            options={
                "verbose_name": "donation",
                "verbose_name_plural": "donations",
                "proxy": True,
                "indexes": [],
            },
            bases=("leprikon.transaction",),
        ),
        migrations.CreateModel(
            name="SubjectPayment",
            fields=[],
            options={
                "verbose_name": "payment",
                "verbose_name_plural": "payments",
                "proxy": True,
                "indexes": [],
            },
            bases=("leprikon.transaction",),
        ),
        migrations.CreateModel(
            name="SubjectReceivedPayment",
            fields=[],
            options={
                "verbose_name": "received payment",
                "verbose_name_plural": "received payments",
                "proxy": True,
                "indexes": [],
            },
            bases=(leprikon.models.activities.PaymentMixin, "leprikon.transaction"),
        ),
        migrations.CreateModel(
            name="SubjectReturnedPayment",
            fields=[],
            options={
                "verbose_name": "returned payment",
                "verbose_name_plural": "returned payments",
                "proxy": True,
                "indexes": [],
            },
            bases=(leprikon.models.activities.PaymentMixin, "leprikon.transaction"),
        ),
        migrations.AlterModelOptions(
            name="transaction",
            options={"ordering": ("accounted",), "verbose_name": "transaction", "verbose_name_plural": "transactions"},
        ),
        migrations.RemoveField(
            model_name="transaction",
            name="registration",
        ),
        migrations.RemoveField(
            model_name="transaction",
            name="related_payment",
        ),
        migrations.AddField(
            model_name="coursediscount",
            name="accounted_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="accounted by",
            ),
        ),
        migrations.AddField(
            model_name="coursediscount",
            name="last_updated",
            field=models.DateTimeField(editable=False, null=True, verbose_name="last updated time"),
        ),
        migrations.AddField(
            model_name="coursediscount",
            name="last_updated_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="last updated by",
            ),
        ),
        migrations.AddField(
            model_name="eventdiscount",
            name="accounted_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="accounted by",
            ),
        ),
        migrations.AddField(
            model_name="eventdiscount",
            name="last_updated",
            field=models.DateTimeField(editable=False, null=True, verbose_name="last updated time"),
        ),
        migrations.AddField(
            model_name="eventdiscount",
            name="last_updated_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="last updated by",
            ),
        ),
        migrations.AddField(
            model_name="orderablediscount",
            name="accounted_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="accounted by",
            ),
        ),
        migrations.AddField(
            model_name="orderablediscount",
            name="last_updated",
            field=models.DateTimeField(editable=False, null=True, verbose_name="last updated time"),
        ),
        migrations.AddField(
            model_name="orderablediscount",
            name="last_updated_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="last updated by",
            ),
        ),
        migrations.AddField(
            model_name="organization",
            name="donation_print_setup",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="leprikon.PrintSetup",
                verbose_name="donation print setup",
            ),
        ),
        migrations.AddField(
            model_name="subject",
            name="text_payment_returned",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True, default="", verbose_name="text: payment returned"
            ),
        ),
        migrations.AddField(
            model_name="subjecttype",
            name="text_payment_returned",
            field=djangocms_text_ckeditor.fields.HTMLField(
                blank=True,
                default="",
                help_text="<p>Keep empty to use default value:</p><p>Hello,<br/>\nwe have just returned Your payment. Thank You.<br/>\nPlease see the recipe attached.</p>",
                verbose_name="text: payment returned",
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="donor",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="leprikon_donations",
                to=settings.AUTH_USER_MODEL,
                verbose_name="donor user",
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="last_updated",
            field=models.DateTimeField(editable=False, null=True, verbose_name="last updated time"),
        ),
        migrations.AddField(
            model_name="transaction",
            name="last_updated_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="last updated by",
            ),
        ),
        migrations.AddField(
            model_name="transaction",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="donations",
                to="leprikon.Organization",
                verbose_name="organization",
            ),
        ),
        migrations.AlterField(
            model_name="subjectattachment",
            name="events",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("registration_received", "registration received"),
                    ("registration_approved", "registration approved"),
                    ("registration_refused", "registration refused"),
                    ("registration_payment_request", "payment requested"),
                    ("registration_canceled", "registration canceled"),
                    ("discount_granted", "discount granted"),
                    ("payment_received", "payment received"),
                    ("payment_returned", "payment returned"),
                ],
                default=[],
                help_text="The attachment will be sent with notification on selected events.",
                max_length=166,
                verbose_name="send when",
            ),
        ),
        migrations.AlterField(
            model_name="subjecttypeattachment",
            name="events",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("registration_received", "registration received"),
                    ("registration_approved", "registration approved"),
                    ("registration_refused", "registration refused"),
                    ("registration_payment_request", "payment requested"),
                    ("registration_canceled", "registration canceled"),
                    ("discount_granted", "discount granted"),
                    ("payment_received", "payment received"),
                    ("payment_returned", "payment returned"),
                ],
                default=[],
                help_text="The attachment will be sent with notification on selected events.",
                max_length=166,
                verbose_name="send when",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="accounted_by",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
                verbose_name="accounted by",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="amount",
            field=leprikon.models.fields.PriceField(
                decimal_places=0,
                max_digits=10,
                validators=[django.core.validators.MinValueValidator(Decimal("0.01"))],
                verbose_name="amount",
            ),
        ),
        migrations.AlterField(
            model_name="transaction",
            name="transaction_type",
            field=models.CharField(
                choices=[
                    ("PAYMENT_CASH", "payment - cash"),
                    ("PAYMENT_BANK", "payment - bank"),
                    ("PAYMENT_ONLINE", "payment - online"),
                    ("RETURN_CASH", "returned payment - cash"),
                    ("RETURN_BANK", "returned payment - bank"),
                    ("TRANSFER", "transfer between registrations"),
                    ("DONATION_CASH", "donation - cash"),
                    ("DONATION_BANK", "donation - bank"),
                    ("DONATION_ONLINE", "donation - online"),
                    ("DONATION_TRANSFER", "transfer from registration to donation"),
                ],
                max_length=30,
                verbose_name="payment type",
            ),
        ),
    ]
