# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2022-07-30 14:44
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import leprikon.models.fields


def set_participant_counts(apps, schema_editor):
    Subject = apps.get_model("leprikon", "Subject")
    Subject.objects.filter(registration_type="G").update(
        min_participants_count=models.F("min_group_members_count"),
        max_participants_count=models.F("max_group_members_count"),
    )


def set_registration_schoolyear_division(apps, schema_editor):
    CourseRegistration = apps.get_model("leprikon", "CourseRegistration")
    for registration in CourseRegistration.objects.filter(school_year_division=None).annotate(
        variant_school_year_division_id=models.F("subject_variant__coursevariant__school_year_division_id"),
        subject_school_year_division_id=models.F("subject__course__school_year_division_id"),
    ):
        registration.school_year_division_id = (
            registration.variant_school_year_division_id or registration.subject_school_year_division_id
        )
        registration.save()


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0071_transaction_amount"),
    ]

    operations = [
        # SchoolYearDivision
        migrations.RenameField(
            model_name="schoolyeardivision",
            old_name="period_name",
            new_name="price_unit_name",
        ),
        migrations.AlterField(
            model_name="schoolyeardivision",
            name="price_unit_name",
            field=models.CharField(
                help_text="Unit name the price applies to. For example semester, month, or 5 lessons.",
                max_length=150,
                verbose_name="price unit name",
            ),
        ),
        # SchoolYearPeriod
        migrations.AddField(
            model_name="schoolyearperiod",
            name="price_units_count",
            field=models.DecimalField(decimal_places=2, default=1, max_digits=10, verbose_name="number of price units"),
        ),
        migrations.AlterField(
            model_name="schoolyearperiod",
            name="end",
            field=models.DateField(blank=True, null=True, verbose_name="end date"),
        ),
        migrations.AlterField(
            model_name="schoolyearperiod",
            name="start",
            field=models.DateField(blank=True, null=True, verbose_name="start date"),
        ),
        # Subject
        migrations.RunPython(set_participant_counts),
        migrations.RemoveField(
            model_name="subject",
            name="max_group_members_count",
        ),
        migrations.RemoveField(
            model_name="subject",
            name="min_group_members_count",
        ),
        migrations.AlterField(
            model_name="subject",
            name="max_participants_count",
            field=models.PositiveIntegerField(
                default=1, verbose_name="maximal participants / group members count per registration"
            ),
        ),
        migrations.AlterField(
            model_name="subject",
            name="min_participants_count",
            field=models.PositiveIntegerField(
                default=1, verbose_name="minimal participants / group members count per registration"
            ),
        ),
        migrations.RenameField(
            model_name="subject",
            old_name="price",
            new_name="registration_price",
        ),
        migrations.AlterField(
            model_name="subject",
            name="registration_price",
            field=leprikon.models.fields.PriceField(
                blank=True, decimal_places=0, max_digits=10, null=True, verbose_name="price per registration"
            ),
        ),
        migrations.AddField(
            model_name="subject",
            name="participant_price",
            field=leprikon.models.fields.PriceField(
                blank=True, decimal_places=0, max_digits=10, null=True, verbose_name="price per participant"
            ),
        ),
        # SubjectVariant
        migrations.AddField(
            model_name="subjectvariant",
            name="available",
            field=models.BooleanField(default=True, verbose_name="available for registration"),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="age_groups",
            field=models.ManyToManyField(
                related_name="subject_variants", to="leprikon.AgeGroup", verbose_name="age groups"
            ),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="target_groups",
            field=models.ManyToManyField(
                related_name="subject_variants", to="leprikon.TargetGroup", verbose_name="target groups"
            ),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="min_participants_count",
            field=models.PositiveIntegerField(
                blank=True, null=True, verbose_name="minimal participants / group members count per registration"
            ),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="max_participants_count",
            field=models.PositiveIntegerField(
                blank=True, null=True, verbose_name="maximal participants / group members count per registration"
            ),
        ),
        migrations.RenameField(
            model_name="subjectvariant",
            old_name="price",
            new_name="registration_price",
        ),
        migrations.AlterField(
            model_name="subjectvariant",
            name="registration_price",
            field=leprikon.models.fields.PriceField(
                blank=True, decimal_places=0, max_digits=10, null=True, verbose_name="price per registration"
            ),
        ),
        migrations.AddField(
            model_name="subjectvariant",
            name="participant_price",
            field=leprikon.models.fields.PriceField(
                blank=True, decimal_places=0, max_digits=10, null=True, verbose_name="price per participant"
            ),
        ),
        # CourseVariant
        migrations.CreateModel(
            name="CourseVariant",
            fields=[
                (
                    "subjectvariant_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="leprikon.SubjectVariant",
                    ),
                ),
                (
                    "allow_period_selection",
                    models.BooleanField(
                        default=False,
                        help_text="allow user to choose school year periods on registration form",
                        verbose_name="allow period selection",
                    ),
                ),
                (
                    "school_year_division",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="course_variants",
                        to="leprikon.SchoolYearDivision",
                        verbose_name="school year division",
                    ),
                ),
            ],
            bases=("leprikon.subjectvariant",),
        ),
        migrations.RunSQL(
            sql=(
                "INSERT INTO leprikon_coursevariant (subjectvariant_ptr_id, allow_period_selection, school_year_division_id) "
                "SELECT sv.id, c.allow_period_selection, c.school_year_division_id "
                "FROM leprikon_subjectvariant sv "
                "JOIN leprikon_course c ON c.subject_ptr_id = sv.subject_id;"
            ),
            reverse_sql="DELETE FROM leprikon_coursevariant;",
        ),
        # Course registration
        migrations.AddField(
            model_name="courseregistration",
            name="school_year_division",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="course_registrations",
                to="leprikon.SchoolYearDivision",
                verbose_name="school year division",
            ),
        ),
        migrations.RunPython(set_registration_schoolyear_division),
        migrations.AlterField(
            model_name="courseregistration",
            name="school_year_division",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="course_registrations",
                to="leprikon.SchoolYearDivision",
                verbose_name="school year division",
            ),
        ),
    ]
