# Generated by Django 3.2.16 on 2023-01-08 18:48

from django.db import migrations, models


def ordered_periods(periods):
    for order, period in enumerate(periods, 1):
        period.order = order
        yield period


def set_schoolyearperiod_order(apps, schema_editor):
    SchoolYearDivision = apps.get_model("leprikon", "SchoolYearDivision")
    SchoolYearPeriod = apps.get_model("leprikon", "SchoolYearPeriod")
    for school_year_division in SchoolYearDivision.objects.all():
        SchoolYearPeriod.objects.bulk_update(
            ordered_periods(school_year_division.periods.order_by("start", "id")), ["order"]
        )


class Migration(migrations.Migration):

    dependencies = [
        ("leprikon", "0073_add_limit_choices_to"),
    ]

    operations = [
        migrations.AddField(
            model_name="schoolyearperiod",
            name="order",
            field=models.IntegerField(blank=True, default=0, verbose_name="order"),
        ),
        migrations.RunPython(set_schoolyearperiod_order),
        migrations.AlterModelOptions(
            name="schoolyearperiod",
            options={
                "ordering": ("order",),
                "verbose_name": "school year period",
                "verbose_name_plural": "school year periods",
            },
        ),
    ]
