# Generated by Django 3.2.22 on 2023-11-08 09:26

from django.db import migrations, models


default_stat_group = None


def create_default_stat_group(apps, schema_editor):
    global default_stat_group
    StatGroup = apps.get_model("leprikon", "StatGroup")
    default_stat_group = StatGroup.objects.create(name="výchozí")


class Migration(migrations.Migration):
    dependencies = [
        ("leprikon", "0082_journal_entry_period"),
    ]

    operations = [
        migrations.CreateModel(
            name="StatGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=50, verbose_name="name")),
                ("order", models.IntegerField(blank=True, default=0, verbose_name="order")),
            ],
            options={
                "verbose_name": "group for statistics",
                "verbose_name_plural": "groups for statistics",
                "ordering": ("order",),
            },
        ),
        migrations.RunPython(create_default_stat_group),
        migrations.AddField(
            model_name="agegroup",
            name="stat_group",
            field=models.ForeignKey(
                default=lambda: default_stat_group.id,
                on_delete=models.deletion.PROTECT,
                related_name="+",
                to="leprikon.statgroup",
                verbose_name="group for statistics",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="targetgroup",
            name="stat_group",
            field=models.ForeignKey(
                default=lambda: default_stat_group.id,
                on_delete=models.deletion.PROTECT,
                related_name="+",
                to="leprikon.statgroup",
                verbose_name="group for statistics",
            ),
            preserve_default=False,
        ),
    ]
