from enum import Enum


class ChannelType(str, Enum):
    OTP = 'OTP'
    BULK = 'BULK'


class StatusCode(int, Enum):
    OK = 200
    BAD_REQUEST = 400
    SERVER_ERROR = 500

    REQUEST_ERROR_DB_ERROR = 1010
    REQUEST_ERROR_DB_CONNECTION_FAILED = 1020
    REQUEST_ERROR_HISTORY_RECORD = 1030
    REQUEST_ERROR_NO_RECORD_FOUND = 1040
    REQUEST_ERROR_UNKNOWN_METHOD = 1050

    EMPTY_RECEIVER_LIST = 1060
    INVALID_SEND_DATE_FORMAT = 1063
    INVALID_EXPIRE_DATE_FORMAT = 1064
    MAX_NUMBER_OF_RECIPIENTS = 1070
    DIFFERENT_SIZE_RECIPIENT_AND_MESSAGE = 1080
    MESSAGE_EMPTY = 1090

    STATUS_QUERY_DB_ERROR = 2020
    STATUS_INQUIRY_HISTORY_RECORD_ERROR = 2030
    STATUS_INQUIRY_NO_RECORD_FOUND_ERROR = 2040
    STATUS_INQUIRY_DB_METHOD_ERROR = 2050

    CREDIT_INQUIRY_DB_ERROR = 7020
    CREDIT_INQUIRY_HISTORY_RECORD_ERROR = 7030
    CREDIT_INQUIRY_NO_RECORD_FOUND_ERROR = 7040
    CREDIT_INQUIRY_DB_METHOD_ERROR = 7050

    ALPHANUMBERIC_QUERY_DB_ERROR = 7020
    ALPHANUMBERIC_QUERY_HISTORY_RECORD_ERROR = 7030
    ALPHANUMBERIC_QUERY_NO_RECORD_FOUND_ERROR = 7040
    ALPHANUMBERIC_QUERY_DB_METHOD_ERROR = 7050
