from _typeshed import Incomplete
from dataclasses import dataclass, field
from opentelemetry.sdk._logs.export import LogExporter as LogExporter
from opentelemetry.sdk.metrics.export import MetricExporter as MetricExporter
from opentelemetry.sdk.trace.export import SpanExporter as SpanExporter
from typing import Any

@dataclass
class LumberjackConfig:
    project_name: str | None = ...
    api_key: str | None = ...
    endpoint: str = ...
    objects_endpoint: str | None = ...
    spans_endpoint: str | None = ...
    metrics_endpoint: str | None = ...
    env: str = ...
    batch_size: int = ...
    batch_age: float = ...
    flush_interval: float = ...
    log_to_stdout: bool | None = ...
    stdout_log_level: str = ...
    stdout_log_format: str = ...
    stdout_date_format: str = ...
    debug_mode: bool = ...
    otel_format: bool = ...
    capture_stdout: bool | None = ...
    capture_python_logger: bool = ...
    python_logger_level: str = ...
    python_logger_name: str | None = ...
    code_snippet_enabled: bool = ...
    code_snippet_context_lines: int = ...
    code_snippet_max_frames: int = ...
    code_snippet_exclude_patterns: list[str] = field(default_factory=Incomplete)
    install_signal_handlers: bool = ...
    local_server_enabled: bool | None = ...
    local_server_endpoint: str = ...
    local_server_service_name: str | None = ...
    service_discovery_enabled: bool = ...
    service_discovery_config_path: str | None = ...
    cache_max_size: int = ...
    discovery_interval: float = ...
    custom_log_exporter: LogExporter | None = ...
    custom_span_exporter: SpanExporter | None = ...
    custom_metrics_exporter: MetricExporter | None = ...
    def __post_init__(self) -> None: ...
    def to_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_dict(cls, data: dict[str, Any]) -> LumberjackConfig: ...
    @classmethod
    def from_kwargs(cls, **kwargs: Any) -> LumberjackConfig: ...
    def get_logging_level(self, level_str: str) -> int: ...
    def is_fallback_mode(self) -> bool: ...
    def should_capture_stdout(self) -> bool: ...
    def should_capture_python_logger(self) -> bool: ...
    def should_log_to_stdout(self) -> bool: ...
    def should_use_local_server(self) -> bool: ...
    def get_local_server_service_name(self) -> str: ...
ConfigDict = dict[str, Any]
ConfigLike = LumberjackConfig | ConfigDict | None

def create_config(**kwargs: Any) -> LumberjackConfig: ...
def load_config_from_env() -> LumberjackConfig: ...
