from ..internal_utils.fallback_logger import fallback_logger as fallback_logger
from _typeshed import Incomplete
from dataclasses import dataclass
from pathlib import Path as Path
from typing import Any

@dataclass
class LogEntry:
    id: str = ...
    timestamp: int = ...
    level: str = ...
    message: str = ...
    service: str = ...
    attributes: dict[str, Any] = ...
    trace_id: str | None = ...
    span_id: str | None = ...
    def __post_init__(self) -> None: ...
    def to_dict(self) -> dict[str, Any]: ...

class LogDatabase:
    db_path: Incomplete
    def __init__(self, db_path: str | None = None) -> None: ...
    def insert_log(self, log_entry: LogEntry) -> str: ...
    def get_logs(self, limit: int = 100, offset: int = 0, service: str | None = None, level: str | None = None, search_query: str | None = None, since_timestamp: int | None = None) -> list[LogEntry]: ...
    def get_recent_logs(self, limit: int = 50) -> list[LogEntry]: ...
    def get_services(self) -> list[str]: ...
    def get_logs_before_timestamp(self, before_timestamp: int, limit: int = 100, service: str | None = None, level: str | None = None, search_query: str | None = None) -> list[LogEntry]: ...
    def get_log_count(self, service: str | None = None, level: str | None = None, since_timestamp: int | None = None, before_timestamp: int | None = None) -> int: ...
    def cleanup_old_logs(self, max_age_seconds: int = 86400) -> int: ...
    def close(self) -> None: ...
    def __del__(self) -> None: ...

def get_database(db_path: str | None = None) -> LogDatabase: ...
def close_database() -> None: ...
