import asyncio
import queue
from ..internal_utils.fallback_logger import fallback_logger as fallback_logger
from .database import LogEntry as LogEntry, get_database as get_database
from .grpc_collector import GrpcCollector as GrpcCollector
from .service_discovery import check_existing_server as check_existing_server, check_port_availability as check_port_availability, cleanup_own_config as cleanup_own_config, update_heartbeat as update_heartbeat, write_server_config as write_server_config
from _typeshed import Incomplete
from fastapi import FastAPI, WebSocket as WebSocket
from pathlib import Path
from urllib.parse import parse_qs as parse_qs

class ConnectionManager:
    active_connections: set[WebSocket]
    def __init__(self) -> None: ...
    async def connect(self, websocket: WebSocket): ...
    def disconnect(self, websocket: WebSocket): ...
    async def broadcast_log(self, log_entry: LogEntry): ...
    async def send_initial_logs(self, websocket: WebSocket, limit: int = 50): ...

connection_manager: Incomplete
grpc_collector: GrpcCollector | None
log_broadcast_queue: queue.Queue
heartbeat_task: asyncio.Task | None
server_host: str
server_port: int

async def process_log_broadcast_queue() -> None: ...
async def heartbeat_worker() -> None: ...
async def lifespan(app: FastAPI): ...

app: Incomplete

async def websocket_logs(websocket: WebSocket): ...
async def get_logs(limit: int = ..., offset: int = ..., service: str | None = ..., level: str | None = ..., search: str | None = ..., since_timestamp: int | None = ...): ...
async def get_logs_before(before_timestamp: int = ..., limit: int = ..., service: str | None = ..., level: str | None = ..., search: str | None = ...): ...
async def get_services(): ...
async def get_stats(): ...
async def new_log_notification(log_entry: dict): ...
def get_static_dir() -> Path: ...

static_dir: Incomplete
assets_dir: Incomplete

async def serve_index(): ...
async def favicon(): ...
def start_server(host: str = '127.0.0.1', port: int = 8080, db_path: str | None = None, open_browser: bool = True, log_level: str = 'info') -> None: ...
