# coding: utf-8

"""
    LOCKSS Configuration Service REST API

    REST API of the LOCKSS Configuration Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.config.api_client import ApiClient


class AusApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calculate_auid(self, **kwargs):  # noqa: E501
        """Calculate an AUID for a hypothetical AU  # noqa: E501

        Calculate an AUID for a hypothetical AU, given either a plugin ID and an auConfig map (for traditional AUs), or a handle and an optional plugin ID for NamedAUs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_auid(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_id:
        :param str handle:
        :param object au_config:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calculate_auid_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.calculate_auid_with_http_info(**kwargs)  # noqa: E501
            return data

    def calculate_auid_with_http_info(self, **kwargs):  # noqa: E501
        """Calculate an AUID for a hypothetical AU  # noqa: E501

        Calculate an AUID for a hypothetical AU, given either a plugin ID and an auConfig map (for traditional AUs), or a handle and an optional plugin ID for NamedAUs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_auid_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_id:
        :param str handle:
        :param object au_config:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_id', 'handle', 'au_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_auid" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'plugin_id' in params:
            form_params.append(('pluginId', params['plugin_id']))  # noqa: E501
        if 'handle' in params:
            form_params.append(('handle', params['handle']))  # noqa: E501
        if 'au_config' in params:
            form_params.append(('auConfig', params['au_config']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/auids', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_au_config(self, auid, **kwargs):  # noqa: E501
        """Delete the configuration of an AU  # noqa: E501

        Delete the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_au_config(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the configuration is\\ \\ to be deleted (required)
        :return: AuConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_au_config_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_au_config_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def delete_au_config_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Delete the configuration of an AU  # noqa: E501

        Delete the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_au_config_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the configuration is\\ \\ to be deleted (required)
        :return: AuConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_au_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `delete_au_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_aus_delete(self, body, **kwargs):  # noqa: E501
        """Delete AUs  # noqa: E501

        Delete a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_aus_delete(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be deleted (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_aus_delete_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_aus_delete_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def delete_aus_delete_with_http_info(self, body, **kwargs):  # noqa: E501
        """Delete AUs  # noqa: E501

        Delete a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_aus_delete_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be deleted (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_aus_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_aus_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/aus/delete', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContentConfigurationResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_au_config(self, **kwargs):  # noqa: E501
        """Get the configurations of all AUs  # noqa: E501

        Get the configuration of all AUs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_au_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AuConfiguration]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_au_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_au_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_au_config_with_http_info(self, **kwargs):  # noqa: E501
        """Get the configurations of all AUs  # noqa: E501

        Get the configuration of all AUs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_au_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AuConfiguration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_au_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuConfiguration]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_au_agreements(self, auid, **kwargs):  # noqa: E501
        """Get the poll agreements of an AU  # noqa: E501

        Get the poll agreements of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_agreements(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the poll agreements are requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_au_agreements_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_au_agreements_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_au_agreements_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the poll agreements of an AU  # noqa: E501

        Get the poll agreements of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_agreements_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the poll agreements are requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_au_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_au_agreements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/auagreements/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_au_config(self, auid, **kwargs):  # noqa: E501
        """Get the configuration of an AU  # noqa: E501

        Get the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_config(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the configuration is\\ \\ requested (required)
        :return: AuConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_au_config_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_au_config_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_au_config_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the configuration of an AU  # noqa: E501

        Get the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_config_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the configuration is\\ \\ requested (required)
        :return: AuConfiguration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_au_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_au_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuConfiguration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_au_state(self, auid, **kwargs):  # noqa: E501
        """Get the state of an AU  # noqa: E501

        Get the state of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_state(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the state is requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_au_state_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_au_state_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_au_state_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the state of an AU  # noqa: E501

        Get the state of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_state_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the state is requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_au_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_au_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/austates/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_au_status(self, auid, **kwargs):  # noqa: E501
        """Get the status of an AU  # noqa: E501

        Get the status of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_status(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the status is requested (required)
        :return: AuStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_au_status_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_au_status_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_au_status_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the status of an AU  # noqa: E501

        Get the status of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_status_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the status is requested (required)
        :return: AuStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_au_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_au_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/austatuses/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_au_suspect_url_versions(self, auid, **kwargs):  # noqa: E501
        """Get the suspect URL versions of an AU  # noqa: E501

        Get the suspect URL versions of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_suspect_url_versions(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the suspect URL versions are requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_au_suspect_url_versions_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_au_suspect_url_versions_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_au_suspect_url_versions_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the suspect URL versions of an AU  # noqa: E501

        Get the suspect URL versions of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_au_suspect_url_versions_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the suspect URL versions are requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_au_suspect_url_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_au_suspect_url_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aususpecturls/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auqueries(self, au_query, **kwargs):  # noqa: E501
        """Query for archival unit properties  # noqa: E501

        Query for archival units that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auqueries(au_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str au_query: The query that specifies the archival units to be returned (required)
        :return: list[AuWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auqueries_with_http_info(au_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_auqueries_with_http_info(au_query, **kwargs)  # noqa: E501
            return data

    def get_auqueries_with_http_info(self, au_query, **kwargs):  # noqa: E501
        """Query for archival unit properties  # noqa: E501

        Query for archival units that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auqueries_with_http_info(au_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str au_query: The query that specifies the archival units to be returned (required)
        :return: list[AuWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['au_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auqueries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'au_query' is set
        if ('au_query' not in params or
                params['au_query'] is None):
            raise ValueError("Missing the required parameter `au_query` when calling `get_auqueries`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'au_query' in params:
            query_params.append(('auQuery', params['au_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/auqueries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_no_au_peers(self, auid, **kwargs):  # noqa: E501
        """Get the NoAuPeerSet object of an AU  # noqa: E501

        Get the NoAuPeerSet object of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_no_au_peers(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the NoAuPeerSet object is requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_no_au_peers_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_no_au_peers_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_no_au_peers_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the NoAuPeerSet object of an AU  # noqa: E501

        Get the NoAuPeerSet object of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_no_au_peers_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the NoAuPeerSet object is requested (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_no_au_peers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_no_au_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/noaupeers/{auid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_au_agreements(self, body, auid, **kwargs):  # noqa: E501
        """Update the poll agreements of an AU  # noqa: E501

        Update the poll agreements of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_au_agreements(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit poll agreements to be updated (required)
        :param str auid: The identifier of the AU for which the poll agreements are to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_au_agreements_with_http_info(body, auid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_au_agreements_with_http_info(body, auid, **kwargs)  # noqa: E501
            return data

    def patch_au_agreements_with_http_info(self, body, auid, **kwargs):  # noqa: E501
        """Update the poll agreements of an AU  # noqa: E501

        Update the poll agreements of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_au_agreements_with_http_info(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit poll agreements to be updated (required)
        :param str auid: The identifier of the AU for which the poll agreements are to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'auid', 'x_lockss_request_cookie']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_au_agreements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_au_agreements`")  # noqa: E501
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `patch_au_agreements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_lockss_request_cookie' in params:
            header_params['X-Lockss-Request-Cookie'] = params['x_lockss_request_cookie']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/auagreements/{auid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_au_state(self, body, auid, **kwargs):  # noqa: E501
        """Update the state of an AU  # noqa: E501

        Update the state of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_au_state(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit state to be updated (required)
        :param str auid: The identifier of the AU for which the state is to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_au_state_with_http_info(body, auid, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_au_state_with_http_info(body, auid, **kwargs)  # noqa: E501
            return data

    def patch_au_state_with_http_info(self, body, auid, **kwargs):  # noqa: E501
        """Update the state of an AU  # noqa: E501

        Update the state of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_au_state_with_http_info(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit state to be updated (required)
        :param str auid: The identifier of the AU for which the state is to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'auid', 'x_lockss_request_cookie']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_au_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_au_state`")  # noqa: E501
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `patch_au_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_lockss_request_cookie' in params:
            header_params['X-Lockss-Request-Cookie'] = params['x_lockss_request_cookie']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/austates/{auid}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_aus(self, body, **kwargs):  # noqa: E501
        """Add AUs  # noqa: E501

        Add a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_aus(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be added (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_aus_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_aus_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_aus_with_http_info(self, body, **kwargs):  # noqa: E501
        """Add AUs  # noqa: E501

        Add a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_aus_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be added (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_aus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_aus`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/aus/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContentConfigurationResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_au_config(self, body, auid, **kwargs):  # noqa: E501
        """Store the configuration of an AU  # noqa: E501

        Store the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_config(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuConfiguration body: The Archival Unit configuration to be stored (required)
        :param str auid: The identifier of the AU for this configuration. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_au_config_with_http_info(body, auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_au_config_with_http_info(body, auid, **kwargs)  # noqa: E501
            return data

    def put_au_config_with_http_info(self, body, auid, **kwargs):  # noqa: E501
        """Store the configuration of an AU  # noqa: E501

        Store the configuration of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_config_with_http_info(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuConfiguration body: The Archival Unit configuration to be stored (required)
        :param str auid: The identifier of the AU for this configuration. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_au_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_au_config`")  # noqa: E501
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_au_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_au_substance_check(self, auid, **kwargs):  # noqa: E501
        """Update the substance of an AU  # noqa: E501

        Update the substance of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_substance_check(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the substance check is requested (required)
        :return: CheckSubstanceResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_au_substance_check_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_au_substance_check_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def put_au_substance_check_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Update the substance of an AU  # noqa: E501

        Update the substance of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_substance_check_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the AU for which the substance check is requested (required)
        :return: CheckSubstanceResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_au_substance_check" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_au_substance_check`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ausubstances/{auid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CheckSubstanceResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_au_suspect_url_versions(self, body, auid, **kwargs):  # noqa: E501
        """Update the suspect URL versions of an AU  # noqa: E501

        Update the suspect URL versions of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_suspect_url_versions(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit suspect URL versions to be updated (required)
        :param str auid: The identifier of the AU for which the suspect URL versions are to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_au_suspect_url_versions_with_http_info(body, auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_au_suspect_url_versions_with_http_info(body, auid, **kwargs)  # noqa: E501
            return data

    def put_au_suspect_url_versions_with_http_info(self, body, auid, **kwargs):  # noqa: E501
        """Update the suspect URL versions of an AU  # noqa: E501

        Update the suspect URL versions of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_au_suspect_url_versions_with_http_info(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit suspect URL versions to be updated (required)
        :param str auid: The identifier of the AU for which the suspect URL versions are to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'auid', 'x_lockss_request_cookie']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_au_suspect_url_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_au_suspect_url_versions`")  # noqa: E501
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_au_suspect_url_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_lockss_request_cookie' in params:
            header_params['X-Lockss-Request-Cookie'] = params['x_lockss_request_cookie']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aususpecturls/{auid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_aus_deactivate(self, body, **kwargs):  # noqa: E501
        """Deactivate AUs  # noqa: E501

        Deactivate a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_deactivate(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be deactivated (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_aus_deactivate_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_aus_deactivate_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def put_aus_deactivate_with_http_info(self, body, **kwargs):  # noqa: E501
        """Deactivate AUs  # noqa: E501

        Deactivate a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_deactivate_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be deactivated (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_aus_deactivate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_aus_deactivate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/aus/deactivate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContentConfigurationResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_aus_md_disable(self, auid, **kwargs):  # noqa: E501
        """Disable AU metadata extraction  # noqa: E501

        Disable the metadata extraction for an AU given its identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_md_disable(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the Archival Units for which metadata extraction is to be disabled (required)
        :return: RequestAuControlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_aus_md_disable_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_aus_md_disable_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def put_aus_md_disable_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Disable AU metadata extraction  # noqa: E501

        Disable the metadata extraction for an AU given its identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_md_disable_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the Archival Units for which metadata extraction is to be disabled (required)
        :return: RequestAuControlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_aus_md_disable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_aus_md_disable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/mddisable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestAuControlResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_aus_md_enable(self, auid, **kwargs):  # noqa: E501
        """Enable AU metadata extraction  # noqa: E501

        Enable the metadata extraction for an AU given its identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_md_enable(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the Archival Units for which metadata extraction is to be enabled (required)
        :return: RequestAuControlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_aus_md_enable_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_aus_md_enable_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def put_aus_md_enable_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Enable AU metadata extraction  # noqa: E501

        Enable the metadata extraction for an AU given its identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_md_enable_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: The identifier of the Archival Units for which metadata extraction is to be enabled (required)
        :return: RequestAuControlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_aus_md_enable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_aus_md_enable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/mdenable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestAuControlResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_aus_reactivate(self, body, **kwargs):  # noqa: E501
        """Reactivate AUs  # noqa: E501

        Reactivate a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_reactivate(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be reactivated (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_aus_reactivate_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_aus_reactivate_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def put_aus_reactivate_with_http_info(self, body, **kwargs):  # noqa: E501
        """Reactivate AUs  # noqa: E501

        Reactivate a group of AUs given their identifiers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_aus_reactivate_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: The identifiers of the Archival Units to be reactivated (required)
        :return: list[ContentConfigurationResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_aus_reactivate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_aus_reactivate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/aus/reactivate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContentConfigurationResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_no_au_peers(self, body, auid, **kwargs):  # noqa: E501
        """Update the NoAuPeerSet object of an AU  # noqa: E501

        Update the NoAuPeerSet object of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_no_au_peers(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit NoAuPeerSet object to be updated (required)
        :param str auid: The identifier of the AU for which the NoAuPeerSet object is to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_no_au_peers_with_http_info(body, auid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_no_au_peers_with_http_info(body, auid, **kwargs)  # noqa: E501
            return data

    def put_no_au_peers_with_http_info(self, body, auid, **kwargs):  # noqa: E501
        """Update the NoAuPeerSet object of an AU  # noqa: E501

        Update the NoAuPeerSet object of an AU given the AU identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_no_au_peers_with_http_info(body, auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: The parts of the Archival Unit NoAuPeerSet object to be updated (required)
        :param str auid: The identifier of the AU for which the NoAuPeerSet object is to be updated (required)
        :param str x_lockss_request_cookie: The LOCKSS-specific request cookie header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'auid', 'x_lockss_request_cookie']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_no_au_peers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_no_au_peers`")  # noqa: E501
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `put_no_au_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_lockss_request_cookie' in params:
            header_params['X-Lockss-Request-Cookie'] = params['x_lockss_request_cookie']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/noaupeers/{auid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
