# coding: utf-8

"""
    LOCKSS Configuration Service REST API

    REST API of the LOCKSS Configuration Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.config.api_client import ApiClient


class ConfigApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_last_update_time(self, **kwargs):  # noqa: E501
        """Get the timestamp when the configuration was last updated  # noqa: E501

        Get the timestamp when the configuration was last updated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_last_update_time(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: datetime
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_last_update_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_last_update_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_last_update_time_with_http_info(self, **kwargs):  # noqa: E501
        """Get the timestamp when the configuration was last updated  # noqa: E501

        Get the timestamp when the configuration was last updated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_last_update_time_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: datetime
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_last_update_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/lastupdatetime', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='datetime',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_loaded_url_list(self, **kwargs):  # noqa: E501
        """Get the URLs from which the configuration was loaded  # noqa: E501

        Get the URLs from which the configuration was actually loaded, reflecting any failover to local copies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loaded_url_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_loaded_url_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_loaded_url_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_loaded_url_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get the URLs from which the configuration was loaded  # noqa: E501

        Get the URLs from which the configuration was actually loaded, reflecting any failover to local copies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_loaded_url_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_loaded_url_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/loadedurls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_platform_config(self, **kwargs):  # noqa: E501
        """Get the platform configuration  # noqa: E501

        Get the platform configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_platform_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformConfigurationWsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_platform_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_platform_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_platform_config_with_http_info(self, **kwargs):  # noqa: E501
        """Get the platform configuration  # noqa: E501

        Get the platform configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_platform_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformConfigurationWsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_platform_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/platform', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PlatformConfigurationWsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section_config(self, section_name, **kwargs):  # noqa: E501
        """Get the named configuration file  # noqa: E501

        Get the configuration file stored for a given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section_config(section_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_name: The name of the section for which the configuration file is requested (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_section_config_with_http_info(section_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_section_config_with_http_info(section_name, **kwargs)  # noqa: E501
            return data

    def get_section_config_with_http_info(self, section_name, **kwargs):  # noqa: E501
        """Get the named configuration file  # noqa: E501

        Get the configuration file stored for a given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_section_config_with_http_info(section_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str section_name: The name of the section for which the configuration file is requested (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['section_name', 'if_match', 'if_modified_since', 'if_none_match', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'section_name' is set
        if ('section_name' not in params or
                params['section_name'] is None):
            raise ValueError("Missing the required parameter `section_name` when calling `get_section_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'section_name' in params:
            path_params['sectionName'] = params['section_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_none_match' in params:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/file/{sectionName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_url_config(self, url, **kwargs):  # noqa: E501
        """Get the configuration file for a URL  # noqa: E501

        Get the configuration file stored for a given URL  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_url_config(url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str url: The URL for which the configuration is requested (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_url_config_with_http_info(url, **kwargs)  # noqa: E501
        else:
            (data) = self.get_url_config_with_http_info(url, **kwargs)  # noqa: E501
            return data

    def get_url_config_with_http_info(self, url, **kwargs):  # noqa: E501
        """Get the configuration file for a URL  # noqa: E501

        Get the configuration file stored for a given URL  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_url_config_with_http_info(url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str url: The URL for which the configuration is requested (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['url', 'if_match', 'if_modified_since', 'if_none_match', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_url_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'url' is set
        if ('url' not in params or
                params['url'] is None):
            raise ValueError("Missing the required parameter `url` when calling `get_url_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501

        header_params = {}
        if 'if_match' in params:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_none_match' in params:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_config(self, config_file, section_name, **kwargs):  # noqa: E501
        """Store the named configuration file  # noqa: E501

        Store the configuration file for a given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_config(config_file, section_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_file: (required)
        :param str section_name: The name of the section for which the configuration file is to be stored (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_config_with_http_info(config_file, section_name, **kwargs)  # noqa: E501
        else:
            (data) = self.put_config_with_http_info(config_file, section_name, **kwargs)  # noqa: E501
            return data

    def put_config_with_http_info(self, config_file, section_name, **kwargs):  # noqa: E501
        """Store the named configuration file  # noqa: E501

        Store the configuration file for a given name  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_config_with_http_info(config_file, section_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_file: (required)
        :param str section_name: The name of the section for which the configuration file is to be stored (required)
        :param str if_match: The If-Match header
        :param str if_modified_since: The If-Match header
        :param str if_none_match: The If-Match header
        :param str if_unmodified_since: The If-Match header
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_file', 'section_name', 'if_match', 'if_modified_since', 'if_none_match', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_file' is set
        if ('config_file' not in params or
                params['config_file'] is None):
            raise ValueError("Missing the required parameter `config_file` when calling `put_config`")  # noqa: E501
        # verify the required parameter 'section_name' is set
        if ('section_name' not in params or
                params['section_name'] is None):
            raise ValueError("Missing the required parameter `section_name` when calling `put_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'section_name' in params:
            path_params['sectionName'] = params['section_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_none_match' in params:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'config_file' in params:
            local_var_files['configFile'] = params['config_file']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/file/{sectionName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_config_reload(self, **kwargs):  # noqa: E501
        """Request a configuration reload  # noqa: E501

        Request that the stored configuration is reloaded  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_config_reload(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_config_reload_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.put_config_reload_with_http_info(**kwargs)  # noqa: E501
            return data

    def put_config_reload_with_http_info(self, **kwargs):  # noqa: E501
        """Request a configuration reload  # noqa: E501

        Request that the stored configuration is reloaded  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_config_reload_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_config_reload" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/reload', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
