# coding: utf-8

"""
    LOCKSS Configuration Service REST API

    REST API of the LOCKSS Configuration Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.config.api_client import ApiClient


class PluginsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_plugins(self, plugin_query, **kwargs):  # noqa: E501
        """Query for plugin properties  # noqa: E501

        Query for plugins that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugins(plugin_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_query: The query that specifies the plugins to be returned (required)
        :return: list[PluginWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_plugins_with_http_info(plugin_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_plugins_with_http_info(plugin_query, **kwargs)  # noqa: E501
            return data

    def get_plugins_with_http_info(self, plugin_query, **kwargs):  # noqa: E501
        """Query for plugin properties  # noqa: E501

        Query for plugins that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_plugins_with_http_info(plugin_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str plugin_query: The query that specifies the plugins to be returned (required)
        :return: list[PluginWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plugins" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_query' is set
        if ('plugin_query' not in params or
                params['plugin_query'] is None):
            raise ValueError("Missing the required parameter `plugin_query` when calling `get_plugins`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'plugin_query' in params:
            query_params.append(('pluginQuery', params['plugin_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/plugins', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PluginWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
