# coding: utf-8

"""
    LOCKSS Configuration Service REST API

    REST API of the LOCKSS Configuration Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.config.api_client import ApiClient


class TdbApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_tdb_aus(self, tdb_au_query, **kwargs):  # noqa: E501
        """Query the TDB for AUs  # noqa: E501

        Query the TDB for AUs that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_aus(tdb_au_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_au_query: The query that specifies the TDB AUs to be returned (required)
        :return: list[TdbAuWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tdb_aus_with_http_info(tdb_au_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tdb_aus_with_http_info(tdb_au_query, **kwargs)  # noqa: E501
            return data

    def get_tdb_aus_with_http_info(self, tdb_au_query, **kwargs):  # noqa: E501
        """Query the TDB for AUs  # noqa: E501

        Query the TDB for AUs that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_aus_with_http_info(tdb_au_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_au_query: The query that specifies the TDB AUs to be returned (required)
        :return: list[TdbAuWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tdb_au_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tdb_aus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tdb_au_query' is set
        if ('tdb_au_query' not in params or
                params['tdb_au_query'] is None):
            raise ValueError("Missing the required parameter `tdb_au_query` when calling `get_tdb_aus`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tdb_au_query' in params:
            query_params.append(('tdbAuQuery', params['tdb_au_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/tdbaus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TdbAuWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tdb_publishers(self, tdb_publisher_query, **kwargs):  # noqa: E501
        """Query the TDB for Publishers  # noqa: E501

        Query the TDB for Publishers that meet a set of specifie conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_publishers(tdb_publisher_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_publisher_query: The query that specifies the TDB Publishers to be returned (required)
        :return: list[TdbPublisherWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tdb_publishers_with_http_info(tdb_publisher_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tdb_publishers_with_http_info(tdb_publisher_query, **kwargs)  # noqa: E501
            return data

    def get_tdb_publishers_with_http_info(self, tdb_publisher_query, **kwargs):  # noqa: E501
        """Query the TDB for Publishers  # noqa: E501

        Query the TDB for Publishers that meet a set of specifie conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_publishers_with_http_info(tdb_publisher_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_publisher_query: The query that specifies the TDB Publishers to be returned (required)
        :return: list[TdbPublisherWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tdb_publisher_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tdb_publishers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tdb_publisher_query' is set
        if ('tdb_publisher_query' not in params or
                params['tdb_publisher_query'] is None):
            raise ValueError("Missing the required parameter `tdb_publisher_query` when calling `get_tdb_publishers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tdb_publisher_query' in params:
            query_params.append(('tdbPublisherQuery', params['tdb_publisher_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/tdbpublishers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TdbPublisherWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tdb_titles(self, tdb_title_query, **kwargs):  # noqa: E501
        """Query the TDB for Titles  # noqa: E501

        Query the TDB for Titles that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_titles(tdb_title_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_title_query: The query that specifies the TDB Titles to be returned (required)
        :return: list[TdbTitleWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tdb_titles_with_http_info(tdb_title_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tdb_titles_with_http_info(tdb_title_query, **kwargs)  # noqa: E501
            return data

    def get_tdb_titles_with_http_info(self, tdb_title_query, **kwargs):  # noqa: E501
        """Query the TDB for Titles  # noqa: E501

        Query the TDB for Titles that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tdb_titles_with_http_info(tdb_title_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tdb_title_query: The query that specifies the TDB Titles to be returned (required)
        :return: list[TdbTitleWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tdb_title_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tdb_titles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tdb_title_query' is set
        if ('tdb_title_query' not in params or
                params['tdb_title_query'] is None):
            raise ValueError("Missing the required parameter `tdb_title_query` when calling `get_tdb_titles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tdb_title_query' in params:
            query_params.append(('tdbTitleQuery', params['tdb_title_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/tdbtitles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TdbTitleWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
