# coding: utf-8

"""
    LOCKSS Crawler Service REST API

    REST API of the LOCKSS Crawler Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.crawler.api_client import ApiClient


class CrawlersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_crawler_config(self, crawler_id, **kwargs):  # noqa: E501
        """Return information about a crawler.  # noqa: E501

        Get information related to a installed crawler.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawler_config(crawler_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crawler_id: Identifier for the crawler (required)
        :return: CrawlerConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawler_config_with_http_info(crawler_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawler_config_with_http_info(crawler_id, **kwargs)  # noqa: E501
            return data

    def get_crawler_config_with_http_info(self, crawler_id, **kwargs):  # noqa: E501
        """Return information about a crawler.  # noqa: E501

        Get information related to a installed crawler.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawler_config_with_http_info(crawler_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crawler_id: Identifier for the crawler (required)
        :return: CrawlerConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crawler_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawler_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crawler_id' is set
        if ('crawler_id' not in params or
                params['crawler_id'] is None):
            raise ValueError("Missing the required parameter `crawler_id` when calling `get_crawler_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'crawler_id' in params:
            path_params['crawlerId'] = params['crawler_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawlers/{crawlerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrawlerConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawlers(self, **kwargs):  # noqa: E501
        """Get the list of supported crawlers.  # noqa: E501

        Return the list of supported crawlers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawlers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CrawlerStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawlers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_crawlers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_crawlers_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of supported crawlers.  # noqa: E501

        Return the list of supported crawlers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawlers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CrawlerStatuses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawlers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawlers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrawlerStatuses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
