# coding: utf-8

"""
    LOCKSS Crawler Service REST API

    REST API of the LOCKSS Crawler Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.crawler.api_client import ApiClient


class CrawlsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_crawl_by_id(self, job_id, **kwargs):  # noqa: E501
        """Get the crawl status of this job  # noqa: E501

        Get the job represented by this crawl id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_by_id(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :return: CrawlStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_by_id_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_by_id_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_by_id_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get the crawl status of this job  # noqa: E501

        Get the job represented by this crawl id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_by_id_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :return: CrawlStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrawlStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_by_mime_type(self, job_id, type, **kwargs):  # noqa: E501
        """A pageable list of urls of mimetype.  # noqa: E501

        Get a list of urls of mimetype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_by_mime_type(job_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param str type: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_by_mime_type_with_http_info(job_id, type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_by_mime_type_with_http_info(job_id, type, **kwargs)  # noqa: E501
            return data

    def get_crawl_by_mime_type_with_http_info(self, job_id, type, **kwargs):  # noqa: E501
        """A pageable list of urls of mimetype.  # noqa: E501

        Get a list of urls of mimetype.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_by_mime_type_with_http_info(job_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param str type: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'type', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_by_mime_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_by_mime_type`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_crawl_by_mime_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/mimeType/{type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_errors(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of urls with errors.  # noqa: E501

        Get a list of urls with errors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_errors(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_errors_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_errors_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_errors_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of urls with errors.  # noqa: E501

        Get a list of urls with errors.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_errors_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_errors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_errors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/errors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_excluded(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of excluded urls.  # noqa: E501

        Get a list of excluded urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_excluded(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: identifier used to identify a specific crawl. (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_excluded_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_excluded_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_excluded_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of excluded urls.  # noqa: E501

        Get a list of excluded urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_excluded_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: identifier used to identify a specific crawl. (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_excluded" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_excluded`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/excluded', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_fetched(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of fetched urls.  # noqa: E501

        Get a list of fetched urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_fetched(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of jobs to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_fetched_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_fetched_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_fetched_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of fetched urls.  # noqa: E501

        Get a list of fetched urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_fetched_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of jobs to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_fetched" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_fetched`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/fetched', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_not_modified(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of not modified urls.  # noqa: E501

        Get a list of not modified urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_not_modified(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_not_modified_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_not_modified_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_not_modified_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of not modified urls.  # noqa: E501

        Get a list of not modified urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_not_modified_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_not_modified" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_not_modified`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/notModified', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_parsed(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of parsed urls.  # noqa: E501

        Get a list of parsed urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_parsed(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_parsed_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_parsed_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_parsed_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of parsed urls.  # noqa: E501

        Get a list of parsed urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_parsed_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_parsed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_parsed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/parsed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawl_pending(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of pending urls.  # noqa: E501

        Get a list of pending urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_pending(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawl_pending_with_http_info(job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crawl_pending_with_http_info(job_id, **kwargs)  # noqa: E501
            return data

    def get_crawl_pending_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """A pageable list of pending urls.  # noqa: E501

        Get a list of pending urls.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawl_pending_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_id: (required)
        :param int limit: The number of jobs per page.
        :param str continuation_token: The continuation token of the next page of urls to be returned.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawl_pending" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_crawl_pending`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls/{jobId}/pending', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crawls(self, **kwargs):  # noqa: E501
        """Get the list of crawls.  # noqa: E501

        Get a list of crawls a pageful at a time as defined by limit.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawls(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of jobs per page
        :param str continuation_token: The continuation token of the next page of crawl status data to be returned.
        :return: CrawlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crawls_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_crawls_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_crawls_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of crawls.  # noqa: E501

        Get a list of crawls a pageful at a time as defined by limit.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crawls_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of jobs per page
        :param str continuation_token: The continuation token of the next page of crawl status data to be returned.
        :return: CrawlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crawls" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/crawls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrawlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
