# coding: utf-8

"""
    LOCKSS Crawler Service REST API

    REST API of the LOCKSS Crawler Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.crawler.api_client import ApiClient


class WsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_ws_crawls(self, crawl_query, **kwargs):  # noqa: E501
        """Query for list of crawls based on subset defined by query string  # noqa: E501

        Query for crawls that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ws_crawls(crawl_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crawl_query: The query that specifies the crawls to be returned (required)
        :return: CrawlWsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ws_crawls_with_http_info(crawl_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ws_crawls_with_http_info(crawl_query, **kwargs)  # noqa: E501
            return data

    def get_ws_crawls_with_http_info(self, crawl_query, **kwargs):  # noqa: E501
        """Query for list of crawls based on subset defined by query string  # noqa: E501

        Query for crawls that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ws_crawls_with_http_info(crawl_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str crawl_query: The query that specifies the crawls to be returned (required)
        :return: CrawlWsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['crawl_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ws_crawls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'crawl_query' is set
        if ('crawl_query' not in params or
                params['crawl_query'] is None):
            raise ValueError("Missing the required parameter `crawl_query` when calling `get_ws_crawls`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'crawl_query' in params:
            query_params.append(('crawlQuery', params['crawl_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/crawls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrawlWsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
