# coding: utf-8

"""
    LOCKSS Crawler Service REST API

    REST API of the LOCKSS Crawler Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CrawlDesc(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'au_id': 'str',
        'crawl_kind': 'str',
        'crawler_id': 'str',
        'force_crawl': 'bool',
        'refetch_depth': 'int',
        'priority': 'int',
        'crawl_list': 'list[str]',
        'crawl_depth': 'int',
        'extra_crawler_data': 'dict(str, object)'
    }

    attribute_map = {
        'au_id': 'auId',
        'crawl_kind': 'crawlKind',
        'crawler_id': 'crawlerId',
        'force_crawl': 'forceCrawl',
        'refetch_depth': 'refetchDepth',
        'priority': 'priority',
        'crawl_list': 'crawlList',
        'crawl_depth': 'crawlDepth',
        'extra_crawler_data': 'extraCrawlerData'
    }

    def __init__(self, au_id=None, crawl_kind=None, crawler_id='classic', force_crawl=False, refetch_depth=-1, priority=0, crawl_list=None, crawl_depth=None, extra_crawler_data=None):  # noqa: E501
        """CrawlDesc - a model defined in Swagger"""  # noqa: E501
        self._au_id = None
        self._crawl_kind = None
        self._crawler_id = None
        self._force_crawl = None
        self._refetch_depth = None
        self._priority = None
        self._crawl_list = None
        self._crawl_depth = None
        self._extra_crawler_data = None
        self.discriminator = None
        self.au_id = au_id
        self.crawl_kind = crawl_kind
        if crawler_id is not None:
            self.crawler_id = crawler_id
        if force_crawl is not None:
            self.force_crawl = force_crawl
        if refetch_depth is not None:
            self.refetch_depth = refetch_depth
        if priority is not None:
            self.priority = priority
        if crawl_list is not None:
            self.crawl_list = crawl_list
        if crawl_depth is not None:
            self.crawl_depth = crawl_depth
        if extra_crawler_data is not None:
            self.extra_crawler_data = extra_crawler_data

    @property
    def au_id(self):
        """Gets the au_id of this CrawlDesc.  # noqa: E501

        The identifier of the archival unit to be crawled.  # noqa: E501

        :return: The au_id of this CrawlDesc.  # noqa: E501
        :rtype: str
        """
        return self._au_id

    @au_id.setter
    def au_id(self, au_id):
        """Sets the au_id of this CrawlDesc.

        The identifier of the archival unit to be crawled.  # noqa: E501

        :param au_id: The au_id of this CrawlDesc.  # noqa: E501
        :type: str
        """
        if au_id is None:
            raise ValueError("Invalid value for `au_id`, must not be `None`")  # noqa: E501

        self._au_id = au_id

    @property
    def crawl_kind(self):
        """Gets the crawl_kind of this CrawlDesc.  # noqa: E501

        The kind of crawl being performed either 'newContent' or 'repair'.  # noqa: E501

        :return: The crawl_kind of this CrawlDesc.  # noqa: E501
        :rtype: str
        """
        return self._crawl_kind

    @crawl_kind.setter
    def crawl_kind(self, crawl_kind):
        """Sets the crawl_kind of this CrawlDesc.

        The kind of crawl being performed either 'newContent' or 'repair'.  # noqa: E501

        :param crawl_kind: The crawl_kind of this CrawlDesc.  # noqa: E501
        :type: str
        """
        if crawl_kind is None:
            raise ValueError("Invalid value for `crawl_kind`, must not be `None`")  # noqa: E501
        allowed_values = ["newContent", "repair"]  # noqa: E501
        if crawl_kind not in allowed_values:
            raise ValueError(
                "Invalid value for `crawl_kind` ({0}), must be one of {1}"  # noqa: E501
                .format(crawl_kind, allowed_values)
            )

        self._crawl_kind = crawl_kind

    @property
    def crawler_id(self):
        """Gets the crawler_id of this CrawlDesc.  # noqa: E501

        The crawler to be used for this crawl.  # noqa: E501

        :return: The crawler_id of this CrawlDesc.  # noqa: E501
        :rtype: str
        """
        return self._crawler_id

    @crawler_id.setter
    def crawler_id(self, crawler_id):
        """Sets the crawler_id of this CrawlDesc.

        The crawler to be used for this crawl.  # noqa: E501

        :param crawler_id: The crawler_id of this CrawlDesc.  # noqa: E501
        :type: str
        """

        self._crawler_id = crawler_id

    @property
    def force_crawl(self):
        """Gets the force_crawl of this CrawlDesc.  # noqa: E501

        An indication of whether the crawl is to be forced, suppressing conditions that might otherwise prevent the crawl from happening.  # noqa: E501

        :return: The force_crawl of this CrawlDesc.  # noqa: E501
        :rtype: bool
        """
        return self._force_crawl

    @force_crawl.setter
    def force_crawl(self, force_crawl):
        """Sets the force_crawl of this CrawlDesc.

        An indication of whether the crawl is to be forced, suppressing conditions that might otherwise prevent the crawl from happening.  # noqa: E501

        :param force_crawl: The force_crawl of this CrawlDesc.  # noqa: E501
        :type: bool
        """

        self._force_crawl = force_crawl

    @property
    def refetch_depth(self):
        """Gets the refetch_depth of this CrawlDesc.  # noqa: E501

        The refetch depth to use for a deep crawl.  # noqa: E501

        :return: The refetch_depth of this CrawlDesc.  # noqa: E501
        :rtype: int
        """
        return self._refetch_depth

    @refetch_depth.setter
    def refetch_depth(self, refetch_depth):
        """Sets the refetch_depth of this CrawlDesc.

        The refetch depth to use for a deep crawl.  # noqa: E501

        :param refetch_depth: The refetch_depth of this CrawlDesc.  # noqa: E501
        :type: int
        """

        self._refetch_depth = refetch_depth

    @property
    def priority(self):
        """Gets the priority of this CrawlDesc.  # noqa: E501

        The priority for the crawl.  # noqa: E501

        :return: The priority of this CrawlDesc.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this CrawlDesc.

        The priority for the crawl.  # noqa: E501

        :param priority: The priority of this CrawlDesc.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def crawl_list(self):
        """Gets the crawl_list of this CrawlDesc.  # noqa: E501

        The list of URLs to crawl.  # noqa: E501

        :return: The crawl_list of this CrawlDesc.  # noqa: E501
        :rtype: list[str]
        """
        return self._crawl_list

    @crawl_list.setter
    def crawl_list(self, crawl_list):
        """Sets the crawl_list of this CrawlDesc.

        The list of URLs to crawl.  # noqa: E501

        :param crawl_list: The crawl_list of this CrawlDesc.  # noqa: E501
        :type: list[str]
        """

        self._crawl_list = crawl_list

    @property
    def crawl_depth(self):
        """Gets the crawl_depth of this CrawlDesc.  # noqa: E501

        The depth to which the links should be followed. 0 means do not follow links.  # noqa: E501

        :return: The crawl_depth of this CrawlDesc.  # noqa: E501
        :rtype: int
        """
        return self._crawl_depth

    @crawl_depth.setter
    def crawl_depth(self, crawl_depth):
        """Sets the crawl_depth of this CrawlDesc.

        The depth to which the links should be followed. 0 means do not follow links.  # noqa: E501

        :param crawl_depth: The crawl_depth of this CrawlDesc.  # noqa: E501
        :type: int
        """

        self._crawl_depth = crawl_depth

    @property
    def extra_crawler_data(self):
        """Gets the extra_crawler_data of this CrawlDesc.  # noqa: E501

        A map of additional properties for a crawl on a given crawler.  # noqa: E501

        :return: The extra_crawler_data of this CrawlDesc.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._extra_crawler_data

    @extra_crawler_data.setter
    def extra_crawler_data(self, extra_crawler_data):
        """Sets the extra_crawler_data of this CrawlDesc.

        A map of additional properties for a crawl on a given crawler.  # noqa: E501

        :param extra_crawler_data: The extra_crawler_data of this CrawlDesc.  # noqa: E501
        :type: dict(str, object)
        """

        self._extra_crawler_data = extra_crawler_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CrawlDesc, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CrawlDesc):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
