# coding: utf-8

"""
    LOCKSS Crawler Service REST API

    REST API of the LOCKSS Crawler Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CrawlStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'job_id': 'str',
        'au_id': 'str',
        'au_name': 'str',
        'type': 'str',
        'start_urls': 'list[str]',
        'priority': 'int',
        'crawler_id': 'str',
        'sources': 'list[str]',
        'depth': 'int',
        'refetch_depth': 'int',
        'proxy': 'str',
        'start_time': 'int',
        'end_time': 'int',
        'job_status': 'JobStatus',
        'is_waiting': 'bool',
        'is_active': 'bool',
        'is_error': 'bool',
        'bytes_fetched': 'int',
        'fetched_items': 'Counter',
        'excluded_items': 'Counter',
        'not_modified_items': 'Counter',
        'parsed_items': 'Counter',
        'pending_items': 'Counter',
        'errors': 'Counter',
        'mime_types': 'list[MimeCounter]'
    }

    attribute_map = {
        'job_id': 'jobId',
        'au_id': 'auId',
        'au_name': 'auName',
        'type': 'type',
        'start_urls': 'startUrls',
        'priority': 'priority',
        'crawler_id': 'crawlerId',
        'sources': 'sources',
        'depth': 'depth',
        'refetch_depth': 'refetchDepth',
        'proxy': 'proxy',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'job_status': 'jobStatus',
        'is_waiting': 'isWaiting',
        'is_active': 'isActive',
        'is_error': 'isError',
        'bytes_fetched': 'bytesFetched',
        'fetched_items': 'fetchedItems',
        'excluded_items': 'excludedItems',
        'not_modified_items': 'notModifiedItems',
        'parsed_items': 'parsedItems',
        'pending_items': 'pendingItems',
        'errors': 'errors',
        'mime_types': 'mimeTypes'
    }

    def __init__(self, job_id=None, au_id=None, au_name=None, type=None, start_urls=None, priority=None, crawler_id='classic', sources=None, depth=None, refetch_depth=None, proxy=None, start_time=None, end_time=None, job_status=None, is_waiting=None, is_active=None, is_error=None, bytes_fetched=None, fetched_items=None, excluded_items=None, not_modified_items=None, parsed_items=None, pending_items=None, errors=None, mime_types=None):  # noqa: E501
        """CrawlStatus - a model defined in Swagger"""  # noqa: E501
        self._job_id = None
        self._au_id = None
        self._au_name = None
        self._type = None
        self._start_urls = None
        self._priority = None
        self._crawler_id = None
        self._sources = None
        self._depth = None
        self._refetch_depth = None
        self._proxy = None
        self._start_time = None
        self._end_time = None
        self._job_status = None
        self._is_waiting = None
        self._is_active = None
        self._is_error = None
        self._bytes_fetched = None
        self._fetched_items = None
        self._excluded_items = None
        self._not_modified_items = None
        self._parsed_items = None
        self._pending_items = None
        self._errors = None
        self._mime_types = None
        self.discriminator = None
        self.job_id = job_id
        self.au_id = au_id
        self.au_name = au_name
        self.type = type
        self.start_urls = start_urls
        self.priority = priority
        self.crawler_id = crawler_id
        if sources is not None:
            self.sources = sources
        if depth is not None:
            self.depth = depth
        if refetch_depth is not None:
            self.refetch_depth = refetch_depth
        if proxy is not None:
            self.proxy = proxy
        self.start_time = start_time
        self.end_time = end_time
        self.job_status = job_status
        if is_waiting is not None:
            self.is_waiting = is_waiting
        if is_active is not None:
            self.is_active = is_active
        if is_error is not None:
            self.is_error = is_error
        if bytes_fetched is not None:
            self.bytes_fetched = bytes_fetched
        if fetched_items is not None:
            self.fetched_items = fetched_items
        if excluded_items is not None:
            self.excluded_items = excluded_items
        if not_modified_items is not None:
            self.not_modified_items = not_modified_items
        if parsed_items is not None:
            self.parsed_items = parsed_items
        if pending_items is not None:
            self.pending_items = pending_items
        if errors is not None:
            self.errors = errors
        if mime_types is not None:
            self.mime_types = mime_types

    @property
    def job_id(self):
        """Gets the job_id of this CrawlStatus.  # noqa: E501

        The id for the crawl.  # noqa: E501

        :return: The job_id of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this CrawlStatus.

        The id for the crawl.  # noqa: E501

        :param job_id: The job_id of this CrawlStatus.  # noqa: E501
        :type: str
        """
        if job_id is None:
            raise ValueError("Invalid value for `job_id`, must not be `None`")  # noqa: E501

        self._job_id = job_id

    @property
    def au_id(self):
        """Gets the au_id of this CrawlStatus.  # noqa: E501

        The id for the au.  # noqa: E501

        :return: The au_id of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._au_id

    @au_id.setter
    def au_id(self, au_id):
        """Sets the au_id of this CrawlStatus.

        The id for the au.  # noqa: E501

        :param au_id: The au_id of this CrawlStatus.  # noqa: E501
        :type: str
        """
        if au_id is None:
            raise ValueError("Invalid value for `au_id`, must not be `None`")  # noqa: E501

        self._au_id = au_id

    @property
    def au_name(self):
        """Gets the au_name of this CrawlStatus.  # noqa: E501

        The name for the au.  # noqa: E501

        :return: The au_name of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._au_name

    @au_name.setter
    def au_name(self, au_name):
        """Sets the au_name of this CrawlStatus.

        The name for the au.  # noqa: E501

        :param au_name: The au_name of this CrawlStatus.  # noqa: E501
        :type: str
        """
        if au_name is None:
            raise ValueError("Invalid value for `au_name`, must not be `None`")  # noqa: E501

        self._au_name = au_name

    @property
    def type(self):
        """Gets the type of this CrawlStatus.  # noqa: E501

        The type of crawl.  # noqa: E501

        :return: The type of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CrawlStatus.

        The type of crawl.  # noqa: E501

        :param type: The type of this CrawlStatus.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def start_urls(self):
        """Gets the start_urls of this CrawlStatus.  # noqa: E501

        The array of start urls.  # noqa: E501

        :return: The start_urls of this CrawlStatus.  # noqa: E501
        :rtype: list[str]
        """
        return self._start_urls

    @start_urls.setter
    def start_urls(self, start_urls):
        """Sets the start_urls of this CrawlStatus.

        The array of start urls.  # noqa: E501

        :param start_urls: The start_urls of this CrawlStatus.  # noqa: E501
        :type: list[str]
        """
        if start_urls is None:
            raise ValueError("Invalid value for `start_urls`, must not be `None`")  # noqa: E501

        self._start_urls = start_urls

    @property
    def priority(self):
        """Gets the priority of this CrawlStatus.  # noqa: E501

        The priority for this crawl.  # noqa: E501

        :return: The priority of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this CrawlStatus.

        The priority for this crawl.  # noqa: E501

        :param priority: The priority of this CrawlStatus.  # noqa: E501
        :type: int
        """
        if priority is None:
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501

        self._priority = priority

    @property
    def crawler_id(self):
        """Gets the crawler_id of this CrawlStatus.  # noqa: E501

        The id of the crawler used for this crawl.  # noqa: E501

        :return: The crawler_id of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._crawler_id

    @crawler_id.setter
    def crawler_id(self, crawler_id):
        """Sets the crawler_id of this CrawlStatus.

        The id of the crawler used for this crawl.  # noqa: E501

        :param crawler_id: The crawler_id of this CrawlStatus.  # noqa: E501
        :type: str
        """
        if crawler_id is None:
            raise ValueError("Invalid value for `crawler_id`, must not be `None`")  # noqa: E501

        self._crawler_id = crawler_id

    @property
    def sources(self):
        """Gets the sources of this CrawlStatus.  # noqa: E501

        The sources to use for the crawl.  # noqa: E501

        :return: The sources of this CrawlStatus.  # noqa: E501
        :rtype: list[str]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """Sets the sources of this CrawlStatus.

        The sources to use for the crawl.  # noqa: E501

        :param sources: The sources of this CrawlStatus.  # noqa: E501
        :type: list[str]
        """

        self._sources = sources

    @property
    def depth(self):
        """Gets the depth of this CrawlStatus.  # noqa: E501

        The depth of the crawl.  # noqa: E501

        :return: The depth of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._depth

    @depth.setter
    def depth(self, depth):
        """Sets the depth of this CrawlStatus.

        The depth of the crawl.  # noqa: E501

        :param depth: The depth of this CrawlStatus.  # noqa: E501
        :type: int
        """

        self._depth = depth

    @property
    def refetch_depth(self):
        """Gets the refetch_depth of this CrawlStatus.  # noqa: E501

        The refetch depth of the crawl.  # noqa: E501

        :return: The refetch_depth of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._refetch_depth

    @refetch_depth.setter
    def refetch_depth(self, refetch_depth):
        """Sets the refetch_depth of this CrawlStatus.

        The refetch depth of the crawl.  # noqa: E501

        :param refetch_depth: The refetch_depth of this CrawlStatus.  # noqa: E501
        :type: int
        """

        self._refetch_depth = refetch_depth

    @property
    def proxy(self):
        """Gets the proxy of this CrawlStatus.  # noqa: E501

        The proxy used for crawling.  # noqa: E501

        :return: The proxy of this CrawlStatus.  # noqa: E501
        :rtype: str
        """
        return self._proxy

    @proxy.setter
    def proxy(self, proxy):
        """Sets the proxy of this CrawlStatus.

        The proxy used for crawling.  # noqa: E501

        :param proxy: The proxy of this CrawlStatus.  # noqa: E501
        :type: str
        """

        self._proxy = proxy

    @property
    def start_time(self):
        """Gets the start_time of this CrawlStatus.  # noqa: E501

        The timestamp for the start of crawl.  # noqa: E501

        :return: The start_time of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this CrawlStatus.

        The timestamp for the start of crawl.  # noqa: E501

        :param start_time: The start_time of this CrawlStatus.  # noqa: E501
        :type: int
        """
        if start_time is None:
            raise ValueError("Invalid value for `start_time`, must not be `None`")  # noqa: E501

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this CrawlStatus.  # noqa: E501

        The timestamp for the end of the crawl.  # noqa: E501

        :return: The end_time of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this CrawlStatus.

        The timestamp for the end of the crawl.  # noqa: E501

        :param end_time: The end_time of this CrawlStatus.  # noqa: E501
        :type: int
        """
        if end_time is None:
            raise ValueError("Invalid value for `end_time`, must not be `None`")  # noqa: E501

        self._end_time = end_time

    @property
    def job_status(self):
        """Gets the job_status of this CrawlStatus.  # noqa: E501


        :return: The job_status of this CrawlStatus.  # noqa: E501
        :rtype: JobStatus
        """
        return self._job_status

    @job_status.setter
    def job_status(self, job_status):
        """Sets the job_status of this CrawlStatus.


        :param job_status: The job_status of this CrawlStatus.  # noqa: E501
        :type: JobStatus
        """
        if job_status is None:
            raise ValueError("Invalid value for `job_status`, must not be `None`")  # noqa: E501

        self._job_status = job_status

    @property
    def is_waiting(self):
        """Gets the is_waiting of this CrawlStatus.  # noqa: E501

        True if the crawl waiting to start.  # noqa: E501

        :return: The is_waiting of this CrawlStatus.  # noqa: E501
        :rtype: bool
        """
        return self._is_waiting

    @is_waiting.setter
    def is_waiting(self, is_waiting):
        """Sets the is_waiting of this CrawlStatus.

        True if the crawl waiting to start.  # noqa: E501

        :param is_waiting: The is_waiting of this CrawlStatus.  # noqa: E501
        :type: bool
        """

        self._is_waiting = is_waiting

    @property
    def is_active(self):
        """Gets the is_active of this CrawlStatus.  # noqa: E501

        True if the crawl is active.  # noqa: E501

        :return: The is_active of this CrawlStatus.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this CrawlStatus.

        True if the crawl is active.  # noqa: E501

        :param is_active: The is_active of this CrawlStatus.  # noqa: E501
        :type: bool
        """

        self._is_active = is_active

    @property
    def is_error(self):
        """Gets the is_error of this CrawlStatus.  # noqa: E501

        True if the crawl has errored.  # noqa: E501

        :return: The is_error of this CrawlStatus.  # noqa: E501
        :rtype: bool
        """
        return self._is_error

    @is_error.setter
    def is_error(self, is_error):
        """Sets the is_error of this CrawlStatus.

        True if the crawl has errored.  # noqa: E501

        :param is_error: The is_error of this CrawlStatus.  # noqa: E501
        :type: bool
        """

        self._is_error = is_error

    @property
    def bytes_fetched(self):
        """Gets the bytes_fetched of this CrawlStatus.  # noqa: E501

        The number of bytes fetched.  # noqa: E501

        :return: The bytes_fetched of this CrawlStatus.  # noqa: E501
        :rtype: int
        """
        return self._bytes_fetched

    @bytes_fetched.setter
    def bytes_fetched(self, bytes_fetched):
        """Sets the bytes_fetched of this CrawlStatus.

        The number of bytes fetched.  # noqa: E501

        :param bytes_fetched: The bytes_fetched of this CrawlStatus.  # noqa: E501
        :type: int
        """

        self._bytes_fetched = bytes_fetched

    @property
    def fetched_items(self):
        """Gets the fetched_items of this CrawlStatus.  # noqa: E501


        :return: The fetched_items of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._fetched_items

    @fetched_items.setter
    def fetched_items(self, fetched_items):
        """Sets the fetched_items of this CrawlStatus.


        :param fetched_items: The fetched_items of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._fetched_items = fetched_items

    @property
    def excluded_items(self):
        """Gets the excluded_items of this CrawlStatus.  # noqa: E501


        :return: The excluded_items of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._excluded_items

    @excluded_items.setter
    def excluded_items(self, excluded_items):
        """Sets the excluded_items of this CrawlStatus.


        :param excluded_items: The excluded_items of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._excluded_items = excluded_items

    @property
    def not_modified_items(self):
        """Gets the not_modified_items of this CrawlStatus.  # noqa: E501


        :return: The not_modified_items of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._not_modified_items

    @not_modified_items.setter
    def not_modified_items(self, not_modified_items):
        """Sets the not_modified_items of this CrawlStatus.


        :param not_modified_items: The not_modified_items of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._not_modified_items = not_modified_items

    @property
    def parsed_items(self):
        """Gets the parsed_items of this CrawlStatus.  # noqa: E501


        :return: The parsed_items of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._parsed_items

    @parsed_items.setter
    def parsed_items(self, parsed_items):
        """Sets the parsed_items of this CrawlStatus.


        :param parsed_items: The parsed_items of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._parsed_items = parsed_items

    @property
    def pending_items(self):
        """Gets the pending_items of this CrawlStatus.  # noqa: E501


        :return: The pending_items of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._pending_items

    @pending_items.setter
    def pending_items(self, pending_items):
        """Sets the pending_items of this CrawlStatus.


        :param pending_items: The pending_items of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._pending_items = pending_items

    @property
    def errors(self):
        """Gets the errors of this CrawlStatus.  # noqa: E501


        :return: The errors of this CrawlStatus.  # noqa: E501
        :rtype: Counter
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this CrawlStatus.


        :param errors: The errors of this CrawlStatus.  # noqa: E501
        :type: Counter
        """

        self._errors = errors

    @property
    def mime_types(self):
        """Gets the mime_types of this CrawlStatus.  # noqa: E501

        The list of urls by mimeType.  # noqa: E501

        :return: The mime_types of this CrawlStatus.  # noqa: E501
        :rtype: list[MimeCounter]
        """
        return self._mime_types

    @mime_types.setter
    def mime_types(self, mime_types):
        """Sets the mime_types of this CrawlStatus.

        The list of urls by mimeType.  # noqa: E501

        :param mime_types: The mime_types of this CrawlStatus.  # noqa: E501
        :type: list[MimeCounter]
        """

        self._mime_types = mime_types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CrawlStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CrawlStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
