# coding: utf-8

"""
    LOCKSS Metadata Service REST API

    REST API of the LOCKSS Metadata Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.md.api_client import ApiClient


class MdupdatesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_mdupdates(self, **kwargs):  # noqa: E501
        """Delete all of the currently queued and active jobs  # noqa: E501

        Delete all of the currently queued and active jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mdupdates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mdupdates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_mdupdates_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_mdupdates_with_http_info(self, **kwargs):  # noqa: E501
        """Delete all of the currently queued and active jobs  # noqa: E501

        Delete all of the currently queued and active jobs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mdupdates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mdupdates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mdupdates', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_mdupdates_jobid(self, jobid, **kwargs):  # noqa: E501
        """Delete a job  # noqa: E501

        Delete a job given the job identifier, stopping any current processing, if necessary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mdupdates_jobid(jobid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str jobid: The identifier of the job to be deleted (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_mdupdates_jobid_with_http_info(jobid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_mdupdates_jobid_with_http_info(jobid, **kwargs)  # noqa: E501
            return data

    def delete_mdupdates_jobid_with_http_info(self, jobid, **kwargs):  # noqa: E501
        """Delete a job  # noqa: E501

        Delete a job given the job identifier, stopping any current processing, if necessary  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_mdupdates_jobid_with_http_info(jobid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str jobid: The identifier of the job to be deleted (required)
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['jobid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_mdupdates_jobid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'jobid' is set
        if ('jobid' not in params or
                params['jobid'] is None):
            raise ValueError("Missing the required parameter `jobid` when calling `delete_mdupdates_jobid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'jobid' in params:
            path_params['jobid'] = params['jobid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mdupdates/{jobid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mdupdates(self, **kwargs):  # noqa: E501
        """Get a list of currently active jobs  # noqa: E501

        Get a list of all currently active jobs or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mdupdates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of jobs per page
        :param str continuation_token: The continuation token of the next page of jobs to be returned
        :return: JobPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mdupdates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mdupdates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mdupdates_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of currently active jobs  # noqa: E501

        Get a list of all currently active jobs or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mdupdates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The number of jobs per page
        :param str continuation_token: The continuation token of the next page of jobs to be returned
        :return: JobPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mdupdates" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mdupdates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobPageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mdupdates_jobid(self, jobid, **kwargs):  # noqa: E501
        """Get a job  # noqa: E501

        Get a job given the job identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mdupdates_jobid(jobid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str jobid: The identifier of the requested job (required)
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mdupdates_jobid_with_http_info(jobid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mdupdates_jobid_with_http_info(jobid, **kwargs)  # noqa: E501
            return data

    def get_mdupdates_jobid_with_http_info(self, jobid, **kwargs):  # noqa: E501
        """Get a job  # noqa: E501

        Get a job given the job identifier  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mdupdates_jobid_with_http_info(jobid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str jobid: The identifier of the requested job (required)
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['jobid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mdupdates_jobid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'jobid' is set
        if ('jobid' not in params or
                params['jobid'] is None):
            raise ValueError("Missing the required parameter `jobid` when calling `get_mdupdates_jobid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'jobid' in params:
            path_params['jobid'] = params['jobid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mdupdates/{jobid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Status',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_mdupdates(self, body, **kwargs):  # noqa: E501
        """Perform an AU metadata update operation  # noqa: E501

        Perform an AU metadata update operation given the update specification  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_mdupdates(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataUpdateSpec body: The information defining the AU metadata update operation (required)
        :param bool force: An indication of whether to force the operation regardless of the current state of the AU
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_mdupdates_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_mdupdates_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_mdupdates_with_http_info(self, body, **kwargs):  # noqa: E501
        """Perform an AU metadata update operation  # noqa: E501

        Perform an AU metadata update operation given the update specification  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_mdupdates_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetadataUpdateSpec body: The information defining the AU metadata update operation (required)
        :param bool force: An indication of whether to force the operation regardless of the current state of the AU
        :return: Job
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_mdupdates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_mdupdates`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/mdupdates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Job',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
