# coding: utf-8

"""
    LOCKSS Metadata Service REST API

    REST API of the LOCKSS Metadata Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.md.api_client import ApiClient


class UrlsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_urls_doi(self, doi, **kwargs):  # noqa: E501
        """Gets the URL for a DOI  # noqa: E501

        Provides the URL for a DOI given the DOI  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_urls_doi(doi, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str doi: The DOI for which the URL is requested (required)
        :return: UrlInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_urls_doi_with_http_info(doi, **kwargs)  # noqa: E501
        else:
            (data) = self.get_urls_doi_with_http_info(doi, **kwargs)  # noqa: E501
            return data

    def get_urls_doi_with_http_info(self, doi, **kwargs):  # noqa: E501
        """Gets the URL for a DOI  # noqa: E501

        Provides the URL for a DOI given the DOI  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_urls_doi_with_http_info(doi, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str doi: The DOI for which the URL is requested (required)
        :return: UrlInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['doi']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_urls_doi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'doi' is set
        if ('doi' not in params or
                params['doi'] is None):
            raise ValueError("Missing the required parameter `doi` when calling `get_urls_doi`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'doi' in params:
            query_params.append(('doi', params['doi']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/urls/doi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_urls_open_url(self, params, **kwargs):  # noqa: E501
        """Performs an OpenURL query  # noqa: E501

        Provides the URL that results from performing an OpenURL query. With query parameters inline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_urls_open_url(params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] params: The OpenURL parameters (required)
        :return: UrlInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_urls_open_url_with_http_info(params, **kwargs)  # noqa: E501
        else:
            (data) = self.get_urls_open_url_with_http_info(params, **kwargs)  # noqa: E501
            return data

    def get_urls_open_url_with_http_info(self, params, **kwargs):  # noqa: E501
        """Performs an OpenURL query  # noqa: E501

        Provides the URL that results from performing an OpenURL query. With query parameters inline  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_urls_open_url_with_http_info(params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] params: The OpenURL parameters (required)
        :return: UrlInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_urls_open_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'params' is set
        if ('params' not in params or
                params['params'] is None):
            raise ValueError("Missing the required parameter `params` when calling `get_urls_open_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'params' in params:
            query_params.append(('params', params['params']))  # noqa: E501
            collection_formats['params'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/urls/openurl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
