# coding: utf-8

"""
    LOCKSS Metadata Service REST API

    REST API of the LOCKSS Metadata Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ApiStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_version': 'str',
        'component_name': 'str',
        'component_version': 'str',
        'lockss_version': 'str',
        'ready': 'bool',
        'service_name': 'str',
        'ready_time': 'int',
        'reason': 'str',
        'startup_status': 'str'
    }

    attribute_map = {
        'api_version': 'apiVersion',
        'component_name': 'componentName',
        'component_version': 'componentVersion',
        'lockss_version': 'lockssVersion',
        'ready': 'ready',
        'service_name': 'serviceName',
        'ready_time': 'readyTime',
        'reason': 'reason',
        'startup_status': 'startupStatus'
    }

    def __init__(self, api_version=None, component_name=None, component_version=None, lockss_version=None, ready=None, service_name=None, ready_time=None, reason=None, startup_status=None):  # noqa: E501
        """ApiStatus - a model defined in Swagger"""  # noqa: E501
        self._api_version = None
        self._component_name = None
        self._component_version = None
        self._lockss_version = None
        self._ready = None
        self._service_name = None
        self._ready_time = None
        self._reason = None
        self._startup_status = None
        self.discriminator = None
        self.api_version = api_version
        if component_name is not None:
            self.component_name = component_name
        if component_version is not None:
            self.component_version = component_version
        if lockss_version is not None:
            self.lockss_version = lockss_version
        self.ready = ready
        if service_name is not None:
            self.service_name = service_name
        if ready_time is not None:
            self.ready_time = ready_time
        if reason is not None:
            self.reason = reason
        if startup_status is not None:
            self.startup_status = startup_status

    @property
    def api_version(self):
        """Gets the api_version of this ApiStatus.  # noqa: E501

        The version of the API  # noqa: E501

        :return: The api_version of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """Sets the api_version of this ApiStatus.

        The version of the API  # noqa: E501

        :param api_version: The api_version of this ApiStatus.  # noqa: E501
        :type: str
        """
        if api_version is None:
            raise ValueError("Invalid value for `api_version`, must not be `None`")  # noqa: E501

        self._api_version = api_version

    @property
    def component_name(self):
        """Gets the component_name of this ApiStatus.  # noqa: E501

        The name of the component  # noqa: E501

        :return: The component_name of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """Sets the component_name of this ApiStatus.

        The name of the component  # noqa: E501

        :param component_name: The component_name of this ApiStatus.  # noqa: E501
        :type: str
        """

        self._component_name = component_name

    @property
    def component_version(self):
        """Gets the component_version of this ApiStatus.  # noqa: E501

        The version of the component software  # noqa: E501

        :return: The component_version of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._component_version

    @component_version.setter
    def component_version(self, component_version):
        """Sets the component_version of this ApiStatus.

        The version of the component software  # noqa: E501

        :param component_version: The component_version of this ApiStatus.  # noqa: E501
        :type: str
        """

        self._component_version = component_version

    @property
    def lockss_version(self):
        """Gets the lockss_version of this ApiStatus.  # noqa: E501

        The version of the LOCKSS system  # noqa: E501

        :return: The lockss_version of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._lockss_version

    @lockss_version.setter
    def lockss_version(self, lockss_version):
        """Sets the lockss_version of this ApiStatus.

        The version of the LOCKSS system  # noqa: E501

        :param lockss_version: The lockss_version of this ApiStatus.  # noqa: E501
        :type: str
        """

        self._lockss_version = lockss_version

    @property
    def ready(self):
        """Gets the ready of this ApiStatus.  # noqa: E501

        The indication of whether the service is available  # noqa: E501

        :return: The ready of this ApiStatus.  # noqa: E501
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """Sets the ready of this ApiStatus.

        The indication of whether the service is available  # noqa: E501

        :param ready: The ready of this ApiStatus.  # noqa: E501
        :type: bool
        """
        if ready is None:
            raise ValueError("Invalid value for `ready`, must not be `None`")  # noqa: E501

        self._ready = ready

    @property
    def service_name(self):
        """Gets the service_name of this ApiStatus.  # noqa: E501

        The name of the service  # noqa: E501

        :return: The service_name of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """Sets the service_name of this ApiStatus.

        The name of the service  # noqa: E501

        :param service_name: The service_name of this ApiStatus.  # noqa: E501
        :type: str
        """

        self._service_name = service_name

    @property
    def ready_time(self):
        """Gets the ready_time of this ApiStatus.  # noqa: E501

        The time the service last became ready.  # noqa: E501

        :return: The ready_time of this ApiStatus.  # noqa: E501
        :rtype: int
        """
        return self._ready_time

    @ready_time.setter
    def ready_time(self, ready_time):
        """Sets the ready_time of this ApiStatus.

        The time the service last became ready.  # noqa: E501

        :param ready_time: The ready_time of this ApiStatus.  # noqa: E501
        :type: int
        """

        self._ready_time = ready_time

    @property
    def reason(self):
        """Gets the reason of this ApiStatus.  # noqa: E501

        The reason the service isn't ready.  # noqa: E501

        :return: The reason of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this ApiStatus.

        The reason the service isn't ready.  # noqa: E501

        :param reason: The reason of this ApiStatus.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def startup_status(self):
        """Gets the startup_status of this ApiStatus.  # noqa: E501

        Enum indicating progress of plugin/AU processing at startup.  # noqa: E501

        :return: The startup_status of this ApiStatus.  # noqa: E501
        :rtype: str
        """
        return self._startup_status

    @startup_status.setter
    def startup_status(self, startup_status):
        """Sets the startup_status of this ApiStatus.

        Enum indicating progress of plugin/AU processing at startup.  # noqa: E501

        :param startup_status: The startup_status of this ApiStatus.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "PLUGINS_CRAWLING", "PLUGINS_COLLECTED", "PLUGINS_LOADING", "PLUGINS_LOADED", "AUS_STARTING", "AUS_STARTED"]  # noqa: E501
        if startup_status not in allowed_values:
            raise ValueError(
                "Invalid value for `startup_status` ({0}), must be one of {1}"  # noqa: E501
                .format(startup_status, allowed_values)
            )

        self._startup_status = startup_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ApiStatus, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
