# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.poller.api_client import ApiClient


class ExportApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_export_files(self, auid, **kwargs):  # noqa: E501
        """Export artifacts in an Archival Unit  # noqa: E501

        Export artifacts in an Archival Unit as a group of archives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_export_files(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str file_type: The type of archive to create
        :param bool is_compress: Indication of whether contents should be compressed
        :param bool is_exclude_dir_nodes: Indication of whether directories should be excluded
        :param str xlate_filenames: Type of filename translation to be done
        :param str file_prefix: The prefix to be used to name the exported file
        :param int max_size: The maximum size of the exported file
        :param int max_versions: The maximum number of versions of an artifact to be exported
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_export_files_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_export_files_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_export_files_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Export artifacts in an Archival Unit  # noqa: E501

        Export artifacts in an Archival Unit as a group of archives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_export_files_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str file_type: The type of archive to create
        :param bool is_compress: Indication of whether contents should be compressed
        :param bool is_exclude_dir_nodes: Indication of whether directories should be excluded
        :param str xlate_filenames: Type of filename translation to be done
        :param str file_prefix: The prefix to be used to name the exported file
        :param int max_size: The maximum size of the exported file
        :param int max_versions: The maximum number of versions of an artifact to be exported
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid', 'file_type', 'is_compress', 'is_exclude_dir_nodes', 'xlate_filenames', 'file_prefix', 'max_size', 'max_versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_export_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_export_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []
        if 'file_type' in params:
            query_params.append(('fileType', params['file_type']))  # noqa: E501
        if 'is_compress' in params:
            query_params.append(('isCompress', params['is_compress']))  # noqa: E501
        if 'is_exclude_dir_nodes' in params:
            query_params.append(('isExcludeDirNodes', params['is_exclude_dir_nodes']))  # noqa: E501
        if 'xlate_filenames' in params:
            query_params.append(('xlateFilenames', params['xlate_filenames']))  # noqa: E501
        if 'file_prefix' in params:
            query_params.append(('filePrefix', params['file_prefix']))  # noqa: E501
        if 'max_size' in params:
            query_params.append(('maxSize', params['max_size']))  # noqa: E501
        if 'max_versions' in params:
            query_params.append(('maxVersions', params['max_versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
