# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.poller.api_client import ApiClient


class PollDetailApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_poll_peer_vote_urls(self, poll_key, peer_id, urls, **kwargs):  # noqa: E501
        """Poll Peer Data  # noqa: E501

        Return the list of urls of vote type for a given peer in a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_peer_vote_urls(poll_key, peer_id, urls, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey from the PollDetail. (required)
        :param str peer_id: The peerId from the Poll Detail.PeerData. (required)
        :param str urls: The voter urls to return. (required)
        :param int page: The page number
        :param int size: The page size
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_poll_peer_vote_urls_with_http_info(poll_key, peer_id, urls, **kwargs)  # noqa: E501
        else:
            (data) = self.get_poll_peer_vote_urls_with_http_info(poll_key, peer_id, urls, **kwargs)  # noqa: E501
            return data

    def get_poll_peer_vote_urls_with_http_info(self, poll_key, peer_id, urls, **kwargs):  # noqa: E501
        """Poll Peer Data  # noqa: E501

        Return the list of urls of vote type for a given peer in a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_peer_vote_urls_with_http_info(poll_key, peer_id, urls, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey from the PollDetail. (required)
        :param str peer_id: The peerId from the Poll Detail.PeerData. (required)
        :param str urls: The voter urls to return. (required)
        :param int page: The page number
        :param int size: The page size
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_key', 'peer_id', 'urls', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_poll_peer_vote_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_key' is set
        if ('poll_key' not in params or
                params['poll_key'] is None):
            raise ValueError("Missing the required parameter `poll_key` when calling `get_poll_peer_vote_urls`")  # noqa: E501
        # verify the required parameter 'peer_id' is set
        if ('peer_id' not in params or
                params['peer_id'] is None):
            raise ValueError("Missing the required parameter `peer_id` when calling `get_poll_peer_vote_urls`")  # noqa: E501
        # verify the required parameter 'urls' is set
        if ('urls' not in params or
                params['urls'] is None):
            raise ValueError("Missing the required parameter `urls` when calling `get_poll_peer_vote_urls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll_key' in params:
            path_params['pollKey'] = params['poll_key']  # noqa: E501
        if 'peer_id' in params:
            path_params['peerId'] = params['peer_id']  # noqa: E501

        query_params = []
        if 'urls' in params:
            query_params.append(('urls', params['urls']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/{pollKey}/peer/{peerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_repair_queue_data(self, poll_key, repair, **kwargs):  # noqa: E501
        """Poll Repairs  # noqa: E501

        Return the repair status for a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repair_queue_data(poll_key, repair, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey as listed in the PollDetail object. (required)
        :param str repair: The repair queue elements to return. (required)
        :param int page: The page number.
        :param int size: The size of the page.
        :return: RepairPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_repair_queue_data_with_http_info(poll_key, repair, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repair_queue_data_with_http_info(poll_key, repair, **kwargs)  # noqa: E501
            return data

    def get_repair_queue_data_with_http_info(self, poll_key, repair, **kwargs):  # noqa: E501
        """Poll Repairs  # noqa: E501

        Return the repair status for a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repair_queue_data_with_http_info(poll_key, repair, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey as listed in the PollDetail object. (required)
        :param str repair: The repair queue elements to return. (required)
        :param int page: The page number.
        :param int size: The size of the page.
        :return: RepairPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_key', 'repair', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repair_queue_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_key' is set
        if ('poll_key' not in params or
                params['poll_key'] is None):
            raise ValueError("Missing the required parameter `poll_key` when calling `get_repair_queue_data`")  # noqa: E501
        # verify the required parameter 'repair' is set
        if ('repair' not in params or
                params['repair'] is None):
            raise ValueError("Missing the required parameter `repair` when calling `get_repair_queue_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll_key' in params:
            path_params['pollKey'] = params['poll_key']  # noqa: E501

        query_params = []
        if 'repair' in params:
            query_params.append(('repair', params['repair']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/{pollKey}/repairs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepairPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tally_urls(self, poll_key, tally, **kwargs):  # noqa: E501
        """Page Tally  # noqa: E501

        Return the vote tallies for a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tally_urls(poll_key, tally, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey as listed in the PollDetail object. (required)
        :param str tally: The kind of tally element to return. (required)
        :param int page: The page number.
        :param int size: The size of the page.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tally_urls_with_http_info(poll_key, tally, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tally_urls_with_http_info(poll_key, tally, **kwargs)  # noqa: E501
            return data

    def get_tally_urls_with_http_info(self, poll_key, tally, **kwargs):  # noqa: E501
        """Page Tally  # noqa: E501

        Return the vote tallies for a specific poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tally_urls_with_http_info(poll_key, tally, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The pollKey as listed in the PollDetail object. (required)
        :param str tally: The kind of tally element to return. (required)
        :param int page: The page number.
        :param int size: The size of the page.
        :return: UrlPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_key', 'tally', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tally_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_key' is set
        if ('poll_key' not in params or
                params['poll_key'] is None):
            raise ValueError("Missing the required parameter `poll_key` when calling `get_tally_urls`")  # noqa: E501
        # verify the required parameter 'tally' is set
        if ('tally' not in params or
                params['tally'] is None):
            raise ValueError("Missing the required parameter `tally` when calling `get_tally_urls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll_key' in params:
            path_params['pollKey'] = params['poll_key']  # noqa: E501

        query_params = []
        if 'tally' in params:
            query_params.append(('tally', params['tally']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/{pollKey}/tallies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
