# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.poller.api_client import ApiClient


class RepoApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_repositories(self, repository_query, **kwargs):  # noqa: E501
        """Query the properties of repositories  # noqa: E501

        Query the system for selected repository properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repositories(repository_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_query: The query that specifies the repository properties to be returned (required)
        :return: list[RepositoryWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_repositories_with_http_info(repository_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repositories_with_http_info(repository_query, **kwargs)  # noqa: E501
            return data

    def get_repositories_with_http_info(self, repository_query, **kwargs):  # noqa: E501
        """Query the properties of repositories  # noqa: E501

        Query the system for selected repository properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repositories_with_http_info(repository_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_query: The query that specifies the repository properties to be returned (required)
        :return: list[RepositoryWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repositories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_query' is set
        if ('repository_query' not in params or
                params['repository_query'] is None):
            raise ValueError("Missing the required parameter `repository_query` when calling `get_repositories`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repository_query' in params:
            query_params.append(('repositoryQuery', params['repository_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/aurepositories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RepositoryWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_repository_spaces(self, repository_space_query, **kwargs):  # noqa: E501
        """Query the properties of repository spaces  # noqa: E501

        Query the system for selected repository space properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repository_spaces(repository_space_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_space_query: The query that specifies the repository space properties to be returned (required)
        :return: list[RepositorySpaceWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_repository_spaces_with_http_info(repository_space_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repository_spaces_with_http_info(repository_space_query, **kwargs)  # noqa: E501
            return data

    def get_repository_spaces_with_http_info(self, repository_space_query, **kwargs):  # noqa: E501
        """Query the properties of repository spaces  # noqa: E501

        Query the system for selected repository space properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repository_spaces_with_http_info(repository_space_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository_space_query: The query that specifies the repository space properties to be returned (required)
        :return: list[RepositorySpaceWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository_space_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repository_spaces" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository_space_query' is set
        if ('repository_space_query' not in params or
                params['repository_space_query'] is None):
            raise ValueError("Missing the required parameter `repository_space_query` when calling `get_repository_spaces`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repository_space_query' in params:
            query_params.append(('repositorySpaceQuery', params['repository_space_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/repositoryspaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RepositorySpaceWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
