# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.poller.api_client import ApiClient


class ServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def call_poll(self, body, **kwargs):  # noqa: E501
        """Send a request to call a poll to the poller  # noqa: E501

        Use the information found in the descriptor object to initiate a  poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_poll(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PollDesc body: A poll descriptor object used to define the poll being requested. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.call_poll_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.call_poll_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def call_poll_with_http_info(self, body, **kwargs):  # noqa: E501
        """Send a request to call a poll to the poller  # noqa: E501

        Use the information found in the descriptor object to initiate a  poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.call_poll_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PollDesc body: A poll descriptor object used to define the poll being requested. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method call_poll" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `call_poll`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_poll(self, ps_id, **kwargs):  # noqa: E501
        """Stop a poll and remove from queue.  # noqa: E501

        Stop a running poll and delete any schecduled polls for poll with the poll service id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_poll(ps_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ps_id: The poll id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_poll_with_http_info(ps_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_poll_with_http_info(ps_id, **kwargs)  # noqa: E501
            return data

    def cancel_poll_with_http_info(self, ps_id, **kwargs):  # noqa: E501
        """Stop a poll and remove from queue.  # noqa: E501

        Stop a running poll and delete any schecduled polls for poll with the poll service id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_poll_with_http_info(ps_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ps_id: The poll id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ps_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_poll" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ps_id' is set
        if ('ps_id' not in params or
                params['ps_id'] is None):
            raise ValueError("Missing the required parameter `ps_id` when calling `cancel_poll`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ps_id' in params:
            path_params['psId'] = params['ps_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/{psId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_peers(self, peer_query, **kwargs):  # noqa: E501
        """Query for peer properties  # noqa: E501

        Query for peers that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_peers(peer_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str peer_query: The query that specifies the peers to be returned (required)
        :return: list[PeerWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_peers_with_http_info(peer_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_peers_with_http_info(peer_query, **kwargs)  # noqa: E501
            return data

    def get_peers_with_http_info(self, peer_query, **kwargs):  # noqa: E501
        """Query for peer properties  # noqa: E501

        Query for peers that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_peers_with_http_info(peer_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str peer_query: The query that specifies the peers to be returned (required)
        :return: list[PeerWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['peer_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_peers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'peer_query' is set
        if ('peer_query' not in params or
                params['peer_query'] is None):
            raise ValueError("Missing the required parameter `peer_query` when calling `get_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'peer_query' in params:
            query_params.append(('peerQuery', params['peer_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/peers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PeerWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_poll_status(self, ps_id, **kwargs):  # noqa: E501
        """Get queued poll status  # noqa: E501

        Get the status of a previously queued poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_status(ps_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ps_id: The poll id. (required)
        :return: PollerSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_poll_status_with_http_info(ps_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_poll_status_with_http_info(ps_id, **kwargs)  # noqa: E501
            return data

    def get_poll_status_with_http_info(self, ps_id, **kwargs):  # noqa: E501
        """Get queued poll status  # noqa: E501

        Get the status of a previously queued poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_poll_status_with_http_info(ps_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ps_id: The poll id. (required)
        :return: PollerSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ps_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_poll_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ps_id' is set
        if ('ps_id' not in params or
                params['ps_id'] is None):
            raise ValueError("Missing the required parameter `ps_id` when calling `get_poll_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ps_id' in params:
            path_params['psId'] = params['ps_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/{psId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PollerSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_polls(self, poll_query, **kwargs):  # noqa: E501
        """Query for poll properties  # noqa: E501

        Query for polls that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_polls(poll_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_query: The query that specifies the polls to be returned (required)
        :return: list[PollWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_polls_with_http_info(poll_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_polls_with_http_info(poll_query, **kwargs)  # noqa: E501
            return data

    def get_polls_with_http_info(self, poll_query, **kwargs):  # noqa: E501
        """Query for poll properties  # noqa: E501

        Query for polls that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_polls_with_http_info(poll_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_query: The query that specifies the polls to be returned (required)
        :return: list[PollWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_polls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_query' is set
        if ('poll_query' not in params or
                params['poll_query'] is None):
            raise ValueError("Missing the required parameter `poll_query` when calling `get_polls`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'poll_query' in params:
            query_params.append(('pollQuery', params['poll_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/polls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PollWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """Get the status of the service  # noqa: E501

        Get the status of the service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get the status of the service  # noqa: E501

        Get the status of the service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_votes(self, vote_query, **kwargs):  # noqa: E501
        """Query for vote properties  # noqa: E501

        Query for votes that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_votes(vote_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str vote_query: The query that specifies the votes to be returned (required)
        :return: list[VoteWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_votes_with_http_info(vote_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_votes_with_http_info(vote_query, **kwargs)  # noqa: E501
            return data

    def get_votes_with_http_info(self, vote_query, **kwargs):  # noqa: E501
        """Query for vote properties  # noqa: E501

        Query for votes that meet a set of specified conditions  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_votes_with_http_info(vote_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str vote_query: The query that specifies the votes to be returned (required)
        :return: list[VoteWsResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vote_query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_votes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vote_query' is set
        if ('vote_query' not in params or
                params['vote_query'] is None):
            raise ValueError("Missing the required parameter `vote_query` when calling `get_votes`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'vote_query' in params:
            query_params.append(('voteQuery', params['vote_query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/ws/votes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[VoteWsResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
