# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.poller.api_client import ApiClient


class VoterPollsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_polls_as_voter(self, **kwargs):  # noqa: E501
        """Get the list of recent voter only polls.  # noqa: E501

        Get the list of recent polls as voter from the poll queue. if size and page are passed in use those arguments to limit return data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_polls_as_voter(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int size: Size of the page to retrieve.
        :param int page: Number of the page to retrieve.
        :return: VoterPager
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_polls_as_voter_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_polls_as_voter_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_polls_as_voter_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of recent voter only polls.  # noqa: E501

        Get the list of recent polls as voter from the poll queue. if size and page are passed in use those arguments to limit return data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_polls_as_voter_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int size: Size of the page to retrieve.
        :param int page: Number of the page to retrieve.
        :return: VoterPager
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_polls_as_voter" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/voter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VoterPager',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_voter_poll_details(self, poll_key, **kwargs):  # noqa: E501
        """VoterDetails  # noqa: E501

        Return the detailed information about a poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_voter_poll_details(poll_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The key assigned by the PollManager. (required)
        :return: VoterDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_voter_poll_details_with_http_info(poll_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_voter_poll_details_with_http_info(poll_key, **kwargs)  # noqa: E501
            return data

    def get_voter_poll_details_with_http_info(self, poll_key, **kwargs):  # noqa: E501
        """VoterDetails  # noqa: E501

        Return the detailed information about a poll.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_voter_poll_details_with_http_info(poll_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str poll_key: The key assigned by the PollManager. (required)
        :return: VoterDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_voter_poll_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_key' is set
        if ('poll_key' not in params or
                params['poll_key'] is None):
            raise ValueError("Missing the required parameter `poll_key` when calling `get_voter_poll_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll_key' in params:
            path_params['pollKey'] = params['poll_key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/polls/voter/{pollKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VoterDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
