# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class HasherWsParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'au_id': 'str',
        'url': 'str',
        'lower': 'str',
        'upper': 'str',
        'record_filtered_stream': 'bool',
        'exclude_suspect_versions': 'bool',
        'include_weight': 'bool',
        'algorithm': 'str',
        'hash_type': 'str',
        'result_encoding': 'str',
        'challenge': 'str',
        'verifier': 'str'
    }

    attribute_map = {
        'au_id': 'auId',
        'url': 'url',
        'lower': 'lower',
        'upper': 'upper',
        'record_filtered_stream': 'recordFilteredStream',
        'exclude_suspect_versions': 'excludeSuspectVersions',
        'include_weight': 'includeWeight',
        'algorithm': 'algorithm',
        'hash_type': 'hashType',
        'result_encoding': 'resultEncoding',
        'challenge': 'challenge',
        'verifier': 'verifier'
    }

    def __init__(self, au_id=None, url=None, lower=None, upper=None, record_filtered_stream=None, exclude_suspect_versions=None, include_weight=None, algorithm=None, hash_type=None, result_encoding=None, challenge=None, verifier=None):  # noqa: E501
        """HasherWsParams - a model defined in Swagger"""  # noqa: E501
        self._au_id = None
        self._url = None
        self._lower = None
        self._upper = None
        self._record_filtered_stream = None
        self._exclude_suspect_versions = None
        self._include_weight = None
        self._algorithm = None
        self._hash_type = None
        self._result_encoding = None
        self._challenge = None
        self._verifier = None
        self.discriminator = None
        self.au_id = au_id
        self.url = url
        self.lower = lower
        self.upper = upper
        self.record_filtered_stream = record_filtered_stream
        self.exclude_suspect_versions = exclude_suspect_versions
        self.include_weight = include_weight
        self.algorithm = algorithm
        self.hash_type = hash_type
        self.result_encoding = result_encoding
        self.challenge = challenge
        self.verifier = verifier

    @property
    def au_id(self):
        """Gets the au_id of this HasherWsParams.  # noqa: E501

        The identifier of the Archival Unit content to be hashed  # noqa: E501

        :return: The au_id of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._au_id

    @au_id.setter
    def au_id(self, au_id):
        """Sets the au_id of this HasherWsParams.

        The identifier of the Archival Unit content to be hashed  # noqa: E501

        :param au_id: The au_id of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if au_id is None:
            raise ValueError("Invalid value for `au_id`, must not be `None`")  # noqa: E501

        self._au_id = au_id

    @property
    def url(self):
        """Gets the url of this HasherWsParams.  # noqa: E501

        The identifier of the URL content to be hashed  # noqa: E501

        :return: The url of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this HasherWsParams.

        The identifier of the URL content to be hashed  # noqa: E501

        :param url: The url of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def lower(self):
        """Gets the lower of this HasherWsParams.  # noqa: E501

        The lower boundary URL  # noqa: E501

        :return: The lower of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._lower

    @lower.setter
    def lower(self, lower):
        """Sets the lower of this HasherWsParams.

        The lower boundary URL  # noqa: E501

        :param lower: The lower of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if lower is None:
            raise ValueError("Invalid value for `lower`, must not be `None`")  # noqa: E501

        self._lower = lower

    @property
    def upper(self):
        """Gets the upper of this HasherWsParams.  # noqa: E501

        The upper boundary URL  # noqa: E501

        :return: The upper of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._upper

    @upper.setter
    def upper(self, upper):
        """Sets the upper of this HasherWsParams.

        The upper boundary URL  # noqa: E501

        :param upper: The upper of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if upper is None:
            raise ValueError("Invalid value for `upper`, must not be `None`")  # noqa: E501

        self._upper = upper

    @property
    def record_filtered_stream(self):
        """Gets the record_filtered_stream of this HasherWsParams.  # noqa: E501

        An indication of whether the filtered stream should be recorded  # noqa: E501

        :return: The record_filtered_stream of this HasherWsParams.  # noqa: E501
        :rtype: bool
        """
        return self._record_filtered_stream

    @record_filtered_stream.setter
    def record_filtered_stream(self, record_filtered_stream):
        """Sets the record_filtered_stream of this HasherWsParams.

        An indication of whether the filtered stream should be recorded  # noqa: E501

        :param record_filtered_stream: The record_filtered_stream of this HasherWsParams.  # noqa: E501
        :type: bool
        """
        if record_filtered_stream is None:
            raise ValueError("Invalid value for `record_filtered_stream`, must not be `None`")  # noqa: E501

        self._record_filtered_stream = record_filtered_stream

    @property
    def exclude_suspect_versions(self):
        """Gets the exclude_suspect_versions of this HasherWsParams.  # noqa: E501

        An indication of whether to exclude suspect versions  # noqa: E501

        :return: The exclude_suspect_versions of this HasherWsParams.  # noqa: E501
        :rtype: bool
        """
        return self._exclude_suspect_versions

    @exclude_suspect_versions.setter
    def exclude_suspect_versions(self, exclude_suspect_versions):
        """Sets the exclude_suspect_versions of this HasherWsParams.

        An indication of whether to exclude suspect versions  # noqa: E501

        :param exclude_suspect_versions: The exclude_suspect_versions of this HasherWsParams.  # noqa: E501
        :type: bool
        """
        if exclude_suspect_versions is None:
            raise ValueError("Invalid value for `exclude_suspect_versions`, must not be `None`")  # noqa: E501

        self._exclude_suspect_versions = exclude_suspect_versions

    @property
    def include_weight(self):
        """Gets the include_weight of this HasherWsParams.  # noqa: E501

        An indication of whether to include hash weight  # noqa: E501

        :return: The include_weight of this HasherWsParams.  # noqa: E501
        :rtype: bool
        """
        return self._include_weight

    @include_weight.setter
    def include_weight(self, include_weight):
        """Sets the include_weight of this HasherWsParams.

        An indication of whether to include hash weight  # noqa: E501

        :param include_weight: The include_weight of this HasherWsParams.  # noqa: E501
        :type: bool
        """
        if include_weight is None:
            raise ValueError("Invalid value for `include_weight`, must not be `None`")  # noqa: E501

        self._include_weight = include_weight

    @property
    def algorithm(self):
        """Gets the algorithm of this HasherWsParams.  # noqa: E501

        The name of the hashing algorithm to be used [SHA-1 (or SHA1), MD5 or SHA-256]  # noqa: E501

        :return: The algorithm of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        """Sets the algorithm of this HasherWsParams.

        The name of the hashing algorithm to be used [SHA-1 (or SHA1), MD5 or SHA-256]  # noqa: E501

        :param algorithm: The algorithm of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if algorithm is None:
            raise ValueError("Invalid value for `algorithm`, must not be `None`")  # noqa: E501

        self._algorithm = algorithm

    @property
    def hash_type(self):
        """Gets the hash_type of this HasherWsParams.  # noqa: E501

        The type of hashing to be performed [V1Content, V1Name, V1File, V3Tree or V3File]  # noqa: E501

        :return: The hash_type of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._hash_type

    @hash_type.setter
    def hash_type(self, hash_type):
        """Sets the hash_type of this HasherWsParams.

        The type of hashing to be performed [V1Content, V1Name, V1File, V3Tree or V3File]  # noqa: E501

        :param hash_type: The hash_type of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if hash_type is None:
            raise ValueError("Invalid value for `hash_type`, must not be `None`")  # noqa: E501

        self._hash_type = hash_type

    @property
    def result_encoding(self):
        """Gets the result_encoding of this HasherWsParams.  # noqa: E501

        The result encoding to be used [Base64 or Hex]  # noqa: E501

        :return: The result_encoding of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._result_encoding

    @result_encoding.setter
    def result_encoding(self, result_encoding):
        """Sets the result_encoding of this HasherWsParams.

        The result encoding to be used [Base64 or Hex]  # noqa: E501

        :param result_encoding: The result_encoding of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if result_encoding is None:
            raise ValueError("Invalid value for `result_encoding`, must not be `None`")  # noqa: E501

        self._result_encoding = result_encoding

    @property
    def challenge(self):
        """Gets the challenge of this HasherWsParams.  # noqa: E501

        The encoded challenge  # noqa: E501

        :return: The challenge of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._challenge

    @challenge.setter
    def challenge(self, challenge):
        """Sets the challenge of this HasherWsParams.

        The encoded challenge  # noqa: E501

        :param challenge: The challenge of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if challenge is None:
            raise ValueError("Invalid value for `challenge`, must not be `None`")  # noqa: E501

        self._challenge = challenge

    @property
    def verifier(self):
        """Gets the verifier of this HasherWsParams.  # noqa: E501

        The encoded verifier  # noqa: E501

        :return: The verifier of this HasherWsParams.  # noqa: E501
        :rtype: str
        """
        return self._verifier

    @verifier.setter
    def verifier(self, verifier):
        """Sets the verifier of this HasherWsParams.

        The encoded verifier  # noqa: E501

        :param verifier: The verifier of this HasherWsParams.  # noqa: E501
        :type: str
        """
        if verifier is None:
            raise ValueError("Invalid value for `verifier`, must not be `None`")  # noqa: E501

        self._verifier = verifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HasherWsParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HasherWsParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
