# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PollDesc(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'au_id': 'str',
        'cu_set_spec': 'CachedUriSetSpec',
        'poll_type': 'int',
        'protocol': 'int',
        'plugin_poll_version': 'str',
        'variant': 'str',
        'modulus': 'int'
    }

    attribute_map = {
        'au_id': 'auId',
        'cu_set_spec': 'cuSetSpec',
        'poll_type': 'pollType',
        'protocol': 'protocol',
        'plugin_poll_version': 'pluginPollVersion',
        'variant': 'variant',
        'modulus': 'modulus'
    }

    def __init__(self, au_id=None, cu_set_spec=None, poll_type=None, protocol=None, plugin_poll_version=None, variant=None, modulus=None):  # noqa: E501
        """PollDesc - a model defined in Swagger"""  # noqa: E501
        self._au_id = None
        self._cu_set_spec = None
        self._poll_type = None
        self._protocol = None
        self._plugin_poll_version = None
        self._variant = None
        self._modulus = None
        self.discriminator = None
        self.au_id = au_id
        if cu_set_spec is not None:
            self.cu_set_spec = cu_set_spec
        if poll_type is not None:
            self.poll_type = poll_type
        if protocol is not None:
            self.protocol = protocol
        if plugin_poll_version is not None:
            self.plugin_poll_version = plugin_poll_version
        if variant is not None:
            self.variant = variant
        if modulus is not None:
            self.modulus = modulus

    @property
    def au_id(self):
        """Gets the au_id of this PollDesc.  # noqa: E501

        The id which defines the poll  # noqa: E501

        :return: The au_id of this PollDesc.  # noqa: E501
        :rtype: str
        """
        return self._au_id

    @au_id.setter
    def au_id(self, au_id):
        """Sets the au_id of this PollDesc.

        The id which defines the poll  # noqa: E501

        :param au_id: The au_id of this PollDesc.  # noqa: E501
        :type: str
        """
        if au_id is None:
            raise ValueError("Invalid value for `au_id`, must not be `None`")  # noqa: E501

        self._au_id = au_id

    @property
    def cu_set_spec(self):
        """Gets the cu_set_spec of this PollDesc.  # noqa: E501


        :return: The cu_set_spec of this PollDesc.  # noqa: E501
        :rtype: CachedUriSetSpec
        """
        return self._cu_set_spec

    @cu_set_spec.setter
    def cu_set_spec(self, cu_set_spec):
        """Sets the cu_set_spec of this PollDesc.


        :param cu_set_spec: The cu_set_spec of this PollDesc.  # noqa: E501
        :type: CachedUriSetSpec
        """

        self._cu_set_spec = cu_set_spec

    @property
    def poll_type(self):
        """Gets the poll_type of this PollDesc.  # noqa: E501

        The type of poll to run. Only V3 is supported.  # noqa: E501

        :return: The poll_type of this PollDesc.  # noqa: E501
        :rtype: int
        """
        return self._poll_type

    @poll_type.setter
    def poll_type(self, poll_type):
        """Sets the poll_type of this PollDesc.

        The type of poll to run. Only V3 is supported.  # noqa: E501

        :param poll_type: The poll_type of this PollDesc.  # noqa: E501
        :type: int
        """

        self._poll_type = poll_type

    @property
    def protocol(self):
        """Gets the protocol of this PollDesc.  # noqa: E501

        The version of polling protocol.  # noqa: E501

        :return: The protocol of this PollDesc.  # noqa: E501
        :rtype: int
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this PollDesc.

        The version of polling protocol.  # noqa: E501

        :param protocol: The protocol of this PollDesc.  # noqa: E501
        :type: int
        """

        self._protocol = protocol

    @property
    def plugin_poll_version(self):
        """Gets the plugin_poll_version of this PollDesc.  # noqa: E501

        The version of the polling features needed by the plugin.  # noqa: E501

        :return: The plugin_poll_version of this PollDesc.  # noqa: E501
        :rtype: str
        """
        return self._plugin_poll_version

    @plugin_poll_version.setter
    def plugin_poll_version(self, plugin_poll_version):
        """Sets the plugin_poll_version of this PollDesc.

        The version of the polling features needed by the plugin.  # noqa: E501

        :param plugin_poll_version: The plugin_poll_version of this PollDesc.  # noqa: E501
        :type: str
        """

        self._plugin_poll_version = plugin_poll_version

    @property
    def variant(self):
        """Gets the variant of this PollDesc.  # noqa: E501

        The V3 poll variation.  # noqa: E501

        :return: The variant of this PollDesc.  # noqa: E501
        :rtype: str
        """
        return self._variant

    @variant.setter
    def variant(self, variant):
        """Sets the variant of this PollDesc.

        The V3 poll variation.  # noqa: E501

        :param variant: The variant of this PollDesc.  # noqa: E501
        :type: str
        """
        allowed_values = ["PoR", "PoP", "Local", "NoPoll"]  # noqa: E501
        if variant not in allowed_values:
            raise ValueError(
                "Invalid value for `variant` ({0}), must be one of {1}"  # noqa: E501
                .format(variant, allowed_values)
            )

        self._variant = variant

    @property
    def modulus(self):
        """Gets the modulus of this PollDesc.  # noqa: E501

        Poll on every 'n'th url.  # noqa: E501

        :return: The modulus of this PollDesc.  # noqa: E501
        :rtype: int
        """
        return self._modulus

    @modulus.setter
    def modulus(self, modulus):
        """Sets the modulus of this PollDesc.

        Poll on every 'n'th url.  # noqa: E501

        :param modulus: The modulus of this PollDesc.  # noqa: E501
        :type: int
        """

        self._modulus = modulus

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PollDesc, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PollDesc):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
