# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PollerDetail(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'poll_desc': 'PollDesc',
        'poller_id': 'str',
        'status': 'str',
        'poll_key': 'str',
        'create_time': 'int',
        'duration': 'int',
        'deadline': 'int',
        'outer_circle_target': 'int',
        'hash_algorithm': 'str',
        'vote_margin': 'int',
        'vote_deadline': 'int',
        'vote_duration': 'int',
        'poll_end': 'int',
        'quorum': 'int',
        'error_details': 'str',
        'voted_peers': 'list[PeerData]',
        'no_au_peers': 'list[str]',
        'tally': 'TallyData',
        'repair_queue': 'RepairQueue'
    }

    attribute_map = {
        'poll_desc': 'pollDesc',
        'poller_id': 'pollerId',
        'status': 'status',
        'poll_key': 'pollKey',
        'create_time': 'createTime',
        'duration': 'duration',
        'deadline': 'deadline',
        'outer_circle_target': 'outerCircleTarget',
        'hash_algorithm': 'hashAlgorithm',
        'vote_margin': 'voteMargin',
        'vote_deadline': 'voteDeadline',
        'vote_duration': 'voteDuration',
        'poll_end': 'pollEnd',
        'quorum': 'quorum',
        'error_details': 'errorDetails',
        'voted_peers': 'votedPeers',
        'no_au_peers': 'noAuPeers',
        'tally': 'tally',
        'repair_queue': 'repairQueue'
    }

    def __init__(self, poll_desc=None, poller_id=None, status=None, poll_key=None, create_time=None, duration=None, deadline=None, outer_circle_target=None, hash_algorithm=None, vote_margin=None, vote_deadline=None, vote_duration=None, poll_end=None, quorum=None, error_details=None, voted_peers=None, no_au_peers=None, tally=None, repair_queue=None):  # noqa: E501
        """PollerDetail - a model defined in Swagger"""  # noqa: E501
        self._poll_desc = None
        self._poller_id = None
        self._status = None
        self._poll_key = None
        self._create_time = None
        self._duration = None
        self._deadline = None
        self._outer_circle_target = None
        self._hash_algorithm = None
        self._vote_margin = None
        self._vote_deadline = None
        self._vote_duration = None
        self._poll_end = None
        self._quorum = None
        self._error_details = None
        self._voted_peers = None
        self._no_au_peers = None
        self._tally = None
        self._repair_queue = None
        self.discriminator = None
        self.poll_desc = poll_desc
        self.poller_id = poller_id
        self.status = status
        if poll_key is not None:
            self.poll_key = poll_key
        if create_time is not None:
            self.create_time = create_time
        if duration is not None:
            self.duration = duration
        if deadline is not None:
            self.deadline = deadline
        if outer_circle_target is not None:
            self.outer_circle_target = outer_circle_target
        if hash_algorithm is not None:
            self.hash_algorithm = hash_algorithm
        if vote_margin is not None:
            self.vote_margin = vote_margin
        if vote_deadline is not None:
            self.vote_deadline = vote_deadline
        if vote_duration is not None:
            self.vote_duration = vote_duration
        if poll_end is not None:
            self.poll_end = poll_end
        if quorum is not None:
            self.quorum = quorum
        if error_details is not None:
            self.error_details = error_details
        if voted_peers is not None:
            self.voted_peers = voted_peers
        if no_au_peers is not None:
            self.no_au_peers = no_au_peers
        if tally is not None:
            self.tally = tally
        if repair_queue is not None:
            self.repair_queue = repair_queue

    @property
    def poll_desc(self):
        """Gets the poll_desc of this PollerDetail.  # noqa: E501


        :return: The poll_desc of this PollerDetail.  # noqa: E501
        :rtype: PollDesc
        """
        return self._poll_desc

    @poll_desc.setter
    def poll_desc(self, poll_desc):
        """Sets the poll_desc of this PollerDetail.


        :param poll_desc: The poll_desc of this PollerDetail.  # noqa: E501
        :type: PollDesc
        """
        if poll_desc is None:
            raise ValueError("Invalid value for `poll_desc`, must not be `None`")  # noqa: E501

        self._poll_desc = poll_desc

    @property
    def poller_id(self):
        """Gets the poller_id of this PollerDetail.  # noqa: E501

        The id of the poller who called the poll  # noqa: E501

        :return: The poller_id of this PollerDetail.  # noqa: E501
        :rtype: str
        """
        return self._poller_id

    @poller_id.setter
    def poller_id(self, poller_id):
        """Sets the poller_id of this PollerDetail.

        The id of the poller who called the poll  # noqa: E501

        :param poller_id: The poller_id of this PollerDetail.  # noqa: E501
        :type: str
        """
        if poller_id is None:
            raise ValueError("Invalid value for `poller_id`, must not be `None`")  # noqa: E501

        self._poller_id = poller_id

    @property
    def status(self):
        """Gets the status of this PollerDetail.  # noqa: E501

        The current status of the poll.  # noqa: E501

        :return: The status of this PollerDetail.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PollerDetail.

        The current status of the poll.  # noqa: E501

        :param status: The status of this PollerDetail.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def poll_key(self):
        """Gets the poll_key of this PollerDetail.  # noqa: E501

        Key generated by poll manager when poll is created.  # noqa: E501

        :return: The poll_key of this PollerDetail.  # noqa: E501
        :rtype: str
        """
        return self._poll_key

    @poll_key.setter
    def poll_key(self, poll_key):
        """Sets the poll_key of this PollerDetail.

        Key generated by poll manager when poll is created.  # noqa: E501

        :param poll_key: The poll_key of this PollerDetail.  # noqa: E501
        :type: str
        """

        self._poll_key = poll_key

    @property
    def create_time(self):
        """Gets the create_time of this PollerDetail.  # noqa: E501

        The timestamp  at which the poll was created.  # noqa: E501

        :return: The create_time of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this PollerDetail.

        The timestamp  at which the poll was created.  # noqa: E501

        :param create_time: The create_time of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._create_time = create_time

    @property
    def duration(self):
        """Gets the duration of this PollerDetail.  # noqa: E501

        The estimated duration for the poll.  # noqa: E501

        :return: The duration of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this PollerDetail.

        The estimated duration for the poll.  # noqa: E501

        :param duration: The duration of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def deadline(self):
        """Gets the deadline of this PollerDetail.  # noqa: E501

        The time by which the poll must have completed  # noqa: E501

        :return: The deadline of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._deadline

    @deadline.setter
    def deadline(self, deadline):
        """Sets the deadline of this PollerDetail.

        The time by which the poll must have completed  # noqa: E501

        :param deadline: The deadline of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._deadline = deadline

    @property
    def outer_circle_target(self):
        """Gets the outer_circle_target of this PollerDetail.  # noqa: E501

        The number of peers from the poller outer circle to taget.  # noqa: E501

        :return: The outer_circle_target of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._outer_circle_target

    @outer_circle_target.setter
    def outer_circle_target(self, outer_circle_target):
        """Sets the outer_circle_target of this PollerDetail.

        The number of peers from the poller outer circle to taget.  # noqa: E501

        :param outer_circle_target: The outer_circle_target of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._outer_circle_target = outer_circle_target

    @property
    def hash_algorithm(self):
        """Gets the hash_algorithm of this PollerDetail.  # noqa: E501

        The algorithm used by the hasher for this poll.  # noqa: E501

        :return: The hash_algorithm of this PollerDetail.  # noqa: E501
        :rtype: str
        """
        return self._hash_algorithm

    @hash_algorithm.setter
    def hash_algorithm(self, hash_algorithm):
        """Sets the hash_algorithm of this PollerDetail.

        The algorithm used by the hasher for this poll.  # noqa: E501

        :param hash_algorithm: The hash_algorithm of this PollerDetail.  # noqa: E501
        :type: str
        """

        self._hash_algorithm = hash_algorithm

    @property
    def vote_margin(self):
        """Gets the vote_margin of this PollerDetail.  # noqa: E501

        The required agreement need to decide landslide agreement or disagreement.  # noqa: E501

        :return: The vote_margin of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._vote_margin

    @vote_margin.setter
    def vote_margin(self, vote_margin):
        """Sets the vote_margin of this PollerDetail.

        The required agreement need to decide landslide agreement or disagreement.  # noqa: E501

        :param vote_margin: The vote_margin of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._vote_margin = vote_margin

    @property
    def vote_deadline(self):
        """Gets the vote_deadline of this PollerDetail.  # noqa: E501

        The  time by which all voters must have voted.  # noqa: E501

        :return: The vote_deadline of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._vote_deadline

    @vote_deadline.setter
    def vote_deadline(self, vote_deadline):
        """Sets the vote_deadline of this PollerDetail.

        The  time by which all voters must have voted.  # noqa: E501

        :param vote_deadline: The vote_deadline of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._vote_deadline = vote_deadline

    @property
    def vote_duration(self):
        """Gets the vote_duration of this PollerDetail.  # noqa: E501

        The  estimated duration for voters.  # noqa: E501

        :return: The vote_duration of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._vote_duration

    @vote_duration.setter
    def vote_duration(self, vote_duration):
        """Sets the vote_duration of this PollerDetail.

        The  estimated duration for voters.  # noqa: E501

        :param vote_duration: The vote_duration of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._vote_duration = vote_duration

    @property
    def poll_end(self):
        """Gets the poll_end of this PollerDetail.  # noqa: E501

        the time at which the poll ended or -1 if still running.  # noqa: E501

        :return: The poll_end of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._poll_end

    @poll_end.setter
    def poll_end(self, poll_end):
        """Sets the poll_end of this PollerDetail.

        the time at which the poll ended or -1 if still running.  # noqa: E501

        :param poll_end: The poll_end of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._poll_end = poll_end

    @property
    def quorum(self):
        """Gets the quorum of this PollerDetail.  # noqa: E501

        The minimum required for a quroum  # noqa: E501

        :return: The quorum of this PollerDetail.  # noqa: E501
        :rtype: int
        """
        return self._quorum

    @quorum.setter
    def quorum(self, quorum):
        """Sets the quorum of this PollerDetail.

        The minimum required for a quroum  # noqa: E501

        :param quorum: The quorum of this PollerDetail.  # noqa: E501
        :type: int
        """

        self._quorum = quorum

    @property
    def error_details(self):
        """Gets the error_details of this PollerDetail.  # noqa: E501

        The error which caused the poll to fail.  # noqa: E501

        :return: The error_details of this PollerDetail.  # noqa: E501
        :rtype: str
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """Sets the error_details of this PollerDetail.

        The error which caused the poll to fail.  # noqa: E501

        :param error_details: The error_details of this PollerDetail.  # noqa: E501
        :type: str
        """

        self._error_details = error_details

    @property
    def voted_peers(self):
        """Gets the voted_peers of this PollerDetail.  # noqa: E501

        The data from peers whom voted.  # noqa: E501

        :return: The voted_peers of this PollerDetail.  # noqa: E501
        :rtype: list[PeerData]
        """
        return self._voted_peers

    @voted_peers.setter
    def voted_peers(self, voted_peers):
        """Sets the voted_peers of this PollerDetail.

        The data from peers whom voted.  # noqa: E501

        :param voted_peers: The voted_peers of this PollerDetail.  # noqa: E501
        :type: list[PeerData]
        """

        self._voted_peers = voted_peers

    @property
    def no_au_peers(self):
        """Gets the no_au_peers of this PollerDetail.  # noqa: E501

        The peers who do not have the au.  # noqa: E501

        :return: The no_au_peers of this PollerDetail.  # noqa: E501
        :rtype: list[str]
        """
        return self._no_au_peers

    @no_au_peers.setter
    def no_au_peers(self, no_au_peers):
        """Sets the no_au_peers of this PollerDetail.

        The peers who do not have the au.  # noqa: E501

        :param no_au_peers: The no_au_peers of this PollerDetail.  # noqa: E501
        :type: list[str]
        """

        self._no_au_peers = no_au_peers

    @property
    def tally(self):
        """Gets the tally of this PollerDetail.  # noqa: E501


        :return: The tally of this PollerDetail.  # noqa: E501
        :rtype: TallyData
        """
        return self._tally

    @tally.setter
    def tally(self, tally):
        """Sets the tally of this PollerDetail.


        :param tally: The tally of this PollerDetail.  # noqa: E501
        :type: TallyData
        """

        self._tally = tally

    @property
    def repair_queue(self):
        """Gets the repair_queue of this PollerDetail.  # noqa: E501


        :return: The repair_queue of this PollerDetail.  # noqa: E501
        :rtype: RepairQueue
        """
        return self._repair_queue

    @repair_queue.setter
    def repair_queue(self, repair_queue):
        """Sets the repair_queue of this PollerDetail.


        :param repair_queue: The repair_queue of this PollerDetail.  # noqa: E501
        :type: RepairQueue
        """

        self._repair_queue = repair_queue

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PollerDetail, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PollerDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
