# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PollerSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'au_id': 'str',
        'variant': 'str',
        'status': 'str',
        'participants': 'int',
        'num_tallied_urls': 'int',
        'num_hash_errors': 'int',
        'num_completed_repairs': 'int',
        'num_agree_urls': 'int',
        'start': 'int',
        'deadline': 'int',
        'poll_end': 'int',
        'poll_key': 'str',
        'detail_link': 'LinkDesc'
    }

    attribute_map = {
        'au_id': 'auId',
        'variant': 'variant',
        'status': 'status',
        'participants': 'participants',
        'num_tallied_urls': 'numTalliedUrls',
        'num_hash_errors': 'numHashErrors',
        'num_completed_repairs': 'numCompletedRepairs',
        'num_agree_urls': 'numAgreeUrls',
        'start': 'start',
        'deadline': 'deadline',
        'poll_end': 'pollEnd',
        'poll_key': 'pollKey',
        'detail_link': 'detailLink'
    }

    def __init__(self, au_id=None, variant=None, status=None, participants=None, num_tallied_urls=None, num_hash_errors=None, num_completed_repairs=None, num_agree_urls=None, start=None, deadline=None, poll_end=None, poll_key=None, detail_link=None):  # noqa: E501
        """PollerSummary - a model defined in Swagger"""  # noqa: E501
        self._au_id = None
        self._variant = None
        self._status = None
        self._participants = None
        self._num_tallied_urls = None
        self._num_hash_errors = None
        self._num_completed_repairs = None
        self._num_agree_urls = None
        self._start = None
        self._deadline = None
        self._poll_end = None
        self._poll_key = None
        self._detail_link = None
        self.discriminator = None
        self.au_id = au_id
        self.variant = variant
        self.status = status
        if participants is not None:
            self.participants = participants
        if num_tallied_urls is not None:
            self.num_tallied_urls = num_tallied_urls
        if num_hash_errors is not None:
            self.num_hash_errors = num_hash_errors
        if num_completed_repairs is not None:
            self.num_completed_repairs = num_completed_repairs
        if num_agree_urls is not None:
            self.num_agree_urls = num_agree_urls
        self.start = start
        self.deadline = deadline
        if poll_end is not None:
            self.poll_end = poll_end
        self.poll_key = poll_key
        if detail_link is not None:
            self.detail_link = detail_link

    @property
    def au_id(self):
        """Gets the au_id of this PollerSummary.  # noqa: E501

        The id for the au being polled.  # noqa: E501

        :return: The au_id of this PollerSummary.  # noqa: E501
        :rtype: str
        """
        return self._au_id

    @au_id.setter
    def au_id(self, au_id):
        """Sets the au_id of this PollerSummary.

        The id for the au being polled.  # noqa: E501

        :param au_id: The au_id of this PollerSummary.  # noqa: E501
        :type: str
        """
        if au_id is None:
            raise ValueError("Invalid value for `au_id`, must not be `None`")  # noqa: E501

        self._au_id = au_id

    @property
    def variant(self):
        """Gets the variant of this PollerSummary.  # noqa: E501

        The V3 Poll variant.  # noqa: E501

        :return: The variant of this PollerSummary.  # noqa: E501
        :rtype: str
        """
        return self._variant

    @variant.setter
    def variant(self, variant):
        """Sets the variant of this PollerSummary.

        The V3 Poll variant.  # noqa: E501

        :param variant: The variant of this PollerSummary.  # noqa: E501
        :type: str
        """
        if variant is None:
            raise ValueError("Invalid value for `variant`, must not be `None`")  # noqa: E501

        self._variant = variant

    @property
    def status(self):
        """Gets the status of this PollerSummary.  # noqa: E501

        The current status of the poll.  # noqa: E501

        :return: The status of this PollerSummary.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PollerSummary.

        The current status of the poll.  # noqa: E501

        :param status: The status of this PollerSummary.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def participants(self):
        """Gets the participants of this PollerSummary.  # noqa: E501

        The number of participants voting.  # noqa: E501

        :return: The participants of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._participants

    @participants.setter
    def participants(self, participants):
        """Sets the participants of this PollerSummary.

        The number of participants voting.  # noqa: E501

        :param participants: The participants of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._participants = participants

    @property
    def num_tallied_urls(self):
        """Gets the num_tallied_urls of this PollerSummary.  # noqa: E501

        The number of tallied urls.  # noqa: E501

        :return: The num_tallied_urls of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._num_tallied_urls

    @num_tallied_urls.setter
    def num_tallied_urls(self, num_tallied_urls):
        """Sets the num_tallied_urls of this PollerSummary.

        The number of tallied urls.  # noqa: E501

        :param num_tallied_urls: The num_tallied_urls of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._num_tallied_urls = num_tallied_urls

    @property
    def num_hash_errors(self):
        """Gets the num_hash_errors of this PollerSummary.  # noqa: E501

        The number of hash errors.  # noqa: E501

        :return: The num_hash_errors of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._num_hash_errors

    @num_hash_errors.setter
    def num_hash_errors(self, num_hash_errors):
        """Sets the num_hash_errors of this PollerSummary.

        The number of hash errors.  # noqa: E501

        :param num_hash_errors: The num_hash_errors of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._num_hash_errors = num_hash_errors

    @property
    def num_completed_repairs(self):
        """Gets the num_completed_repairs of this PollerSummary.  # noqa: E501

        The number of completed repairs.  # noqa: E501

        :return: The num_completed_repairs of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._num_completed_repairs

    @num_completed_repairs.setter
    def num_completed_repairs(self, num_completed_repairs):
        """Sets the num_completed_repairs of this PollerSummary.

        The number of completed repairs.  # noqa: E501

        :param num_completed_repairs: The num_completed_repairs of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._num_completed_repairs = num_completed_repairs

    @property
    def num_agree_urls(self):
        """Gets the num_agree_urls of this PollerSummary.  # noqa: E501

        The number of urls with agreement.  # noqa: E501

        :return: The num_agree_urls of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._num_agree_urls

    @num_agree_urls.setter
    def num_agree_urls(self, num_agree_urls):
        """Sets the num_agree_urls of this PollerSummary.

        The number of urls with agreement.  # noqa: E501

        :param num_agree_urls: The num_agree_urls of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._num_agree_urls = num_agree_urls

    @property
    def start(self):
        """Gets the start of this PollerSummary.  # noqa: E501

        The timestamp for when the poll started.  # noqa: E501

        :return: The start of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this PollerSummary.

        The timestamp for when the poll started.  # noqa: E501

        :param start: The start of this PollerSummary.  # noqa: E501
        :type: int
        """
        if start is None:
            raise ValueError("Invalid value for `start`, must not be `None`")  # noqa: E501

        self._start = start

    @property
    def deadline(self):
        """Gets the deadline of this PollerSummary.  # noqa: E501

        The deadline for voting in this poll.  # noqa: E501

        :return: The deadline of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._deadline

    @deadline.setter
    def deadline(self, deadline):
        """Sets the deadline of this PollerSummary.

        The deadline for voting in this poll.  # noqa: E501

        :param deadline: The deadline of this PollerSummary.  # noqa: E501
        :type: int
        """
        if deadline is None:
            raise ValueError("Invalid value for `deadline`, must not be `None`")  # noqa: E501

        self._deadline = deadline

    @property
    def poll_end(self):
        """Gets the poll_end of this PollerSummary.  # noqa: E501

        The time at which the poll ended.  # noqa: E501

        :return: The poll_end of this PollerSummary.  # noqa: E501
        :rtype: int
        """
        return self._poll_end

    @poll_end.setter
    def poll_end(self, poll_end):
        """Sets the poll_end of this PollerSummary.

        The time at which the poll ended.  # noqa: E501

        :param poll_end: The poll_end of this PollerSummary.  # noqa: E501
        :type: int
        """

        self._poll_end = poll_end

    @property
    def poll_key(self):
        """Gets the poll_key of this PollerSummary.  # noqa: E501

        Key generated by poll manager when poll was created.  # noqa: E501

        :return: The poll_key of this PollerSummary.  # noqa: E501
        :rtype: str
        """
        return self._poll_key

    @poll_key.setter
    def poll_key(self, poll_key):
        """Sets the poll_key of this PollerSummary.

        Key generated by poll manager when poll was created.  # noqa: E501

        :param poll_key: The poll_key of this PollerSummary.  # noqa: E501
        :type: str
        """
        if poll_key is None:
            raise ValueError("Invalid value for `poll_key`, must not be `None`")  # noqa: E501

        self._poll_key = poll_key

    @property
    def detail_link(self):
        """Gets the detail_link of this PollerSummary.  # noqa: E501


        :return: The detail_link of this PollerSummary.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._detail_link

    @detail_link.setter
    def detail_link(self, detail_link):
        """Sets the detail_link of this PollerSummary.


        :param detail_link: The detail_link of this PollerSummary.  # noqa: E501
        :type: LinkDesc
        """

        self._detail_link = detail_link

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PollerSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PollerSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
