# coding: utf-8

"""
    LOCKSS Poller Service REST API

    REST API of the LOCKSS Poller Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TallyData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'num_agree': 'int',
        'agree_link': 'LinkDesc',
        'num_disagree': 'int',
        'disagree_link': 'LinkDesc',
        'num_too_close': 'int',
        'too_close_link': 'LinkDesc',
        'num_no_quorum': 'int',
        'no_quorum_link': 'LinkDesc',
        'num_error': 'int',
        'error_link': 'LinkDesc',
        'wt_agreed': 'float',
        'wt_disagreed': 'float',
        'wt_too_close': 'float',
        'wt_no_quorum': 'float'
    }

    attribute_map = {
        'num_agree': 'numAgree',
        'agree_link': 'agreeLink',
        'num_disagree': 'numDisagree',
        'disagree_link': 'disagreeLink',
        'num_too_close': 'numTooClose',
        'too_close_link': 'tooCloseLink',
        'num_no_quorum': 'numNoQuorum',
        'no_quorum_link': 'noQuorumLink',
        'num_error': 'numError',
        'error_link': 'errorLink',
        'wt_agreed': 'wtAgreed',
        'wt_disagreed': 'wtDisagreed',
        'wt_too_close': 'wtTooClose',
        'wt_no_quorum': 'wtNoQuorum'
    }

    def __init__(self, num_agree=None, agree_link=None, num_disagree=None, disagree_link=None, num_too_close=None, too_close_link=None, num_no_quorum=None, no_quorum_link=None, num_error=None, error_link=None, wt_agreed=0.0, wt_disagreed=0.0, wt_too_close=0.0, wt_no_quorum=0.0):  # noqa: E501
        """TallyData - a model defined in Swagger"""  # noqa: E501
        self._num_agree = None
        self._agree_link = None
        self._num_disagree = None
        self._disagree_link = None
        self._num_too_close = None
        self._too_close_link = None
        self._num_no_quorum = None
        self._no_quorum_link = None
        self._num_error = None
        self._error_link = None
        self._wt_agreed = None
        self._wt_disagreed = None
        self._wt_too_close = None
        self._wt_no_quorum = None
        self.discriminator = None
        self.num_agree = num_agree
        if agree_link is not None:
            self.agree_link = agree_link
        self.num_disagree = num_disagree
        if disagree_link is not None:
            self.disagree_link = disagree_link
        self.num_too_close = num_too_close
        if too_close_link is not None:
            self.too_close_link = too_close_link
        self.num_no_quorum = num_no_quorum
        if no_quorum_link is not None:
            self.no_quorum_link = no_quorum_link
        self.num_error = num_error
        if error_link is not None:
            self.error_link = error_link
        if wt_agreed is not None:
            self.wt_agreed = wt_agreed
        if wt_disagreed is not None:
            self.wt_disagreed = wt_disagreed
        if wt_too_close is not None:
            self.wt_too_close = wt_too_close
        if wt_no_quorum is not None:
            self.wt_no_quorum = wt_no_quorum

    @property
    def num_agree(self):
        """Gets the num_agree of this TallyData.  # noqa: E501

        The number of urls with agreement.  # noqa: E501

        :return: The num_agree of this TallyData.  # noqa: E501
        :rtype: int
        """
        return self._num_agree

    @num_agree.setter
    def num_agree(self, num_agree):
        """Sets the num_agree of this TallyData.

        The number of urls with agreement.  # noqa: E501

        :param num_agree: The num_agree of this TallyData.  # noqa: E501
        :type: int
        """
        if num_agree is None:
            raise ValueError("Invalid value for `num_agree`, must not be `None`")  # noqa: E501

        self._num_agree = num_agree

    @property
    def agree_link(self):
        """Gets the agree_link of this TallyData.  # noqa: E501


        :return: The agree_link of this TallyData.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._agree_link

    @agree_link.setter
    def agree_link(self, agree_link):
        """Sets the agree_link of this TallyData.


        :param agree_link: The agree_link of this TallyData.  # noqa: E501
        :type: LinkDesc
        """

        self._agree_link = agree_link

    @property
    def num_disagree(self):
        """Gets the num_disagree of this TallyData.  # noqa: E501

        The number of urls with disagreement.  # noqa: E501

        :return: The num_disagree of this TallyData.  # noqa: E501
        :rtype: int
        """
        return self._num_disagree

    @num_disagree.setter
    def num_disagree(self, num_disagree):
        """Sets the num_disagree of this TallyData.

        The number of urls with disagreement.  # noqa: E501

        :param num_disagree: The num_disagree of this TallyData.  # noqa: E501
        :type: int
        """
        if num_disagree is None:
            raise ValueError("Invalid value for `num_disagree`, must not be `None`")  # noqa: E501

        self._num_disagree = num_disagree

    @property
    def disagree_link(self):
        """Gets the disagree_link of this TallyData.  # noqa: E501


        :return: The disagree_link of this TallyData.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._disagree_link

    @disagree_link.setter
    def disagree_link(self, disagree_link):
        """Sets the disagree_link of this TallyData.


        :param disagree_link: The disagree_link of this TallyData.  # noqa: E501
        :type: LinkDesc
        """

        self._disagree_link = disagree_link

    @property
    def num_too_close(self):
        """Gets the num_too_close of this TallyData.  # noqa: E501

        The number of urls too close.  # noqa: E501

        :return: The num_too_close of this TallyData.  # noqa: E501
        :rtype: int
        """
        return self._num_too_close

    @num_too_close.setter
    def num_too_close(self, num_too_close):
        """Sets the num_too_close of this TallyData.

        The number of urls too close.  # noqa: E501

        :param num_too_close: The num_too_close of this TallyData.  # noqa: E501
        :type: int
        """
        if num_too_close is None:
            raise ValueError("Invalid value for `num_too_close`, must not be `None`")  # noqa: E501

        self._num_too_close = num_too_close

    @property
    def too_close_link(self):
        """Gets the too_close_link of this TallyData.  # noqa: E501


        :return: The too_close_link of this TallyData.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._too_close_link

    @too_close_link.setter
    def too_close_link(self, too_close_link):
        """Sets the too_close_link of this TallyData.


        :param too_close_link: The too_close_link of this TallyData.  # noqa: E501
        :type: LinkDesc
        """

        self._too_close_link = too_close_link

    @property
    def num_no_quorum(self):
        """Gets the num_no_quorum of this TallyData.  # noqa: E501

        The number of urls without enough voters.  # noqa: E501

        :return: The num_no_quorum of this TallyData.  # noqa: E501
        :rtype: int
        """
        return self._num_no_quorum

    @num_no_quorum.setter
    def num_no_quorum(self, num_no_quorum):
        """Sets the num_no_quorum of this TallyData.

        The number of urls without enough voters.  # noqa: E501

        :param num_no_quorum: The num_no_quorum of this TallyData.  # noqa: E501
        :type: int
        """
        if num_no_quorum is None:
            raise ValueError("Invalid value for `num_no_quorum`, must not be `None`")  # noqa: E501

        self._num_no_quorum = num_no_quorum

    @property
    def no_quorum_link(self):
        """Gets the no_quorum_link of this TallyData.  # noqa: E501


        :return: The no_quorum_link of this TallyData.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._no_quorum_link

    @no_quorum_link.setter
    def no_quorum_link(self, no_quorum_link):
        """Sets the no_quorum_link of this TallyData.


        :param no_quorum_link: The no_quorum_link of this TallyData.  # noqa: E501
        :type: LinkDesc
        """

        self._no_quorum_link = no_quorum_link

    @property
    def num_error(self):
        """Gets the num_error of this TallyData.  # noqa: E501

        The number of urls wit errors.  # noqa: E501

        :return: The num_error of this TallyData.  # noqa: E501
        :rtype: int
        """
        return self._num_error

    @num_error.setter
    def num_error(self, num_error):
        """Sets the num_error of this TallyData.

        The number of urls wit errors.  # noqa: E501

        :param num_error: The num_error of this TallyData.  # noqa: E501
        :type: int
        """
        if num_error is None:
            raise ValueError("Invalid value for `num_error`, must not be `None`")  # noqa: E501

        self._num_error = num_error

    @property
    def error_link(self):
        """Gets the error_link of this TallyData.  # noqa: E501


        :return: The error_link of this TallyData.  # noqa: E501
        :rtype: LinkDesc
        """
        return self._error_link

    @error_link.setter
    def error_link(self, error_link):
        """Sets the error_link of this TallyData.


        :param error_link: The error_link of this TallyData.  # noqa: E501
        :type: LinkDesc
        """

        self._error_link = error_link

    @property
    def wt_agreed(self):
        """Gets the wt_agreed of this TallyData.  # noqa: E501

        The weighted sum agreed uris.  # noqa: E501

        :return: The wt_agreed of this TallyData.  # noqa: E501
        :rtype: float
        """
        return self._wt_agreed

    @wt_agreed.setter
    def wt_agreed(self, wt_agreed):
        """Sets the wt_agreed of this TallyData.

        The weighted sum agreed uris.  # noqa: E501

        :param wt_agreed: The wt_agreed of this TallyData.  # noqa: E501
        :type: float
        """

        self._wt_agreed = wt_agreed

    @property
    def wt_disagreed(self):
        """Gets the wt_disagreed of this TallyData.  # noqa: E501

        The weighted sum of disagree uris.  # noqa: E501

        :return: The wt_disagreed of this TallyData.  # noqa: E501
        :rtype: float
        """
        return self._wt_disagreed

    @wt_disagreed.setter
    def wt_disagreed(self, wt_disagreed):
        """Sets the wt_disagreed of this TallyData.

        The weighted sum of disagree uris.  # noqa: E501

        :param wt_disagreed: The wt_disagreed of this TallyData.  # noqa: E501
        :type: float
        """

        self._wt_disagreed = wt_disagreed

    @property
    def wt_too_close(self):
        """Gets the wt_too_close of this TallyData.  # noqa: E501

        The sum of the tooClose uris.  # noqa: E501

        :return: The wt_too_close of this TallyData.  # noqa: E501
        :rtype: float
        """
        return self._wt_too_close

    @wt_too_close.setter
    def wt_too_close(self, wt_too_close):
        """Sets the wt_too_close of this TallyData.

        The sum of the tooClose uris.  # noqa: E501

        :param wt_too_close: The wt_too_close of this TallyData.  # noqa: E501
        :type: float
        """

        self._wt_too_close = wt_too_close

    @property
    def wt_no_quorum(self):
        """Gets the wt_no_quorum of this TallyData.  # noqa: E501

        The weighted sum of NoQuorum uris.  # noqa: E501

        :return: The wt_no_quorum of this TallyData.  # noqa: E501
        :rtype: float
        """
        return self._wt_no_quorum

    @wt_no_quorum.setter
    def wt_no_quorum(self, wt_no_quorum):
        """Sets the wt_no_quorum of this TallyData.

        The weighted sum of NoQuorum uris.  # noqa: E501

        :param wt_no_quorum: The wt_no_quorum of this TallyData.  # noqa: E501
        :type: float
        """

        self._wt_no_quorum = wt_no_quorum

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TallyData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TallyData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
