# coding: utf-8

"""
    LOCKSS Repository Service REST API

    REST API of the LOCKSS Repository Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.rs.api_client import ApiClient


class ArtifactsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_artifacts(self, auid, archive, **kwargs):  # noqa: E501
        """Imports artifacts from an archive  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_artifacts(auid, archive, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: (required)
        :param str archive: (required)
        :param str namespace: Namespace of the artifacts
        :param bool store_duplicate: If true, artifacts with duplicate content will be stored, otherwise suppressed
        :param str exclude_status_pattern: If supplied, WARC records whose HTTP response status code matches the regular expression will not be imported
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_artifacts_with_http_info(auid, archive, **kwargs)  # noqa: E501
        else:
            (data) = self.add_artifacts_with_http_info(auid, archive, **kwargs)  # noqa: E501
            return data

    def add_artifacts_with_http_info(self, auid, archive, **kwargs):  # noqa: E501
        """Imports artifacts from an archive  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_artifacts_with_http_info(auid, archive, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: (required)
        :param str archive: (required)
        :param str namespace: Namespace of the artifacts
        :param bool store_duplicate: If true, artifacts with duplicate content will be stored, otherwise suppressed
        :param str exclude_status_pattern: If supplied, WARC records whose HTTP response status code matches the regular expression will not be imported
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid', 'archive', 'namespace', 'store_duplicate', 'exclude_status_pattern']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `add_artifacts`")  # noqa: E501
        # verify the required parameter 'archive' is set
        if ('archive' not in params or
                params['archive'] is None):
            raise ValueError("Missing the required parameter `archive` when calling `add_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'store_duplicate' in params:
            query_params.append(('storeDuplicate', params['store_duplicate']))  # noqa: E501
        if 'exclude_status_pattern' in params:
            query_params.append(('excludeStatusPattern', params['exclude_status_pattern']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'auid' in params:
            form_params.append(('auid', params['auid']))  # noqa: E501
        if 'archive' in params:
            local_var_files['archive'] = params['archive']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/archives', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_artifact(self, **kwargs):  # noqa: E501
        """Create an artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_artifact(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str artifact_props:
        :param str payload:
        :param str http_response_header:
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_artifact_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_artifact_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_artifact_with_http_info(self, **kwargs):  # noqa: E501
        """Create an artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_artifact_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str artifact_props:
        :param str payload:
        :param str http_response_header:
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_props', 'payload', 'http_response_header']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_artifact" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'artifact_props' in params:
            form_params.append(('artifactProps', params['artifact_props']))  # noqa: E501
        if 'payload' in params:
            local_var_files['payload'] = params['payload']  # noqa: E501
        if 'http_response_header' in params:
            form_params.append(('httpResponseHeader', params['http_response_header']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifact',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_artifact(self, uuid, **kwargs):  # noqa: E501
        """Remove an artifact from the repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_artifact(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_artifact_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_artifact_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_artifact_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Remove an artifact from the repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_artifact_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact_data_by_multipart(self, uuid, **kwargs):  # noqa: E501
        """Get artifact and metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_multipart(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifact_data_by_multipart_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_data_by_multipart_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_artifact_data_by_multipart_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get artifact and metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_multipart_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'namespace', 'include_content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact_data_by_multipart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_artifact_data_by_multipart`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'include_content' in params:
            query_params.append(('includeContent', params['include_content']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact_data_by_payload(self, uuid, **kwargs):  # noqa: E501
        """Get artifact payload  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_payload(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifact_data_by_payload_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_data_by_payload_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_artifact_data_by_payload_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get artifact payload  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_payload_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'namespace', 'include_content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact_data_by_payload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_artifact_data_by_payload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'include_content' in params:
            query_params.append(('includeContent', params['include_content']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts/{uuid}/payload', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact_data_by_response(self, uuid, **kwargs):  # noqa: E501
        """Get artifact data as HTTP response  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_response(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifact_data_by_response_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_data_by_response_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_artifact_data_by_response_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get artifact data as HTTP response  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_data_by_response_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :param str include_content: Controls whether to include the artifact content part in multipart response
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'namespace', 'include_content']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact_data_by_response" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_artifact_data_by_response`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'include_content' in params:
            query_params.append(('includeContent', params['include_content']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/http;msgtype=response', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts/{uuid}/response', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifacts(self, auid, **kwargs):  # noqa: E501
        """Get artifacts in an Archival Unit  # noqa: E501

        Get a list of all artifacts in a namespace and Archival Unit or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str namespace: Namespace of the artifacts
        :param str url: The URL contained by the artifacts
        :param str url_prefix: The prefix to be matched by the artifact URLs
        :param str version: The version of the artifact
        :param bool include_uncommitted: Indication of whether uncommitted artifacts should be returned
        :param int limit: The requested maximum number of artifacts per response
        :param str continuation_token: The continuation token of the next page of artifacts to be returned
        :return: ArtifactPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifacts_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifacts_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_artifacts_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get artifacts in an Archival Unit  # noqa: E501

        Get a list of all artifacts in a namespace and Archival Unit or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str namespace: Namespace of the artifacts
        :param str url: The URL contained by the artifacts
        :param str url_prefix: The prefix to be matched by the artifact URLs
        :param str version: The version of the artifact
        :param bool include_uncommitted: Indication of whether uncommitted artifacts should be returned
        :param int limit: The requested maximum number of artifacts per response
        :param str continuation_token: The continuation token of the next page of artifacts to be returned
        :return: ArtifactPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid', 'namespace', 'url', 'url_prefix', 'version', 'include_uncommitted', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501
        if 'url_prefix' in params:
            query_params.append(('urlPrefix', params['url_prefix']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501
        if 'include_uncommitted' in params:
            query_params.append(('includeUncommitted', params['include_uncommitted']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/artifacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtifactPageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifacts_from_all_aus(self, **kwargs):  # noqa: E501
        """Returns all artifacts that match a given a URL or URL prefix and/or version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts_from_all_aus(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts
        :param str url: The URL contained by the artifacts
        :param str url_prefix: The prefix to be matched by the artifact URLs
        :param str versions: Versions of the artifacts to return
        :param int limit: The requested maximum number of artifacts per response
        :param str continuation_token: The continuation token of the next page of artifacts to be returned
        :return: ArtifactPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifacts_from_all_aus_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_artifacts_from_all_aus_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_artifacts_from_all_aus_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all artifacts that match a given a URL or URL prefix and/or version.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts_from_all_aus_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts
        :param str url: The URL contained by the artifacts
        :param str url_prefix: The prefix to be matched by the artifact URLs
        :param str versions: Versions of the artifacts to return
        :param int limit: The requested maximum number of artifacts per response
        :param str continuation_token: The continuation token of the next page of artifacts to be returned
        :return: ArtifactPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'url', 'url_prefix', 'versions', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifacts_from_all_aus" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501
        if 'url_prefix' in params:
            query_params.append(('urlPrefix', params['url_prefix']))  # noqa: E501
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtifactPageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_artifact(self, committed, uuid, **kwargs):  # noqa: E501
        """Update the property of an artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_artifact(committed, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool committed: Committed status of the artifact (required)
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_artifact_with_http_info(committed, uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_artifact_with_http_info(committed, uuid, **kwargs)  # noqa: E501
            return data

    def update_artifact_with_http_info(self, committed, uuid, **kwargs):  # noqa: E501
        """Update the property of an artifact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_artifact_with_http_info(committed, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool committed: Committed status of the artifact (required)
        :param str uuid: Identifier of the artifact (required)
        :param str namespace: Namespace of the artifacts
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['committed', 'uuid', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'committed' is set
        if ('committed' not in params or
                params['committed'] is None):
            raise ValueError("Missing the required parameter `committed` when calling `update_artifact`")  # noqa: E501
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'committed' in params:
            query_params.append(('committed', params['committed']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/artifacts/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifact',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
