# coding: utf-8

"""
    LOCKSS Repository Service REST API

    REST API of the LOCKSS Repository Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.rs.api_client import ApiClient


class AusApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_artifacts_size(self, auid, **kwargs):  # noqa: E501
        """Get the size of Archival Unit artifacts in a namespace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts_size(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str namespace: Namespace of the artifacts
        :return: AuSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifacts_size_with_http_info(auid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifacts_size_with_http_info(auid, **kwargs)  # noqa: E501
            return data

    def get_artifacts_size_with_http_info(self, auid, **kwargs):  # noqa: E501
        """Get the size of Archival Unit artifacts in a namespace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifacts_size_with_http_info(auid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Identifier of the Archival Unit containing the artifacts (required)
        :param str namespace: Namespace of the artifacts
        :return: AuSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifacts_size" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `get_artifacts_size`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aus(self, **kwargs):  # noqa: E501
        """Get Archival Unit IDs (AUIDs) in a namespace  # noqa: E501

        Get a list of all Archival Unit identifiers in a namespace or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aus(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts
        :param int limit: The requested maximum number of Archival Unit identifiers per response
        :param str continuation_token: The continuation token of the next page of Archival Unit identifiers to be returned
        :return: AuidPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_aus_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_aus_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_aus_with_http_info(self, **kwargs):  # noqa: E501
        """Get Archival Unit IDs (AUIDs) in a namespace  # noqa: E501

        Get a list of all Archival Unit identifiers in a namespace or a pageful of the list defined by the continuation token and size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aus_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts
        :param int limit: The requested maximum number of Archival Unit identifiers per response
        :param str continuation_token: The continuation token of the next page of Archival Unit identifiers to be returned
        :return: AuidPageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'limit', 'continuation_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aus" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/aus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuidPageInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_bulk_au_op(self, auid, op, **kwargs):  # noqa: E501
        """Marks the AUID for bulk artifact transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_bulk_au_op(auid, op, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Archival Unit ID (required)
        :param str op: (required)
        :param str namespace: Namespace of the artifacts
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_bulk_au_op_with_http_info(auid, op, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_bulk_au_op_with_http_info(auid, op, **kwargs)  # noqa: E501
            return data

    def handle_bulk_au_op_with_http_info(self, auid, op, **kwargs):  # noqa: E501
        """Marks the AUID for bulk artifact transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_bulk_au_op_with_http_info(auid, op, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str auid: Archival Unit ID (required)
        :param str op: (required)
        :param str namespace: Namespace of the artifacts
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['auid', 'op', 'namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_bulk_au_op" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'auid' is set
        if ('auid' not in params or
                params['auid'] is None):
            raise ValueError("Missing the required parameter `auid` when calling `handle_bulk_au_op`")  # noqa: E501
        # verify the required parameter 'op' is set
        if ('op' not in params or
                params['op'] is None):
            raise ValueError("Missing the required parameter `op` when calling `handle_bulk_au_op`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'auid' in params:
            path_params['auid'] = params['auid']  # noqa: E501

        query_params = []
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'op' in params:
            query_params.append(('op', params['op']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/aus/{auid}/bulk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
