# coding: utf-8

"""
    LOCKSS Repository Service REST API

    REST API of the LOCKSS Repository Service  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: lockss-support@lockss.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lockss.pyclient.rs.api_client import ApiClient


class WaybackApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cdx_owb(self, namespace, **kwargs):  # noqa: E501
        """Get OpenWayback CDX records  # noqa: E501

        Get the OpenWayback CDX records of a URL in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cdx_owb(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts (required)
        :param str q: Query string. Supported fields are url, type (urlqueryprefixquery), offset and limit.
        :param int count: .
        :param int start_page: .
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cdx_owb_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cdx_owb_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def get_cdx_owb_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """Get OpenWayback CDX records  # noqa: E501

        Get the OpenWayback CDX records of a URL in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cdx_owb_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts (required)
        :param str q: Query string. Supported fields are url, type (urlqueryprefixquery), offset and limit.
        :param int count: .
        :param int start_page: .
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'q', 'count', 'start_page', 'accept', 'accept_encoding']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cdx_owb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_cdx_owb`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'start_page' in params:
            query_params.append(('start_page', params['start_page']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']  # noqa: E501
        if 'accept_encoding' in params:
            header_params['Accept-Encoding'] = params['accept_encoding']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/wayback/cdx/owb/{namespace}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cdx_pywb(self, namespace, **kwargs):  # noqa: E501
        """Get PyWayback CDX records  # noqa: E501

        Get the PyWayback CDX records of a URL in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cdx_pywb(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts (required)
        :param str url: The URL for which the CDX records are requested
        :param int limit: .
        :param str match_type:
        :param str sort:
        :param str closest: Timestamp for sort=closest mode
        :param str output: Output format
        :param str fl: Comma-separated list of fields to include in output
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cdx_pywb_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cdx_pywb_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def get_cdx_pywb_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """Get PyWayback CDX records  # noqa: E501

        Get the PyWayback CDX records of a URL in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cdx_pywb_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: Namespace of the artifacts (required)
        :param str url: The URL for which the CDX records are requested
        :param int limit: .
        :param str match_type:
        :param str sort:
        :param str closest: Timestamp for sort=closest mode
        :param str output: Output format
        :param str fl: Comma-separated list of fields to include in output
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'url', 'limit', 'match_type', 'sort', 'closest', 'output', 'fl', 'accept', 'accept_encoding']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cdx_pywb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params or
                params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `get_cdx_pywb`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []
        if 'url' in params:
            query_params.append(('url', params['url']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'match_type' in params:
            query_params.append(('matchType', params['match_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'closest' in params:
            query_params.append(('closest', params['closest']))  # noqa: E501
        if 'output' in params:
            query_params.append(('output', params['output']))  # noqa: E501
        if 'fl' in params:
            query_params.append(('fl', params['fl']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']  # noqa: E501
        if 'accept_encoding' in params:
            header_params['Accept-Encoding'] = params['accept_encoding']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/wayback/cdx/pywb/{namespace}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_warc_archive(self, file_name, **kwargs):  # noqa: E501
        """Get a WARC archive  # noqa: E501

        Get the contents of a single WARC record as a WARC archive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_warc_archive(file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: Name of the WARC archive (required)
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :param str range: The Range header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_warc_archive_with_http_info(file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_warc_archive_with_http_info(file_name, **kwargs)  # noqa: E501
            return data

    def get_warc_archive_with_http_info(self, file_name, **kwargs):  # noqa: E501
        """Get a WARC archive  # noqa: E501

        Get the contents of a single WARC record as a WARC archive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_warc_archive_with_http_info(file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: Name of the WARC archive (required)
        :param str accept: The Accept header
        :param str accept_encoding: The Accept-Encoding header
        :param str range: The Range header
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'accept', 'accept_encoding', 'range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_warc_archive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_warc_archive`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']  # noqa: E501
        if 'accept_encoding' in params:
            header_params['Accept-Encoding'] = params['accept_encoding']  # noqa: E501
        if 'range' in params:
            header_params['Range'] = params['range']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/warc', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/wayback/warcs/{fileName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
