# Automatically generated by `_icons_generate_enum.py`
# See https://tabler-icons.io/
from typing import NewType

IconName = NewType("IconName", str)
"""Name of an icon. Should be generated via `viser.Icon.*`."""


class _IconStringConverter(type):
    def __getattr__(self, __name: str) -> IconName:
        if not __name.startswith("_"):
            return IconName(__name.lower().replace("_", "-"))
        else:
            raise AttributeError()


class Icon(metaclass=_IconStringConverter):
    """'Enum' class for referencing Tabler icons.

    We don't subclass enum.Enum for performance reasons -- importing an enum with
    thousands of names can result in import times in the hundreds of milliseconds.

    Attributes:
        ICON_123 (IconName): The :code:`123` icon.
        ICON_24_HOURS (IconName): The :code:`24-hours` icon.
        ICON_2FA (IconName): The :code:`2fa` icon.
        ICON_360 (IconName): The :code:`360` icon.
        ICON_360_VIEW (IconName): The :code:`360-view` icon.
        ICON_3D_CUBE_SPHERE (IconName): The :code:`3d-cube-sphere` icon.
        ICON_3D_CUBE_SPHERE_OFF (IconName): The :code:`3d-cube-sphere-off` icon.
        ICON_3D_ROTATE (IconName): The :code:`3d-rotate` icon.
        A_B (IconName): The :code:`a-b` icon.
        A_B_2 (IconName): The :code:`a-b-2` icon.
        A_B_OFF (IconName): The :code:`a-b-off` icon.
        ABACUS (IconName): The :code:`abacus` icon.
        ABACUS_OFF (IconName): The :code:`abacus-off` icon.
        ABC (IconName): The :code:`abc` icon.
        ACCESS_POINT (IconName): The :code:`access-point` icon.
        ACCESS_POINT_OFF (IconName): The :code:`access-point-off` icon.
        ACCESSIBLE (IconName): The :code:`accessible` icon.
        ACCESSIBLE_OFF (IconName): The :code:`accessible-off` icon.
        ACCESSIBLE_OFF_FILLED (IconName): The :code:`accessible-off-filled` icon.
        ACTIVITY (IconName): The :code:`activity` icon.
        ACTIVITY_HEARTBEAT (IconName): The :code:`activity-heartbeat` icon.
        AD (IconName): The :code:`ad` icon.
        AD_2 (IconName): The :code:`ad-2` icon.
        AD_CIRCLE (IconName): The :code:`ad-circle` icon.
        AD_CIRCLE_FILLED (IconName): The :code:`ad-circle-filled` icon.
        AD_CIRCLE_OFF (IconName): The :code:`ad-circle-off` icon.
        AD_FILLED (IconName): The :code:`ad-filled` icon.
        AD_OFF (IconName): The :code:`ad-off` icon.
        ADDRESS_BOOK (IconName): The :code:`address-book` icon.
        ADDRESS_BOOK_OFF (IconName): The :code:`address-book-off` icon.
        ADJUSTMENTS (IconName): The :code:`adjustments` icon.
        ADJUSTMENTS_ALT (IconName): The :code:`adjustments-alt` icon.
        ADJUSTMENTS_BOLT (IconName): The :code:`adjustments-bolt` icon.
        ADJUSTMENTS_CANCEL (IconName): The :code:`adjustments-cancel` icon.
        ADJUSTMENTS_CHECK (IconName): The :code:`adjustments-check` icon.
        ADJUSTMENTS_CODE (IconName): The :code:`adjustments-code` icon.
        ADJUSTMENTS_COG (IconName): The :code:`adjustments-cog` icon.
        ADJUSTMENTS_DOLLAR (IconName): The :code:`adjustments-dollar` icon.
        ADJUSTMENTS_DOWN (IconName): The :code:`adjustments-down` icon.
        ADJUSTMENTS_EXCLAMATION (IconName): The :code:`adjustments-exclamation` icon.
        ADJUSTMENTS_FILLED (IconName): The :code:`adjustments-filled` icon.
        ADJUSTMENTS_HEART (IconName): The :code:`adjustments-heart` icon.
        ADJUSTMENTS_HORIZONTAL (IconName): The :code:`adjustments-horizontal` icon.
        ADJUSTMENTS_MINUS (IconName): The :code:`adjustments-minus` icon.
        ADJUSTMENTS_OFF (IconName): The :code:`adjustments-off` icon.
        ADJUSTMENTS_PAUSE (IconName): The :code:`adjustments-pause` icon.
        ADJUSTMENTS_PIN (IconName): The :code:`adjustments-pin` icon.
        ADJUSTMENTS_PLUS (IconName): The :code:`adjustments-plus` icon.
        ADJUSTMENTS_QUESTION (IconName): The :code:`adjustments-question` icon.
        ADJUSTMENTS_SEARCH (IconName): The :code:`adjustments-search` icon.
        ADJUSTMENTS_SHARE (IconName): The :code:`adjustments-share` icon.
        ADJUSTMENTS_STAR (IconName): The :code:`adjustments-star` icon.
        ADJUSTMENTS_UP (IconName): The :code:`adjustments-up` icon.
        ADJUSTMENTS_X (IconName): The :code:`adjustments-x` icon.
        AERIAL_LIFT (IconName): The :code:`aerial-lift` icon.
        AFFILIATE (IconName): The :code:`affiliate` icon.
        AFFILIATE_FILLED (IconName): The :code:`affiliate-filled` icon.
        AIR_BALLOON (IconName): The :code:`air-balloon` icon.
        AIR_CONDITIONING (IconName): The :code:`air-conditioning` icon.
        AIR_CONDITIONING_DISABLED (IconName): The :code:`air-conditioning-disabled` icon.
        ALARM (IconName): The :code:`alarm` icon.
        ALARM_FILLED (IconName): The :code:`alarm-filled` icon.
        ALARM_MINUS (IconName): The :code:`alarm-minus` icon.
        ALARM_MINUS_FILLED (IconName): The :code:`alarm-minus-filled` icon.
        ALARM_OFF (IconName): The :code:`alarm-off` icon.
        ALARM_PLUS (IconName): The :code:`alarm-plus` icon.
        ALARM_PLUS_FILLED (IconName): The :code:`alarm-plus-filled` icon.
        ALARM_SNOOZE (IconName): The :code:`alarm-snooze` icon.
        ALARM_SNOOZE_FILLED (IconName): The :code:`alarm-snooze-filled` icon.
        ALBUM (IconName): The :code:`album` icon.
        ALBUM_OFF (IconName): The :code:`album-off` icon.
        ALERT_CIRCLE (IconName): The :code:`alert-circle` icon.
        ALERT_CIRCLE_FILLED (IconName): The :code:`alert-circle-filled` icon.
        ALERT_HEXAGON (IconName): The :code:`alert-hexagon` icon.
        ALERT_HEXAGON_FILLED (IconName): The :code:`alert-hexagon-filled` icon.
        ALERT_OCTAGON (IconName): The :code:`alert-octagon` icon.
        ALERT_OCTAGON_FILLED (IconName): The :code:`alert-octagon-filled` icon.
        ALERT_SMALL (IconName): The :code:`alert-small` icon.
        ALERT_SQUARE (IconName): The :code:`alert-square` icon.
        ALERT_SQUARE_FILLED (IconName): The :code:`alert-square-filled` icon.
        ALERT_SQUARE_ROUNDED (IconName): The :code:`alert-square-rounded` icon.
        ALERT_SQUARE_ROUNDED_FILLED (IconName): The :code:`alert-square-rounded-filled` icon.
        ALERT_TRIANGLE (IconName): The :code:`alert-triangle` icon.
        ALERT_TRIANGLE_FILLED (IconName): The :code:`alert-triangle-filled` icon.
        ALIEN (IconName): The :code:`alien` icon.
        ALIEN_FILLED (IconName): The :code:`alien-filled` icon.
        ALIGN_BOX_BOTTOM_CENTER (IconName): The :code:`align-box-bottom-center` icon.
        ALIGN_BOX_BOTTOM_CENTER_FILLED (IconName): The :code:`align-box-bottom-center-filled` icon.
        ALIGN_BOX_BOTTOM_LEFT (IconName): The :code:`align-box-bottom-left` icon.
        ALIGN_BOX_BOTTOM_LEFT_FILLED (IconName): The :code:`align-box-bottom-left-filled` icon.
        ALIGN_BOX_BOTTOM_RIGHT (IconName): The :code:`align-box-bottom-right` icon.
        ALIGN_BOX_BOTTOM_RIGHT_FILLED (IconName): The :code:`align-box-bottom-right-filled` icon.
        ALIGN_BOX_CENTER_BOTTOM (IconName): The :code:`align-box-center-bottom` icon.
        ALIGN_BOX_CENTER_MIDDLE (IconName): The :code:`align-box-center-middle` icon.
        ALIGN_BOX_CENTER_MIDDLE_FILLED (IconName): The :code:`align-box-center-middle-filled` icon.
        ALIGN_BOX_CENTER_STRETCH (IconName): The :code:`align-box-center-stretch` icon.
        ALIGN_BOX_CENTER_TOP (IconName): The :code:`align-box-center-top` icon.
        ALIGN_BOX_LEFT_BOTTOM (IconName): The :code:`align-box-left-bottom` icon.
        ALIGN_BOX_LEFT_BOTTOM_FILLED (IconName): The :code:`align-box-left-bottom-filled` icon.
        ALIGN_BOX_LEFT_MIDDLE (IconName): The :code:`align-box-left-middle` icon.
        ALIGN_BOX_LEFT_MIDDLE_FILLED (IconName): The :code:`align-box-left-middle-filled` icon.
        ALIGN_BOX_LEFT_STRETCH (IconName): The :code:`align-box-left-stretch` icon.
        ALIGN_BOX_LEFT_TOP (IconName): The :code:`align-box-left-top` icon.
        ALIGN_BOX_LEFT_TOP_FILLED (IconName): The :code:`align-box-left-top-filled` icon.
        ALIGN_BOX_RIGHT_BOTTOM (IconName): The :code:`align-box-right-bottom` icon.
        ALIGN_BOX_RIGHT_BOTTOM_FILLED (IconName): The :code:`align-box-right-bottom-filled` icon.
        ALIGN_BOX_RIGHT_MIDDLE (IconName): The :code:`align-box-right-middle` icon.
        ALIGN_BOX_RIGHT_MIDDLE_FILLED (IconName): The :code:`align-box-right-middle-filled` icon.
        ALIGN_BOX_RIGHT_STRETCH (IconName): The :code:`align-box-right-stretch` icon.
        ALIGN_BOX_RIGHT_TOP (IconName): The :code:`align-box-right-top` icon.
        ALIGN_BOX_RIGHT_TOP_FILLED (IconName): The :code:`align-box-right-top-filled` icon.
        ALIGN_BOX_TOP_CENTER (IconName): The :code:`align-box-top-center` icon.
        ALIGN_BOX_TOP_CENTER_FILLED (IconName): The :code:`align-box-top-center-filled` icon.
        ALIGN_BOX_TOP_LEFT (IconName): The :code:`align-box-top-left` icon.
        ALIGN_BOX_TOP_LEFT_FILLED (IconName): The :code:`align-box-top-left-filled` icon.
        ALIGN_BOX_TOP_RIGHT (IconName): The :code:`align-box-top-right` icon.
        ALIGN_BOX_TOP_RIGHT_FILLED (IconName): The :code:`align-box-top-right-filled` icon.
        ALIGN_CENTER (IconName): The :code:`align-center` icon.
        ALIGN_JUSTIFIED (IconName): The :code:`align-justified` icon.
        ALIGN_LEFT (IconName): The :code:`align-left` icon.
        ALIGN_RIGHT (IconName): The :code:`align-right` icon.
        ALPHA (IconName): The :code:`alpha` icon.
        ALPHABET_CYRILLIC (IconName): The :code:`alphabet-cyrillic` icon.
        ALPHABET_GREEK (IconName): The :code:`alphabet-greek` icon.
        ALPHABET_LATIN (IconName): The :code:`alphabet-latin` icon.
        AMBULANCE (IconName): The :code:`ambulance` icon.
        AMPERSAND (IconName): The :code:`ampersand` icon.
        ANALYZE (IconName): The :code:`analyze` icon.
        ANALYZE_FILLED (IconName): The :code:`analyze-filled` icon.
        ANALYZE_OFF (IconName): The :code:`analyze-off` icon.
        ANCHOR (IconName): The :code:`anchor` icon.
        ANCHOR_OFF (IconName): The :code:`anchor-off` icon.
        ANGLE (IconName): The :code:`angle` icon.
        ANKH (IconName): The :code:`ankh` icon.
        ANTENNA (IconName): The :code:`antenna` icon.
        ANTENNA_BARS_1 (IconName): The :code:`antenna-bars-1` icon.
        ANTENNA_BARS_2 (IconName): The :code:`antenna-bars-2` icon.
        ANTENNA_BARS_3 (IconName): The :code:`antenna-bars-3` icon.
        ANTENNA_BARS_4 (IconName): The :code:`antenna-bars-4` icon.
        ANTENNA_BARS_5 (IconName): The :code:`antenna-bars-5` icon.
        ANTENNA_BARS_OFF (IconName): The :code:`antenna-bars-off` icon.
        ANTENNA_OFF (IconName): The :code:`antenna-off` icon.
        APERTURE (IconName): The :code:`aperture` icon.
        APERTURE_OFF (IconName): The :code:`aperture-off` icon.
        API (IconName): The :code:`api` icon.
        API_APP (IconName): The :code:`api-app` icon.
        API_APP_OFF (IconName): The :code:`api-app-off` icon.
        API_OFF (IconName): The :code:`api-off` icon.
        APP_WINDOW (IconName): The :code:`app-window` icon.
        APP_WINDOW_FILLED (IconName): The :code:`app-window-filled` icon.
        APPLE (IconName): The :code:`apple` icon.
        APPS (IconName): The :code:`apps` icon.
        APPS_FILLED (IconName): The :code:`apps-filled` icon.
        APPS_OFF (IconName): The :code:`apps-off` icon.
        ARCHIVE (IconName): The :code:`archive` icon.
        ARCHIVE_FILLED (IconName): The :code:`archive-filled` icon.
        ARCHIVE_OFF (IconName): The :code:`archive-off` icon.
        ARMCHAIR (IconName): The :code:`armchair` icon.
        ARMCHAIR_2 (IconName): The :code:`armchair-2` icon.
        ARMCHAIR_2_OFF (IconName): The :code:`armchair-2-off` icon.
        ARMCHAIR_OFF (IconName): The :code:`armchair-off` icon.
        ARROW_AUTOFIT_CONTENT (IconName): The :code:`arrow-autofit-content` icon.
        ARROW_AUTOFIT_CONTENT_FILLED (IconName): The :code:`arrow-autofit-content-filled` icon.
        ARROW_AUTOFIT_DOWN (IconName): The :code:`arrow-autofit-down` icon.
        ARROW_AUTOFIT_HEIGHT (IconName): The :code:`arrow-autofit-height` icon.
        ARROW_AUTOFIT_LEFT (IconName): The :code:`arrow-autofit-left` icon.
        ARROW_AUTOFIT_RIGHT (IconName): The :code:`arrow-autofit-right` icon.
        ARROW_AUTOFIT_UP (IconName): The :code:`arrow-autofit-up` icon.
        ARROW_AUTOFIT_WIDTH (IconName): The :code:`arrow-autofit-width` icon.
        ARROW_BACK (IconName): The :code:`arrow-back` icon.
        ARROW_BACK_UP (IconName): The :code:`arrow-back-up` icon.
        ARROW_BACK_UP_DOUBLE (IconName): The :code:`arrow-back-up-double` icon.
        ARROW_BADGE_DOWN (IconName): The :code:`arrow-badge-down` icon.
        ARROW_BADGE_DOWN_FILLED (IconName): The :code:`arrow-badge-down-filled` icon.
        ARROW_BADGE_LEFT (IconName): The :code:`arrow-badge-left` icon.
        ARROW_BADGE_LEFT_FILLED (IconName): The :code:`arrow-badge-left-filled` icon.
        ARROW_BADGE_RIGHT (IconName): The :code:`arrow-badge-right` icon.
        ARROW_BADGE_RIGHT_FILLED (IconName): The :code:`arrow-badge-right-filled` icon.
        ARROW_BADGE_UP (IconName): The :code:`arrow-badge-up` icon.
        ARROW_BADGE_UP_FILLED (IconName): The :code:`arrow-badge-up-filled` icon.
        ARROW_BAR_BOTH (IconName): The :code:`arrow-bar-both` icon.
        ARROW_BAR_DOWN (IconName): The :code:`arrow-bar-down` icon.
        ARROW_BAR_LEFT (IconName): The :code:`arrow-bar-left` icon.
        ARROW_BAR_RIGHT (IconName): The :code:`arrow-bar-right` icon.
        ARROW_BAR_TO_DOWN (IconName): The :code:`arrow-bar-to-down` icon.
        ARROW_BAR_TO_LEFT (IconName): The :code:`arrow-bar-to-left` icon.
        ARROW_BAR_TO_RIGHT (IconName): The :code:`arrow-bar-to-right` icon.
        ARROW_BAR_TO_UP (IconName): The :code:`arrow-bar-to-up` icon.
        ARROW_BAR_UP (IconName): The :code:`arrow-bar-up` icon.
        ARROW_BEAR_LEFT (IconName): The :code:`arrow-bear-left` icon.
        ARROW_BEAR_LEFT_2 (IconName): The :code:`arrow-bear-left-2` icon.
        ARROW_BEAR_RIGHT (IconName): The :code:`arrow-bear-right` icon.
        ARROW_BEAR_RIGHT_2 (IconName): The :code:`arrow-bear-right-2` icon.
        ARROW_BIG_DOWN (IconName): The :code:`arrow-big-down` icon.
        ARROW_BIG_DOWN_FILLED (IconName): The :code:`arrow-big-down-filled` icon.
        ARROW_BIG_DOWN_LINE (IconName): The :code:`arrow-big-down-line` icon.
        ARROW_BIG_DOWN_LINE_FILLED (IconName): The :code:`arrow-big-down-line-filled` icon.
        ARROW_BIG_DOWN_LINES (IconName): The :code:`arrow-big-down-lines` icon.
        ARROW_BIG_DOWN_LINES_FILLED (IconName): The :code:`arrow-big-down-lines-filled` icon.
        ARROW_BIG_LEFT (IconName): The :code:`arrow-big-left` icon.
        ARROW_BIG_LEFT_FILLED (IconName): The :code:`arrow-big-left-filled` icon.
        ARROW_BIG_LEFT_LINE (IconName): The :code:`arrow-big-left-line` icon.
        ARROW_BIG_LEFT_LINE_FILLED (IconName): The :code:`arrow-big-left-line-filled` icon.
        ARROW_BIG_LEFT_LINES (IconName): The :code:`arrow-big-left-lines` icon.
        ARROW_BIG_LEFT_LINES_FILLED (IconName): The :code:`arrow-big-left-lines-filled` icon.
        ARROW_BIG_RIGHT (IconName): The :code:`arrow-big-right` icon.
        ARROW_BIG_RIGHT_FILLED (IconName): The :code:`arrow-big-right-filled` icon.
        ARROW_BIG_RIGHT_LINE (IconName): The :code:`arrow-big-right-line` icon.
        ARROW_BIG_RIGHT_LINE_FILLED (IconName): The :code:`arrow-big-right-line-filled` icon.
        ARROW_BIG_RIGHT_LINES (IconName): The :code:`arrow-big-right-lines` icon.
        ARROW_BIG_RIGHT_LINES_FILLED (IconName): The :code:`arrow-big-right-lines-filled` icon.
        ARROW_BIG_UP (IconName): The :code:`arrow-big-up` icon.
        ARROW_BIG_UP_FILLED (IconName): The :code:`arrow-big-up-filled` icon.
        ARROW_BIG_UP_LINE (IconName): The :code:`arrow-big-up-line` icon.
        ARROW_BIG_UP_LINE_FILLED (IconName): The :code:`arrow-big-up-line-filled` icon.
        ARROW_BIG_UP_LINES (IconName): The :code:`arrow-big-up-lines` icon.
        ARROW_BIG_UP_LINES_FILLED (IconName): The :code:`arrow-big-up-lines-filled` icon.
        ARROW_BOUNCE (IconName): The :code:`arrow-bounce` icon.
        ARROW_CAPSULE (IconName): The :code:`arrow-capsule` icon.
        ARROW_CURVE_LEFT (IconName): The :code:`arrow-curve-left` icon.
        ARROW_CURVE_RIGHT (IconName): The :code:`arrow-curve-right` icon.
        ARROW_DOWN (IconName): The :code:`arrow-down` icon.
        ARROW_DOWN_BAR (IconName): The :code:`arrow-down-bar` icon.
        ARROW_DOWN_CIRCLE (IconName): The :code:`arrow-down-circle` icon.
        ARROW_DOWN_LEFT (IconName): The :code:`arrow-down-left` icon.
        ARROW_DOWN_LEFT_CIRCLE (IconName): The :code:`arrow-down-left-circle` icon.
        ARROW_DOWN_RHOMBUS (IconName): The :code:`arrow-down-rhombus` icon.
        ARROW_DOWN_RIGHT (IconName): The :code:`arrow-down-right` icon.
        ARROW_DOWN_RIGHT_CIRCLE (IconName): The :code:`arrow-down-right-circle` icon.
        ARROW_DOWN_SQUARE (IconName): The :code:`arrow-down-square` icon.
        ARROW_DOWN_TAIL (IconName): The :code:`arrow-down-tail` icon.
        ARROW_ELBOW_LEFT (IconName): The :code:`arrow-elbow-left` icon.
        ARROW_ELBOW_RIGHT (IconName): The :code:`arrow-elbow-right` icon.
        ARROW_FORK (IconName): The :code:`arrow-fork` icon.
        ARROW_FORWARD (IconName): The :code:`arrow-forward` icon.
        ARROW_FORWARD_UP (IconName): The :code:`arrow-forward-up` icon.
        ARROW_FORWARD_UP_DOUBLE (IconName): The :code:`arrow-forward-up-double` icon.
        ARROW_GUIDE (IconName): The :code:`arrow-guide` icon.
        ARROW_ITERATION (IconName): The :code:`arrow-iteration` icon.
        ARROW_LEFT (IconName): The :code:`arrow-left` icon.
        ARROW_LEFT_BAR (IconName): The :code:`arrow-left-bar` icon.
        ARROW_LEFT_CIRCLE (IconName): The :code:`arrow-left-circle` icon.
        ARROW_LEFT_RHOMBUS (IconName): The :code:`arrow-left-rhombus` icon.
        ARROW_LEFT_RIGHT (IconName): The :code:`arrow-left-right` icon.
        ARROW_LEFT_SQUARE (IconName): The :code:`arrow-left-square` icon.
        ARROW_LEFT_TAIL (IconName): The :code:`arrow-left-tail` icon.
        ARROW_LOOP_LEFT (IconName): The :code:`arrow-loop-left` icon.
        ARROW_LOOP_LEFT_2 (IconName): The :code:`arrow-loop-left-2` icon.
        ARROW_LOOP_RIGHT (IconName): The :code:`arrow-loop-right` icon.
        ARROW_LOOP_RIGHT_2 (IconName): The :code:`arrow-loop-right-2` icon.
        ARROW_MERGE (IconName): The :code:`arrow-merge` icon.
        ARROW_MERGE_BOTH (IconName): The :code:`arrow-merge-both` icon.
        ARROW_MERGE_LEFT (IconName): The :code:`arrow-merge-left` icon.
        ARROW_MERGE_RIGHT (IconName): The :code:`arrow-merge-right` icon.
        ARROW_MOVE_DOWN (IconName): The :code:`arrow-move-down` icon.
        ARROW_MOVE_LEFT (IconName): The :code:`arrow-move-left` icon.
        ARROW_MOVE_RIGHT (IconName): The :code:`arrow-move-right` icon.
        ARROW_MOVE_UP (IconName): The :code:`arrow-move-up` icon.
        ARROW_NARROW_DOWN (IconName): The :code:`arrow-narrow-down` icon.
        ARROW_NARROW_LEFT (IconName): The :code:`arrow-narrow-left` icon.
        ARROW_NARROW_RIGHT (IconName): The :code:`arrow-narrow-right` icon.
        ARROW_NARROW_UP (IconName): The :code:`arrow-narrow-up` icon.
        ARROW_RAMP_LEFT (IconName): The :code:`arrow-ramp-left` icon.
        ARROW_RAMP_LEFT_2 (IconName): The :code:`arrow-ramp-left-2` icon.
        ARROW_RAMP_LEFT_3 (IconName): The :code:`arrow-ramp-left-3` icon.
        ARROW_RAMP_RIGHT (IconName): The :code:`arrow-ramp-right` icon.
        ARROW_RAMP_RIGHT_2 (IconName): The :code:`arrow-ramp-right-2` icon.
        ARROW_RAMP_RIGHT_3 (IconName): The :code:`arrow-ramp-right-3` icon.
        ARROW_RIGHT (IconName): The :code:`arrow-right` icon.
        ARROW_RIGHT_BAR (IconName): The :code:`arrow-right-bar` icon.
        ARROW_RIGHT_CIRCLE (IconName): The :code:`arrow-right-circle` icon.
        ARROW_RIGHT_RHOMBUS (IconName): The :code:`arrow-right-rhombus` icon.
        ARROW_RIGHT_SQUARE (IconName): The :code:`arrow-right-square` icon.
        ARROW_RIGHT_TAIL (IconName): The :code:`arrow-right-tail` icon.
        ARROW_ROTARY_FIRST_LEFT (IconName): The :code:`arrow-rotary-first-left` icon.
        ARROW_ROTARY_FIRST_RIGHT (IconName): The :code:`arrow-rotary-first-right` icon.
        ARROW_ROTARY_LAST_LEFT (IconName): The :code:`arrow-rotary-last-left` icon.
        ARROW_ROTARY_LAST_RIGHT (IconName): The :code:`arrow-rotary-last-right` icon.
        ARROW_ROTARY_LEFT (IconName): The :code:`arrow-rotary-left` icon.
        ARROW_ROTARY_RIGHT (IconName): The :code:`arrow-rotary-right` icon.
        ARROW_ROTARY_STRAIGHT (IconName): The :code:`arrow-rotary-straight` icon.
        ARROW_ROUNDABOUT_LEFT (IconName): The :code:`arrow-roundabout-left` icon.
        ARROW_ROUNDABOUT_RIGHT (IconName): The :code:`arrow-roundabout-right` icon.
        ARROW_SHARP_TURN_LEFT (IconName): The :code:`arrow-sharp-turn-left` icon.
        ARROW_SHARP_TURN_RIGHT (IconName): The :code:`arrow-sharp-turn-right` icon.
        ARROW_UP (IconName): The :code:`arrow-up` icon.
        ARROW_UP_BAR (IconName): The :code:`arrow-up-bar` icon.
        ARROW_UP_CIRCLE (IconName): The :code:`arrow-up-circle` icon.
        ARROW_UP_LEFT (IconName): The :code:`arrow-up-left` icon.
        ARROW_UP_LEFT_CIRCLE (IconName): The :code:`arrow-up-left-circle` icon.
        ARROW_UP_RHOMBUS (IconName): The :code:`arrow-up-rhombus` icon.
        ARROW_UP_RIGHT (IconName): The :code:`arrow-up-right` icon.
        ARROW_UP_RIGHT_CIRCLE (IconName): The :code:`arrow-up-right-circle` icon.
        ARROW_UP_SQUARE (IconName): The :code:`arrow-up-square` icon.
        ARROW_UP_TAIL (IconName): The :code:`arrow-up-tail` icon.
        ARROW_WAVE_LEFT_DOWN (IconName): The :code:`arrow-wave-left-down` icon.
        ARROW_WAVE_LEFT_UP (IconName): The :code:`arrow-wave-left-up` icon.
        ARROW_WAVE_RIGHT_DOWN (IconName): The :code:`arrow-wave-right-down` icon.
        ARROW_WAVE_RIGHT_UP (IconName): The :code:`arrow-wave-right-up` icon.
        ARROW_ZIG_ZAG (IconName): The :code:`arrow-zig-zag` icon.
        ARROWS_CROSS (IconName): The :code:`arrows-cross` icon.
        ARROWS_DIAGONAL (IconName): The :code:`arrows-diagonal` icon.
        ARROWS_DIAGONAL_2 (IconName): The :code:`arrows-diagonal-2` icon.
        ARROWS_DIAGONAL_MINIMIZE (IconName): The :code:`arrows-diagonal-minimize` icon.
        ARROWS_DIAGONAL_MINIMIZE_2 (IconName): The :code:`arrows-diagonal-minimize-2` icon.
        ARROWS_DIFF (IconName): The :code:`arrows-diff` icon.
        ARROWS_DOUBLE_NE_SW (IconName): The :code:`arrows-double-ne-sw` icon.
        ARROWS_DOUBLE_NW_SE (IconName): The :code:`arrows-double-nw-se` icon.
        ARROWS_DOUBLE_SE_NW (IconName): The :code:`arrows-double-se-nw` icon.
        ARROWS_DOUBLE_SW_NE (IconName): The :code:`arrows-double-sw-ne` icon.
        ARROWS_DOWN (IconName): The :code:`arrows-down` icon.
        ARROWS_DOWN_UP (IconName): The :code:`arrows-down-up` icon.
        ARROWS_EXCHANGE (IconName): The :code:`arrows-exchange` icon.
        ARROWS_EXCHANGE_2 (IconName): The :code:`arrows-exchange-2` icon.
        ARROWS_HORIZONTAL (IconName): The :code:`arrows-horizontal` icon.
        ARROWS_JOIN (IconName): The :code:`arrows-join` icon.
        ARROWS_JOIN_2 (IconName): The :code:`arrows-join-2` icon.
        ARROWS_LEFT (IconName): The :code:`arrows-left` icon.
        ARROWS_LEFT_DOWN (IconName): The :code:`arrows-left-down` icon.
        ARROWS_LEFT_RIGHT (IconName): The :code:`arrows-left-right` icon.
        ARROWS_MAXIMIZE (IconName): The :code:`arrows-maximize` icon.
        ARROWS_MINIMIZE (IconName): The :code:`arrows-minimize` icon.
        ARROWS_MOVE (IconName): The :code:`arrows-move` icon.
        ARROWS_MOVE_HORIZONTAL (IconName): The :code:`arrows-move-horizontal` icon.
        ARROWS_MOVE_VERTICAL (IconName): The :code:`arrows-move-vertical` icon.
        ARROWS_RANDOM (IconName): The :code:`arrows-random` icon.
        ARROWS_RIGHT (IconName): The :code:`arrows-right` icon.
        ARROWS_RIGHT_DOWN (IconName): The :code:`arrows-right-down` icon.
        ARROWS_RIGHT_LEFT (IconName): The :code:`arrows-right-left` icon.
        ARROWS_SHUFFLE (IconName): The :code:`arrows-shuffle` icon.
        ARROWS_SHUFFLE_2 (IconName): The :code:`arrows-shuffle-2` icon.
        ARROWS_SORT (IconName): The :code:`arrows-sort` icon.
        ARROWS_SPLIT (IconName): The :code:`arrows-split` icon.
        ARROWS_SPLIT_2 (IconName): The :code:`arrows-split-2` icon.
        ARROWS_TRANSFER_DOWN (IconName): The :code:`arrows-transfer-down` icon.
        ARROWS_TRANSFER_UP (IconName): The :code:`arrows-transfer-up` icon.
        ARROWS_UP (IconName): The :code:`arrows-up` icon.
        ARROWS_UP_DOWN (IconName): The :code:`arrows-up-down` icon.
        ARROWS_UP_LEFT (IconName): The :code:`arrows-up-left` icon.
        ARROWS_UP_RIGHT (IconName): The :code:`arrows-up-right` icon.
        ARROWS_VERTICAL (IconName): The :code:`arrows-vertical` icon.
        ARTBOARD (IconName): The :code:`artboard` icon.
        ARTBOARD_FILLED (IconName): The :code:`artboard-filled` icon.
        ARTBOARD_OFF (IconName): The :code:`artboard-off` icon.
        ARTICLE (IconName): The :code:`article` icon.
        ARTICLE_FILLED_FILLED (IconName): The :code:`article-filled-filled` icon.
        ARTICLE_OFF (IconName): The :code:`article-off` icon.
        ASPECT_RATIO (IconName): The :code:`aspect-ratio` icon.
        ASPECT_RATIO_FILLED (IconName): The :code:`aspect-ratio-filled` icon.
        ASPECT_RATIO_OFF (IconName): The :code:`aspect-ratio-off` icon.
        ASSEMBLY (IconName): The :code:`assembly` icon.
        ASSEMBLY_OFF (IconName): The :code:`assembly-off` icon.
        ASSET (IconName): The :code:`asset` icon.
        ASTERISK (IconName): The :code:`asterisk` icon.
        ASTERISK_SIMPLE (IconName): The :code:`asterisk-simple` icon.
        AT (IconName): The :code:`at` icon.
        AT_OFF (IconName): The :code:`at-off` icon.
        ATOM (IconName): The :code:`atom` icon.
        ATOM_2 (IconName): The :code:`atom-2` icon.
        ATOM_2_FILLED (IconName): The :code:`atom-2-filled` icon.
        ATOM_OFF (IconName): The :code:`atom-off` icon.
        AUGMENTED_REALITY (IconName): The :code:`augmented-reality` icon.
        AUGMENTED_REALITY_2 (IconName): The :code:`augmented-reality-2` icon.
        AUGMENTED_REALITY_OFF (IconName): The :code:`augmented-reality-off` icon.
        AWARD (IconName): The :code:`award` icon.
        AWARD_FILLED (IconName): The :code:`award-filled` icon.
        AWARD_OFF (IconName): The :code:`award-off` icon.
        AXE (IconName): The :code:`axe` icon.
        AXIS_X (IconName): The :code:`axis-x` icon.
        AXIS_Y (IconName): The :code:`axis-y` icon.
        BABY_BOTTLE (IconName): The :code:`baby-bottle` icon.
        BABY_CARRIAGE (IconName): The :code:`baby-carriage` icon.
        BACKHOE (IconName): The :code:`backhoe` icon.
        BACKPACK (IconName): The :code:`backpack` icon.
        BACKPACK_OFF (IconName): The :code:`backpack-off` icon.
        BACKSLASH (IconName): The :code:`backslash` icon.
        BACKSPACE (IconName): The :code:`backspace` icon.
        BACKSPACE_FILLED (IconName): The :code:`backspace-filled` icon.
        BADGE (IconName): The :code:`badge` icon.
        BADGE_3D (IconName): The :code:`badge-3d` icon.
        BADGE_4K (IconName): The :code:`badge-4k` icon.
        BADGE_8K (IconName): The :code:`badge-8k` icon.
        BADGE_AD (IconName): The :code:`badge-ad` icon.
        BADGE_AR (IconName): The :code:`badge-ar` icon.
        BADGE_CC (IconName): The :code:`badge-cc` icon.
        BADGE_FILLED (IconName): The :code:`badge-filled` icon.
        BADGE_HD (IconName): The :code:`badge-hd` icon.
        BADGE_OFF (IconName): The :code:`badge-off` icon.
        BADGE_SD (IconName): The :code:`badge-sd` icon.
        BADGE_TM (IconName): The :code:`badge-tm` icon.
        BADGE_VO (IconName): The :code:`badge-vo` icon.
        BADGE_VR (IconName): The :code:`badge-vr` icon.
        BADGE_WC (IconName): The :code:`badge-wc` icon.
        BADGES (IconName): The :code:`badges` icon.
        BADGES_FILLED (IconName): The :code:`badges-filled` icon.
        BADGES_OFF (IconName): The :code:`badges-off` icon.
        BAGUETTE (IconName): The :code:`baguette` icon.
        BALL_AMERICAN_FOOTBALL (IconName): The :code:`ball-american-football` icon.
        BALL_AMERICAN_FOOTBALL_OFF (IconName): The :code:`ball-american-football-off` icon.
        BALL_BASEBALL (IconName): The :code:`ball-baseball` icon.
        BALL_BASKETBALL (IconName): The :code:`ball-basketball` icon.
        BALL_BOWLING (IconName): The :code:`ball-bowling` icon.
        BALL_FOOTBALL (IconName): The :code:`ball-football` icon.
        BALL_FOOTBALL_OFF (IconName): The :code:`ball-football-off` icon.
        BALL_TENNIS (IconName): The :code:`ball-tennis` icon.
        BALL_VOLLEYBALL (IconName): The :code:`ball-volleyball` icon.
        BALLOON (IconName): The :code:`balloon` icon.
        BALLOON_FILLED (IconName): The :code:`balloon-filled` icon.
        BALLOON_OFF (IconName): The :code:`balloon-off` icon.
        BALLPEN (IconName): The :code:`ballpen` icon.
        BALLPEN_FILLED (IconName): The :code:`ballpen-filled` icon.
        BALLPEN_OFF (IconName): The :code:`ballpen-off` icon.
        BAN (IconName): The :code:`ban` icon.
        BANDAGE (IconName): The :code:`bandage` icon.
        BANDAGE_FILLED (IconName): The :code:`bandage-filled` icon.
        BANDAGE_OFF (IconName): The :code:`bandage-off` icon.
        BARBELL (IconName): The :code:`barbell` icon.
        BARBELL_OFF (IconName): The :code:`barbell-off` icon.
        BARCODE (IconName): The :code:`barcode` icon.
        BARCODE_OFF (IconName): The :code:`barcode-off` icon.
        BARREL (IconName): The :code:`barrel` icon.
        BARREL_OFF (IconName): The :code:`barrel-off` icon.
        BARRIER_BLOCK (IconName): The :code:`barrier-block` icon.
        BARRIER_BLOCK_OFF (IconName): The :code:`barrier-block-off` icon.
        BASELINE (IconName): The :code:`baseline` icon.
        BASELINE_DENSITY_LARGE (IconName): The :code:`baseline-density-large` icon.
        BASELINE_DENSITY_MEDIUM (IconName): The :code:`baseline-density-medium` icon.
        BASELINE_DENSITY_SMALL (IconName): The :code:`baseline-density-small` icon.
        BASKET (IconName): The :code:`basket` icon.
        BASKET_FILLED (IconName): The :code:`basket-filled` icon.
        BASKET_OFF (IconName): The :code:`basket-off` icon.
        BAT (IconName): The :code:`bat` icon.
        BATH (IconName): The :code:`bath` icon.
        BATH_FILLED (IconName): The :code:`bath-filled` icon.
        BATH_OFF (IconName): The :code:`bath-off` icon.
        BATTERY (IconName): The :code:`battery` icon.
        BATTERY_1 (IconName): The :code:`battery-1` icon.
        BATTERY_1_FILLED (IconName): The :code:`battery-1-filled` icon.
        BATTERY_2 (IconName): The :code:`battery-2` icon.
        BATTERY_2_FILLED (IconName): The :code:`battery-2-filled` icon.
        BATTERY_3 (IconName): The :code:`battery-3` icon.
        BATTERY_3_FILLED (IconName): The :code:`battery-3-filled` icon.
        BATTERY_4 (IconName): The :code:`battery-4` icon.
        BATTERY_4_FILLED (IconName): The :code:`battery-4-filled` icon.
        BATTERY_AUTOMOTIVE (IconName): The :code:`battery-automotive` icon.
        BATTERY_CHARGING (IconName): The :code:`battery-charging` icon.
        BATTERY_CHARGING_2 (IconName): The :code:`battery-charging-2` icon.
        BATTERY_ECO (IconName): The :code:`battery-eco` icon.
        BATTERY_FILLED (IconName): The :code:`battery-filled` icon.
        BATTERY_OFF (IconName): The :code:`battery-off` icon.
        BEACH (IconName): The :code:`beach` icon.
        BEACH_OFF (IconName): The :code:`beach-off` icon.
        BED (IconName): The :code:`bed` icon.
        BED_FILLED (IconName): The :code:`bed-filled` icon.
        BED_OFF (IconName): The :code:`bed-off` icon.
        BEER (IconName): The :code:`beer` icon.
        BEER_FILLED (IconName): The :code:`beer-filled` icon.
        BEER_OFF (IconName): The :code:`beer-off` icon.
        BELL (IconName): The :code:`bell` icon.
        BELL_BOLT (IconName): The :code:`bell-bolt` icon.
        BELL_CANCEL (IconName): The :code:`bell-cancel` icon.
        BELL_CHECK (IconName): The :code:`bell-check` icon.
        BELL_CODE (IconName): The :code:`bell-code` icon.
        BELL_COG (IconName): The :code:`bell-cog` icon.
        BELL_DOLLAR (IconName): The :code:`bell-dollar` icon.
        BELL_DOWN (IconName): The :code:`bell-down` icon.
        BELL_EXCLAMATION (IconName): The :code:`bell-exclamation` icon.
        BELL_FILLED (IconName): The :code:`bell-filled` icon.
        BELL_HEART (IconName): The :code:`bell-heart` icon.
        BELL_MINUS (IconName): The :code:`bell-minus` icon.
        BELL_MINUS_FILLED (IconName): The :code:`bell-minus-filled` icon.
        BELL_OFF (IconName): The :code:`bell-off` icon.
        BELL_PAUSE (IconName): The :code:`bell-pause` icon.
        BELL_PIN (IconName): The :code:`bell-pin` icon.
        BELL_PLUS (IconName): The :code:`bell-plus` icon.
        BELL_PLUS_FILLED (IconName): The :code:`bell-plus-filled` icon.
        BELL_QUESTION (IconName): The :code:`bell-question` icon.
        BELL_RINGING (IconName): The :code:`bell-ringing` icon.
        BELL_RINGING_2 (IconName): The :code:`bell-ringing-2` icon.
        BELL_RINGING_2_FILLED (IconName): The :code:`bell-ringing-2-filled` icon.
        BELL_RINGING_FILLED (IconName): The :code:`bell-ringing-filled` icon.
        BELL_SCHOOL (IconName): The :code:`bell-school` icon.
        BELL_SEARCH (IconName): The :code:`bell-search` icon.
        BELL_SHARE (IconName): The :code:`bell-share` icon.
        BELL_STAR (IconName): The :code:`bell-star` icon.
        BELL_UP (IconName): The :code:`bell-up` icon.
        BELL_X (IconName): The :code:`bell-x` icon.
        BELL_X_FILLED (IconName): The :code:`bell-x-filled` icon.
        BELL_Z (IconName): The :code:`bell-z` icon.
        BELL_Z_FILLED (IconName): The :code:`bell-z-filled` icon.
        BETA (IconName): The :code:`beta` icon.
        BIBLE (IconName): The :code:`bible` icon.
        BIKE (IconName): The :code:`bike` icon.
        BIKE_OFF (IconName): The :code:`bike-off` icon.
        BINARY (IconName): The :code:`binary` icon.
        BINARY_OFF (IconName): The :code:`binary-off` icon.
        BINARY_TREE (IconName): The :code:`binary-tree` icon.
        BINARY_TREE_2 (IconName): The :code:`binary-tree-2` icon.
        BIOHAZARD (IconName): The :code:`biohazard` icon.
        BIOHAZARD_OFF (IconName): The :code:`biohazard-off` icon.
        BLADE (IconName): The :code:`blade` icon.
        BLADE_FILLED (IconName): The :code:`blade-filled` icon.
        BLEACH (IconName): The :code:`bleach` icon.
        BLEACH_CHLORINE (IconName): The :code:`bleach-chlorine` icon.
        BLEACH_NO_CHLORINE (IconName): The :code:`bleach-no-chlorine` icon.
        BLEACH_OFF (IconName): The :code:`bleach-off` icon.
        BLOCKQUOTE (IconName): The :code:`blockquote` icon.
        BLUETOOTH (IconName): The :code:`bluetooth` icon.
        BLUETOOTH_CONNECTED (IconName): The :code:`bluetooth-connected` icon.
        BLUETOOTH_OFF (IconName): The :code:`bluetooth-off` icon.
        BLUETOOTH_X (IconName): The :code:`bluetooth-x` icon.
        BLUR (IconName): The :code:`blur` icon.
        BLUR_OFF (IconName): The :code:`blur-off` icon.
        BMP (IconName): The :code:`bmp` icon.
        BOLD (IconName): The :code:`bold` icon.
        BOLD_OFF (IconName): The :code:`bold-off` icon.
        BOLT (IconName): The :code:`bolt` icon.
        BOLT_OFF (IconName): The :code:`bolt-off` icon.
        BOMB (IconName): The :code:`bomb` icon.
        BOMB_FILLED (IconName): The :code:`bomb-filled` icon.
        BONE (IconName): The :code:`bone` icon.
        BONE_OFF (IconName): The :code:`bone-off` icon.
        BONG (IconName): The :code:`bong` icon.
        BONG_OFF (IconName): The :code:`bong-off` icon.
        BOOK (IconName): The :code:`book` icon.
        BOOK_2 (IconName): The :code:`book-2` icon.
        BOOK_DOWNLOAD (IconName): The :code:`book-download` icon.
        BOOK_FILLED (IconName): The :code:`book-filled` icon.
        BOOK_OFF (IconName): The :code:`book-off` icon.
        BOOK_UPLOAD (IconName): The :code:`book-upload` icon.
        BOOKMARK (IconName): The :code:`bookmark` icon.
        BOOKMARK_EDIT (IconName): The :code:`bookmark-edit` icon.
        BOOKMARK_FILLED (IconName): The :code:`bookmark-filled` icon.
        BOOKMARK_MINUS (IconName): The :code:`bookmark-minus` icon.
        BOOKMARK_OFF (IconName): The :code:`bookmark-off` icon.
        BOOKMARK_PLUS (IconName): The :code:`bookmark-plus` icon.
        BOOKMARK_QUESTION (IconName): The :code:`bookmark-question` icon.
        BOOKMARKS (IconName): The :code:`bookmarks` icon.
        BOOKMARKS_OFF (IconName): The :code:`bookmarks-off` icon.
        BOOKS (IconName): The :code:`books` icon.
        BOOKS_OFF (IconName): The :code:`books-off` icon.
        BORDER_ALL (IconName): The :code:`border-all` icon.
        BORDER_BOTTOM (IconName): The :code:`border-bottom` icon.
        BORDER_CORNERS (IconName): The :code:`border-corners` icon.
        BORDER_HORIZONTAL (IconName): The :code:`border-horizontal` icon.
        BORDER_INNER (IconName): The :code:`border-inner` icon.
        BORDER_LEFT (IconName): The :code:`border-left` icon.
        BORDER_NONE (IconName): The :code:`border-none` icon.
        BORDER_OUTER (IconName): The :code:`border-outer` icon.
        BORDER_RADIUS (IconName): The :code:`border-radius` icon.
        BORDER_RIGHT (IconName): The :code:`border-right` icon.
        BORDER_SIDES (IconName): The :code:`border-sides` icon.
        BORDER_STYLE (IconName): The :code:`border-style` icon.
        BORDER_STYLE_2 (IconName): The :code:`border-style-2` icon.
        BORDER_TOP (IconName): The :code:`border-top` icon.
        BORDER_VERTICAL (IconName): The :code:`border-vertical` icon.
        BOTTLE (IconName): The :code:`bottle` icon.
        BOTTLE_FILLED (IconName): The :code:`bottle-filled` icon.
        BOTTLE_OFF (IconName): The :code:`bottle-off` icon.
        BOUNCE_LEFT (IconName): The :code:`bounce-left` icon.
        BOUNCE_RIGHT (IconName): The :code:`bounce-right` icon.
        BOW (IconName): The :code:`bow` icon.
        BOWL (IconName): The :code:`bowl` icon.
        BOX (IconName): The :code:`box` icon.
        BOX_ALIGN_BOTTOM (IconName): The :code:`box-align-bottom` icon.
        BOX_ALIGN_BOTTOM_FILLED (IconName): The :code:`box-align-bottom-filled` icon.
        BOX_ALIGN_BOTTOM_LEFT (IconName): The :code:`box-align-bottom-left` icon.
        BOX_ALIGN_BOTTOM_LEFT_FILLED (IconName): The :code:`box-align-bottom-left-filled` icon.
        BOX_ALIGN_BOTTOM_RIGHT (IconName): The :code:`box-align-bottom-right` icon.
        BOX_ALIGN_BOTTOM_RIGHT_FILLED (IconName): The :code:`box-align-bottom-right-filled` icon.
        BOX_ALIGN_LEFT (IconName): The :code:`box-align-left` icon.
        BOX_ALIGN_LEFT_FILLED (IconName): The :code:`box-align-left-filled` icon.
        BOX_ALIGN_RIGHT (IconName): The :code:`box-align-right` icon.
        BOX_ALIGN_RIGHT_FILLED (IconName): The :code:`box-align-right-filled` icon.
        BOX_ALIGN_TOP (IconName): The :code:`box-align-top` icon.
        BOX_ALIGN_TOP_FILLED (IconName): The :code:`box-align-top-filled` icon.
        BOX_ALIGN_TOP_LEFT (IconName): The :code:`box-align-top-left` icon.
        BOX_ALIGN_TOP_LEFT_FILLED (IconName): The :code:`box-align-top-left-filled` icon.
        BOX_ALIGN_TOP_RIGHT (IconName): The :code:`box-align-top-right` icon.
        BOX_ALIGN_TOP_RIGHT_FILLED (IconName): The :code:`box-align-top-right-filled` icon.
        BOX_MARGIN (IconName): The :code:`box-margin` icon.
        BOX_MODEL (IconName): The :code:`box-model` icon.
        BOX_MODEL_2 (IconName): The :code:`box-model-2` icon.
        BOX_MODEL_2_OFF (IconName): The :code:`box-model-2-off` icon.
        BOX_MODEL_OFF (IconName): The :code:`box-model-off` icon.
        BOX_MULTIPLE (IconName): The :code:`box-multiple` icon.
        BOX_MULTIPLE_0 (IconName): The :code:`box-multiple-0` icon.
        BOX_MULTIPLE_1 (IconName): The :code:`box-multiple-1` icon.
        BOX_MULTIPLE_2 (IconName): The :code:`box-multiple-2` icon.
        BOX_MULTIPLE_3 (IconName): The :code:`box-multiple-3` icon.
        BOX_MULTIPLE_4 (IconName): The :code:`box-multiple-4` icon.
        BOX_MULTIPLE_5 (IconName): The :code:`box-multiple-5` icon.
        BOX_MULTIPLE_6 (IconName): The :code:`box-multiple-6` icon.
        BOX_MULTIPLE_7 (IconName): The :code:`box-multiple-7` icon.
        BOX_MULTIPLE_8 (IconName): The :code:`box-multiple-8` icon.
        BOX_MULTIPLE_9 (IconName): The :code:`box-multiple-9` icon.
        BOX_OFF (IconName): The :code:`box-off` icon.
        BOX_PADDING (IconName): The :code:`box-padding` icon.
        BOX_SEAM (IconName): The :code:`box-seam` icon.
        BRACES (IconName): The :code:`braces` icon.
        BRACES_OFF (IconName): The :code:`braces-off` icon.
        BRACKETS (IconName): The :code:`brackets` icon.
        BRACKETS_CONTAIN (IconName): The :code:`brackets-contain` icon.
        BRACKETS_CONTAIN_END (IconName): The :code:`brackets-contain-end` icon.
        BRACKETS_CONTAIN_START (IconName): The :code:`brackets-contain-start` icon.
        BRACKETS_OFF (IconName): The :code:`brackets-off` icon.
        BRAILLE (IconName): The :code:`braille` icon.
        BRAIN (IconName): The :code:`brain` icon.
        BRAND_4CHAN (IconName): The :code:`brand-4chan` icon.
        BRAND_ABSTRACT (IconName): The :code:`brand-abstract` icon.
        BRAND_ADOBE (IconName): The :code:`brand-adobe` icon.
        BRAND_ADONIS_JS (IconName): The :code:`brand-adonis-js` icon.
        BRAND_AIRBNB (IconName): The :code:`brand-airbnb` icon.
        BRAND_AIRTABLE (IconName): The :code:`brand-airtable` icon.
        BRAND_ALGOLIA (IconName): The :code:`brand-algolia` icon.
        BRAND_ALIPAY (IconName): The :code:`brand-alipay` icon.
        BRAND_ALPINE_JS (IconName): The :code:`brand-alpine-js` icon.
        BRAND_AMAZON (IconName): The :code:`brand-amazon` icon.
        BRAND_AMD (IconName): The :code:`brand-amd` icon.
        BRAND_AMIGO (IconName): The :code:`brand-amigo` icon.
        BRAND_AMONG_US (IconName): The :code:`brand-among-us` icon.
        BRAND_ANDROID (IconName): The :code:`brand-android` icon.
        BRAND_ANGULAR (IconName): The :code:`brand-angular` icon.
        BRAND_ANSIBLE (IconName): The :code:`brand-ansible` icon.
        BRAND_AO3 (IconName): The :code:`brand-ao3` icon.
        BRAND_APPGALLERY (IconName): The :code:`brand-appgallery` icon.
        BRAND_APPLE (IconName): The :code:`brand-apple` icon.
        BRAND_APPLE_ARCADE (IconName): The :code:`brand-apple-arcade` icon.
        BRAND_APPLE_PODCAST (IconName): The :code:`brand-apple-podcast` icon.
        BRAND_APPSTORE (IconName): The :code:`brand-appstore` icon.
        BRAND_ASANA (IconName): The :code:`brand-asana` icon.
        BRAND_AWS (IconName): The :code:`brand-aws` icon.
        BRAND_AZURE (IconName): The :code:`brand-azure` icon.
        BRAND_BACKBONE (IconName): The :code:`brand-backbone` icon.
        BRAND_BADOO (IconName): The :code:`brand-badoo` icon.
        BRAND_BAIDU (IconName): The :code:`brand-baidu` icon.
        BRAND_BANDCAMP (IconName): The :code:`brand-bandcamp` icon.
        BRAND_BANDLAB (IconName): The :code:`brand-bandlab` icon.
        BRAND_BEATS (IconName): The :code:`brand-beats` icon.
        BRAND_BEHANCE (IconName): The :code:`brand-behance` icon.
        BRAND_BILIBILI (IconName): The :code:`brand-bilibili` icon.
        BRAND_BINANCE (IconName): The :code:`brand-binance` icon.
        BRAND_BING (IconName): The :code:`brand-bing` icon.
        BRAND_BITBUCKET (IconName): The :code:`brand-bitbucket` icon.
        BRAND_BLACKBERRY (IconName): The :code:`brand-blackberry` icon.
        BRAND_BLENDER (IconName): The :code:`brand-blender` icon.
        BRAND_BLOGGER (IconName): The :code:`brand-blogger` icon.
        BRAND_BOOKING (IconName): The :code:`brand-booking` icon.
        BRAND_BOOTSTRAP (IconName): The :code:`brand-bootstrap` icon.
        BRAND_BULMA (IconName): The :code:`brand-bulma` icon.
        BRAND_BUMBLE (IconName): The :code:`brand-bumble` icon.
        BRAND_BUNPO (IconName): The :code:`brand-bunpo` icon.
        BRAND_C_SHARP (IconName): The :code:`brand-c-sharp` icon.
        BRAND_CAKE (IconName): The :code:`brand-cake` icon.
        BRAND_CAKEPHP (IconName): The :code:`brand-cakephp` icon.
        BRAND_CAMPAIGNMONITOR (IconName): The :code:`brand-campaignmonitor` icon.
        BRAND_CARBON (IconName): The :code:`brand-carbon` icon.
        BRAND_CASHAPP (IconName): The :code:`brand-cashapp` icon.
        BRAND_CHROME (IconName): The :code:`brand-chrome` icon.
        BRAND_CINEMA_4D (IconName): The :code:`brand-cinema-4d` icon.
        BRAND_CITYMAPPER (IconName): The :code:`brand-citymapper` icon.
        BRAND_CLOUDFLARE (IconName): The :code:`brand-cloudflare` icon.
        BRAND_CODECOV (IconName): The :code:`brand-codecov` icon.
        BRAND_CODEPEN (IconName): The :code:`brand-codepen` icon.
        BRAND_CODESANDBOX (IconName): The :code:`brand-codesandbox` icon.
        BRAND_COHOST (IconName): The :code:`brand-cohost` icon.
        BRAND_COINBASE (IconName): The :code:`brand-coinbase` icon.
        BRAND_COMEDY_CENTRAL (IconName): The :code:`brand-comedy-central` icon.
        BRAND_COREOS (IconName): The :code:`brand-coreos` icon.
        BRAND_COUCHDB (IconName): The :code:`brand-couchdb` icon.
        BRAND_COUCHSURFING (IconName): The :code:`brand-couchsurfing` icon.
        BRAND_CPP (IconName): The :code:`brand-cpp` icon.
        BRAND_CRAFT (IconName): The :code:`brand-craft` icon.
        BRAND_CRUNCHBASE (IconName): The :code:`brand-crunchbase` icon.
        BRAND_CSS3 (IconName): The :code:`brand-css3` icon.
        BRAND_CTEMPLAR (IconName): The :code:`brand-ctemplar` icon.
        BRAND_CUCUMBER (IconName): The :code:`brand-cucumber` icon.
        BRAND_CUPRA (IconName): The :code:`brand-cupra` icon.
        BRAND_CYPRESS (IconName): The :code:`brand-cypress` icon.
        BRAND_D3 (IconName): The :code:`brand-d3` icon.
        BRAND_DAYS_COUNTER (IconName): The :code:`brand-days-counter` icon.
        BRAND_DCOS (IconName): The :code:`brand-dcos` icon.
        BRAND_DEBIAN (IconName): The :code:`brand-debian` icon.
        BRAND_DEEZER (IconName): The :code:`brand-deezer` icon.
        BRAND_DELIVEROO (IconName): The :code:`brand-deliveroo` icon.
        BRAND_DENO (IconName): The :code:`brand-deno` icon.
        BRAND_DENODO (IconName): The :code:`brand-denodo` icon.
        BRAND_DEVIANTART (IconName): The :code:`brand-deviantart` icon.
        BRAND_DIGG (IconName): The :code:`brand-digg` icon.
        BRAND_DINGTALK (IconName): The :code:`brand-dingtalk` icon.
        BRAND_DISCORD (IconName): The :code:`brand-discord` icon.
        BRAND_DISCORD_FILLED (IconName): The :code:`brand-discord-filled` icon.
        BRAND_DISNEY (IconName): The :code:`brand-disney` icon.
        BRAND_DISQUS (IconName): The :code:`brand-disqus` icon.
        BRAND_DJANGO (IconName): The :code:`brand-django` icon.
        BRAND_DOCKER (IconName): The :code:`brand-docker` icon.
        BRAND_DOCTRINE (IconName): The :code:`brand-doctrine` icon.
        BRAND_DOLBY_DIGITAL (IconName): The :code:`brand-dolby-digital` icon.
        BRAND_DOUBAN (IconName): The :code:`brand-douban` icon.
        BRAND_DRIBBBLE (IconName): The :code:`brand-dribbble` icon.
        BRAND_DRIBBBLE_FILLED (IconName): The :code:`brand-dribbble-filled` icon.
        BRAND_DROPS (IconName): The :code:`brand-drops` icon.
        BRAND_DRUPAL (IconName): The :code:`brand-drupal` icon.
        BRAND_EDGE (IconName): The :code:`brand-edge` icon.
        BRAND_ELASTIC (IconName): The :code:`brand-elastic` icon.
        BRAND_ELECTRONIC_ARTS (IconName): The :code:`brand-electronic-arts` icon.
        BRAND_EMBER (IconName): The :code:`brand-ember` icon.
        BRAND_ENVATO (IconName): The :code:`brand-envato` icon.
        BRAND_ETSY (IconName): The :code:`brand-etsy` icon.
        BRAND_EVERNOTE (IconName): The :code:`brand-evernote` icon.
        BRAND_FACEBOOK (IconName): The :code:`brand-facebook` icon.
        BRAND_FACEBOOK_FILLED (IconName): The :code:`brand-facebook-filled` icon.
        BRAND_FEEDLY (IconName): The :code:`brand-feedly` icon.
        BRAND_FIGMA (IconName): The :code:`brand-figma` icon.
        BRAND_FILEZILLA (IconName): The :code:`brand-filezilla` icon.
        BRAND_FINDER (IconName): The :code:`brand-finder` icon.
        BRAND_FIREBASE (IconName): The :code:`brand-firebase` icon.
        BRAND_FIREFOX (IconName): The :code:`brand-firefox` icon.
        BRAND_FIVERR (IconName): The :code:`brand-fiverr` icon.
        BRAND_FLICKR (IconName): The :code:`brand-flickr` icon.
        BRAND_FLIGHTRADAR24 (IconName): The :code:`brand-flightradar24` icon.
        BRAND_FLIPBOARD (IconName): The :code:`brand-flipboard` icon.
        BRAND_FLUTTER (IconName): The :code:`brand-flutter` icon.
        BRAND_FORTNITE (IconName): The :code:`brand-fortnite` icon.
        BRAND_FOURSQUARE (IconName): The :code:`brand-foursquare` icon.
        BRAND_FRAMER (IconName): The :code:`brand-framer` icon.
        BRAND_FRAMER_MOTION (IconName): The :code:`brand-framer-motion` icon.
        BRAND_FUNIMATION (IconName): The :code:`brand-funimation` icon.
        BRAND_GATSBY (IconName): The :code:`brand-gatsby` icon.
        BRAND_GIT (IconName): The :code:`brand-git` icon.
        BRAND_GITHUB (IconName): The :code:`brand-github` icon.
        BRAND_GITHUB_COPILOT (IconName): The :code:`brand-github-copilot` icon.
        BRAND_GITHUB_FILLED (IconName): The :code:`brand-github-filled` icon.
        BRAND_GITLAB (IconName): The :code:`brand-gitlab` icon.
        BRAND_GMAIL (IconName): The :code:`brand-gmail` icon.
        BRAND_GOLANG (IconName): The :code:`brand-golang` icon.
        BRAND_GOOGLE (IconName): The :code:`brand-google` icon.
        BRAND_GOOGLE_ANALYTICS (IconName): The :code:`brand-google-analytics` icon.
        BRAND_GOOGLE_BIG_QUERY (IconName): The :code:`brand-google-big-query` icon.
        BRAND_GOOGLE_DRIVE (IconName): The :code:`brand-google-drive` icon.
        BRAND_GOOGLE_FIT (IconName): The :code:`brand-google-fit` icon.
        BRAND_GOOGLE_HOME (IconName): The :code:`brand-google-home` icon.
        BRAND_GOOGLE_MAPS (IconName): The :code:`brand-google-maps` icon.
        BRAND_GOOGLE_ONE (IconName): The :code:`brand-google-one` icon.
        BRAND_GOOGLE_PHOTOS (IconName): The :code:`brand-google-photos` icon.
        BRAND_GOOGLE_PLAY (IconName): The :code:`brand-google-play` icon.
        BRAND_GOOGLE_PODCASTS (IconName): The :code:`brand-google-podcasts` icon.
        BRAND_GRAMMARLY (IconName): The :code:`brand-grammarly` icon.
        BRAND_GRAPHQL (IconName): The :code:`brand-graphql` icon.
        BRAND_GRAVATAR (IconName): The :code:`brand-gravatar` icon.
        BRAND_GRINDR (IconName): The :code:`brand-grindr` icon.
        BRAND_GUARDIAN (IconName): The :code:`brand-guardian` icon.
        BRAND_GUMROAD (IconName): The :code:`brand-gumroad` icon.
        BRAND_HBO (IconName): The :code:`brand-hbo` icon.
        BRAND_HEADLESSUI (IconName): The :code:`brand-headlessui` icon.
        BRAND_HEXO (IconName): The :code:`brand-hexo` icon.
        BRAND_HIPCHAT (IconName): The :code:`brand-hipchat` icon.
        BRAND_HTML5 (IconName): The :code:`brand-html5` icon.
        BRAND_INERTIA (IconName): The :code:`brand-inertia` icon.
        BRAND_INSTAGRAM (IconName): The :code:`brand-instagram` icon.
        BRAND_INTERCOM (IconName): The :code:`brand-intercom` icon.
        BRAND_ITCH (IconName): The :code:`brand-itch` icon.
        BRAND_JAVASCRIPT (IconName): The :code:`brand-javascript` icon.
        BRAND_JUEJIN (IconName): The :code:`brand-juejin` icon.
        BRAND_KBIN (IconName): The :code:`brand-kbin` icon.
        BRAND_KICK (IconName): The :code:`brand-kick` icon.
        BRAND_KICKSTARTER (IconName): The :code:`brand-kickstarter` icon.
        BRAND_KOTLIN (IconName): The :code:`brand-kotlin` icon.
        BRAND_LARAVEL (IconName): The :code:`brand-laravel` icon.
        BRAND_LASTFM (IconName): The :code:`brand-lastfm` icon.
        BRAND_LEETCODE (IconName): The :code:`brand-leetcode` icon.
        BRAND_LETTERBOXD (IconName): The :code:`brand-letterboxd` icon.
        BRAND_LINE (IconName): The :code:`brand-line` icon.
        BRAND_LINKEDIN (IconName): The :code:`brand-linkedin` icon.
        BRAND_LINKTREE (IconName): The :code:`brand-linktree` icon.
        BRAND_LINQPAD (IconName): The :code:`brand-linqpad` icon.
        BRAND_LOOM (IconName): The :code:`brand-loom` icon.
        BRAND_MAILGUN (IconName): The :code:`brand-mailgun` icon.
        BRAND_MANTINE (IconName): The :code:`brand-mantine` icon.
        BRAND_MASTERCARD (IconName): The :code:`brand-mastercard` icon.
        BRAND_MASTODON (IconName): The :code:`brand-mastodon` icon.
        BRAND_MATRIX (IconName): The :code:`brand-matrix` icon.
        BRAND_MCDONALDS (IconName): The :code:`brand-mcdonalds` icon.
        BRAND_MEDIUM (IconName): The :code:`brand-medium` icon.
        BRAND_MERCEDES (IconName): The :code:`brand-mercedes` icon.
        BRAND_MESSENGER (IconName): The :code:`brand-messenger` icon.
        BRAND_META (IconName): The :code:`brand-meta` icon.
        BRAND_MICROSOFT_TEAMS (IconName): The :code:`brand-microsoft-teams` icon.
        BRAND_MINECRAFT (IconName): The :code:`brand-minecraft` icon.
        BRAND_MINIPROGRAM (IconName): The :code:`brand-miniprogram` icon.
        BRAND_MIXPANEL (IconName): The :code:`brand-mixpanel` icon.
        BRAND_MONDAY (IconName): The :code:`brand-monday` icon.
        BRAND_MONGODB (IconName): The :code:`brand-mongodb` icon.
        BRAND_MY_OPPO (IconName): The :code:`brand-my-oppo` icon.
        BRAND_MYSQL (IconName): The :code:`brand-mysql` icon.
        BRAND_NATIONAL_GEOGRAPHIC (IconName): The :code:`brand-national-geographic` icon.
        BRAND_NEM (IconName): The :code:`brand-nem` icon.
        BRAND_NETBEANS (IconName): The :code:`brand-netbeans` icon.
        BRAND_NETEASE_MUSIC (IconName): The :code:`brand-netease-music` icon.
        BRAND_NETFLIX (IconName): The :code:`brand-netflix` icon.
        BRAND_NEXO (IconName): The :code:`brand-nexo` icon.
        BRAND_NEXTCLOUD (IconName): The :code:`brand-nextcloud` icon.
        BRAND_NEXTJS (IconName): The :code:`brand-nextjs` icon.
        BRAND_NODEJS (IconName): The :code:`brand-nodejs` icon.
        BRAND_NORD_VPN (IconName): The :code:`brand-nord-vpn` icon.
        BRAND_NOTION (IconName): The :code:`brand-notion` icon.
        BRAND_NPM (IconName): The :code:`brand-npm` icon.
        BRAND_NUXT (IconName): The :code:`brand-nuxt` icon.
        BRAND_NYTIMES (IconName): The :code:`brand-nytimes` icon.
        BRAND_OAUTH (IconName): The :code:`brand-oauth` icon.
        BRAND_OFFICE (IconName): The :code:`brand-office` icon.
        BRAND_OK_RU (IconName): The :code:`brand-ok-ru` icon.
        BRAND_ONEDRIVE (IconName): The :code:`brand-onedrive` icon.
        BRAND_ONLYFANS (IconName): The :code:`brand-onlyfans` icon.
        BRAND_OPEN_SOURCE (IconName): The :code:`brand-open-source` icon.
        BRAND_OPENAI (IconName): The :code:`brand-openai` icon.
        BRAND_OPENVPN (IconName): The :code:`brand-openvpn` icon.
        BRAND_OPERA (IconName): The :code:`brand-opera` icon.
        BRAND_PAGEKIT (IconName): The :code:`brand-pagekit` icon.
        BRAND_PATREON (IconName): The :code:`brand-patreon` icon.
        BRAND_PAYPAL (IconName): The :code:`brand-paypal` icon.
        BRAND_PAYPAL_FILLED (IconName): The :code:`brand-paypal-filled` icon.
        BRAND_PAYPAY (IconName): The :code:`brand-paypay` icon.
        BRAND_PEANUT (IconName): The :code:`brand-peanut` icon.
        BRAND_PEPSI (IconName): The :code:`brand-pepsi` icon.
        BRAND_PHP (IconName): The :code:`brand-php` icon.
        BRAND_PICSART (IconName): The :code:`brand-picsart` icon.
        BRAND_PINTEREST (IconName): The :code:`brand-pinterest` icon.
        BRAND_PLANETSCALE (IconName): The :code:`brand-planetscale` icon.
        BRAND_POCKET (IconName): The :code:`brand-pocket` icon.
        BRAND_POLYMER (IconName): The :code:`brand-polymer` icon.
        BRAND_POWERSHELL (IconName): The :code:`brand-powershell` icon.
        BRAND_PRISMA (IconName): The :code:`brand-prisma` icon.
        BRAND_PRODUCTHUNT (IconName): The :code:`brand-producthunt` icon.
        BRAND_PUSHBULLET (IconName): The :code:`brand-pushbullet` icon.
        BRAND_PUSHOVER (IconName): The :code:`brand-pushover` icon.
        BRAND_PYTHON (IconName): The :code:`brand-python` icon.
        BRAND_QQ (IconName): The :code:`brand-qq` icon.
        BRAND_RADIX_UI (IconName): The :code:`brand-radix-ui` icon.
        BRAND_REACT (IconName): The :code:`brand-react` icon.
        BRAND_REACT_NATIVE (IconName): The :code:`brand-react-native` icon.
        BRAND_REASON (IconName): The :code:`brand-reason` icon.
        BRAND_REDDIT (IconName): The :code:`brand-reddit` icon.
        BRAND_REDHAT (IconName): The :code:`brand-redhat` icon.
        BRAND_REDUX (IconName): The :code:`brand-redux` icon.
        BRAND_REVOLUT (IconName): The :code:`brand-revolut` icon.
        BRAND_RUMBLE (IconName): The :code:`brand-rumble` icon.
        BRAND_RUST (IconName): The :code:`brand-rust` icon.
        BRAND_SAFARI (IconName): The :code:`brand-safari` icon.
        BRAND_SAMSUNGPASS (IconName): The :code:`brand-samsungpass` icon.
        BRAND_SASS (IconName): The :code:`brand-sass` icon.
        BRAND_SENTRY (IconName): The :code:`brand-sentry` icon.
        BRAND_SHARIK (IconName): The :code:`brand-sharik` icon.
        BRAND_SHAZAM (IconName): The :code:`brand-shazam` icon.
        BRAND_SHOPEE (IconName): The :code:`brand-shopee` icon.
        BRAND_SKETCH (IconName): The :code:`brand-sketch` icon.
        BRAND_SKYPE (IconName): The :code:`brand-skype` icon.
        BRAND_SLACK (IconName): The :code:`brand-slack` icon.
        BRAND_SNAPCHAT (IconName): The :code:`brand-snapchat` icon.
        BRAND_SNAPSEED (IconName): The :code:`brand-snapseed` icon.
        BRAND_SNOWFLAKE (IconName): The :code:`brand-snowflake` icon.
        BRAND_SOCKET_IO (IconName): The :code:`brand-socket-io` icon.
        BRAND_SOLIDJS (IconName): The :code:`brand-solidjs` icon.
        BRAND_SOUNDCLOUD (IconName): The :code:`brand-soundcloud` icon.
        BRAND_SPACEHEY (IconName): The :code:`brand-spacehey` icon.
        BRAND_SPEEDTEST (IconName): The :code:`brand-speedtest` icon.
        BRAND_SPOTIFY (IconName): The :code:`brand-spotify` icon.
        BRAND_STACKOVERFLOW (IconName): The :code:`brand-stackoverflow` icon.
        BRAND_STACKSHARE (IconName): The :code:`brand-stackshare` icon.
        BRAND_STEAM (IconName): The :code:`brand-steam` icon.
        BRAND_STORJ (IconName): The :code:`brand-storj` icon.
        BRAND_STORYBOOK (IconName): The :code:`brand-storybook` icon.
        BRAND_STORYTEL (IconName): The :code:`brand-storytel` icon.
        BRAND_STRAVA (IconName): The :code:`brand-strava` icon.
        BRAND_STRIPE (IconName): The :code:`brand-stripe` icon.
        BRAND_SUBLIME_TEXT (IconName): The :code:`brand-sublime-text` icon.
        BRAND_SUGARIZER (IconName): The :code:`brand-sugarizer` icon.
        BRAND_SUPABASE (IconName): The :code:`brand-supabase` icon.
        BRAND_SUPERHUMAN (IconName): The :code:`brand-superhuman` icon.
        BRAND_SUPERNOVA (IconName): The :code:`brand-supernova` icon.
        BRAND_SURFSHARK (IconName): The :code:`brand-surfshark` icon.
        BRAND_SVELTE (IconName): The :code:`brand-svelte` icon.
        BRAND_SWIFT (IconName): The :code:`brand-swift` icon.
        BRAND_SYMFONY (IconName): The :code:`brand-symfony` icon.
        BRAND_TABLER (IconName): The :code:`brand-tabler` icon.
        BRAND_TAILWIND (IconName): The :code:`brand-tailwind` icon.
        BRAND_TAOBAO (IconName): The :code:`brand-taobao` icon.
        BRAND_TED (IconName): The :code:`brand-ted` icon.
        BRAND_TELEGRAM (IconName): The :code:`brand-telegram` icon.
        BRAND_TERRAFORM (IconName): The :code:`brand-terraform` icon.
        BRAND_TETHER (IconName): The :code:`brand-tether` icon.
        BRAND_THREEJS (IconName): The :code:`brand-threejs` icon.
        BRAND_TIDAL (IconName): The :code:`brand-tidal` icon.
        BRAND_TIKTO_FILLED (IconName): The :code:`brand-tikto-filled` icon.
        BRAND_TIKTOK (IconName): The :code:`brand-tiktok` icon.
        BRAND_TINDER (IconName): The :code:`brand-tinder` icon.
        BRAND_TOPBUZZ (IconName): The :code:`brand-topbuzz` icon.
        BRAND_TORCHAIN (IconName): The :code:`brand-torchain` icon.
        BRAND_TOYOTA (IconName): The :code:`brand-toyota` icon.
        BRAND_TRELLO (IconName): The :code:`brand-trello` icon.
        BRAND_TRIPADVISOR (IconName): The :code:`brand-tripadvisor` icon.
        BRAND_TUMBLR (IconName): The :code:`brand-tumblr` icon.
        BRAND_TWILIO (IconName): The :code:`brand-twilio` icon.
        BRAND_TWITCH (IconName): The :code:`brand-twitch` icon.
        BRAND_TWITTER (IconName): The :code:`brand-twitter` icon.
        BRAND_TWITTER_FILLED (IconName): The :code:`brand-twitter-filled` icon.
        BRAND_TYPESCRIPT (IconName): The :code:`brand-typescript` icon.
        BRAND_UBER (IconName): The :code:`brand-uber` icon.
        BRAND_UBUNTU (IconName): The :code:`brand-ubuntu` icon.
        BRAND_UNITY (IconName): The :code:`brand-unity` icon.
        BRAND_UNSPLASH (IconName): The :code:`brand-unsplash` icon.
        BRAND_UPWORK (IconName): The :code:`brand-upwork` icon.
        BRAND_VALORANT (IconName): The :code:`brand-valorant` icon.
        BRAND_VERCEL (IconName): The :code:`brand-vercel` icon.
        BRAND_VIMEO (IconName): The :code:`brand-vimeo` icon.
        BRAND_VINTED (IconName): The :code:`brand-vinted` icon.
        BRAND_VISA (IconName): The :code:`brand-visa` icon.
        BRAND_VISUAL_STUDIO (IconName): The :code:`brand-visual-studio` icon.
        BRAND_VITE (IconName): The :code:`brand-vite` icon.
        BRAND_VIVALDI (IconName): The :code:`brand-vivaldi` icon.
        BRAND_VK (IconName): The :code:`brand-vk` icon.
        BRAND_VLC (IconName): The :code:`brand-vlc` icon.
        BRAND_VOLKSWAGEN (IconName): The :code:`brand-volkswagen` icon.
        BRAND_VSCO (IconName): The :code:`brand-vsco` icon.
        BRAND_VSCODE (IconName): The :code:`brand-vscode` icon.
        BRAND_VUE (IconName): The :code:`brand-vue` icon.
        BRAND_WALMART (IconName): The :code:`brand-walmart` icon.
        BRAND_WAZE (IconName): The :code:`brand-waze` icon.
        BRAND_WEBFLOW (IconName): The :code:`brand-webflow` icon.
        BRAND_WECHAT (IconName): The :code:`brand-wechat` icon.
        BRAND_WEIBO (IconName): The :code:`brand-weibo` icon.
        BRAND_WHATSAPP (IconName): The :code:`brand-whatsapp` icon.
        BRAND_WIKIPEDIA (IconName): The :code:`brand-wikipedia` icon.
        BRAND_WINDOWS (IconName): The :code:`brand-windows` icon.
        BRAND_WINDY (IconName): The :code:`brand-windy` icon.
        BRAND_WISH (IconName): The :code:`brand-wish` icon.
        BRAND_WIX (IconName): The :code:`brand-wix` icon.
        BRAND_WORDPRESS (IconName): The :code:`brand-wordpress` icon.
        BRAND_XAMARIN (IconName): The :code:`brand-xamarin` icon.
        BRAND_XBOX (IconName): The :code:`brand-xbox` icon.
        BRAND_XING (IconName): The :code:`brand-xing` icon.
        BRAND_YAHOO (IconName): The :code:`brand-yahoo` icon.
        BRAND_YANDEX (IconName): The :code:`brand-yandex` icon.
        BRAND_YATSE (IconName): The :code:`brand-yatse` icon.
        BRAND_YCOMBINATOR (IconName): The :code:`brand-ycombinator` icon.
        BRAND_YOUTUBE (IconName): The :code:`brand-youtube` icon.
        BRAND_YOUTUBE_KIDS (IconName): The :code:`brand-youtube-kids` icon.
        BRAND_ZALANDO (IconName): The :code:`brand-zalando` icon.
        BRAND_ZAPIER (IconName): The :code:`brand-zapier` icon.
        BRAND_ZEIT (IconName): The :code:`brand-zeit` icon.
        BRAND_ZHIHU (IconName): The :code:`brand-zhihu` icon.
        BRAND_ZOOM (IconName): The :code:`brand-zoom` icon.
        BRAND_ZULIP (IconName): The :code:`brand-zulip` icon.
        BRAND_ZWIFT (IconName): The :code:`brand-zwift` icon.
        BREAD (IconName): The :code:`bread` icon.
        BREAD_OFF (IconName): The :code:`bread-off` icon.
        BRIEFCASE (IconName): The :code:`briefcase` icon.
        BRIEFCASE_OFF (IconName): The :code:`briefcase-off` icon.
        BRIGHTNESS (IconName): The :code:`brightness` icon.
        BRIGHTNESS_2 (IconName): The :code:`brightness-2` icon.
        BRIGHTNESS_DOWN (IconName): The :code:`brightness-down` icon.
        BRIGHTNESS_HALF (IconName): The :code:`brightness-half` icon.
        BRIGHTNESS_OFF (IconName): The :code:`brightness-off` icon.
        BRIGHTNESS_UP (IconName): The :code:`brightness-up` icon.
        BROADCAST (IconName): The :code:`broadcast` icon.
        BROADCAST_OFF (IconName): The :code:`broadcast-off` icon.
        BROWSER (IconName): The :code:`browser` icon.
        BROWSER_CHECK (IconName): The :code:`browser-check` icon.
        BROWSER_OFF (IconName): The :code:`browser-off` icon.
        BROWSER_PLUS (IconName): The :code:`browser-plus` icon.
        BROWSER_X (IconName): The :code:`browser-x` icon.
        BRUSH (IconName): The :code:`brush` icon.
        BRUSH_OFF (IconName): The :code:`brush-off` icon.
        BUCKET (IconName): The :code:`bucket` icon.
        BUCKET_DROPLET (IconName): The :code:`bucket-droplet` icon.
        BUCKET_OFF (IconName): The :code:`bucket-off` icon.
        BUG (IconName): The :code:`bug` icon.
        BUG_OFF (IconName): The :code:`bug-off` icon.
        BUILDING (IconName): The :code:`building` icon.
        BUILDING_ARCH (IconName): The :code:`building-arch` icon.
        BUILDING_BANK (IconName): The :code:`building-bank` icon.
        BUILDING_BRIDGE (IconName): The :code:`building-bridge` icon.
        BUILDING_BRIDGE_2 (IconName): The :code:`building-bridge-2` icon.
        BUILDING_BROADCAST_TOWER (IconName): The :code:`building-broadcast-tower` icon.
        BUILDING_CAROUSEL (IconName): The :code:`building-carousel` icon.
        BUILDING_CASTLE (IconName): The :code:`building-castle` icon.
        BUILDING_CHURCH (IconName): The :code:`building-church` icon.
        BUILDING_CIRCUS (IconName): The :code:`building-circus` icon.
        BUILDING_COMMUNITY (IconName): The :code:`building-community` icon.
        BUILDING_COTTAGE (IconName): The :code:`building-cottage` icon.
        BUILDING_ESTATE (IconName): The :code:`building-estate` icon.
        BUILDING_FACTORY (IconName): The :code:`building-factory` icon.
        BUILDING_FACTORY_2 (IconName): The :code:`building-factory-2` icon.
        BUILDING_FORTRESS (IconName): The :code:`building-fortress` icon.
        BUILDING_HOSPITAL (IconName): The :code:`building-hospital` icon.
        BUILDING_LIGHTHOUSE (IconName): The :code:`building-lighthouse` icon.
        BUILDING_MONUMENT (IconName): The :code:`building-monument` icon.
        BUILDING_MOSQUE (IconName): The :code:`building-mosque` icon.
        BUILDING_PAVILION (IconName): The :code:`building-pavilion` icon.
        BUILDING_SKYSCRAPER (IconName): The :code:`building-skyscraper` icon.
        BUILDING_STADIUM (IconName): The :code:`building-stadium` icon.
        BUILDING_STORE (IconName): The :code:`building-store` icon.
        BUILDING_TUNNEL (IconName): The :code:`building-tunnel` icon.
        BUILDING_WAREHOUSE (IconName): The :code:`building-warehouse` icon.
        BUILDING_WIND_TURBINE (IconName): The :code:`building-wind-turbine` icon.
        BULB (IconName): The :code:`bulb` icon.
        BULB_FILLED (IconName): The :code:`bulb-filled` icon.
        BULB_OFF (IconName): The :code:`bulb-off` icon.
        BULLDOZER (IconName): The :code:`bulldozer` icon.
        BUS (IconName): The :code:`bus` icon.
        BUS_OFF (IconName): The :code:`bus-off` icon.
        BUS_STOP (IconName): The :code:`bus-stop` icon.
        BUSINESSPLAN (IconName): The :code:`businessplan` icon.
        BUTTERFLY (IconName): The :code:`butterfly` icon.
        CACTUS (IconName): The :code:`cactus` icon.
        CACTUS_OFF (IconName): The :code:`cactus-off` icon.
        CAKE (IconName): The :code:`cake` icon.
        CAKE_OFF (IconName): The :code:`cake-off` icon.
        CALCULATOR (IconName): The :code:`calculator` icon.
        CALCULATOR_OFF (IconName): The :code:`calculator-off` icon.
        CALENDAR (IconName): The :code:`calendar` icon.
        CALENDAR_BOLT (IconName): The :code:`calendar-bolt` icon.
        CALENDAR_CANCEL (IconName): The :code:`calendar-cancel` icon.
        CALENDAR_CHECK (IconName): The :code:`calendar-check` icon.
        CALENDAR_CODE (IconName): The :code:`calendar-code` icon.
        CALENDAR_COG (IconName): The :code:`calendar-cog` icon.
        CALENDAR_DOLLAR (IconName): The :code:`calendar-dollar` icon.
        CALENDAR_DOWN (IconName): The :code:`calendar-down` icon.
        CALENDAR_DUE (IconName): The :code:`calendar-due` icon.
        CALENDAR_EVENT (IconName): The :code:`calendar-event` icon.
        CALENDAR_EXCLAMATION (IconName): The :code:`calendar-exclamation` icon.
        CALENDAR_HEART (IconName): The :code:`calendar-heart` icon.
        CALENDAR_MINUS (IconName): The :code:`calendar-minus` icon.
        CALENDAR_OFF (IconName): The :code:`calendar-off` icon.
        CALENDAR_PAUSE (IconName): The :code:`calendar-pause` icon.
        CALENDAR_PIN (IconName): The :code:`calendar-pin` icon.
        CALENDAR_PLUS (IconName): The :code:`calendar-plus` icon.
        CALENDAR_QUESTION (IconName): The :code:`calendar-question` icon.
        CALENDAR_REPEAT (IconName): The :code:`calendar-repeat` icon.
        CALENDAR_SEARCH (IconName): The :code:`calendar-search` icon.
        CALENDAR_SHARE (IconName): The :code:`calendar-share` icon.
        CALENDAR_STAR (IconName): The :code:`calendar-star` icon.
        CALENDAR_STATS (IconName): The :code:`calendar-stats` icon.
        CALENDAR_TIME (IconName): The :code:`calendar-time` icon.
        CALENDAR_UP (IconName): The :code:`calendar-up` icon.
        CALENDAR_X (IconName): The :code:`calendar-x` icon.
        CAMERA (IconName): The :code:`camera` icon.
        CAMERA_BOLT (IconName): The :code:`camera-bolt` icon.
        CAMERA_CANCEL (IconName): The :code:`camera-cancel` icon.
        CAMERA_CHECK (IconName): The :code:`camera-check` icon.
        CAMERA_CODE (IconName): The :code:`camera-code` icon.
        CAMERA_COG (IconName): The :code:`camera-cog` icon.
        CAMERA_DOLLAR (IconName): The :code:`camera-dollar` icon.
        CAMERA_DOWN (IconName): The :code:`camera-down` icon.
        CAMERA_EXCLAMATION (IconName): The :code:`camera-exclamation` icon.
        CAMERA_FILLED (IconName): The :code:`camera-filled` icon.
        CAMERA_HEART (IconName): The :code:`camera-heart` icon.
        CAMERA_MINUS (IconName): The :code:`camera-minus` icon.
        CAMERA_OFF (IconName): The :code:`camera-off` icon.
        CAMERA_PAUSE (IconName): The :code:`camera-pause` icon.
        CAMERA_PIN (IconName): The :code:`camera-pin` icon.
        CAMERA_PLUS (IconName): The :code:`camera-plus` icon.
        CAMERA_QUESTION (IconName): The :code:`camera-question` icon.
        CAMERA_ROTATE (IconName): The :code:`camera-rotate` icon.
        CAMERA_SEARCH (IconName): The :code:`camera-search` icon.
        CAMERA_SELFIE (IconName): The :code:`camera-selfie` icon.
        CAMERA_SHARE (IconName): The :code:`camera-share` icon.
        CAMERA_STAR (IconName): The :code:`camera-star` icon.
        CAMERA_UP (IconName): The :code:`camera-up` icon.
        CAMERA_X (IconName): The :code:`camera-x` icon.
        CAMPER (IconName): The :code:`camper` icon.
        CAMPFIRE (IconName): The :code:`campfire` icon.
        CANDLE (IconName): The :code:`candle` icon.
        CANDY (IconName): The :code:`candy` icon.
        CANDY_OFF (IconName): The :code:`candy-off` icon.
        CANE (IconName): The :code:`cane` icon.
        CANNABIS (IconName): The :code:`cannabis` icon.
        CAPSULE (IconName): The :code:`capsule` icon.
        CAPSULE_HORIZONTAL (IconName): The :code:`capsule-horizontal` icon.
        CAPTURE (IconName): The :code:`capture` icon.
        CAPTURE_OFF (IconName): The :code:`capture-off` icon.
        CAR (IconName): The :code:`car` icon.
        CAR_CRANE (IconName): The :code:`car-crane` icon.
        CAR_CRASH (IconName): The :code:`car-crash` icon.
        CAR_OFF (IconName): The :code:`car-off` icon.
        CAR_TURBINE (IconName): The :code:`car-turbine` icon.
        CARAVAN (IconName): The :code:`caravan` icon.
        CARDBOARDS (IconName): The :code:`cardboards` icon.
        CARDBOARDS_OFF (IconName): The :code:`cardboards-off` icon.
        CARDS (IconName): The :code:`cards` icon.
        CARET_DOWN (IconName): The :code:`caret-down` icon.
        CARET_LEFT (IconName): The :code:`caret-left` icon.
        CARET_RIGHT (IconName): The :code:`caret-right` icon.
        CARET_UP (IconName): The :code:`caret-up` icon.
        CAROUSEL_HORIZONTAL (IconName): The :code:`carousel-horizontal` icon.
        CAROUSEL_HORIZONTAL_FILLED (IconName): The :code:`carousel-horizontal-filled` icon.
        CAROUSEL_VERTICAL (IconName): The :code:`carousel-vertical` icon.
        CAROUSEL_VERTICAL_FILLED (IconName): The :code:`carousel-vertical-filled` icon.
        CARROT (IconName): The :code:`carrot` icon.
        CARROT_OFF (IconName): The :code:`carrot-off` icon.
        CASH (IconName): The :code:`cash` icon.
        CASH_BANKNOTE (IconName): The :code:`cash-banknote` icon.
        CASH_BANKNOTE_OFF (IconName): The :code:`cash-banknote-off` icon.
        CASH_OFF (IconName): The :code:`cash-off` icon.
        CAST (IconName): The :code:`cast` icon.
        CAST_OFF (IconName): The :code:`cast-off` icon.
        CAT (IconName): The :code:`cat` icon.
        CATEGORY (IconName): The :code:`category` icon.
        CATEGORY_2 (IconName): The :code:`category-2` icon.
        CE (IconName): The :code:`ce` icon.
        CE_OFF (IconName): The :code:`ce-off` icon.
        CELL (IconName): The :code:`cell` icon.
        CELL_SIGNAL_1 (IconName): The :code:`cell-signal-1` icon.
        CELL_SIGNAL_2 (IconName): The :code:`cell-signal-2` icon.
        CELL_SIGNAL_3 (IconName): The :code:`cell-signal-3` icon.
        CELL_SIGNAL_4 (IconName): The :code:`cell-signal-4` icon.
        CELL_SIGNAL_5 (IconName): The :code:`cell-signal-5` icon.
        CELL_SIGNAL_OFF (IconName): The :code:`cell-signal-off` icon.
        CERTIFICATE (IconName): The :code:`certificate` icon.
        CERTIFICATE_2 (IconName): The :code:`certificate-2` icon.
        CERTIFICATE_2_OFF (IconName): The :code:`certificate-2-off` icon.
        CERTIFICATE_OFF (IconName): The :code:`certificate-off` icon.
        CHAIR_DIRECTOR (IconName): The :code:`chair-director` icon.
        CHALKBOARD (IconName): The :code:`chalkboard` icon.
        CHALKBOARD_OFF (IconName): The :code:`chalkboard-off` icon.
        CHARGING_PILE (IconName): The :code:`charging-pile` icon.
        CHART_ARCS (IconName): The :code:`chart-arcs` icon.
        CHART_ARCS_3 (IconName): The :code:`chart-arcs-3` icon.
        CHART_AREA (IconName): The :code:`chart-area` icon.
        CHART_AREA_FILLED (IconName): The :code:`chart-area-filled` icon.
        CHART_AREA_LINE (IconName): The :code:`chart-area-line` icon.
        CHART_AREA_LINE_FILLED (IconName): The :code:`chart-area-line-filled` icon.
        CHART_ARROWS (IconName): The :code:`chart-arrows` icon.
        CHART_ARROWS_VERTICAL (IconName): The :code:`chart-arrows-vertical` icon.
        CHART_BAR (IconName): The :code:`chart-bar` icon.
        CHART_BAR_OFF (IconName): The :code:`chart-bar-off` icon.
        CHART_BUBBLE (IconName): The :code:`chart-bubble` icon.
        CHART_BUBBLE_FILLED (IconName): The :code:`chart-bubble-filled` icon.
        CHART_CANDLE (IconName): The :code:`chart-candle` icon.
        CHART_CANDLE_FILLED (IconName): The :code:`chart-candle-filled` icon.
        CHART_CIRCLES (IconName): The :code:`chart-circles` icon.
        CHART_DONUT (IconName): The :code:`chart-donut` icon.
        CHART_DONUT_2 (IconName): The :code:`chart-donut-2` icon.
        CHART_DONUT_3 (IconName): The :code:`chart-donut-3` icon.
        CHART_DONUT_4 (IconName): The :code:`chart-donut-4` icon.
        CHART_DONUT_FILLED (IconName): The :code:`chart-donut-filled` icon.
        CHART_DOTS (IconName): The :code:`chart-dots` icon.
        CHART_DOTS_2 (IconName): The :code:`chart-dots-2` icon.
        CHART_DOTS_3 (IconName): The :code:`chart-dots-3` icon.
        CHART_GRID_DOTS (IconName): The :code:`chart-grid-dots` icon.
        CHART_HISTOGRAM (IconName): The :code:`chart-histogram` icon.
        CHART_INFOGRAPHIC (IconName): The :code:`chart-infographic` icon.
        CHART_LINE (IconName): The :code:`chart-line` icon.
        CHART_PIE (IconName): The :code:`chart-pie` icon.
        CHART_PIE_2 (IconName): The :code:`chart-pie-2` icon.
        CHART_PIE_3 (IconName): The :code:`chart-pie-3` icon.
        CHART_PIE_4 (IconName): The :code:`chart-pie-4` icon.
        CHART_PIE_FILLED (IconName): The :code:`chart-pie-filled` icon.
        CHART_PIE_OFF (IconName): The :code:`chart-pie-off` icon.
        CHART_PPF (IconName): The :code:`chart-ppf` icon.
        CHART_RADAR (IconName): The :code:`chart-radar` icon.
        CHART_SANKEY (IconName): The :code:`chart-sankey` icon.
        CHART_TREEMAP (IconName): The :code:`chart-treemap` icon.
        CHECK (IconName): The :code:`check` icon.
        CHECKBOX (IconName): The :code:`checkbox` icon.
        CHECKLIST (IconName): The :code:`checklist` icon.
        CHECKS (IconName): The :code:`checks` icon.
        CHECKUP_LIST (IconName): The :code:`checkup-list` icon.
        CHEESE (IconName): The :code:`cheese` icon.
        CHEF_HAT (IconName): The :code:`chef-hat` icon.
        CHEF_HAT_OFF (IconName): The :code:`chef-hat-off` icon.
        CHERRY (IconName): The :code:`cherry` icon.
        CHERRY_FILLED (IconName): The :code:`cherry-filled` icon.
        CHESS (IconName): The :code:`chess` icon.
        CHESS_BISHOP (IconName): The :code:`chess-bishop` icon.
        CHESS_BISHOP_FILLED (IconName): The :code:`chess-bishop-filled` icon.
        CHESS_FILLED (IconName): The :code:`chess-filled` icon.
        CHESS_KING (IconName): The :code:`chess-king` icon.
        CHESS_KING_FILLED (IconName): The :code:`chess-king-filled` icon.
        CHESS_KNIGHT (IconName): The :code:`chess-knight` icon.
        CHESS_KNIGHT_FILLED (IconName): The :code:`chess-knight-filled` icon.
        CHESS_QUEEN (IconName): The :code:`chess-queen` icon.
        CHESS_QUEEN_FILLED (IconName): The :code:`chess-queen-filled` icon.
        CHESS_ROOK (IconName): The :code:`chess-rook` icon.
        CHESS_ROOK_FILLED (IconName): The :code:`chess-rook-filled` icon.
        CHEVRON_COMPACT_DOWN (IconName): The :code:`chevron-compact-down` icon.
        CHEVRON_COMPACT_LEFT (IconName): The :code:`chevron-compact-left` icon.
        CHEVRON_COMPACT_RIGHT (IconName): The :code:`chevron-compact-right` icon.
        CHEVRON_COMPACT_UP (IconName): The :code:`chevron-compact-up` icon.
        CHEVRON_DOWN (IconName): The :code:`chevron-down` icon.
        CHEVRON_DOWN_LEFT (IconName): The :code:`chevron-down-left` icon.
        CHEVRON_DOWN_RIGHT (IconName): The :code:`chevron-down-right` icon.
        CHEVRON_LEFT (IconName): The :code:`chevron-left` icon.
        CHEVRON_LEFT_PIPE (IconName): The :code:`chevron-left-pipe` icon.
        CHEVRON_RIGHT (IconName): The :code:`chevron-right` icon.
        CHEVRON_RIGHT_PIPE (IconName): The :code:`chevron-right-pipe` icon.
        CHEVRON_UP (IconName): The :code:`chevron-up` icon.
        CHEVRON_UP_LEFT (IconName): The :code:`chevron-up-left` icon.
        CHEVRON_UP_RIGHT (IconName): The :code:`chevron-up-right` icon.
        CHEVRONS_DOWN (IconName): The :code:`chevrons-down` icon.
        CHEVRONS_DOWN_LEFT (IconName): The :code:`chevrons-down-left` icon.
        CHEVRONS_DOWN_RIGHT (IconName): The :code:`chevrons-down-right` icon.
        CHEVRONS_LEFT (IconName): The :code:`chevrons-left` icon.
        CHEVRONS_RIGHT (IconName): The :code:`chevrons-right` icon.
        CHEVRONS_UP (IconName): The :code:`chevrons-up` icon.
        CHEVRONS_UP_LEFT (IconName): The :code:`chevrons-up-left` icon.
        CHEVRONS_UP_RIGHT (IconName): The :code:`chevrons-up-right` icon.
        CHISEL (IconName): The :code:`chisel` icon.
        CHRISTMAS_TREE (IconName): The :code:`christmas-tree` icon.
        CHRISTMAS_TREE_OFF (IconName): The :code:`christmas-tree-off` icon.
        CIRCLE (IconName): The :code:`circle` icon.
        CIRCLE_0_FILLED (IconName): The :code:`circle-0-filled` icon.
        CIRCLE_1_FILLED (IconName): The :code:`circle-1-filled` icon.
        CIRCLE_2_FILLED (IconName): The :code:`circle-2-filled` icon.
        CIRCLE_3_FILLED (IconName): The :code:`circle-3-filled` icon.
        CIRCLE_4_FILLED (IconName): The :code:`circle-4-filled` icon.
        CIRCLE_5_FILLED (IconName): The :code:`circle-5-filled` icon.
        CIRCLE_6_FILLED (IconName): The :code:`circle-6-filled` icon.
        CIRCLE_7_FILLED (IconName): The :code:`circle-7-filled` icon.
        CIRCLE_8_FILLED (IconName): The :code:`circle-8-filled` icon.
        CIRCLE_9_FILLED (IconName): The :code:`circle-9-filled` icon.
        CIRCLE_ARROW_DOWN (IconName): The :code:`circle-arrow-down` icon.
        CIRCLE_ARROW_DOWN_FILLED (IconName): The :code:`circle-arrow-down-filled` icon.
        CIRCLE_ARROW_DOWN_LEFT (IconName): The :code:`circle-arrow-down-left` icon.
        CIRCLE_ARROW_DOWN_LEFT_FILLED (IconName): The :code:`circle-arrow-down-left-filled` icon.
        CIRCLE_ARROW_DOWN_RIGHT (IconName): The :code:`circle-arrow-down-right` icon.
        CIRCLE_ARROW_DOWN_RIGHT_FILLED (IconName): The :code:`circle-arrow-down-right-filled` icon.
        CIRCLE_ARROW_LEFT (IconName): The :code:`circle-arrow-left` icon.
        CIRCLE_ARROW_LEFT_FILLED (IconName): The :code:`circle-arrow-left-filled` icon.
        CIRCLE_ARROW_RIGHT (IconName): The :code:`circle-arrow-right` icon.
        CIRCLE_ARROW_RIGHT_FILLED (IconName): The :code:`circle-arrow-right-filled` icon.
        CIRCLE_ARROW_UP (IconName): The :code:`circle-arrow-up` icon.
        CIRCLE_ARROW_UP_FILLED (IconName): The :code:`circle-arrow-up-filled` icon.
        CIRCLE_ARROW_UP_LEFT (IconName): The :code:`circle-arrow-up-left` icon.
        CIRCLE_ARROW_UP_LEFT_FILLED (IconName): The :code:`circle-arrow-up-left-filled` icon.
        CIRCLE_ARROW_UP_RIGHT (IconName): The :code:`circle-arrow-up-right` icon.
        CIRCLE_ARROW_UP_RIGHT_FILLED (IconName): The :code:`circle-arrow-up-right-filled` icon.
        CIRCLE_CARET_DOWN (IconName): The :code:`circle-caret-down` icon.
        CIRCLE_CARET_LEFT (IconName): The :code:`circle-caret-left` icon.
        CIRCLE_CARET_RIGHT (IconName): The :code:`circle-caret-right` icon.
        CIRCLE_CARET_UP (IconName): The :code:`circle-caret-up` icon.
        CIRCLE_CHECK (IconName): The :code:`circle-check` icon.
        CIRCLE_CHECK_FILLED (IconName): The :code:`circle-check-filled` icon.
        CIRCLE_CHEVRON_DOWN (IconName): The :code:`circle-chevron-down` icon.
        CIRCLE_CHEVRON_LEFT (IconName): The :code:`circle-chevron-left` icon.
        CIRCLE_CHEVRON_RIGHT (IconName): The :code:`circle-chevron-right` icon.
        CIRCLE_CHEVRON_UP (IconName): The :code:`circle-chevron-up` icon.
        CIRCLE_CHEVRONS_DOWN (IconName): The :code:`circle-chevrons-down` icon.
        CIRCLE_CHEVRONS_LEFT (IconName): The :code:`circle-chevrons-left` icon.
        CIRCLE_CHEVRONS_RIGHT (IconName): The :code:`circle-chevrons-right` icon.
        CIRCLE_CHEVRONS_UP (IconName): The :code:`circle-chevrons-up` icon.
        CIRCLE_DASHED (IconName): The :code:`circle-dashed` icon.
        CIRCLE_DOT (IconName): The :code:`circle-dot` icon.
        CIRCLE_DOT_FILLED (IconName): The :code:`circle-dot-filled` icon.
        CIRCLE_DOTTED (IconName): The :code:`circle-dotted` icon.
        CIRCLE_FILLED (IconName): The :code:`circle-filled` icon.
        CIRCLE_HALF (IconName): The :code:`circle-half` icon.
        CIRCLE_HALF_2 (IconName): The :code:`circle-half-2` icon.
        CIRCLE_HALF_VERTICAL (IconName): The :code:`circle-half-vertical` icon.
        CIRCLE_KEY (IconName): The :code:`circle-key` icon.
        CIRCLE_KEY_FILLED (IconName): The :code:`circle-key-filled` icon.
        CIRCLE_LETTER_A (IconName): The :code:`circle-letter-a` icon.
        CIRCLE_LETTER_B (IconName): The :code:`circle-letter-b` icon.
        CIRCLE_LETTER_C (IconName): The :code:`circle-letter-c` icon.
        CIRCLE_LETTER_D (IconName): The :code:`circle-letter-d` icon.
        CIRCLE_LETTER_E (IconName): The :code:`circle-letter-e` icon.
        CIRCLE_LETTER_F (IconName): The :code:`circle-letter-f` icon.
        CIRCLE_LETTER_G (IconName): The :code:`circle-letter-g` icon.
        CIRCLE_LETTER_H (IconName): The :code:`circle-letter-h` icon.
        CIRCLE_LETTER_I (IconName): The :code:`circle-letter-i` icon.
        CIRCLE_LETTER_J (IconName): The :code:`circle-letter-j` icon.
        CIRCLE_LETTER_K (IconName): The :code:`circle-letter-k` icon.
        CIRCLE_LETTER_L (IconName): The :code:`circle-letter-l` icon.
        CIRCLE_LETTER_M (IconName): The :code:`circle-letter-m` icon.
        CIRCLE_LETTER_N (IconName): The :code:`circle-letter-n` icon.
        CIRCLE_LETTER_O (IconName): The :code:`circle-letter-o` icon.
        CIRCLE_LETTER_P (IconName): The :code:`circle-letter-p` icon.
        CIRCLE_LETTER_Q (IconName): The :code:`circle-letter-q` icon.
        CIRCLE_LETTER_R (IconName): The :code:`circle-letter-r` icon.
        CIRCLE_LETTER_S (IconName): The :code:`circle-letter-s` icon.
        CIRCLE_LETTER_T (IconName): The :code:`circle-letter-t` icon.
        CIRCLE_LETTER_U (IconName): The :code:`circle-letter-u` icon.
        CIRCLE_LETTER_V (IconName): The :code:`circle-letter-v` icon.
        CIRCLE_LETTER_W (IconName): The :code:`circle-letter-w` icon.
        CIRCLE_LETTER_X (IconName): The :code:`circle-letter-x` icon.
        CIRCLE_LETTER_Y (IconName): The :code:`circle-letter-y` icon.
        CIRCLE_LETTER_Z (IconName): The :code:`circle-letter-z` icon.
        CIRCLE_MINUS (IconName): The :code:`circle-minus` icon.
        CIRCLE_NUMBER_0 (IconName): The :code:`circle-number-0` icon.
        CIRCLE_NUMBER_1 (IconName): The :code:`circle-number-1` icon.
        CIRCLE_NUMBER_2 (IconName): The :code:`circle-number-2` icon.
        CIRCLE_NUMBER_3 (IconName): The :code:`circle-number-3` icon.
        CIRCLE_NUMBER_4 (IconName): The :code:`circle-number-4` icon.
        CIRCLE_NUMBER_5 (IconName): The :code:`circle-number-5` icon.
        CIRCLE_NUMBER_6 (IconName): The :code:`circle-number-6` icon.
        CIRCLE_NUMBER_7 (IconName): The :code:`circle-number-7` icon.
        CIRCLE_NUMBER_8 (IconName): The :code:`circle-number-8` icon.
        CIRCLE_NUMBER_9 (IconName): The :code:`circle-number-9` icon.
        CIRCLE_OFF (IconName): The :code:`circle-off` icon.
        CIRCLE_PLUS (IconName): The :code:`circle-plus` icon.
        CIRCLE_RECTANGLE (IconName): The :code:`circle-rectangle` icon.
        CIRCLE_RECTANGLE_OFF (IconName): The :code:`circle-rectangle-off` icon.
        CIRCLE_SQUARE (IconName): The :code:`circle-square` icon.
        CIRCLE_TRIANGLE (IconName): The :code:`circle-triangle` icon.
        CIRCLE_X (IconName): The :code:`circle-x` icon.
        CIRCLE_X_FILLED (IconName): The :code:`circle-x-filled` icon.
        CIRCLES (IconName): The :code:`circles` icon.
        CIRCLES_FILLED (IconName): The :code:`circles-filled` icon.
        CIRCLES_RELATION (IconName): The :code:`circles-relation` icon.
        CIRCUIT_AMMETER (IconName): The :code:`circuit-ammeter` icon.
        CIRCUIT_BATTERY (IconName): The :code:`circuit-battery` icon.
        CIRCUIT_BULB (IconName): The :code:`circuit-bulb` icon.
        CIRCUIT_CAPACITOR (IconName): The :code:`circuit-capacitor` icon.
        CIRCUIT_CAPACITOR_POLARIZED (IconName): The :code:`circuit-capacitor-polarized` icon.
        CIRCUIT_CELL (IconName): The :code:`circuit-cell` icon.
        CIRCUIT_CELL_PLUS (IconName): The :code:`circuit-cell-plus` icon.
        CIRCUIT_CHANGEOVER (IconName): The :code:`circuit-changeover` icon.
        CIRCUIT_DIODE (IconName): The :code:`circuit-diode` icon.
        CIRCUIT_DIODE_ZENER (IconName): The :code:`circuit-diode-zener` icon.
        CIRCUIT_GROUND (IconName): The :code:`circuit-ground` icon.
        CIRCUIT_GROUND_DIGITAL (IconName): The :code:`circuit-ground-digital` icon.
        CIRCUIT_INDUCTOR (IconName): The :code:`circuit-inductor` icon.
        CIRCUIT_MOTOR (IconName): The :code:`circuit-motor` icon.
        CIRCUIT_PUSHBUTTON (IconName): The :code:`circuit-pushbutton` icon.
        CIRCUIT_RESISTOR (IconName): The :code:`circuit-resistor` icon.
        CIRCUIT_SWITCH_CLOSED (IconName): The :code:`circuit-switch-closed` icon.
        CIRCUIT_SWITCH_OPEN (IconName): The :code:`circuit-switch-open` icon.
        CIRCUIT_VOLTMETER (IconName): The :code:`circuit-voltmeter` icon.
        CLEAR_ALL (IconName): The :code:`clear-all` icon.
        CLEAR_FORMATTING (IconName): The :code:`clear-formatting` icon.
        CLICK (IconName): The :code:`click` icon.
        CLIPBOARD (IconName): The :code:`clipboard` icon.
        CLIPBOARD_CHECK (IconName): The :code:`clipboard-check` icon.
        CLIPBOARD_COPY (IconName): The :code:`clipboard-copy` icon.
        CLIPBOARD_DATA (IconName): The :code:`clipboard-data` icon.
        CLIPBOARD_HEART (IconName): The :code:`clipboard-heart` icon.
        CLIPBOARD_LIST (IconName): The :code:`clipboard-list` icon.
        CLIPBOARD_OFF (IconName): The :code:`clipboard-off` icon.
        CLIPBOARD_PLUS (IconName): The :code:`clipboard-plus` icon.
        CLIPBOARD_TEXT (IconName): The :code:`clipboard-text` icon.
        CLIPBOARD_TYPOGRAPHY (IconName): The :code:`clipboard-typography` icon.
        CLIPBOARD_X (IconName): The :code:`clipboard-x` icon.
        CLOCK (IconName): The :code:`clock` icon.
        CLOCK_2 (IconName): The :code:`clock-2` icon.
        CLOCK_BOLT (IconName): The :code:`clock-bolt` icon.
        CLOCK_CANCEL (IconName): The :code:`clock-cancel` icon.
        CLOCK_CHECK (IconName): The :code:`clock-check` icon.
        CLOCK_CODE (IconName): The :code:`clock-code` icon.
        CLOCK_COG (IconName): The :code:`clock-cog` icon.
        CLOCK_DOLLAR (IconName): The :code:`clock-dollar` icon.
        CLOCK_DOWN (IconName): The :code:`clock-down` icon.
        CLOCK_EDIT (IconName): The :code:`clock-edit` icon.
        CLOCK_EXCLAMATION (IconName): The :code:`clock-exclamation` icon.
        CLOCK_FILLED (IconName): The :code:`clock-filled` icon.
        CLOCK_HEART (IconName): The :code:`clock-heart` icon.
        CLOCK_HOUR_1 (IconName): The :code:`clock-hour-1` icon.
        CLOCK_HOUR_10 (IconName): The :code:`clock-hour-10` icon.
        CLOCK_HOUR_11 (IconName): The :code:`clock-hour-11` icon.
        CLOCK_HOUR_12 (IconName): The :code:`clock-hour-12` icon.
        CLOCK_HOUR_2 (IconName): The :code:`clock-hour-2` icon.
        CLOCK_HOUR_3 (IconName): The :code:`clock-hour-3` icon.
        CLOCK_HOUR_4 (IconName): The :code:`clock-hour-4` icon.
        CLOCK_HOUR_5 (IconName): The :code:`clock-hour-5` icon.
        CLOCK_HOUR_6 (IconName): The :code:`clock-hour-6` icon.
        CLOCK_HOUR_7 (IconName): The :code:`clock-hour-7` icon.
        CLOCK_HOUR_8 (IconName): The :code:`clock-hour-8` icon.
        CLOCK_HOUR_9 (IconName): The :code:`clock-hour-9` icon.
        CLOCK_MINUS (IconName): The :code:`clock-minus` icon.
        CLOCK_OFF (IconName): The :code:`clock-off` icon.
        CLOCK_PAUSE (IconName): The :code:`clock-pause` icon.
        CLOCK_PIN (IconName): The :code:`clock-pin` icon.
        CLOCK_PLAY (IconName): The :code:`clock-play` icon.
        CLOCK_PLUS (IconName): The :code:`clock-plus` icon.
        CLOCK_QUESTION (IconName): The :code:`clock-question` icon.
        CLOCK_RECORD (IconName): The :code:`clock-record` icon.
        CLOCK_SEARCH (IconName): The :code:`clock-search` icon.
        CLOCK_SHARE (IconName): The :code:`clock-share` icon.
        CLOCK_SHIELD (IconName): The :code:`clock-shield` icon.
        CLOCK_STAR (IconName): The :code:`clock-star` icon.
        CLOCK_STOP (IconName): The :code:`clock-stop` icon.
        CLOCK_UP (IconName): The :code:`clock-up` icon.
        CLOCK_X (IconName): The :code:`clock-x` icon.
        CLOTHES_RACK (IconName): The :code:`clothes-rack` icon.
        CLOTHES_RACK_OFF (IconName): The :code:`clothes-rack-off` icon.
        CLOUD (IconName): The :code:`cloud` icon.
        CLOUD_BOLT (IconName): The :code:`cloud-bolt` icon.
        CLOUD_CANCEL (IconName): The :code:`cloud-cancel` icon.
        CLOUD_CHECK (IconName): The :code:`cloud-check` icon.
        CLOUD_CODE (IconName): The :code:`cloud-code` icon.
        CLOUD_COG (IconName): The :code:`cloud-cog` icon.
        CLOUD_COMPUTING (IconName): The :code:`cloud-computing` icon.
        CLOUD_DATA_CONNECTION (IconName): The :code:`cloud-data-connection` icon.
        CLOUD_DOLLAR (IconName): The :code:`cloud-dollar` icon.
        CLOUD_DOWN (IconName): The :code:`cloud-down` icon.
        CLOUD_DOWNLOAD (IconName): The :code:`cloud-download` icon.
        CLOUD_EXCLAMATION (IconName): The :code:`cloud-exclamation` icon.
        CLOUD_FILLED (IconName): The :code:`cloud-filled` icon.
        CLOUD_FOG (IconName): The :code:`cloud-fog` icon.
        CLOUD_HEART (IconName): The :code:`cloud-heart` icon.
        CLOUD_LOCK (IconName): The :code:`cloud-lock` icon.
        CLOUD_LOCK_OPEN (IconName): The :code:`cloud-lock-open` icon.
        CLOUD_MINUS (IconName): The :code:`cloud-minus` icon.
        CLOUD_OFF (IconName): The :code:`cloud-off` icon.
        CLOUD_PAUSE (IconName): The :code:`cloud-pause` icon.
        CLOUD_PIN (IconName): The :code:`cloud-pin` icon.
        CLOUD_PLUS (IconName): The :code:`cloud-plus` icon.
        CLOUD_QUESTION (IconName): The :code:`cloud-question` icon.
        CLOUD_RAIN (IconName): The :code:`cloud-rain` icon.
        CLOUD_SEARCH (IconName): The :code:`cloud-search` icon.
        CLOUD_SHARE (IconName): The :code:`cloud-share` icon.
        CLOUD_SNOW (IconName): The :code:`cloud-snow` icon.
        CLOUD_STAR (IconName): The :code:`cloud-star` icon.
        CLOUD_STORM (IconName): The :code:`cloud-storm` icon.
        CLOUD_UP (IconName): The :code:`cloud-up` icon.
        CLOUD_UPLOAD (IconName): The :code:`cloud-upload` icon.
        CLOUD_X (IconName): The :code:`cloud-x` icon.
        CLOVER (IconName): The :code:`clover` icon.
        CLOVER_2 (IconName): The :code:`clover-2` icon.
        CLUBS (IconName): The :code:`clubs` icon.
        CLUBS_FILLED (IconName): The :code:`clubs-filled` icon.
        CODE (IconName): The :code:`code` icon.
        CODE_ASTERIX (IconName): The :code:`code-asterix` icon.
        CODE_CIRCLE (IconName): The :code:`code-circle` icon.
        CODE_CIRCLE_2 (IconName): The :code:`code-circle-2` icon.
        CODE_DOTS (IconName): The :code:`code-dots` icon.
        CODE_MINUS (IconName): The :code:`code-minus` icon.
        CODE_OFF (IconName): The :code:`code-off` icon.
        CODE_PLUS (IconName): The :code:`code-plus` icon.
        COFFEE (IconName): The :code:`coffee` icon.
        COFFEE_OFF (IconName): The :code:`coffee-off` icon.
        COFFIN (IconName): The :code:`coffin` icon.
        COIN (IconName): The :code:`coin` icon.
        COIN_BITCOIN (IconName): The :code:`coin-bitcoin` icon.
        COIN_EURO (IconName): The :code:`coin-euro` icon.
        COIN_MONERO (IconName): The :code:`coin-monero` icon.
        COIN_OFF (IconName): The :code:`coin-off` icon.
        COIN_POUND (IconName): The :code:`coin-pound` icon.
        COIN_RUPEE (IconName): The :code:`coin-rupee` icon.
        COIN_YEN (IconName): The :code:`coin-yen` icon.
        COIN_YUAN (IconName): The :code:`coin-yuan` icon.
        COINS (IconName): The :code:`coins` icon.
        COLOR_FILTER (IconName): The :code:`color-filter` icon.
        COLOR_PICKER (IconName): The :code:`color-picker` icon.
        COLOR_PICKER_OFF (IconName): The :code:`color-picker-off` icon.
        COLOR_SWATCH (IconName): The :code:`color-swatch` icon.
        COLOR_SWATCH_OFF (IconName): The :code:`color-swatch-off` icon.
        COLUMN_INSERT_LEFT (IconName): The :code:`column-insert-left` icon.
        COLUMN_INSERT_RIGHT (IconName): The :code:`column-insert-right` icon.
        COLUMN_REMOVE (IconName): The :code:`column-remove` icon.
        COLUMNS (IconName): The :code:`columns` icon.
        COLUMNS_1 (IconName): The :code:`columns-1` icon.
        COLUMNS_2 (IconName): The :code:`columns-2` icon.
        COLUMNS_3 (IconName): The :code:`columns-3` icon.
        COLUMNS_OFF (IconName): The :code:`columns-off` icon.
        COMET (IconName): The :code:`comet` icon.
        COMMAND (IconName): The :code:`command` icon.
        COMMAND_OFF (IconName): The :code:`command-off` icon.
        COMPASS (IconName): The :code:`compass` icon.
        COMPASS_OFF (IconName): The :code:`compass-off` icon.
        COMPONENTS (IconName): The :code:`components` icon.
        COMPONENTS_OFF (IconName): The :code:`components-off` icon.
        CONE (IconName): The :code:`cone` icon.
        CONE_2 (IconName): The :code:`cone-2` icon.
        CONE_OFF (IconName): The :code:`cone-off` icon.
        CONE_PLUS (IconName): The :code:`cone-plus` icon.
        CONFETTI (IconName): The :code:`confetti` icon.
        CONFETTI_OFF (IconName): The :code:`confetti-off` icon.
        CONFUCIUS (IconName): The :code:`confucius` icon.
        CONTAINER (IconName): The :code:`container` icon.
        CONTAINER_OFF (IconName): The :code:`container-off` icon.
        CONTRAST (IconName): The :code:`contrast` icon.
        CONTRAST_2 (IconName): The :code:`contrast-2` icon.
        CONTRAST_2_OFF (IconName): The :code:`contrast-2-off` icon.
        CONTRAST_OFF (IconName): The :code:`contrast-off` icon.
        COOKER (IconName): The :code:`cooker` icon.
        COOKIE (IconName): The :code:`cookie` icon.
        COOKIE_MAN (IconName): The :code:`cookie-man` icon.
        COOKIE_OFF (IconName): The :code:`cookie-off` icon.
        COPY (IconName): The :code:`copy` icon.
        COPY_OFF (IconName): The :code:`copy-off` icon.
        COPYLEFT (IconName): The :code:`copyleft` icon.
        COPYLEFT_FILLED (IconName): The :code:`copyleft-filled` icon.
        COPYLEFT_OFF (IconName): The :code:`copyleft-off` icon.
        COPYRIGHT (IconName): The :code:`copyright` icon.
        COPYRIGHT_FILLED (IconName): The :code:`copyright-filled` icon.
        COPYRIGHT_OFF (IconName): The :code:`copyright-off` icon.
        CORNER_DOWN_LEFT (IconName): The :code:`corner-down-left` icon.
        CORNER_DOWN_LEFT_DOUBLE (IconName): The :code:`corner-down-left-double` icon.
        CORNER_DOWN_RIGHT (IconName): The :code:`corner-down-right` icon.
        CORNER_DOWN_RIGHT_DOUBLE (IconName): The :code:`corner-down-right-double` icon.
        CORNER_LEFT_DOWN (IconName): The :code:`corner-left-down` icon.
        CORNER_LEFT_DOWN_DOUBLE (IconName): The :code:`corner-left-down-double` icon.
        CORNER_LEFT_UP (IconName): The :code:`corner-left-up` icon.
        CORNER_LEFT_UP_DOUBLE (IconName): The :code:`corner-left-up-double` icon.
        CORNER_RIGHT_DOWN (IconName): The :code:`corner-right-down` icon.
        CORNER_RIGHT_DOWN_DOUBLE (IconName): The :code:`corner-right-down-double` icon.
        CORNER_RIGHT_UP (IconName): The :code:`corner-right-up` icon.
        CORNER_RIGHT_UP_DOUBLE (IconName): The :code:`corner-right-up-double` icon.
        CORNER_UP_LEFT (IconName): The :code:`corner-up-left` icon.
        CORNER_UP_LEFT_DOUBLE (IconName): The :code:`corner-up-left-double` icon.
        CORNER_UP_RIGHT (IconName): The :code:`corner-up-right` icon.
        CORNER_UP_RIGHT_DOUBLE (IconName): The :code:`corner-up-right-double` icon.
        CPU (IconName): The :code:`cpu` icon.
        CPU_2 (IconName): The :code:`cpu-2` icon.
        CPU_OFF (IconName): The :code:`cpu-off` icon.
        CRANE (IconName): The :code:`crane` icon.
        CRANE_OFF (IconName): The :code:`crane-off` icon.
        CREATIVE_COMMONS (IconName): The :code:`creative-commons` icon.
        CREATIVE_COMMONS_BY (IconName): The :code:`creative-commons-by` icon.
        CREATIVE_COMMONS_NC (IconName): The :code:`creative-commons-nc` icon.
        CREATIVE_COMMONS_ND (IconName): The :code:`creative-commons-nd` icon.
        CREATIVE_COMMONS_OFF (IconName): The :code:`creative-commons-off` icon.
        CREATIVE_COMMONS_SA (IconName): The :code:`creative-commons-sa` icon.
        CREATIVE_COMMONS_ZERO (IconName): The :code:`creative-commons-zero` icon.
        CREDIT_CARD (IconName): The :code:`credit-card` icon.
        CREDIT_CARD_OFF (IconName): The :code:`credit-card-off` icon.
        CRICKET (IconName): The :code:`cricket` icon.
        CROP (IconName): The :code:`crop` icon.
        CROSS (IconName): The :code:`cross` icon.
        CROSS_FILLED (IconName): The :code:`cross-filled` icon.
        CROSS_OFF (IconName): The :code:`cross-off` icon.
        CROSSHAIR (IconName): The :code:`crosshair` icon.
        CROWN (IconName): The :code:`crown` icon.
        CROWN_OFF (IconName): The :code:`crown-off` icon.
        CRUTCHES (IconName): The :code:`crutches` icon.
        CRUTCHES_OFF (IconName): The :code:`crutches-off` icon.
        CRYSTAL_BALL (IconName): The :code:`crystal-ball` icon.
        CSV (IconName): The :code:`csv` icon.
        CUBE (IconName): The :code:`cube` icon.
        CUBE_OFF (IconName): The :code:`cube-off` icon.
        CUBE_PLUS (IconName): The :code:`cube-plus` icon.
        CUBE_SEND (IconName): The :code:`cube-send` icon.
        CUBE_UNFOLDED (IconName): The :code:`cube-unfolded` icon.
        CUP (IconName): The :code:`cup` icon.
        CUP_OFF (IconName): The :code:`cup-off` icon.
        CURLING (IconName): The :code:`curling` icon.
        CURLY_LOOP (IconName): The :code:`curly-loop` icon.
        CURRENCY (IconName): The :code:`currency` icon.
        CURRENCY_AFGHANI (IconName): The :code:`currency-afghani` icon.
        CURRENCY_BAHRAINI (IconName): The :code:`currency-bahraini` icon.
        CURRENCY_BAHT (IconName): The :code:`currency-baht` icon.
        CURRENCY_BITCOIN (IconName): The :code:`currency-bitcoin` icon.
        CURRENCY_CENT (IconName): The :code:`currency-cent` icon.
        CURRENCY_DINAR (IconName): The :code:`currency-dinar` icon.
        CURRENCY_DIRHAM (IconName): The :code:`currency-dirham` icon.
        CURRENCY_DOGECOIN (IconName): The :code:`currency-dogecoin` icon.
        CURRENCY_DOLLAR (IconName): The :code:`currency-dollar` icon.
        CURRENCY_DOLLAR_AUSTRALIAN (IconName): The :code:`currency-dollar-australian` icon.
        CURRENCY_DOLLAR_BRUNEI (IconName): The :code:`currency-dollar-brunei` icon.
        CURRENCY_DOLLAR_CANADIAN (IconName): The :code:`currency-dollar-canadian` icon.
        CURRENCY_DOLLAR_GUYANESE (IconName): The :code:`currency-dollar-guyanese` icon.
        CURRENCY_DOLLAR_OFF (IconName): The :code:`currency-dollar-off` icon.
        CURRENCY_DOLLAR_SINGAPORE (IconName): The :code:`currency-dollar-singapore` icon.
        CURRENCY_DOLLAR_ZIMBABWEAN (IconName): The :code:`currency-dollar-zimbabwean` icon.
        CURRENCY_DONG (IconName): The :code:`currency-dong` icon.
        CURRENCY_DRAM (IconName): The :code:`currency-dram` icon.
        CURRENCY_ETHEREUM (IconName): The :code:`currency-ethereum` icon.
        CURRENCY_EURO (IconName): The :code:`currency-euro` icon.
        CURRENCY_EURO_OFF (IconName): The :code:`currency-euro-off` icon.
        CURRENCY_FLORIN (IconName): The :code:`currency-florin` icon.
        CURRENCY_FORINT (IconName): The :code:`currency-forint` icon.
        CURRENCY_FRANK (IconName): The :code:`currency-frank` icon.
        CURRENCY_GUARANI (IconName): The :code:`currency-guarani` icon.
        CURRENCY_HRYVNIA (IconName): The :code:`currency-hryvnia` icon.
        CURRENCY_IRANIAN_RIAL (IconName): The :code:`currency-iranian-rial` icon.
        CURRENCY_KIP (IconName): The :code:`currency-kip` icon.
        CURRENCY_KRONE_CZECH (IconName): The :code:`currency-krone-czech` icon.
        CURRENCY_KRONE_DANISH (IconName): The :code:`currency-krone-danish` icon.
        CURRENCY_KRONE_SWEDISH (IconName): The :code:`currency-krone-swedish` icon.
        CURRENCY_LARI (IconName): The :code:`currency-lari` icon.
        CURRENCY_LEU (IconName): The :code:`currency-leu` icon.
        CURRENCY_LIRA (IconName): The :code:`currency-lira` icon.
        CURRENCY_LITECOIN (IconName): The :code:`currency-litecoin` icon.
        CURRENCY_LYD (IconName): The :code:`currency-lyd` icon.
        CURRENCY_MANAT (IconName): The :code:`currency-manat` icon.
        CURRENCY_MONERO (IconName): The :code:`currency-monero` icon.
        CURRENCY_NAIRA (IconName): The :code:`currency-naira` icon.
        CURRENCY_NANO (IconName): The :code:`currency-nano` icon.
        CURRENCY_OFF (IconName): The :code:`currency-off` icon.
        CURRENCY_PAANGA (IconName): The :code:`currency-paanga` icon.
        CURRENCY_PESO (IconName): The :code:`currency-peso` icon.
        CURRENCY_POUND (IconName): The :code:`currency-pound` icon.
        CURRENCY_POUND_OFF (IconName): The :code:`currency-pound-off` icon.
        CURRENCY_QUETZAL (IconName): The :code:`currency-quetzal` icon.
        CURRENCY_REAL (IconName): The :code:`currency-real` icon.
        CURRENCY_RENMINBI (IconName): The :code:`currency-renminbi` icon.
        CURRENCY_RIPPLE (IconName): The :code:`currency-ripple` icon.
        CURRENCY_RIYAL (IconName): The :code:`currency-riyal` icon.
        CURRENCY_RUBEL (IconName): The :code:`currency-rubel` icon.
        CURRENCY_RUFIYAA (IconName): The :code:`currency-rufiyaa` icon.
        CURRENCY_RUPEE (IconName): The :code:`currency-rupee` icon.
        CURRENCY_RUPEE_NEPALESE (IconName): The :code:`currency-rupee-nepalese` icon.
        CURRENCY_SHEKEL (IconName): The :code:`currency-shekel` icon.
        CURRENCY_SOLANA (IconName): The :code:`currency-solana` icon.
        CURRENCY_SOM (IconName): The :code:`currency-som` icon.
        CURRENCY_TAKA (IconName): The :code:`currency-taka` icon.
        CURRENCY_TENGE (IconName): The :code:`currency-tenge` icon.
        CURRENCY_TUGRIK (IconName): The :code:`currency-tugrik` icon.
        CURRENCY_WON (IconName): The :code:`currency-won` icon.
        CURRENCY_YEN (IconName): The :code:`currency-yen` icon.
        CURRENCY_YEN_OFF (IconName): The :code:`currency-yen-off` icon.
        CURRENCY_YUAN (IconName): The :code:`currency-yuan` icon.
        CURRENCY_ZLOTY (IconName): The :code:`currency-zloty` icon.
        CURRENT_LOCATION (IconName): The :code:`current-location` icon.
        CURRENT_LOCATION_OFF (IconName): The :code:`current-location-off` icon.
        CURSOR_OFF (IconName): The :code:`cursor-off` icon.
        CURSOR_TEXT (IconName): The :code:`cursor-text` icon.
        CUT (IconName): The :code:`cut` icon.
        CYLINDER (IconName): The :code:`cylinder` icon.
        CYLINDER_OFF (IconName): The :code:`cylinder-off` icon.
        CYLINDER_PLUS (IconName): The :code:`cylinder-plus` icon.
        DASHBOARD (IconName): The :code:`dashboard` icon.
        DASHBOARD_OFF (IconName): The :code:`dashboard-off` icon.
        DATABASE (IconName): The :code:`database` icon.
        DATABASE_COG (IconName): The :code:`database-cog` icon.
        DATABASE_DOLLAR (IconName): The :code:`database-dollar` icon.
        DATABASE_EDIT (IconName): The :code:`database-edit` icon.
        DATABASE_EXCLAMATION (IconName): The :code:`database-exclamation` icon.
        DATABASE_EXPORT (IconName): The :code:`database-export` icon.
        DATABASE_HEART (IconName): The :code:`database-heart` icon.
        DATABASE_IMPORT (IconName): The :code:`database-import` icon.
        DATABASE_LEAK (IconName): The :code:`database-leak` icon.
        DATABASE_MINUS (IconName): The :code:`database-minus` icon.
        DATABASE_OFF (IconName): The :code:`database-off` icon.
        DATABASE_PLUS (IconName): The :code:`database-plus` icon.
        DATABASE_SEARCH (IconName): The :code:`database-search` icon.
        DATABASE_SHARE (IconName): The :code:`database-share` icon.
        DATABASE_STAR (IconName): The :code:`database-star` icon.
        DATABASE_X (IconName): The :code:`database-x` icon.
        DECIMAL (IconName): The :code:`decimal` icon.
        DEER (IconName): The :code:`deer` icon.
        DELTA (IconName): The :code:`delta` icon.
        DENTAL (IconName): The :code:`dental` icon.
        DENTAL_BROKEN (IconName): The :code:`dental-broken` icon.
        DENTAL_OFF (IconName): The :code:`dental-off` icon.
        DESELECT (IconName): The :code:`deselect` icon.
        DETAILS (IconName): The :code:`details` icon.
        DETAILS_OFF (IconName): The :code:`details-off` icon.
        DEVICE_AIRPODS (IconName): The :code:`device-airpods` icon.
        DEVICE_AIRPODS_CASE (IconName): The :code:`device-airpods-case` icon.
        DEVICE_AIRTAG (IconName): The :code:`device-airtag` icon.
        DEVICE_ANALYTICS (IconName): The :code:`device-analytics` icon.
        DEVICE_AUDIO_TAPE (IconName): The :code:`device-audio-tape` icon.
        DEVICE_CAMERA_PHONE (IconName): The :code:`device-camera-phone` icon.
        DEVICE_CCTV (IconName): The :code:`device-cctv` icon.
        DEVICE_CCTV_OFF (IconName): The :code:`device-cctv-off` icon.
        DEVICE_COMPUTER_CAMERA (IconName): The :code:`device-computer-camera` icon.
        DEVICE_COMPUTER_CAMERA_OFF (IconName): The :code:`device-computer-camera-off` icon.
        DEVICE_DESKTOP (IconName): The :code:`device-desktop` icon.
        DEVICE_DESKTOP_ANALYTICS (IconName): The :code:`device-desktop-analytics` icon.
        DEVICE_DESKTOP_BOLT (IconName): The :code:`device-desktop-bolt` icon.
        DEVICE_DESKTOP_CANCEL (IconName): The :code:`device-desktop-cancel` icon.
        DEVICE_DESKTOP_CHECK (IconName): The :code:`device-desktop-check` icon.
        DEVICE_DESKTOP_CODE (IconName): The :code:`device-desktop-code` icon.
        DEVICE_DESKTOP_COG (IconName): The :code:`device-desktop-cog` icon.
        DEVICE_DESKTOP_DOLLAR (IconName): The :code:`device-desktop-dollar` icon.
        DEVICE_DESKTOP_DOWN (IconName): The :code:`device-desktop-down` icon.
        DEVICE_DESKTOP_EXCLAMATION (IconName): The :code:`device-desktop-exclamation` icon.
        DEVICE_DESKTOP_HEART (IconName): The :code:`device-desktop-heart` icon.
        DEVICE_DESKTOP_MINUS (IconName): The :code:`device-desktop-minus` icon.
        DEVICE_DESKTOP_OFF (IconName): The :code:`device-desktop-off` icon.
        DEVICE_DESKTOP_PAUSE (IconName): The :code:`device-desktop-pause` icon.
        DEVICE_DESKTOP_PIN (IconName): The :code:`device-desktop-pin` icon.
        DEVICE_DESKTOP_PLUS (IconName): The :code:`device-desktop-plus` icon.
        DEVICE_DESKTOP_QUESTION (IconName): The :code:`device-desktop-question` icon.
        DEVICE_DESKTOP_SEARCH (IconName): The :code:`device-desktop-search` icon.
        DEVICE_DESKTOP_SHARE (IconName): The :code:`device-desktop-share` icon.
        DEVICE_DESKTOP_STAR (IconName): The :code:`device-desktop-star` icon.
        DEVICE_DESKTOP_UP (IconName): The :code:`device-desktop-up` icon.
        DEVICE_DESKTOP_X (IconName): The :code:`device-desktop-x` icon.
        DEVICE_FLOPPY (IconName): The :code:`device-floppy` icon.
        DEVICE_GAMEPAD (IconName): The :code:`device-gamepad` icon.
        DEVICE_GAMEPAD_2 (IconName): The :code:`device-gamepad-2` icon.
        DEVICE_HEART_MONITOR (IconName): The :code:`device-heart-monitor` icon.
        DEVICE_HEART_MONITOR_FILLED (IconName): The :code:`device-heart-monitor-filled` icon.
        DEVICE_IMAC (IconName): The :code:`device-imac` icon.
        DEVICE_IMAC_BOLT (IconName): The :code:`device-imac-bolt` icon.
        DEVICE_IMAC_CANCEL (IconName): The :code:`device-imac-cancel` icon.
        DEVICE_IMAC_CHECK (IconName): The :code:`device-imac-check` icon.
        DEVICE_IMAC_CODE (IconName): The :code:`device-imac-code` icon.
        DEVICE_IMAC_COG (IconName): The :code:`device-imac-cog` icon.
        DEVICE_IMAC_DOLLAR (IconName): The :code:`device-imac-dollar` icon.
        DEVICE_IMAC_DOWN (IconName): The :code:`device-imac-down` icon.
        DEVICE_IMAC_EXCLAMATION (IconName): The :code:`device-imac-exclamation` icon.
        DEVICE_IMAC_HEART (IconName): The :code:`device-imac-heart` icon.
        DEVICE_IMAC_MINUS (IconName): The :code:`device-imac-minus` icon.
        DEVICE_IMAC_OFF (IconName): The :code:`device-imac-off` icon.
        DEVICE_IMAC_PAUSE (IconName): The :code:`device-imac-pause` icon.
        DEVICE_IMAC_PIN (IconName): The :code:`device-imac-pin` icon.
        DEVICE_IMAC_PLUS (IconName): The :code:`device-imac-plus` icon.
        DEVICE_IMAC_QUESTION (IconName): The :code:`device-imac-question` icon.
        DEVICE_IMAC_SEARCH (IconName): The :code:`device-imac-search` icon.
        DEVICE_IMAC_SHARE (IconName): The :code:`device-imac-share` icon.
        DEVICE_IMAC_STAR (IconName): The :code:`device-imac-star` icon.
        DEVICE_IMAC_UP (IconName): The :code:`device-imac-up` icon.
        DEVICE_IMAC_X (IconName): The :code:`device-imac-x` icon.
        DEVICE_IPAD (IconName): The :code:`device-ipad` icon.
        DEVICE_IPAD_BOLT (IconName): The :code:`device-ipad-bolt` icon.
        DEVICE_IPAD_CANCEL (IconName): The :code:`device-ipad-cancel` icon.
        DEVICE_IPAD_CHECK (IconName): The :code:`device-ipad-check` icon.
        DEVICE_IPAD_CODE (IconName): The :code:`device-ipad-code` icon.
        DEVICE_IPAD_COG (IconName): The :code:`device-ipad-cog` icon.
        DEVICE_IPAD_DOLLAR (IconName): The :code:`device-ipad-dollar` icon.
        DEVICE_IPAD_DOWN (IconName): The :code:`device-ipad-down` icon.
        DEVICE_IPAD_EXCLAMATION (IconName): The :code:`device-ipad-exclamation` icon.
        DEVICE_IPAD_HEART (IconName): The :code:`device-ipad-heart` icon.
        DEVICE_IPAD_HORIZONTAL (IconName): The :code:`device-ipad-horizontal` icon.
        DEVICE_IPAD_HORIZONTAL_BOLT (IconName): The :code:`device-ipad-horizontal-bolt` icon.
        DEVICE_IPAD_HORIZONTAL_CANCEL (IconName): The :code:`device-ipad-horizontal-cancel` icon.
        DEVICE_IPAD_HORIZONTAL_CHECK (IconName): The :code:`device-ipad-horizontal-check` icon.
        DEVICE_IPAD_HORIZONTAL_CODE (IconName): The :code:`device-ipad-horizontal-code` icon.
        DEVICE_IPAD_HORIZONTAL_COG (IconName): The :code:`device-ipad-horizontal-cog` icon.
        DEVICE_IPAD_HORIZONTAL_DOLLAR (IconName): The :code:`device-ipad-horizontal-dollar` icon.
        DEVICE_IPAD_HORIZONTAL_DOWN (IconName): The :code:`device-ipad-horizontal-down` icon.
        DEVICE_IPAD_HORIZONTAL_EXCLAMATION (IconName): The :code:`device-ipad-horizontal-exclamation` icon.
        DEVICE_IPAD_HORIZONTAL_HEART (IconName): The :code:`device-ipad-horizontal-heart` icon.
        DEVICE_IPAD_HORIZONTAL_MINUS (IconName): The :code:`device-ipad-horizontal-minus` icon.
        DEVICE_IPAD_HORIZONTAL_OFF (IconName): The :code:`device-ipad-horizontal-off` icon.
        DEVICE_IPAD_HORIZONTAL_PAUSE (IconName): The :code:`device-ipad-horizontal-pause` icon.
        DEVICE_IPAD_HORIZONTAL_PIN (IconName): The :code:`device-ipad-horizontal-pin` icon.
        DEVICE_IPAD_HORIZONTAL_PLUS (IconName): The :code:`device-ipad-horizontal-plus` icon.
        DEVICE_IPAD_HORIZONTAL_QUESTION (IconName): The :code:`device-ipad-horizontal-question` icon.
        DEVICE_IPAD_HORIZONTAL_SEARCH (IconName): The :code:`device-ipad-horizontal-search` icon.
        DEVICE_IPAD_HORIZONTAL_SHARE (IconName): The :code:`device-ipad-horizontal-share` icon.
        DEVICE_IPAD_HORIZONTAL_STAR (IconName): The :code:`device-ipad-horizontal-star` icon.
        DEVICE_IPAD_HORIZONTAL_UP (IconName): The :code:`device-ipad-horizontal-up` icon.
        DEVICE_IPAD_HORIZONTAL_X (IconName): The :code:`device-ipad-horizontal-x` icon.
        DEVICE_IPAD_MINUS (IconName): The :code:`device-ipad-minus` icon.
        DEVICE_IPAD_OFF (IconName): The :code:`device-ipad-off` icon.
        DEVICE_IPAD_PAUSE (IconName): The :code:`device-ipad-pause` icon.
        DEVICE_IPAD_PIN (IconName): The :code:`device-ipad-pin` icon.
        DEVICE_IPAD_PLUS (IconName): The :code:`device-ipad-plus` icon.
        DEVICE_IPAD_QUESTION (IconName): The :code:`device-ipad-question` icon.
        DEVICE_IPAD_SEARCH (IconName): The :code:`device-ipad-search` icon.
        DEVICE_IPAD_SHARE (IconName): The :code:`device-ipad-share` icon.
        DEVICE_IPAD_STAR (IconName): The :code:`device-ipad-star` icon.
        DEVICE_IPAD_UP (IconName): The :code:`device-ipad-up` icon.
        DEVICE_IPAD_X (IconName): The :code:`device-ipad-x` icon.
        DEVICE_LANDLINE_PHONE (IconName): The :code:`device-landline-phone` icon.
        DEVICE_LAPTOP (IconName): The :code:`device-laptop` icon.
        DEVICE_LAPTOP_OFF (IconName): The :code:`device-laptop-off` icon.
        DEVICE_MOBILE (IconName): The :code:`device-mobile` icon.
        DEVICE_MOBILE_BOLT (IconName): The :code:`device-mobile-bolt` icon.
        DEVICE_MOBILE_CANCEL (IconName): The :code:`device-mobile-cancel` icon.
        DEVICE_MOBILE_CHARGING (IconName): The :code:`device-mobile-charging` icon.
        DEVICE_MOBILE_CHECK (IconName): The :code:`device-mobile-check` icon.
        DEVICE_MOBILE_CODE (IconName): The :code:`device-mobile-code` icon.
        DEVICE_MOBILE_COG (IconName): The :code:`device-mobile-cog` icon.
        DEVICE_MOBILE_DOLLAR (IconName): The :code:`device-mobile-dollar` icon.
        DEVICE_MOBILE_DOWN (IconName): The :code:`device-mobile-down` icon.
        DEVICE_MOBILE_EXCLAMATION (IconName): The :code:`device-mobile-exclamation` icon.
        DEVICE_MOBILE_FILLED (IconName): The :code:`device-mobile-filled` icon.
        DEVICE_MOBILE_HEART (IconName): The :code:`device-mobile-heart` icon.
        DEVICE_MOBILE_MESSAGE (IconName): The :code:`device-mobile-message` icon.
        DEVICE_MOBILE_MINUS (IconName): The :code:`device-mobile-minus` icon.
        DEVICE_MOBILE_OFF (IconName): The :code:`device-mobile-off` icon.
        DEVICE_MOBILE_PAUSE (IconName): The :code:`device-mobile-pause` icon.
        DEVICE_MOBILE_PIN (IconName): The :code:`device-mobile-pin` icon.
        DEVICE_MOBILE_PLUS (IconName): The :code:`device-mobile-plus` icon.
        DEVICE_MOBILE_QUESTION (IconName): The :code:`device-mobile-question` icon.
        DEVICE_MOBILE_ROTATED (IconName): The :code:`device-mobile-rotated` icon.
        DEVICE_MOBILE_SEARCH (IconName): The :code:`device-mobile-search` icon.
        DEVICE_MOBILE_SHARE (IconName): The :code:`device-mobile-share` icon.
        DEVICE_MOBILE_STAR (IconName): The :code:`device-mobile-star` icon.
        DEVICE_MOBILE_UP (IconName): The :code:`device-mobile-up` icon.
        DEVICE_MOBILE_VIBRATION (IconName): The :code:`device-mobile-vibration` icon.
        DEVICE_MOBILE_X (IconName): The :code:`device-mobile-x` icon.
        DEVICE_NINTENDO (IconName): The :code:`device-nintendo` icon.
        DEVICE_NINTENDO_OFF (IconName): The :code:`device-nintendo-off` icon.
        DEVICE_REMOTE (IconName): The :code:`device-remote` icon.
        DEVICE_SD_CARD (IconName): The :code:`device-sd-card` icon.
        DEVICE_SIM (IconName): The :code:`device-sim` icon.
        DEVICE_SIM_1 (IconName): The :code:`device-sim-1` icon.
        DEVICE_SIM_2 (IconName): The :code:`device-sim-2` icon.
        DEVICE_SIM_3 (IconName): The :code:`device-sim-3` icon.
        DEVICE_SPEAKER (IconName): The :code:`device-speaker` icon.
        DEVICE_SPEAKER_OFF (IconName): The :code:`device-speaker-off` icon.
        DEVICE_TABLET (IconName): The :code:`device-tablet` icon.
        DEVICE_TABLET_BOLT (IconName): The :code:`device-tablet-bolt` icon.
        DEVICE_TABLET_CANCEL (IconName): The :code:`device-tablet-cancel` icon.
        DEVICE_TABLET_CHECK (IconName): The :code:`device-tablet-check` icon.
        DEVICE_TABLET_CODE (IconName): The :code:`device-tablet-code` icon.
        DEVICE_TABLET_COG (IconName): The :code:`device-tablet-cog` icon.
        DEVICE_TABLET_DOLLAR (IconName): The :code:`device-tablet-dollar` icon.
        DEVICE_TABLET_DOWN (IconName): The :code:`device-tablet-down` icon.
        DEVICE_TABLET_EXCLAMATION (IconName): The :code:`device-tablet-exclamation` icon.
        DEVICE_TABLET_FILLED (IconName): The :code:`device-tablet-filled` icon.
        DEVICE_TABLET_HEART (IconName): The :code:`device-tablet-heart` icon.
        DEVICE_TABLET_MINUS (IconName): The :code:`device-tablet-minus` icon.
        DEVICE_TABLET_OFF (IconName): The :code:`device-tablet-off` icon.
        DEVICE_TABLET_PAUSE (IconName): The :code:`device-tablet-pause` icon.
        DEVICE_TABLET_PIN (IconName): The :code:`device-tablet-pin` icon.
        DEVICE_TABLET_PLUS (IconName): The :code:`device-tablet-plus` icon.
        DEVICE_TABLET_QUESTION (IconName): The :code:`device-tablet-question` icon.
        DEVICE_TABLET_SEARCH (IconName): The :code:`device-tablet-search` icon.
        DEVICE_TABLET_SHARE (IconName): The :code:`device-tablet-share` icon.
        DEVICE_TABLET_STAR (IconName): The :code:`device-tablet-star` icon.
        DEVICE_TABLET_UP (IconName): The :code:`device-tablet-up` icon.
        DEVICE_TABLET_X (IconName): The :code:`device-tablet-x` icon.
        DEVICE_TV (IconName): The :code:`device-tv` icon.
        DEVICE_TV_OFF (IconName): The :code:`device-tv-off` icon.
        DEVICE_TV_OLD (IconName): The :code:`device-tv-old` icon.
        DEVICE_VISION_PRO (IconName): The :code:`device-vision-pro` icon.
        DEVICE_WATCH (IconName): The :code:`device-watch` icon.
        DEVICE_WATCH_BOLT (IconName): The :code:`device-watch-bolt` icon.
        DEVICE_WATCH_CANCEL (IconName): The :code:`device-watch-cancel` icon.
        DEVICE_WATCH_CHECK (IconName): The :code:`device-watch-check` icon.
        DEVICE_WATCH_CODE (IconName): The :code:`device-watch-code` icon.
        DEVICE_WATCH_COG (IconName): The :code:`device-watch-cog` icon.
        DEVICE_WATCH_DOLLAR (IconName): The :code:`device-watch-dollar` icon.
        DEVICE_WATCH_DOWN (IconName): The :code:`device-watch-down` icon.
        DEVICE_WATCH_EXCLAMATION (IconName): The :code:`device-watch-exclamation` icon.
        DEVICE_WATCH_HEART (IconName): The :code:`device-watch-heart` icon.
        DEVICE_WATCH_MINUS (IconName): The :code:`device-watch-minus` icon.
        DEVICE_WATCH_OFF (IconName): The :code:`device-watch-off` icon.
        DEVICE_WATCH_PAUSE (IconName): The :code:`device-watch-pause` icon.
        DEVICE_WATCH_PIN (IconName): The :code:`device-watch-pin` icon.
        DEVICE_WATCH_PLUS (IconName): The :code:`device-watch-plus` icon.
        DEVICE_WATCH_QUESTION (IconName): The :code:`device-watch-question` icon.
        DEVICE_WATCH_SEARCH (IconName): The :code:`device-watch-search` icon.
        DEVICE_WATCH_SHARE (IconName): The :code:`device-watch-share` icon.
        DEVICE_WATCH_STAR (IconName): The :code:`device-watch-star` icon.
        DEVICE_WATCH_STATS (IconName): The :code:`device-watch-stats` icon.
        DEVICE_WATCH_STATS_2 (IconName): The :code:`device-watch-stats-2` icon.
        DEVICE_WATCH_UP (IconName): The :code:`device-watch-up` icon.
        DEVICE_WATCH_X (IconName): The :code:`device-watch-x` icon.
        DEVICES (IconName): The :code:`devices` icon.
        DEVICES_2 (IconName): The :code:`devices-2` icon.
        DEVICES_BOLT (IconName): The :code:`devices-bolt` icon.
        DEVICES_CANCEL (IconName): The :code:`devices-cancel` icon.
        DEVICES_CHECK (IconName): The :code:`devices-check` icon.
        DEVICES_CODE (IconName): The :code:`devices-code` icon.
        DEVICES_COG (IconName): The :code:`devices-cog` icon.
        DEVICES_DOLLAR (IconName): The :code:`devices-dollar` icon.
        DEVICES_DOWN (IconName): The :code:`devices-down` icon.
        DEVICES_EXCLAMATION (IconName): The :code:`devices-exclamation` icon.
        DEVICES_HEART (IconName): The :code:`devices-heart` icon.
        DEVICES_MINUS (IconName): The :code:`devices-minus` icon.
        DEVICES_OFF (IconName): The :code:`devices-off` icon.
        DEVICES_PAUSE (IconName): The :code:`devices-pause` icon.
        DEVICES_PC (IconName): The :code:`devices-pc` icon.
        DEVICES_PC_OFF (IconName): The :code:`devices-pc-off` icon.
        DEVICES_PIN (IconName): The :code:`devices-pin` icon.
        DEVICES_PLUS (IconName): The :code:`devices-plus` icon.
        DEVICES_QUESTION (IconName): The :code:`devices-question` icon.
        DEVICES_SEARCH (IconName): The :code:`devices-search` icon.
        DEVICES_SHARE (IconName): The :code:`devices-share` icon.
        DEVICES_STAR (IconName): The :code:`devices-star` icon.
        DEVICES_UP (IconName): The :code:`devices-up` icon.
        DEVICES_X (IconName): The :code:`devices-x` icon.
        DIABOLO (IconName): The :code:`diabolo` icon.
        DIABOLO_OFF (IconName): The :code:`diabolo-off` icon.
        DIABOLO_PLUS (IconName): The :code:`diabolo-plus` icon.
        DIALPAD (IconName): The :code:`dialpad` icon.
        DIALPAD_FILLED (IconName): The :code:`dialpad-filled` icon.
        DIALPAD_OFF (IconName): The :code:`dialpad-off` icon.
        DIAMOND (IconName): The :code:`diamond` icon.
        DIAMOND_FILLED (IconName): The :code:`diamond-filled` icon.
        DIAMOND_OFF (IconName): The :code:`diamond-off` icon.
        DIAMONDS (IconName): The :code:`diamonds` icon.
        DIAMONDS_FILLED (IconName): The :code:`diamonds-filled` icon.
        DICE (IconName): The :code:`dice` icon.
        DICE_1 (IconName): The :code:`dice-1` icon.
        DICE_1_FILLED (IconName): The :code:`dice-1-filled` icon.
        DICE_2 (IconName): The :code:`dice-2` icon.
        DICE_2_FILLED (IconName): The :code:`dice-2-filled` icon.
        DICE_3 (IconName): The :code:`dice-3` icon.
        DICE_3_FILLED (IconName): The :code:`dice-3-filled` icon.
        DICE_4 (IconName): The :code:`dice-4` icon.
        DICE_4_FILLED (IconName): The :code:`dice-4-filled` icon.
        DICE_5 (IconName): The :code:`dice-5` icon.
        DICE_5_FILLED (IconName): The :code:`dice-5-filled` icon.
        DICE_6 (IconName): The :code:`dice-6` icon.
        DICE_6_FILLED (IconName): The :code:`dice-6-filled` icon.
        DICE_FILLED (IconName): The :code:`dice-filled` icon.
        DIMENSIONS (IconName): The :code:`dimensions` icon.
        DIRECTION (IconName): The :code:`direction` icon.
        DIRECTION_HORIZONTAL (IconName): The :code:`direction-horizontal` icon.
        DIRECTION_SIGN (IconName): The :code:`direction-sign` icon.
        DIRECTION_SIGN_FILLED (IconName): The :code:`direction-sign-filled` icon.
        DIRECTION_SIGN_OFF (IconName): The :code:`direction-sign-off` icon.
        DIRECTIONS (IconName): The :code:`directions` icon.
        DIRECTIONS_OFF (IconName): The :code:`directions-off` icon.
        DISABLED (IconName): The :code:`disabled` icon.
        DISABLED_2 (IconName): The :code:`disabled-2` icon.
        DISABLED_OFF (IconName): The :code:`disabled-off` icon.
        DISC (IconName): The :code:`disc` icon.
        DISC_GOLF (IconName): The :code:`disc-golf` icon.
        DISC_OFF (IconName): The :code:`disc-off` icon.
        DISCOUNT (IconName): The :code:`discount` icon.
        DISCOUNT_2 (IconName): The :code:`discount-2` icon.
        DISCOUNT_2_OFF (IconName): The :code:`discount-2-off` icon.
        DISCOUNT_CHECK (IconName): The :code:`discount-check` icon.
        DISCOUNT_CHECK_FILLED (IconName): The :code:`discount-check-filled` icon.
        DISCOUNT_OFF (IconName): The :code:`discount-off` icon.
        DIVIDE (IconName): The :code:`divide` icon.
        DNA (IconName): The :code:`dna` icon.
        DNA_2 (IconName): The :code:`dna-2` icon.
        DNA_2_OFF (IconName): The :code:`dna-2-off` icon.
        DNA_OFF (IconName): The :code:`dna-off` icon.
        DOG (IconName): The :code:`dog` icon.
        DOG_BOWL (IconName): The :code:`dog-bowl` icon.
        DOOR (IconName): The :code:`door` icon.
        DOOR_ENTER (IconName): The :code:`door-enter` icon.
        DOOR_EXIT (IconName): The :code:`door-exit` icon.
        DOOR_OFF (IconName): The :code:`door-off` icon.
        DOTS (IconName): The :code:`dots` icon.
        DOTS_CIRCLE_HORIZONTAL (IconName): The :code:`dots-circle-horizontal` icon.
        DOTS_DIAGONAL (IconName): The :code:`dots-diagonal` icon.
        DOTS_DIAGONAL_2 (IconName): The :code:`dots-diagonal-2` icon.
        DOTS_VERTICAL (IconName): The :code:`dots-vertical` icon.
        DOWNLOAD (IconName): The :code:`download` icon.
        DOWNLOAD_OFF (IconName): The :code:`download-off` icon.
        DRAG_DROP (IconName): The :code:`drag-drop` icon.
        DRAG_DROP_2 (IconName): The :code:`drag-drop-2` icon.
        DRONE (IconName): The :code:`drone` icon.
        DRONE_OFF (IconName): The :code:`drone-off` icon.
        DROP_CIRCLE (IconName): The :code:`drop-circle` icon.
        DROPLET (IconName): The :code:`droplet` icon.
        DROPLET_BOLT (IconName): The :code:`droplet-bolt` icon.
        DROPLET_CANCEL (IconName): The :code:`droplet-cancel` icon.
        DROPLET_CHECK (IconName): The :code:`droplet-check` icon.
        DROPLET_CODE (IconName): The :code:`droplet-code` icon.
        DROPLET_COG (IconName): The :code:`droplet-cog` icon.
        DROPLET_DOLLAR (IconName): The :code:`droplet-dollar` icon.
        DROPLET_DOWN (IconName): The :code:`droplet-down` icon.
        DROPLET_EXCLAMATION (IconName): The :code:`droplet-exclamation` icon.
        DROPLET_FILLED (IconName): The :code:`droplet-filled` icon.
        DROPLET_FILLED_2 (IconName): The :code:`droplet-filled-2` icon.
        DROPLET_HALF (IconName): The :code:`droplet-half` icon.
        DROPLET_HALF_2 (IconName): The :code:`droplet-half-2` icon.
        DROPLET_HALF_FILLED (IconName): The :code:`droplet-half-filled` icon.
        DROPLET_HEART (IconName): The :code:`droplet-heart` icon.
        DROPLET_MINUS (IconName): The :code:`droplet-minus` icon.
        DROPLET_OFF (IconName): The :code:`droplet-off` icon.
        DROPLET_PAUSE (IconName): The :code:`droplet-pause` icon.
        DROPLET_PIN (IconName): The :code:`droplet-pin` icon.
        DROPLET_PLUS (IconName): The :code:`droplet-plus` icon.
        DROPLET_QUESTION (IconName): The :code:`droplet-question` icon.
        DROPLET_SEARCH (IconName): The :code:`droplet-search` icon.
        DROPLET_SHARE (IconName): The :code:`droplet-share` icon.
        DROPLET_STAR (IconName): The :code:`droplet-star` icon.
        DROPLET_UP (IconName): The :code:`droplet-up` icon.
        DROPLET_X (IconName): The :code:`droplet-x` icon.
        DUAL_SCREEN (IconName): The :code:`dual-screen` icon.
        E_PASSPORT (IconName): The :code:`e-passport` icon.
        EAR (IconName): The :code:`ear` icon.
        EAR_OFF (IconName): The :code:`ear-off` icon.
        EASE_IN (IconName): The :code:`ease-in` icon.
        EASE_IN_CONTROL_POINT (IconName): The :code:`ease-in-control-point` icon.
        EASE_IN_OUT (IconName): The :code:`ease-in-out` icon.
        EASE_IN_OUT_CONTROL_POINTS (IconName): The :code:`ease-in-out-control-points` icon.
        EASE_OUT (IconName): The :code:`ease-out` icon.
        EASE_OUT_CONTROL_POINT (IconName): The :code:`ease-out-control-point` icon.
        EDIT (IconName): The :code:`edit` icon.
        EDIT_CIRCLE (IconName): The :code:`edit-circle` icon.
        EDIT_CIRCLE_OFF (IconName): The :code:`edit-circle-off` icon.
        EDIT_OFF (IconName): The :code:`edit-off` icon.
        EGG (IconName): The :code:`egg` icon.
        EGG_CRACKED (IconName): The :code:`egg-cracked` icon.
        EGG_FILLED (IconName): The :code:`egg-filled` icon.
        EGG_FRIED (IconName): The :code:`egg-fried` icon.
        EGG_OFF (IconName): The :code:`egg-off` icon.
        EGGS (IconName): The :code:`eggs` icon.
        ELEVATOR (IconName): The :code:`elevator` icon.
        ELEVATOR_OFF (IconName): The :code:`elevator-off` icon.
        EMERGENCY_BED (IconName): The :code:`emergency-bed` icon.
        EMPATHIZE (IconName): The :code:`empathize` icon.
        EMPATHIZE_OFF (IconName): The :code:`empathize-off` icon.
        EMPHASIS (IconName): The :code:`emphasis` icon.
        ENGINE (IconName): The :code:`engine` icon.
        ENGINE_OFF (IconName): The :code:`engine-off` icon.
        EQUAL (IconName): The :code:`equal` icon.
        EQUAL_DOUBLE (IconName): The :code:`equal-double` icon.
        EQUAL_NOT (IconName): The :code:`equal-not` icon.
        ERASER (IconName): The :code:`eraser` icon.
        ERASER_OFF (IconName): The :code:`eraser-off` icon.
        ERROR_404 (IconName): The :code:`error-404` icon.
        ERROR_404_OFF (IconName): The :code:`error-404-off` icon.
        EXCHANGE (IconName): The :code:`exchange` icon.
        EXCHANGE_OFF (IconName): The :code:`exchange-off` icon.
        EXCLAMATION_CIRCLE (IconName): The :code:`exclamation-circle` icon.
        EXCLAMATION_MARK (IconName): The :code:`exclamation-mark` icon.
        EXCLAMATION_MARK_OFF (IconName): The :code:`exclamation-mark-off` icon.
        EXPLICIT (IconName): The :code:`explicit` icon.
        EXPLICIT_OFF (IconName): The :code:`explicit-off` icon.
        EXPOSURE (IconName): The :code:`exposure` icon.
        EXPOSURE_0 (IconName): The :code:`exposure-0` icon.
        EXPOSURE_MINUS_1 (IconName): The :code:`exposure-minus-1` icon.
        EXPOSURE_MINUS_2 (IconName): The :code:`exposure-minus-2` icon.
        EXPOSURE_OFF (IconName): The :code:`exposure-off` icon.
        EXPOSURE_PLUS_1 (IconName): The :code:`exposure-plus-1` icon.
        EXPOSURE_PLUS_2 (IconName): The :code:`exposure-plus-2` icon.
        EXTERNAL_LINK (IconName): The :code:`external-link` icon.
        EXTERNAL_LINK_OFF (IconName): The :code:`external-link-off` icon.
        EYE (IconName): The :code:`eye` icon.
        EYE_CHECK (IconName): The :code:`eye-check` icon.
        EYE_CLOSED (IconName): The :code:`eye-closed` icon.
        EYE_COG (IconName): The :code:`eye-cog` icon.
        EYE_EDIT (IconName): The :code:`eye-edit` icon.
        EYE_EXCLAMATION (IconName): The :code:`eye-exclamation` icon.
        EYE_FILLED (IconName): The :code:`eye-filled` icon.
        EYE_HEART (IconName): The :code:`eye-heart` icon.
        EYE_OFF (IconName): The :code:`eye-off` icon.
        EYE_TABLE (IconName): The :code:`eye-table` icon.
        EYE_X (IconName): The :code:`eye-x` icon.
        EYEGLASS (IconName): The :code:`eyeglass` icon.
        EYEGLASS_2 (IconName): The :code:`eyeglass-2` icon.
        EYEGLASS_OFF (IconName): The :code:`eyeglass-off` icon.
        FACE_ID (IconName): The :code:`face-id` icon.
        FACE_ID_ERROR (IconName): The :code:`face-id-error` icon.
        FACE_MASK (IconName): The :code:`face-mask` icon.
        FACE_MASK_OFF (IconName): The :code:`face-mask-off` icon.
        FALL (IconName): The :code:`fall` icon.
        FEATHER (IconName): The :code:`feather` icon.
        FEATHER_OFF (IconName): The :code:`feather-off` icon.
        FENCE (IconName): The :code:`fence` icon.
        FENCE_OFF (IconName): The :code:`fence-off` icon.
        FIDGET_SPINNER (IconName): The :code:`fidget-spinner` icon.
        FILE (IconName): The :code:`file` icon.
        FILE_3D (IconName): The :code:`file-3d` icon.
        FILE_ALERT (IconName): The :code:`file-alert` icon.
        FILE_ANALYTICS (IconName): The :code:`file-analytics` icon.
        FILE_ARROW_LEFT (IconName): The :code:`file-arrow-left` icon.
        FILE_ARROW_RIGHT (IconName): The :code:`file-arrow-right` icon.
        FILE_BARCODE (IconName): The :code:`file-barcode` icon.
        FILE_BROKEN (IconName): The :code:`file-broken` icon.
        FILE_CERTIFICATE (IconName): The :code:`file-certificate` icon.
        FILE_CHART (IconName): The :code:`file-chart` icon.
        FILE_CHECK (IconName): The :code:`file-check` icon.
        FILE_CODE (IconName): The :code:`file-code` icon.
        FILE_CODE_2 (IconName): The :code:`file-code-2` icon.
        FILE_CV (IconName): The :code:`file-cv` icon.
        FILE_DATABASE (IconName): The :code:`file-database` icon.
        FILE_DELTA (IconName): The :code:`file-delta` icon.
        FILE_DESCRIPTION (IconName): The :code:`file-description` icon.
        FILE_DIFF (IconName): The :code:`file-diff` icon.
        FILE_DIGIT (IconName): The :code:`file-digit` icon.
        FILE_DISLIKE (IconName): The :code:`file-dislike` icon.
        FILE_DOLLAR (IconName): The :code:`file-dollar` icon.
        FILE_DOTS (IconName): The :code:`file-dots` icon.
        FILE_DOWNLOAD (IconName): The :code:`file-download` icon.
        FILE_EURO (IconName): The :code:`file-euro` icon.
        FILE_EXPORT (IconName): The :code:`file-export` icon.
        FILE_FILLED (IconName): The :code:`file-filled` icon.
        FILE_FUNCTION (IconName): The :code:`file-function` icon.
        FILE_HORIZONTAL (IconName): The :code:`file-horizontal` icon.
        FILE_IMPORT (IconName): The :code:`file-import` icon.
        FILE_INFINITY (IconName): The :code:`file-infinity` icon.
        FILE_INFO (IconName): The :code:`file-info` icon.
        FILE_INVOICE (IconName): The :code:`file-invoice` icon.
        FILE_LAMBDA (IconName): The :code:`file-lambda` icon.
        FILE_LIKE (IconName): The :code:`file-like` icon.
        FILE_MINUS (IconName): The :code:`file-minus` icon.
        FILE_MUSIC (IconName): The :code:`file-music` icon.
        FILE_OFF (IconName): The :code:`file-off` icon.
        FILE_ORIENTATION (IconName): The :code:`file-orientation` icon.
        FILE_PENCIL (IconName): The :code:`file-pencil` icon.
        FILE_PERCENT (IconName): The :code:`file-percent` icon.
        FILE_PHONE (IconName): The :code:`file-phone` icon.
        FILE_PLUS (IconName): The :code:`file-plus` icon.
        FILE_POWER (IconName): The :code:`file-power` icon.
        FILE_REPORT (IconName): The :code:`file-report` icon.
        FILE_RSS (IconName): The :code:`file-rss` icon.
        FILE_SCISSORS (IconName): The :code:`file-scissors` icon.
        FILE_SEARCH (IconName): The :code:`file-search` icon.
        FILE_SETTINGS (IconName): The :code:`file-settings` icon.
        FILE_SHREDDER (IconName): The :code:`file-shredder` icon.
        FILE_SIGNAL (IconName): The :code:`file-signal` icon.
        FILE_SPREADSHEET (IconName): The :code:`file-spreadsheet` icon.
        FILE_STACK (IconName): The :code:`file-stack` icon.
        FILE_STAR (IconName): The :code:`file-star` icon.
        FILE_SYMLINK (IconName): The :code:`file-symlink` icon.
        FILE_TEXT (IconName): The :code:`file-text` icon.
        FILE_TEXT_AI (IconName): The :code:`file-text-ai` icon.
        FILE_TIME (IconName): The :code:`file-time` icon.
        FILE_TYPOGRAPHY (IconName): The :code:`file-typography` icon.
        FILE_UNKNOWN (IconName): The :code:`file-unknown` icon.
        FILE_UPLOAD (IconName): The :code:`file-upload` icon.
        FILE_VECTOR (IconName): The :code:`file-vector` icon.
        FILE_X (IconName): The :code:`file-x` icon.
        FILE_X_FILLED (IconName): The :code:`file-x-filled` icon.
        FILE_ZIP (IconName): The :code:`file-zip` icon.
        FILES (IconName): The :code:`files` icon.
        FILES_OFF (IconName): The :code:`files-off` icon.
        FILTER (IconName): The :code:`filter` icon.
        FILTER_COG (IconName): The :code:`filter-cog` icon.
        FILTER_DOLLAR (IconName): The :code:`filter-dollar` icon.
        FILTER_EDIT (IconName): The :code:`filter-edit` icon.
        FILTER_MINUS (IconName): The :code:`filter-minus` icon.
        FILTER_OFF (IconName): The :code:`filter-off` icon.
        FILTER_PLUS (IconName): The :code:`filter-plus` icon.
        FILTER_STAR (IconName): The :code:`filter-star` icon.
        FILTER_X (IconName): The :code:`filter-x` icon.
        FILTERS (IconName): The :code:`filters` icon.
        FINGERPRINT (IconName): The :code:`fingerprint` icon.
        FINGERPRINT_OFF (IconName): The :code:`fingerprint-off` icon.
        FIRE_EXTINGUISHER (IconName): The :code:`fire-extinguisher` icon.
        FIRE_HYDRANT (IconName): The :code:`fire-hydrant` icon.
        FIRE_HYDRANT_OFF (IconName): The :code:`fire-hydrant-off` icon.
        FIRETRUCK (IconName): The :code:`firetruck` icon.
        FIRST_AID_KIT (IconName): The :code:`first-aid-kit` icon.
        FIRST_AID_KIT_OFF (IconName): The :code:`first-aid-kit-off` icon.
        FISH (IconName): The :code:`fish` icon.
        FISH_BONE (IconName): The :code:`fish-bone` icon.
        FISH_CHRISTIANITY (IconName): The :code:`fish-christianity` icon.
        FISH_HOOK (IconName): The :code:`fish-hook` icon.
        FISH_HOOK_OFF (IconName): The :code:`fish-hook-off` icon.
        FISH_OFF (IconName): The :code:`fish-off` icon.
        FLAG (IconName): The :code:`flag` icon.
        FLAG_2 (IconName): The :code:`flag-2` icon.
        FLAG_2_FILLED (IconName): The :code:`flag-2-filled` icon.
        FLAG_2_OFF (IconName): The :code:`flag-2-off` icon.
        FLAG_3 (IconName): The :code:`flag-3` icon.
        FLAG_3_FILLED (IconName): The :code:`flag-3-filled` icon.
        FLAG_FILLED (IconName): The :code:`flag-filled` icon.
        FLAG_OFF (IconName): The :code:`flag-off` icon.
        FLAME (IconName): The :code:`flame` icon.
        FLAME_OFF (IconName): The :code:`flame-off` icon.
        FLARE (IconName): The :code:`flare` icon.
        FLASK (IconName): The :code:`flask` icon.
        FLASK_2 (IconName): The :code:`flask-2` icon.
        FLASK_2_OFF (IconName): The :code:`flask-2-off` icon.
        FLASK_OFF (IconName): The :code:`flask-off` icon.
        FLIP_FLOPS (IconName): The :code:`flip-flops` icon.
        FLIP_HORIZONTAL (IconName): The :code:`flip-horizontal` icon.
        FLIP_VERTICAL (IconName): The :code:`flip-vertical` icon.
        FLOAT_CENTER (IconName): The :code:`float-center` icon.
        FLOAT_LEFT (IconName): The :code:`float-left` icon.
        FLOAT_NONE (IconName): The :code:`float-none` icon.
        FLOAT_RIGHT (IconName): The :code:`float-right` icon.
        FLOWER (IconName): The :code:`flower` icon.
        FLOWER_OFF (IconName): The :code:`flower-off` icon.
        FOCUS (IconName): The :code:`focus` icon.
        FOCUS_2 (IconName): The :code:`focus-2` icon.
        FOCUS_AUTO (IconName): The :code:`focus-auto` icon.
        FOCUS_CENTERED (IconName): The :code:`focus-centered` icon.
        FOLD (IconName): The :code:`fold` icon.
        FOLD_DOWN (IconName): The :code:`fold-down` icon.
        FOLD_UP (IconName): The :code:`fold-up` icon.
        FOLDER (IconName): The :code:`folder` icon.
        FOLDER_BOLT (IconName): The :code:`folder-bolt` icon.
        FOLDER_CANCEL (IconName): The :code:`folder-cancel` icon.
        FOLDER_CHECK (IconName): The :code:`folder-check` icon.
        FOLDER_CODE (IconName): The :code:`folder-code` icon.
        FOLDER_COG (IconName): The :code:`folder-cog` icon.
        FOLDER_DOLLAR (IconName): The :code:`folder-dollar` icon.
        FOLDER_DOWN (IconName): The :code:`folder-down` icon.
        FOLDER_EXCLAMATION (IconName): The :code:`folder-exclamation` icon.
        FOLDER_FILLED (IconName): The :code:`folder-filled` icon.
        FOLDER_HEART (IconName): The :code:`folder-heart` icon.
        FOLDER_MINUS (IconName): The :code:`folder-minus` icon.
        FOLDER_OFF (IconName): The :code:`folder-off` icon.
        FOLDER_OPEN (IconName): The :code:`folder-open` icon.
        FOLDER_PAUSE (IconName): The :code:`folder-pause` icon.
        FOLDER_PIN (IconName): The :code:`folder-pin` icon.
        FOLDER_PLUS (IconName): The :code:`folder-plus` icon.
        FOLDER_QUESTION (IconName): The :code:`folder-question` icon.
        FOLDER_SEARCH (IconName): The :code:`folder-search` icon.
        FOLDER_SHARE (IconName): The :code:`folder-share` icon.
        FOLDER_STAR (IconName): The :code:`folder-star` icon.
        FOLDER_SYMLINK (IconName): The :code:`folder-symlink` icon.
        FOLDER_UP (IconName): The :code:`folder-up` icon.
        FOLDER_X (IconName): The :code:`folder-x` icon.
        FOLDERS (IconName): The :code:`folders` icon.
        FOLDERS_OFF (IconName): The :code:`folders-off` icon.
        FORBID (IconName): The :code:`forbid` icon.
        FORBID_2 (IconName): The :code:`forbid-2` icon.
        FORKLIFT (IconName): The :code:`forklift` icon.
        FORMS (IconName): The :code:`forms` icon.
        FOUNTAIN (IconName): The :code:`fountain` icon.
        FOUNTAIN_OFF (IconName): The :code:`fountain-off` icon.
        FRAME (IconName): The :code:`frame` icon.
        FRAME_OFF (IconName): The :code:`frame-off` icon.
        FREE_RIGHTS (IconName): The :code:`free-rights` icon.
        FREEZE_COLUMN (IconName): The :code:`freeze-column` icon.
        FREEZE_ROW (IconName): The :code:`freeze-row` icon.
        FREEZE_ROW_COLUMN (IconName): The :code:`freeze-row-column` icon.
        FRIDGE (IconName): The :code:`fridge` icon.
        FRIDGE_OFF (IconName): The :code:`fridge-off` icon.
        FRIENDS (IconName): The :code:`friends` icon.
        FRIENDS_OFF (IconName): The :code:`friends-off` icon.
        FRUSTUM (IconName): The :code:`frustum` icon.
        FRUSTUM_OFF (IconName): The :code:`frustum-off` icon.
        FRUSTUM_PLUS (IconName): The :code:`frustum-plus` icon.
        FUNCTION (IconName): The :code:`function` icon.
        FUNCTION_OFF (IconName): The :code:`function-off` icon.
        GARDEN_CART (IconName): The :code:`garden-cart` icon.
        GARDEN_CART_OFF (IconName): The :code:`garden-cart-off` icon.
        GAS_STATION (IconName): The :code:`gas-station` icon.
        GAS_STATION_OFF (IconName): The :code:`gas-station-off` icon.
        GAUGE (IconName): The :code:`gauge` icon.
        GAUGE_OFF (IconName): The :code:`gauge-off` icon.
        GAVEL (IconName): The :code:`gavel` icon.
        GENDER_AGENDER (IconName): The :code:`gender-agender` icon.
        GENDER_ANDROGYNE (IconName): The :code:`gender-androgyne` icon.
        GENDER_BIGENDER (IconName): The :code:`gender-bigender` icon.
        GENDER_DEMIBOY (IconName): The :code:`gender-demiboy` icon.
        GENDER_DEMIGIRL (IconName): The :code:`gender-demigirl` icon.
        GENDER_EPICENE (IconName): The :code:`gender-epicene` icon.
        GENDER_FEMALE (IconName): The :code:`gender-female` icon.
        GENDER_FEMME (IconName): The :code:`gender-femme` icon.
        GENDER_GENDERFLUID (IconName): The :code:`gender-genderfluid` icon.
        GENDER_GENDERLESS (IconName): The :code:`gender-genderless` icon.
        GENDER_GENDERQUEER (IconName): The :code:`gender-genderqueer` icon.
        GENDER_HERMAPHRODITE (IconName): The :code:`gender-hermaphrodite` icon.
        GENDER_INTERGENDER (IconName): The :code:`gender-intergender` icon.
        GENDER_MALE (IconName): The :code:`gender-male` icon.
        GENDER_NEUTROIS (IconName): The :code:`gender-neutrois` icon.
        GENDER_THIRD (IconName): The :code:`gender-third` icon.
        GENDER_TRANSGENDER (IconName): The :code:`gender-transgender` icon.
        GENDER_TRASVESTI (IconName): The :code:`gender-trasvesti` icon.
        GEOMETRY (IconName): The :code:`geometry` icon.
        GHOST (IconName): The :code:`ghost` icon.
        GHOST_2 (IconName): The :code:`ghost-2` icon.
        GHOST_2_FILLED (IconName): The :code:`ghost-2-filled` icon.
        GHOST_FILLED (IconName): The :code:`ghost-filled` icon.
        GHOST_OFF (IconName): The :code:`ghost-off` icon.
        GIF (IconName): The :code:`gif` icon.
        GIFT (IconName): The :code:`gift` icon.
        GIFT_CARD (IconName): The :code:`gift-card` icon.
        GIFT_OFF (IconName): The :code:`gift-off` icon.
        GIT_BRANCH (IconName): The :code:`git-branch` icon.
        GIT_BRANCH_DELETED (IconName): The :code:`git-branch-deleted` icon.
        GIT_CHERRY_PICK (IconName): The :code:`git-cherry-pick` icon.
        GIT_COMMIT (IconName): The :code:`git-commit` icon.
        GIT_COMPARE (IconName): The :code:`git-compare` icon.
        GIT_FORK (IconName): The :code:`git-fork` icon.
        GIT_MERGE (IconName): The :code:`git-merge` icon.
        GIT_PULL_REQUEST (IconName): The :code:`git-pull-request` icon.
        GIT_PULL_REQUEST_CLOSED (IconName): The :code:`git-pull-request-closed` icon.
        GIT_PULL_REQUEST_DRAFT (IconName): The :code:`git-pull-request-draft` icon.
        GIZMO (IconName): The :code:`gizmo` icon.
        GLASS (IconName): The :code:`glass` icon.
        GLASS_FULL (IconName): The :code:`glass-full` icon.
        GLASS_OFF (IconName): The :code:`glass-off` icon.
        GLOBE (IconName): The :code:`globe` icon.
        GLOBE_OFF (IconName): The :code:`globe-off` icon.
        GO_GAME (IconName): The :code:`go-game` icon.
        GOLF (IconName): The :code:`golf` icon.
        GOLF_OFF (IconName): The :code:`golf-off` icon.
        GPS (IconName): The :code:`gps` icon.
        GRADIENTER (IconName): The :code:`gradienter` icon.
        GRAIN (IconName): The :code:`grain` icon.
        GRAPH (IconName): The :code:`graph` icon.
        GRAPH_OFF (IconName): The :code:`graph-off` icon.
        GRAVE (IconName): The :code:`grave` icon.
        GRAVE_2 (IconName): The :code:`grave-2` icon.
        GRID_DOTS (IconName): The :code:`grid-dots` icon.
        GRID_PATTERN (IconName): The :code:`grid-pattern` icon.
        GRILL (IconName): The :code:`grill` icon.
        GRILL_FORK (IconName): The :code:`grill-fork` icon.
        GRILL_OFF (IconName): The :code:`grill-off` icon.
        GRILL_SPATULA (IconName): The :code:`grill-spatula` icon.
        GRIP_HORIZONTAL (IconName): The :code:`grip-horizontal` icon.
        GRIP_VERTICAL (IconName): The :code:`grip-vertical` icon.
        GROWTH (IconName): The :code:`growth` icon.
        GUITAR_PICK (IconName): The :code:`guitar-pick` icon.
        GUITAR_PICK_FILLED (IconName): The :code:`guitar-pick-filled` icon.
        H_1 (IconName): The :code:`h-1` icon.
        H_2 (IconName): The :code:`h-2` icon.
        H_3 (IconName): The :code:`h-3` icon.
        H_4 (IconName): The :code:`h-4` icon.
        H_5 (IconName): The :code:`h-5` icon.
        H_6 (IconName): The :code:`h-6` icon.
        HAMMER (IconName): The :code:`hammer` icon.
        HAMMER_OFF (IconName): The :code:`hammer-off` icon.
        HAND_CLICK (IconName): The :code:`hand-click` icon.
        HAND_FINGER (IconName): The :code:`hand-finger` icon.
        HAND_FINGER_OFF (IconName): The :code:`hand-finger-off` icon.
        HAND_GRAB (IconName): The :code:`hand-grab` icon.
        HAND_LITTLE_FINGER (IconName): The :code:`hand-little-finger` icon.
        HAND_MIDDLE_FINGER (IconName): The :code:`hand-middle-finger` icon.
        HAND_MOVE (IconName): The :code:`hand-move` icon.
        HAND_OFF (IconName): The :code:`hand-off` icon.
        HAND_RING_FINGER (IconName): The :code:`hand-ring-finger` icon.
        HAND_ROCK (IconName): The :code:`hand-rock` icon.
        HAND_SANITIZER (IconName): The :code:`hand-sanitizer` icon.
        HAND_STOP (IconName): The :code:`hand-stop` icon.
        HAND_THREE_FINGERS (IconName): The :code:`hand-three-fingers` icon.
        HAND_TWO_FINGERS (IconName): The :code:`hand-two-fingers` icon.
        HANGER (IconName): The :code:`hanger` icon.
        HANGER_2 (IconName): The :code:`hanger-2` icon.
        HANGER_OFF (IconName): The :code:`hanger-off` icon.
        HASH (IconName): The :code:`hash` icon.
        HAZE (IconName): The :code:`haze` icon.
        HAZE_MOON (IconName): The :code:`haze-moon` icon.
        HDR (IconName): The :code:`hdr` icon.
        HEADING (IconName): The :code:`heading` icon.
        HEADING_OFF (IconName): The :code:`heading-off` icon.
        HEADPHONES (IconName): The :code:`headphones` icon.
        HEADPHONES_FILLED (IconName): The :code:`headphones-filled` icon.
        HEADPHONES_OFF (IconName): The :code:`headphones-off` icon.
        HEADSET (IconName): The :code:`headset` icon.
        HEADSET_OFF (IconName): The :code:`headset-off` icon.
        HEALTH_RECOGNITION (IconName): The :code:`health-recognition` icon.
        HEART (IconName): The :code:`heart` icon.
        HEART_BROKEN (IconName): The :code:`heart-broken` icon.
        HEART_FILLED (IconName): The :code:`heart-filled` icon.
        HEART_HANDSHAKE (IconName): The :code:`heart-handshake` icon.
        HEART_MINUS (IconName): The :code:`heart-minus` icon.
        HEART_OFF (IconName): The :code:`heart-off` icon.
        HEART_PLUS (IconName): The :code:`heart-plus` icon.
        HEART_RATE_MONITOR (IconName): The :code:`heart-rate-monitor` icon.
        HEARTBEAT (IconName): The :code:`heartbeat` icon.
        HEARTS (IconName): The :code:`hearts` icon.
        HEARTS_OFF (IconName): The :code:`hearts-off` icon.
        HELICOPTER (IconName): The :code:`helicopter` icon.
        HELICOPTER_LANDING (IconName): The :code:`helicopter-landing` icon.
        HELMET (IconName): The :code:`helmet` icon.
        HELMET_OFF (IconName): The :code:`helmet-off` icon.
        HELP (IconName): The :code:`help` icon.
        HELP_CIRCLE (IconName): The :code:`help-circle` icon.
        HELP_CIRCLE_FILLED (IconName): The :code:`help-circle-filled` icon.
        HELP_HEXAGON (IconName): The :code:`help-hexagon` icon.
        HELP_HEXAGON_FILLED (IconName): The :code:`help-hexagon-filled` icon.
        HELP_OCTAGON (IconName): The :code:`help-octagon` icon.
        HELP_OCTAGON_FILLED (IconName): The :code:`help-octagon-filled` icon.
        HELP_OFF (IconName): The :code:`help-off` icon.
        HELP_SMALL (IconName): The :code:`help-small` icon.
        HELP_SQUARE (IconName): The :code:`help-square` icon.
        HELP_SQUARE_FILLED (IconName): The :code:`help-square-filled` icon.
        HELP_SQUARE_ROUNDED (IconName): The :code:`help-square-rounded` icon.
        HELP_SQUARE_ROUNDED_FILLED (IconName): The :code:`help-square-rounded-filled` icon.
        HELP_TRIANGLE (IconName): The :code:`help-triangle` icon.
        HELP_TRIANGLE_FILLED (IconName): The :code:`help-triangle-filled` icon.
        HEMISPHERE (IconName): The :code:`hemisphere` icon.
        HEMISPHERE_OFF (IconName): The :code:`hemisphere-off` icon.
        HEMISPHERE_PLUS (IconName): The :code:`hemisphere-plus` icon.
        HEXAGON (IconName): The :code:`hexagon` icon.
        HEXAGON_0_FILLED (IconName): The :code:`hexagon-0-filled` icon.
        HEXAGON_1_FILLED (IconName): The :code:`hexagon-1-filled` icon.
        HEXAGON_2_FILLED (IconName): The :code:`hexagon-2-filled` icon.
        HEXAGON_3_FILLED (IconName): The :code:`hexagon-3-filled` icon.
        HEXAGON_3D (IconName): The :code:`hexagon-3d` icon.
        HEXAGON_4_FILLED (IconName): The :code:`hexagon-4-filled` icon.
        HEXAGON_5_FILLED (IconName): The :code:`hexagon-5-filled` icon.
        HEXAGON_6_FILLED (IconName): The :code:`hexagon-6-filled` icon.
        HEXAGON_7_FILLED (IconName): The :code:`hexagon-7-filled` icon.
        HEXAGON_8_FILLED (IconName): The :code:`hexagon-8-filled` icon.
        HEXAGON_9_FILLED (IconName): The :code:`hexagon-9-filled` icon.
        HEXAGON_FILLED (IconName): The :code:`hexagon-filled` icon.
        HEXAGON_LETTER_A (IconName): The :code:`hexagon-letter-a` icon.
        HEXAGON_LETTER_B (IconName): The :code:`hexagon-letter-b` icon.
        HEXAGON_LETTER_C (IconName): The :code:`hexagon-letter-c` icon.
        HEXAGON_LETTER_D (IconName): The :code:`hexagon-letter-d` icon.
        HEXAGON_LETTER_E (IconName): The :code:`hexagon-letter-e` icon.
        HEXAGON_LETTER_F (IconName): The :code:`hexagon-letter-f` icon.
        HEXAGON_LETTER_G (IconName): The :code:`hexagon-letter-g` icon.
        HEXAGON_LETTER_H (IconName): The :code:`hexagon-letter-h` icon.
        HEXAGON_LETTER_I (IconName): The :code:`hexagon-letter-i` icon.
        HEXAGON_LETTER_J (IconName): The :code:`hexagon-letter-j` icon.
        HEXAGON_LETTER_K (IconName): The :code:`hexagon-letter-k` icon.
        HEXAGON_LETTER_L (IconName): The :code:`hexagon-letter-l` icon.
        HEXAGON_LETTER_M (IconName): The :code:`hexagon-letter-m` icon.
        HEXAGON_LETTER_N (IconName): The :code:`hexagon-letter-n` icon.
        HEXAGON_LETTER_O (IconName): The :code:`hexagon-letter-o` icon.
        HEXAGON_LETTER_P (IconName): The :code:`hexagon-letter-p` icon.
        HEXAGON_LETTER_Q (IconName): The :code:`hexagon-letter-q` icon.
        HEXAGON_LETTER_R (IconName): The :code:`hexagon-letter-r` icon.
        HEXAGON_LETTER_S (IconName): The :code:`hexagon-letter-s` icon.
        HEXAGON_LETTER_T (IconName): The :code:`hexagon-letter-t` icon.
        HEXAGON_LETTER_U (IconName): The :code:`hexagon-letter-u` icon.
        HEXAGON_LETTER_V (IconName): The :code:`hexagon-letter-v` icon.
        HEXAGON_LETTER_W (IconName): The :code:`hexagon-letter-w` icon.
        HEXAGON_LETTER_X (IconName): The :code:`hexagon-letter-x` icon.
        HEXAGON_LETTER_Y (IconName): The :code:`hexagon-letter-y` icon.
        HEXAGON_LETTER_Z (IconName): The :code:`hexagon-letter-z` icon.
        HEXAGON_NUMBER_0 (IconName): The :code:`hexagon-number-0` icon.
        HEXAGON_NUMBER_1 (IconName): The :code:`hexagon-number-1` icon.
        HEXAGON_NUMBER_2 (IconName): The :code:`hexagon-number-2` icon.
        HEXAGON_NUMBER_3 (IconName): The :code:`hexagon-number-3` icon.
        HEXAGON_NUMBER_4 (IconName): The :code:`hexagon-number-4` icon.
        HEXAGON_NUMBER_5 (IconName): The :code:`hexagon-number-5` icon.
        HEXAGON_NUMBER_6 (IconName): The :code:`hexagon-number-6` icon.
        HEXAGON_NUMBER_7 (IconName): The :code:`hexagon-number-7` icon.
        HEXAGON_NUMBER_8 (IconName): The :code:`hexagon-number-8` icon.
        HEXAGON_NUMBER_9 (IconName): The :code:`hexagon-number-9` icon.
        HEXAGON_OFF (IconName): The :code:`hexagon-off` icon.
        HEXAGONAL_PRISM (IconName): The :code:`hexagonal-prism` icon.
        HEXAGONAL_PRISM_OFF (IconName): The :code:`hexagonal-prism-off` icon.
        HEXAGONAL_PRISM_PLUS (IconName): The :code:`hexagonal-prism-plus` icon.
        HEXAGONAL_PYRAMID (IconName): The :code:`hexagonal-pyramid` icon.
        HEXAGONAL_PYRAMID_OFF (IconName): The :code:`hexagonal-pyramid-off` icon.
        HEXAGONAL_PYRAMID_PLUS (IconName): The :code:`hexagonal-pyramid-plus` icon.
        HEXAGONS (IconName): The :code:`hexagons` icon.
        HEXAGONS_OFF (IconName): The :code:`hexagons-off` icon.
        HIERARCHY (IconName): The :code:`hierarchy` icon.
        HIERARCHY_2 (IconName): The :code:`hierarchy-2` icon.
        HIERARCHY_3 (IconName): The :code:`hierarchy-3` icon.
        HIERARCHY_OFF (IconName): The :code:`hierarchy-off` icon.
        HIGHLIGHT (IconName): The :code:`highlight` icon.
        HIGHLIGHT_OFF (IconName): The :code:`highlight-off` icon.
        HISTORY (IconName): The :code:`history` icon.
        HISTORY_OFF (IconName): The :code:`history-off` icon.
        HISTORY_TOGGLE (IconName): The :code:`history-toggle` icon.
        HOME (IconName): The :code:`home` icon.
        HOME_2 (IconName): The :code:`home-2` icon.
        HOME_BOLT (IconName): The :code:`home-bolt` icon.
        HOME_CANCEL (IconName): The :code:`home-cancel` icon.
        HOME_CHECK (IconName): The :code:`home-check` icon.
        HOME_COG (IconName): The :code:`home-cog` icon.
        HOME_DOLLAR (IconName): The :code:`home-dollar` icon.
        HOME_DOT (IconName): The :code:`home-dot` icon.
        HOME_DOWN (IconName): The :code:`home-down` icon.
        HOME_ECO (IconName): The :code:`home-eco` icon.
        HOME_EDIT (IconName): The :code:`home-edit` icon.
        HOME_EXCLAMATION (IconName): The :code:`home-exclamation` icon.
        HOME_HAND (IconName): The :code:`home-hand` icon.
        HOME_HEART (IconName): The :code:`home-heart` icon.
        HOME_INFINITY (IconName): The :code:`home-infinity` icon.
        HOME_LINK (IconName): The :code:`home-link` icon.
        HOME_MINUS (IconName): The :code:`home-minus` icon.
        HOME_MOVE (IconName): The :code:`home-move` icon.
        HOME_OFF (IconName): The :code:`home-off` icon.
        HOME_PLUS (IconName): The :code:`home-plus` icon.
        HOME_QUESTION (IconName): The :code:`home-question` icon.
        HOME_RIBBON (IconName): The :code:`home-ribbon` icon.
        HOME_SEARCH (IconName): The :code:`home-search` icon.
        HOME_SHARE (IconName): The :code:`home-share` icon.
        HOME_SHIELD (IconName): The :code:`home-shield` icon.
        HOME_SIGNAL (IconName): The :code:`home-signal` icon.
        HOME_STAR (IconName): The :code:`home-star` icon.
        HOME_STATS (IconName): The :code:`home-stats` icon.
        HOME_UP (IconName): The :code:`home-up` icon.
        HOME_X (IconName): The :code:`home-x` icon.
        HORSE_TOY (IconName): The :code:`horse-toy` icon.
        HOTEL_SERVICE (IconName): The :code:`hotel-service` icon.
        HOURGLASS (IconName): The :code:`hourglass` icon.
        HOURGLASS_EMPTY (IconName): The :code:`hourglass-empty` icon.
        HOURGLASS_FILLED (IconName): The :code:`hourglass-filled` icon.
        HOURGLASS_HIGH (IconName): The :code:`hourglass-high` icon.
        HOURGLASS_LOW (IconName): The :code:`hourglass-low` icon.
        HOURGLASS_OFF (IconName): The :code:`hourglass-off` icon.
        HTML (IconName): The :code:`html` icon.
        HTTP_CONNECT (IconName): The :code:`http-connect` icon.
        HTTP_DELETE (IconName): The :code:`http-delete` icon.
        HTTP_GET (IconName): The :code:`http-get` icon.
        HTTP_HEAD (IconName): The :code:`http-head` icon.
        HTTP_OPTIONS (IconName): The :code:`http-options` icon.
        HTTP_PATCH (IconName): The :code:`http-patch` icon.
        HTTP_POST (IconName): The :code:`http-post` icon.
        HTTP_PUT (IconName): The :code:`http-put` icon.
        HTTP_QUE (IconName): The :code:`http-que` icon.
        HTTP_TRACE (IconName): The :code:`http-trace` icon.
        ICE_CREAM (IconName): The :code:`ice-cream` icon.
        ICE_CREAM_2 (IconName): The :code:`ice-cream-2` icon.
        ICE_CREAM_OFF (IconName): The :code:`ice-cream-off` icon.
        ICE_SKATING (IconName): The :code:`ice-skating` icon.
        ICONS (IconName): The :code:`icons` icon.
        ICONS_OFF (IconName): The :code:`icons-off` icon.
        ID (IconName): The :code:`id` icon.
        ID_BADGE (IconName): The :code:`id-badge` icon.
        ID_BADGE_2 (IconName): The :code:`id-badge-2` icon.
        ID_BADGE_OFF (IconName): The :code:`id-badge-off` icon.
        ID_OFF (IconName): The :code:`id-off` icon.
        INBOX (IconName): The :code:`inbox` icon.
        INBOX_OFF (IconName): The :code:`inbox-off` icon.
        INDENT_DECREASE (IconName): The :code:`indent-decrease` icon.
        INDENT_INCREASE (IconName): The :code:`indent-increase` icon.
        INFINITY (IconName): The :code:`infinity` icon.
        INFINITY_OFF (IconName): The :code:`infinity-off` icon.
        INFO_CIRCLE (IconName): The :code:`info-circle` icon.
        INFO_CIRCLE_FILLED (IconName): The :code:`info-circle-filled` icon.
        INFO_HEXAGON (IconName): The :code:`info-hexagon` icon.
        INFO_HEXAGON_FILLED (IconName): The :code:`info-hexagon-filled` icon.
        INFO_OCTAGON (IconName): The :code:`info-octagon` icon.
        INFO_OCTAGON_FILLED (IconName): The :code:`info-octagon-filled` icon.
        INFO_SMALL (IconName): The :code:`info-small` icon.
        INFO_SQUARE (IconName): The :code:`info-square` icon.
        INFO_SQUARE_FILLED (IconName): The :code:`info-square-filled` icon.
        INFO_SQUARE_ROUNDED (IconName): The :code:`info-square-rounded` icon.
        INFO_SQUARE_ROUNDED_FILLED (IconName): The :code:`info-square-rounded-filled` icon.
        INFO_TRIANGLE (IconName): The :code:`info-triangle` icon.
        INFO_TRIANGLE_FILLED (IconName): The :code:`info-triangle-filled` icon.
        INNER_SHADOW_BOTTOM (IconName): The :code:`inner-shadow-bottom` icon.
        INNER_SHADOW_BOTTOM_FILLED (IconName): The :code:`inner-shadow-bottom-filled` icon.
        INNER_SHADOW_BOTTOM_LEFT (IconName): The :code:`inner-shadow-bottom-left` icon.
        INNER_SHADOW_BOTTOM_LEFT_FILLED (IconName): The :code:`inner-shadow-bottom-left-filled` icon.
        INNER_SHADOW_BOTTOM_RIGHT (IconName): The :code:`inner-shadow-bottom-right` icon.
        INNER_SHADOW_BOTTOM_RIGHT_FILLED (IconName): The :code:`inner-shadow-bottom-right-filled` icon.
        INNER_SHADOW_LEFT (IconName): The :code:`inner-shadow-left` icon.
        INNER_SHADOW_LEFT_FILLED (IconName): The :code:`inner-shadow-left-filled` icon.
        INNER_SHADOW_RIGHT (IconName): The :code:`inner-shadow-right` icon.
        INNER_SHADOW_RIGHT_FILLED (IconName): The :code:`inner-shadow-right-filled` icon.
        INNER_SHADOW_TOP (IconName): The :code:`inner-shadow-top` icon.
        INNER_SHADOW_TOP_FILLED (IconName): The :code:`inner-shadow-top-filled` icon.
        INNER_SHADOW_TOP_LEFT (IconName): The :code:`inner-shadow-top-left` icon.
        INNER_SHADOW_TOP_LEFT_FILLED (IconName): The :code:`inner-shadow-top-left-filled` icon.
        INNER_SHADOW_TOP_RIGHT (IconName): The :code:`inner-shadow-top-right` icon.
        INNER_SHADOW_TOP_RIGHT_FILLED (IconName): The :code:`inner-shadow-top-right-filled` icon.
        INPUT_SEARCH (IconName): The :code:`input-search` icon.
        IRONING (IconName): The :code:`ironing` icon.
        IRONING_1 (IconName): The :code:`ironing-1` icon.
        IRONING_2 (IconName): The :code:`ironing-2` icon.
        IRONING_3 (IconName): The :code:`ironing-3` icon.
        IRONING_OFF (IconName): The :code:`ironing-off` icon.
        IRONING_STEAM (IconName): The :code:`ironing-steam` icon.
        IRONING_STEAM_OFF (IconName): The :code:`ironing-steam-off` icon.
        IRREGULAR_POLYHEDRON (IconName): The :code:`irregular-polyhedron` icon.
        IRREGULAR_POLYHEDRON_OFF (IconName): The :code:`irregular-polyhedron-off` icon.
        IRREGULAR_POLYHEDRON_PLUS (IconName): The :code:`irregular-polyhedron-plus` icon.
        ITALIC (IconName): The :code:`italic` icon.
        JACKET (IconName): The :code:`jacket` icon.
        JETPACK (IconName): The :code:`jetpack` icon.
        JEWISH_STAR (IconName): The :code:`jewish-star` icon.
        JEWISH_STAR_FILLED (IconName): The :code:`jewish-star-filled` icon.
        JPG (IconName): The :code:`jpg` icon.
        JSON (IconName): The :code:`json` icon.
        JUMP_ROPE (IconName): The :code:`jump-rope` icon.
        KARATE (IconName): The :code:`karate` icon.
        KAYAK (IconName): The :code:`kayak` icon.
        KERING (IconName): The :code:`kering` icon.
        KEY (IconName): The :code:`key` icon.
        KEY_OFF (IconName): The :code:`key-off` icon.
        KEYBOARD (IconName): The :code:`keyboard` icon.
        KEYBOARD_HIDE (IconName): The :code:`keyboard-hide` icon.
        KEYBOARD_OFF (IconName): The :code:`keyboard-off` icon.
        KEYBOARD_SHOW (IconName): The :code:`keyboard-show` icon.
        KEYFRAME (IconName): The :code:`keyframe` icon.
        KEYFRAME_ALIGN_CENTER (IconName): The :code:`keyframe-align-center` icon.
        KEYFRAME_ALIGN_HORIZONTAL (IconName): The :code:`keyframe-align-horizontal` icon.
        KEYFRAME_ALIGN_VERTICAL (IconName): The :code:`keyframe-align-vertical` icon.
        KEYFRAMES (IconName): The :code:`keyframes` icon.
        LADDER (IconName): The :code:`ladder` icon.
        LADDER_OFF (IconName): The :code:`ladder-off` icon.
        LAMBDA (IconName): The :code:`lambda` icon.
        LAMP (IconName): The :code:`lamp` icon.
        LAMP_2 (IconName): The :code:`lamp-2` icon.
        LAMP_OFF (IconName): The :code:`lamp-off` icon.
        LANE (IconName): The :code:`lane` icon.
        LANGUAGE (IconName): The :code:`language` icon.
        LANGUAGE_HIRAGANA (IconName): The :code:`language-hiragana` icon.
        LANGUAGE_KATAKANA (IconName): The :code:`language-katakana` icon.
        LANGUAGE_OFF (IconName): The :code:`language-off` icon.
        LASSO (IconName): The :code:`lasso` icon.
        LASSO_OFF (IconName): The :code:`lasso-off` icon.
        LASSO_POLYGON (IconName): The :code:`lasso-polygon` icon.
        LAYERS_DIFFERENCE (IconName): The :code:`layers-difference` icon.
        LAYERS_INTERSECT (IconName): The :code:`layers-intersect` icon.
        LAYERS_INTERSECT_2 (IconName): The :code:`layers-intersect-2` icon.
        LAYERS_LINKED (IconName): The :code:`layers-linked` icon.
        LAYERS_OFF (IconName): The :code:`layers-off` icon.
        LAYERS_SUBTRACT (IconName): The :code:`layers-subtract` icon.
        LAYERS_UNION (IconName): The :code:`layers-union` icon.
        LAYOUT (IconName): The :code:`layout` icon.
        LAYOUT_2 (IconName): The :code:`layout-2` icon.
        LAYOUT_ALIGN_BOTTOM (IconName): The :code:`layout-align-bottom` icon.
        LAYOUT_ALIGN_CENTER (IconName): The :code:`layout-align-center` icon.
        LAYOUT_ALIGN_LEFT (IconName): The :code:`layout-align-left` icon.
        LAYOUT_ALIGN_MIDDLE (IconName): The :code:`layout-align-middle` icon.
        LAYOUT_ALIGN_RIGHT (IconName): The :code:`layout-align-right` icon.
        LAYOUT_ALIGN_TOP (IconName): The :code:`layout-align-top` icon.
        LAYOUT_BOARD (IconName): The :code:`layout-board` icon.
        LAYOUT_BOARD_SPLIT (IconName): The :code:`layout-board-split` icon.
        LAYOUT_BOTTOMBAR (IconName): The :code:`layout-bottombar` icon.
        LAYOUT_BOTTOMBAR_COLLAPSE (IconName): The :code:`layout-bottombar-collapse` icon.
        LAYOUT_BOTTOMBAR_EXPAND (IconName): The :code:`layout-bottombar-expand` icon.
        LAYOUT_CARDS (IconName): The :code:`layout-cards` icon.
        LAYOUT_COLLAGE (IconName): The :code:`layout-collage` icon.
        LAYOUT_COLUMNS (IconName): The :code:`layout-columns` icon.
        LAYOUT_DASHBOARD (IconName): The :code:`layout-dashboard` icon.
        LAYOUT_DISTRIBUTE_HORIZONTAL (IconName): The :code:`layout-distribute-horizontal` icon.
        LAYOUT_DISTRIBUTE_VERTICAL (IconName): The :code:`layout-distribute-vertical` icon.
        LAYOUT_GRID (IconName): The :code:`layout-grid` icon.
        LAYOUT_GRID_ADD (IconName): The :code:`layout-grid-add` icon.
        LAYOUT_GRID_REMOVE (IconName): The :code:`layout-grid-remove` icon.
        LAYOUT_KANBAN (IconName): The :code:`layout-kanban` icon.
        LAYOUT_LIST (IconName): The :code:`layout-list` icon.
        LAYOUT_NAVBAR (IconName): The :code:`layout-navbar` icon.
        LAYOUT_NAVBAR_COLLAPSE (IconName): The :code:`layout-navbar-collapse` icon.
        LAYOUT_NAVBAR_EXPAND (IconName): The :code:`layout-navbar-expand` icon.
        LAYOUT_OFF (IconName): The :code:`layout-off` icon.
        LAYOUT_ROWS (IconName): The :code:`layout-rows` icon.
        LAYOUT_SIDEBAR (IconName): The :code:`layout-sidebar` icon.
        LAYOUT_SIDEBAR_LEFT_COLLAPSE (IconName): The :code:`layout-sidebar-left-collapse` icon.
        LAYOUT_SIDEBAR_LEFT_EXPAND (IconName): The :code:`layout-sidebar-left-expand` icon.
        LAYOUT_SIDEBAR_RIGHT (IconName): The :code:`layout-sidebar-right` icon.
        LAYOUT_SIDEBAR_RIGHT_COLLAPSE (IconName): The :code:`layout-sidebar-right-collapse` icon.
        LAYOUT_SIDEBAR_RIGHT_EXPAND (IconName): The :code:`layout-sidebar-right-expand` icon.
        LEAF (IconName): The :code:`leaf` icon.
        LEAF_OFF (IconName): The :code:`leaf-off` icon.
        LEGO (IconName): The :code:`lego` icon.
        LEGO_OFF (IconName): The :code:`lego-off` icon.
        LEMON (IconName): The :code:`lemon` icon.
        LEMON_2 (IconName): The :code:`lemon-2` icon.
        LETTER_A (IconName): The :code:`letter-a` icon.
        LETTER_B (IconName): The :code:`letter-b` icon.
        LETTER_C (IconName): The :code:`letter-c` icon.
        LETTER_CASE (IconName): The :code:`letter-case` icon.
        LETTER_CASE_LOWER (IconName): The :code:`letter-case-lower` icon.
        LETTER_CASE_TOGGLE (IconName): The :code:`letter-case-toggle` icon.
        LETTER_CASE_UPPER (IconName): The :code:`letter-case-upper` icon.
        LETTER_D (IconName): The :code:`letter-d` icon.
        LETTER_E (IconName): The :code:`letter-e` icon.
        LETTER_F (IconName): The :code:`letter-f` icon.
        LETTER_G (IconName): The :code:`letter-g` icon.
        LETTER_H (IconName): The :code:`letter-h` icon.
        LETTER_I (IconName): The :code:`letter-i` icon.
        LETTER_J (IconName): The :code:`letter-j` icon.
        LETTER_K (IconName): The :code:`letter-k` icon.
        LETTER_L (IconName): The :code:`letter-l` icon.
        LETTER_M (IconName): The :code:`letter-m` icon.
        LETTER_N (IconName): The :code:`letter-n` icon.
        LETTER_O (IconName): The :code:`letter-o` icon.
        LETTER_P (IconName): The :code:`letter-p` icon.
        LETTER_Q (IconName): The :code:`letter-q` icon.
        LETTER_R (IconName): The :code:`letter-r` icon.
        LETTER_S (IconName): The :code:`letter-s` icon.
        LETTER_SPACING (IconName): The :code:`letter-spacing` icon.
        LETTER_T (IconName): The :code:`letter-t` icon.
        LETTER_U (IconName): The :code:`letter-u` icon.
        LETTER_V (IconName): The :code:`letter-v` icon.
        LETTER_W (IconName): The :code:`letter-w` icon.
        LETTER_X (IconName): The :code:`letter-x` icon.
        LETTER_Y (IconName): The :code:`letter-y` icon.
        LETTER_Z (IconName): The :code:`letter-z` icon.
        LICENSE (IconName): The :code:`license` icon.
        LICENSE_OFF (IconName): The :code:`license-off` icon.
        LIFEBUOY (IconName): The :code:`lifebuoy` icon.
        LIFEBUOY_OFF (IconName): The :code:`lifebuoy-off` icon.
        LIGHTER (IconName): The :code:`lighter` icon.
        LINE (IconName): The :code:`line` icon.
        LINE_DASHED (IconName): The :code:`line-dashed` icon.
        LINE_DOTTED (IconName): The :code:`line-dotted` icon.
        LINE_HEIGHT (IconName): The :code:`line-height` icon.
        LINK (IconName): The :code:`link` icon.
        LINK_OFF (IconName): The :code:`link-off` icon.
        LIST (IconName): The :code:`list` icon.
        LIST_CHECK (IconName): The :code:`list-check` icon.
        LIST_DETAILS (IconName): The :code:`list-details` icon.
        LIST_NUMBERS (IconName): The :code:`list-numbers` icon.
        LIST_SEARCH (IconName): The :code:`list-search` icon.
        LIST_TREE (IconName): The :code:`list-tree` icon.
        LIVE_PHOTO (IconName): The :code:`live-photo` icon.
        LIVE_PHOTO_OFF (IconName): The :code:`live-photo-off` icon.
        LIVE_VIEW (IconName): The :code:`live-view` icon.
        LOAD_BALANCER (IconName): The :code:`load-balancer` icon.
        LOADER (IconName): The :code:`loader` icon.
        LOADER_2 (IconName): The :code:`loader-2` icon.
        LOADER_3 (IconName): The :code:`loader-3` icon.
        LOADER_QUARTER (IconName): The :code:`loader-quarter` icon.
        LOCATION (IconName): The :code:`location` icon.
        LOCATION_BROKEN (IconName): The :code:`location-broken` icon.
        LOCATION_FILLED (IconName): The :code:`location-filled` icon.
        LOCATION_OFF (IconName): The :code:`location-off` icon.
        LOCK (IconName): The :code:`lock` icon.
        LOCK_ACCESS (IconName): The :code:`lock-access` icon.
        LOCK_ACCESS_OFF (IconName): The :code:`lock-access-off` icon.
        LOCK_BOLT (IconName): The :code:`lock-bolt` icon.
        LOCK_CANCEL (IconName): The :code:`lock-cancel` icon.
        LOCK_CHECK (IconName): The :code:`lock-check` icon.
        LOCK_CODE (IconName): The :code:`lock-code` icon.
        LOCK_COG (IconName): The :code:`lock-cog` icon.
        LOCK_DOLLAR (IconName): The :code:`lock-dollar` icon.
        LOCK_DOWN (IconName): The :code:`lock-down` icon.
        LOCK_EXCLAMATION (IconName): The :code:`lock-exclamation` icon.
        LOCK_HEART (IconName): The :code:`lock-heart` icon.
        LOCK_MINUS (IconName): The :code:`lock-minus` icon.
        LOCK_OFF (IconName): The :code:`lock-off` icon.
        LOCK_OPEN (IconName): The :code:`lock-open` icon.
        LOCK_OPEN_OFF (IconName): The :code:`lock-open-off` icon.
        LOCK_PAUSE (IconName): The :code:`lock-pause` icon.
        LOCK_PIN (IconName): The :code:`lock-pin` icon.
        LOCK_PLUS (IconName): The :code:`lock-plus` icon.
        LOCK_QUESTION (IconName): The :code:`lock-question` icon.
        LOCK_SEARCH (IconName): The :code:`lock-search` icon.
        LOCK_SHARE (IconName): The :code:`lock-share` icon.
        LOCK_SQUARE (IconName): The :code:`lock-square` icon.
        LOCK_SQUARE_ROUNDED (IconName): The :code:`lock-square-rounded` icon.
        LOCK_SQUARE_ROUNDED_FILLED (IconName): The :code:`lock-square-rounded-filled` icon.
        LOCK_STAR (IconName): The :code:`lock-star` icon.
        LOCK_UP (IconName): The :code:`lock-up` icon.
        LOCK_X (IconName): The :code:`lock-x` icon.
        LOGIC_AND (IconName): The :code:`logic-and` icon.
        LOGIC_BUFFER (IconName): The :code:`logic-buffer` icon.
        LOGIC_NAND (IconName): The :code:`logic-nand` icon.
        LOGIC_NOR (IconName): The :code:`logic-nor` icon.
        LOGIC_NOT (IconName): The :code:`logic-not` icon.
        LOGIC_OR (IconName): The :code:`logic-or` icon.
        LOGIC_XNOR (IconName): The :code:`logic-xnor` icon.
        LOGIC_XOR (IconName): The :code:`logic-xor` icon.
        LOGIN (IconName): The :code:`login` icon.
        LOGOUT (IconName): The :code:`logout` icon.
        LOGOUT_2 (IconName): The :code:`logout-2` icon.
        LOLLIPOP (IconName): The :code:`lollipop` icon.
        LOLLIPOP_OFF (IconName): The :code:`lollipop-off` icon.
        LUGGAGE (IconName): The :code:`luggage` icon.
        LUGGAGE_OFF (IconName): The :code:`luggage-off` icon.
        LUNGS (IconName): The :code:`lungs` icon.
        LUNGS_OFF (IconName): The :code:`lungs-off` icon.
        MACRO (IconName): The :code:`macro` icon.
        MACRO_OFF (IconName): The :code:`macro-off` icon.
        MAGNET (IconName): The :code:`magnet` icon.
        MAGNET_OFF (IconName): The :code:`magnet-off` icon.
        MAIL (IconName): The :code:`mail` icon.
        MAIL_AI (IconName): The :code:`mail-ai` icon.
        MAIL_BOLT (IconName): The :code:`mail-bolt` icon.
        MAIL_CANCEL (IconName): The :code:`mail-cancel` icon.
        MAIL_CHECK (IconName): The :code:`mail-check` icon.
        MAIL_CODE (IconName): The :code:`mail-code` icon.
        MAIL_COG (IconName): The :code:`mail-cog` icon.
        MAIL_DOLLAR (IconName): The :code:`mail-dollar` icon.
        MAIL_DOWN (IconName): The :code:`mail-down` icon.
        MAIL_EXCLAMATION (IconName): The :code:`mail-exclamation` icon.
        MAIL_FAST (IconName): The :code:`mail-fast` icon.
        MAIL_FILLED (IconName): The :code:`mail-filled` icon.
        MAIL_FORWARD (IconName): The :code:`mail-forward` icon.
        MAIL_HEART (IconName): The :code:`mail-heart` icon.
        MAIL_MINUS (IconName): The :code:`mail-minus` icon.
        MAIL_OFF (IconName): The :code:`mail-off` icon.
        MAIL_OPENED (IconName): The :code:`mail-opened` icon.
        MAIL_OPENED_FILLED (IconName): The :code:`mail-opened-filled` icon.
        MAIL_PAUSE (IconName): The :code:`mail-pause` icon.
        MAIL_PIN (IconName): The :code:`mail-pin` icon.
        MAIL_PLUS (IconName): The :code:`mail-plus` icon.
        MAIL_QUESTION (IconName): The :code:`mail-question` icon.
        MAIL_SEARCH (IconName): The :code:`mail-search` icon.
        MAIL_SHARE (IconName): The :code:`mail-share` icon.
        MAIL_STAR (IconName): The :code:`mail-star` icon.
        MAIL_UP (IconName): The :code:`mail-up` icon.
        MAIL_X (IconName): The :code:`mail-x` icon.
        MAILBOX (IconName): The :code:`mailbox` icon.
        MAILBOX_OFF (IconName): The :code:`mailbox-off` icon.
        MAN (IconName): The :code:`man` icon.
        MANUAL_GEARBOX (IconName): The :code:`manual-gearbox` icon.
        MAP (IconName): The :code:`map` icon.
        MAP_2 (IconName): The :code:`map-2` icon.
        MAP_OFF (IconName): The :code:`map-off` icon.
        MAP_PIN (IconName): The :code:`map-pin` icon.
        MAP_PIN_BOLT (IconName): The :code:`map-pin-bolt` icon.
        MAP_PIN_CANCEL (IconName): The :code:`map-pin-cancel` icon.
        MAP_PIN_CHECK (IconName): The :code:`map-pin-check` icon.
        MAP_PIN_CODE (IconName): The :code:`map-pin-code` icon.
        MAP_PIN_COG (IconName): The :code:`map-pin-cog` icon.
        MAP_PIN_DOLLAR (IconName): The :code:`map-pin-dollar` icon.
        MAP_PIN_DOWN (IconName): The :code:`map-pin-down` icon.
        MAP_PIN_EXCLAMATION (IconName): The :code:`map-pin-exclamation` icon.
        MAP_PIN_FILLED (IconName): The :code:`map-pin-filled` icon.
        MAP_PIN_HEART (IconName): The :code:`map-pin-heart` icon.
        MAP_PIN_MINUS (IconName): The :code:`map-pin-minus` icon.
        MAP_PIN_OFF (IconName): The :code:`map-pin-off` icon.
        MAP_PIN_PAUSE (IconName): The :code:`map-pin-pause` icon.
        MAP_PIN_PIN (IconName): The :code:`map-pin-pin` icon.
        MAP_PIN_PLUS (IconName): The :code:`map-pin-plus` icon.
        MAP_PIN_QUESTION (IconName): The :code:`map-pin-question` icon.
        MAP_PIN_SEARCH (IconName): The :code:`map-pin-search` icon.
        MAP_PIN_SHARE (IconName): The :code:`map-pin-share` icon.
        MAP_PIN_STAR (IconName): The :code:`map-pin-star` icon.
        MAP_PIN_UP (IconName): The :code:`map-pin-up` icon.
        MAP_PIN_X (IconName): The :code:`map-pin-x` icon.
        MAP_PINS (IconName): The :code:`map-pins` icon.
        MAP_SEARCH (IconName): The :code:`map-search` icon.
        MARKDOWN (IconName): The :code:`markdown` icon.
        MARKDOWN_OFF (IconName): The :code:`markdown-off` icon.
        MARQUEE (IconName): The :code:`marquee` icon.
        MARQUEE_2 (IconName): The :code:`marquee-2` icon.
        MARQUEE_OFF (IconName): The :code:`marquee-off` icon.
        MARS (IconName): The :code:`mars` icon.
        MASK (IconName): The :code:`mask` icon.
        MASK_OFF (IconName): The :code:`mask-off` icon.
        MASKS_THEATER (IconName): The :code:`masks-theater` icon.
        MASKS_THEATER_OFF (IconName): The :code:`masks-theater-off` icon.
        MASSAGE (IconName): The :code:`massage` icon.
        MATCHSTICK (IconName): The :code:`matchstick` icon.
        MATH (IconName): The :code:`math` icon.
        MATH_1_DIVIDE_2 (IconName): The :code:`math-1-divide-2` icon.
        MATH_1_DIVIDE_3 (IconName): The :code:`math-1-divide-3` icon.
        MATH_AVG (IconName): The :code:`math-avg` icon.
        MATH_EQUAL_GREATER (IconName): The :code:`math-equal-greater` icon.
        MATH_EQUAL_LOWER (IconName): The :code:`math-equal-lower` icon.
        MATH_FUNCTION (IconName): The :code:`math-function` icon.
        MATH_FUNCTION_OFF (IconName): The :code:`math-function-off` icon.
        MATH_FUNCTION_Y (IconName): The :code:`math-function-y` icon.
        MATH_GREATER (IconName): The :code:`math-greater` icon.
        MATH_INTEGRAL (IconName): The :code:`math-integral` icon.
        MATH_INTEGRAL_X (IconName): The :code:`math-integral-x` icon.
        MATH_INTEGRALS (IconName): The :code:`math-integrals` icon.
        MATH_LOWER (IconName): The :code:`math-lower` icon.
        MATH_MAX (IconName): The :code:`math-max` icon.
        MATH_MIN (IconName): The :code:`math-min` icon.
        MATH_NOT (IconName): The :code:`math-not` icon.
        MATH_OFF (IconName): The :code:`math-off` icon.
        MATH_PI (IconName): The :code:`math-pi` icon.
        MATH_PI_DIVIDE_2 (IconName): The :code:`math-pi-divide-2` icon.
        MATH_SYMBOLS (IconName): The :code:`math-symbols` icon.
        MATH_X_DIVIDE_2 (IconName): The :code:`math-x-divide-2` icon.
        MATH_X_DIVIDE_Y (IconName): The :code:`math-x-divide-y` icon.
        MATH_X_DIVIDE_Y_2 (IconName): The :code:`math-x-divide-y-2` icon.
        MATH_X_MINUS_X (IconName): The :code:`math-x-minus-x` icon.
        MATH_X_MINUS_Y (IconName): The :code:`math-x-minus-y` icon.
        MATH_X_PLUS_X (IconName): The :code:`math-x-plus-x` icon.
        MATH_X_PLUS_Y (IconName): The :code:`math-x-plus-y` icon.
        MATH_XY (IconName): The :code:`math-xy` icon.
        MATH_Y_MINUS_Y (IconName): The :code:`math-y-minus-y` icon.
        MATH_Y_PLUS_Y (IconName): The :code:`math-y-plus-y` icon.
        MAXIMIZE (IconName): The :code:`maximize` icon.
        MAXIMIZE_OFF (IconName): The :code:`maximize-off` icon.
        MEAT (IconName): The :code:`meat` icon.
        MEAT_OFF (IconName): The :code:`meat-off` icon.
        MEDAL (IconName): The :code:`medal` icon.
        MEDAL_2 (IconName): The :code:`medal-2` icon.
        MEDICAL_CROSS (IconName): The :code:`medical-cross` icon.
        MEDICAL_CROSS_CIRCLE (IconName): The :code:`medical-cross-circle` icon.
        MEDICAL_CROSS_FILLED (IconName): The :code:`medical-cross-filled` icon.
        MEDICAL_CROSS_OFF (IconName): The :code:`medical-cross-off` icon.
        MEDICINE_SYRUP (IconName): The :code:`medicine-syrup` icon.
        MEEPLE (IconName): The :code:`meeple` icon.
        MENORAH (IconName): The :code:`menorah` icon.
        MENU (IconName): The :code:`menu` icon.
        MENU_2 (IconName): The :code:`menu-2` icon.
        MENU_DEEP (IconName): The :code:`menu-deep` icon.
        MENU_ORDER (IconName): The :code:`menu-order` icon.
        MESSAGE (IconName): The :code:`message` icon.
        MESSAGE_2 (IconName): The :code:`message-2` icon.
        MESSAGE_2_BOLT (IconName): The :code:`message-2-bolt` icon.
        MESSAGE_2_CANCEL (IconName): The :code:`message-2-cancel` icon.
        MESSAGE_2_CHECK (IconName): The :code:`message-2-check` icon.
        MESSAGE_2_CODE (IconName): The :code:`message-2-code` icon.
        MESSAGE_2_COG (IconName): The :code:`message-2-cog` icon.
        MESSAGE_2_DOLLAR (IconName): The :code:`message-2-dollar` icon.
        MESSAGE_2_DOWN (IconName): The :code:`message-2-down` icon.
        MESSAGE_2_EXCLAMATION (IconName): The :code:`message-2-exclamation` icon.
        MESSAGE_2_HEART (IconName): The :code:`message-2-heart` icon.
        MESSAGE_2_MINUS (IconName): The :code:`message-2-minus` icon.
        MESSAGE_2_OFF (IconName): The :code:`message-2-off` icon.
        MESSAGE_2_PAUSE (IconName): The :code:`message-2-pause` icon.
        MESSAGE_2_PIN (IconName): The :code:`message-2-pin` icon.
        MESSAGE_2_PLUS (IconName): The :code:`message-2-plus` icon.
        MESSAGE_2_QUESTION (IconName): The :code:`message-2-question` icon.
        MESSAGE_2_SEARCH (IconName): The :code:`message-2-search` icon.
        MESSAGE_2_SHARE (IconName): The :code:`message-2-share` icon.
        MESSAGE_2_STAR (IconName): The :code:`message-2-star` icon.
        MESSAGE_2_UP (IconName): The :code:`message-2-up` icon.
        MESSAGE_2_X (IconName): The :code:`message-2-x` icon.
        MESSAGE_BOLT (IconName): The :code:`message-bolt` icon.
        MESSAGE_CANCEL (IconName): The :code:`message-cancel` icon.
        MESSAGE_CHATBOT (IconName): The :code:`message-chatbot` icon.
        MESSAGE_CHECK (IconName): The :code:`message-check` icon.
        MESSAGE_CIRCLE (IconName): The :code:`message-circle` icon.
        MESSAGE_CIRCLE_2 (IconName): The :code:`message-circle-2` icon.
        MESSAGE_CIRCLE_2_FILLED (IconName): The :code:`message-circle-2-filled` icon.
        MESSAGE_CIRCLE_BOLT (IconName): The :code:`message-circle-bolt` icon.
        MESSAGE_CIRCLE_CANCEL (IconName): The :code:`message-circle-cancel` icon.
        MESSAGE_CIRCLE_CHECK (IconName): The :code:`message-circle-check` icon.
        MESSAGE_CIRCLE_CODE (IconName): The :code:`message-circle-code` icon.
        MESSAGE_CIRCLE_COG (IconName): The :code:`message-circle-cog` icon.
        MESSAGE_CIRCLE_DOLLAR (IconName): The :code:`message-circle-dollar` icon.
        MESSAGE_CIRCLE_DOWN (IconName): The :code:`message-circle-down` icon.
        MESSAGE_CIRCLE_EXCLAMATION (IconName): The :code:`message-circle-exclamation` icon.
        MESSAGE_CIRCLE_HEART (IconName): The :code:`message-circle-heart` icon.
        MESSAGE_CIRCLE_MINUS (IconName): The :code:`message-circle-minus` icon.
        MESSAGE_CIRCLE_OFF (IconName): The :code:`message-circle-off` icon.
        MESSAGE_CIRCLE_PAUSE (IconName): The :code:`message-circle-pause` icon.
        MESSAGE_CIRCLE_PIN (IconName): The :code:`message-circle-pin` icon.
        MESSAGE_CIRCLE_PLUS (IconName): The :code:`message-circle-plus` icon.
        MESSAGE_CIRCLE_QUESTION (IconName): The :code:`message-circle-question` icon.
        MESSAGE_CIRCLE_SEARCH (IconName): The :code:`message-circle-search` icon.
        MESSAGE_CIRCLE_SHARE (IconName): The :code:`message-circle-share` icon.
        MESSAGE_CIRCLE_STAR (IconName): The :code:`message-circle-star` icon.
        MESSAGE_CIRCLE_UP (IconName): The :code:`message-circle-up` icon.
        MESSAGE_CIRCLE_X (IconName): The :code:`message-circle-x` icon.
        MESSAGE_CODE (IconName): The :code:`message-code` icon.
        MESSAGE_COG (IconName): The :code:`message-cog` icon.
        MESSAGE_DOLLAR (IconName): The :code:`message-dollar` icon.
        MESSAGE_DOTS (IconName): The :code:`message-dots` icon.
        MESSAGE_DOWN (IconName): The :code:`message-down` icon.
        MESSAGE_EXCLAMATION (IconName): The :code:`message-exclamation` icon.
        MESSAGE_FORWARD (IconName): The :code:`message-forward` icon.
        MESSAGE_HEART (IconName): The :code:`message-heart` icon.
        MESSAGE_LANGUAGE (IconName): The :code:`message-language` icon.
        MESSAGE_MINUS (IconName): The :code:`message-minus` icon.
        MESSAGE_OFF (IconName): The :code:`message-off` icon.
        MESSAGE_PAUSE (IconName): The :code:`message-pause` icon.
        MESSAGE_PIN (IconName): The :code:`message-pin` icon.
        MESSAGE_PLUS (IconName): The :code:`message-plus` icon.
        MESSAGE_QUESTION (IconName): The :code:`message-question` icon.
        MESSAGE_REPORT (IconName): The :code:`message-report` icon.
        MESSAGE_SEARCH (IconName): The :code:`message-search` icon.
        MESSAGE_SHARE (IconName): The :code:`message-share` icon.
        MESSAGE_STAR (IconName): The :code:`message-star` icon.
        MESSAGE_UP (IconName): The :code:`message-up` icon.
        MESSAGE_X (IconName): The :code:`message-x` icon.
        MESSAGES (IconName): The :code:`messages` icon.
        MESSAGES_OFF (IconName): The :code:`messages-off` icon.
        METEOR (IconName): The :code:`meteor` icon.
        METEOR_OFF (IconName): The :code:`meteor-off` icon.
        MICHELIN_BIB_GOURMAND (IconName): The :code:`michelin-bib-gourmand` icon.
        MICHELIN_STAR (IconName): The :code:`michelin-star` icon.
        MICHELIN_STAR_GREEN (IconName): The :code:`michelin-star-green` icon.
        MICKEY (IconName): The :code:`mickey` icon.
        MICKEY_FILLED (IconName): The :code:`mickey-filled` icon.
        MICROPHONE (IconName): The :code:`microphone` icon.
        MICROPHONE_2 (IconName): The :code:`microphone-2` icon.
        MICROPHONE_2_OFF (IconName): The :code:`microphone-2-off` icon.
        MICROPHONE_OFF (IconName): The :code:`microphone-off` icon.
        MICROSCOPE (IconName): The :code:`microscope` icon.
        MICROSCOPE_OFF (IconName): The :code:`microscope-off` icon.
        MICROWAVE (IconName): The :code:`microwave` icon.
        MICROWAVE_OFF (IconName): The :code:`microwave-off` icon.
        MILITARY_AWARD (IconName): The :code:`military-award` icon.
        MILITARY_RANK (IconName): The :code:`military-rank` icon.
        MILK (IconName): The :code:`milk` icon.
        MILK_OFF (IconName): The :code:`milk-off` icon.
        MILKSHAKE (IconName): The :code:`milkshake` icon.
        MINIMIZE (IconName): The :code:`minimize` icon.
        MINUS (IconName): The :code:`minus` icon.
        MINUS_VERTICAL (IconName): The :code:`minus-vertical` icon.
        MIST (IconName): The :code:`mist` icon.
        MIST_OFF (IconName): The :code:`mist-off` icon.
        MOBILEDATA (IconName): The :code:`mobiledata` icon.
        MOBILEDATA_OFF (IconName): The :code:`mobiledata-off` icon.
        MONEYBAG (IconName): The :code:`moneybag` icon.
        MOOD_ANGRY (IconName): The :code:`mood-angry` icon.
        MOOD_ANNOYED (IconName): The :code:`mood-annoyed` icon.
        MOOD_ANNOYED_2 (IconName): The :code:`mood-annoyed-2` icon.
        MOOD_BOY (IconName): The :code:`mood-boy` icon.
        MOOD_CHECK (IconName): The :code:`mood-check` icon.
        MOOD_COG (IconName): The :code:`mood-cog` icon.
        MOOD_CONFUZED (IconName): The :code:`mood-confuzed` icon.
        MOOD_CONFUZED_FILLED (IconName): The :code:`mood-confuzed-filled` icon.
        MOOD_CRAZY_HAPPY (IconName): The :code:`mood-crazy-happy` icon.
        MOOD_CRY (IconName): The :code:`mood-cry` icon.
        MOOD_DOLLAR (IconName): The :code:`mood-dollar` icon.
        MOOD_EDIT (IconName): The :code:`mood-edit` icon.
        MOOD_EMPTY (IconName): The :code:`mood-empty` icon.
        MOOD_EMPTY_FILLED (IconName): The :code:`mood-empty-filled` icon.
        MOOD_HAPPY (IconName): The :code:`mood-happy` icon.
        MOOD_HAPPY_FILLED (IconName): The :code:`mood-happy-filled` icon.
        MOOD_HEART (IconName): The :code:`mood-heart` icon.
        MOOD_KID (IconName): The :code:`mood-kid` icon.
        MOOD_KID_FILLED (IconName): The :code:`mood-kid-filled` icon.
        MOOD_LOOK_LEFT (IconName): The :code:`mood-look-left` icon.
        MOOD_LOOK_RIGHT (IconName): The :code:`mood-look-right` icon.
        MOOD_MINUS (IconName): The :code:`mood-minus` icon.
        MOOD_NERD (IconName): The :code:`mood-nerd` icon.
        MOOD_NERVOUS (IconName): The :code:`mood-nervous` icon.
        MOOD_NEUTRAL (IconName): The :code:`mood-neutral` icon.
        MOOD_NEUTRAL_FILLED (IconName): The :code:`mood-neutral-filled` icon.
        MOOD_OFF (IconName): The :code:`mood-off` icon.
        MOOD_PIN (IconName): The :code:`mood-pin` icon.
        MOOD_PLUS (IconName): The :code:`mood-plus` icon.
        MOOD_SAD (IconName): The :code:`mood-sad` icon.
        MOOD_SAD_2 (IconName): The :code:`mood-sad-2` icon.
        MOOD_SAD_DIZZY (IconName): The :code:`mood-sad-dizzy` icon.
        MOOD_SAD_FILLED (IconName): The :code:`mood-sad-filled` icon.
        MOOD_SAD_SQUINT (IconName): The :code:`mood-sad-squint` icon.
        MOOD_SEARCH (IconName): The :code:`mood-search` icon.
        MOOD_SHARE (IconName): The :code:`mood-share` icon.
        MOOD_SICK (IconName): The :code:`mood-sick` icon.
        MOOD_SILENCE (IconName): The :code:`mood-silence` icon.
        MOOD_SING (IconName): The :code:`mood-sing` icon.
        MOOD_SMILE (IconName): The :code:`mood-smile` icon.
        MOOD_SMILE_BEAM (IconName): The :code:`mood-smile-beam` icon.
        MOOD_SMILE_DIZZY (IconName): The :code:`mood-smile-dizzy` icon.
        MOOD_SMILE_FILLED (IconName): The :code:`mood-smile-filled` icon.
        MOOD_SUPRISED (IconName): The :code:`mood-suprised` icon.
        MOOD_TONGUE (IconName): The :code:`mood-tongue` icon.
        MOOD_TONGUE_WINK (IconName): The :code:`mood-tongue-wink` icon.
        MOOD_TONGUE_WINK_2 (IconName): The :code:`mood-tongue-wink-2` icon.
        MOOD_UNAMUSED (IconName): The :code:`mood-unamused` icon.
        MOOD_UP (IconName): The :code:`mood-up` icon.
        MOOD_WINK (IconName): The :code:`mood-wink` icon.
        MOOD_WINK_2 (IconName): The :code:`mood-wink-2` icon.
        MOOD_WRRR (IconName): The :code:`mood-wrrr` icon.
        MOOD_X (IconName): The :code:`mood-x` icon.
        MOOD_XD (IconName): The :code:`mood-xd` icon.
        MOON (IconName): The :code:`moon` icon.
        MOON_2 (IconName): The :code:`moon-2` icon.
        MOON_FILLED (IconName): The :code:`moon-filled` icon.
        MOON_OFF (IconName): The :code:`moon-off` icon.
        MOON_STARS (IconName): The :code:`moon-stars` icon.
        MOPED (IconName): The :code:`moped` icon.
        MOTORBIKE (IconName): The :code:`motorbike` icon.
        MOUNTAIN (IconName): The :code:`mountain` icon.
        MOUNTAIN_OFF (IconName): The :code:`mountain-off` icon.
        MOUSE (IconName): The :code:`mouse` icon.
        MOUSE_2 (IconName): The :code:`mouse-2` icon.
        MOUSE_OFF (IconName): The :code:`mouse-off` icon.
        MOUSTACHE (IconName): The :code:`moustache` icon.
        MOVIE (IconName): The :code:`movie` icon.
        MOVIE_OFF (IconName): The :code:`movie-off` icon.
        MUG (IconName): The :code:`mug` icon.
        MUG_OFF (IconName): The :code:`mug-off` icon.
        MULTIPLIER_0_5X (IconName): The :code:`multiplier-0-5x` icon.
        MULTIPLIER_1_5X (IconName): The :code:`multiplier-1-5x` icon.
        MULTIPLIER_1X (IconName): The :code:`multiplier-1x` icon.
        MULTIPLIER_2X (IconName): The :code:`multiplier-2x` icon.
        MUSHROOM (IconName): The :code:`mushroom` icon.
        MUSHROOM_FILLED (IconName): The :code:`mushroom-filled` icon.
        MUSHROOM_OFF (IconName): The :code:`mushroom-off` icon.
        MUSIC (IconName): The :code:`music` icon.
        MUSIC_OFF (IconName): The :code:`music-off` icon.
        NAVIGATION (IconName): The :code:`navigation` icon.
        NAVIGATION_FILLED (IconName): The :code:`navigation-filled` icon.
        NAVIGATION_NORTH (IconName): The :code:`navigation-north` icon.
        NAVIGATION_OFF (IconName): The :code:`navigation-off` icon.
        NEEDLE (IconName): The :code:`needle` icon.
        NEEDLE_THREAD (IconName): The :code:`needle-thread` icon.
        NETWORK (IconName): The :code:`network` icon.
        NETWORK_OFF (IconName): The :code:`network-off` icon.
        NEW_SECTION (IconName): The :code:`new-section` icon.
        NEWS (IconName): The :code:`news` icon.
        NEWS_OFF (IconName): The :code:`news-off` icon.
        NFC (IconName): The :code:`nfc` icon.
        NFC_OFF (IconName): The :code:`nfc-off` icon.
        NO_COPYRIGHT (IconName): The :code:`no-copyright` icon.
        NO_CREATIVE_COMMONS (IconName): The :code:`no-creative-commons` icon.
        NO_DERIVATIVES (IconName): The :code:`no-derivatives` icon.
        NORTH_STAR (IconName): The :code:`north-star` icon.
        NOTE (IconName): The :code:`note` icon.
        NOTE_OFF (IconName): The :code:`note-off` icon.
        NOTEBOOK (IconName): The :code:`notebook` icon.
        NOTEBOOK_OFF (IconName): The :code:`notebook-off` icon.
        NOTES (IconName): The :code:`notes` icon.
        NOTES_OFF (IconName): The :code:`notes-off` icon.
        NOTIFICATION (IconName): The :code:`notification` icon.
        NOTIFICATION_OFF (IconName): The :code:`notification-off` icon.
        NUMBER (IconName): The :code:`number` icon.
        NUMBER_0 (IconName): The :code:`number-0` icon.
        NUMBER_1 (IconName): The :code:`number-1` icon.
        NUMBER_2 (IconName): The :code:`number-2` icon.
        NUMBER_3 (IconName): The :code:`number-3` icon.
        NUMBER_4 (IconName): The :code:`number-4` icon.
        NUMBER_5 (IconName): The :code:`number-5` icon.
        NUMBER_6 (IconName): The :code:`number-6` icon.
        NUMBER_7 (IconName): The :code:`number-7` icon.
        NUMBER_8 (IconName): The :code:`number-8` icon.
        NUMBER_9 (IconName): The :code:`number-9` icon.
        NUMBERS (IconName): The :code:`numbers` icon.
        NURSE (IconName): The :code:`nurse` icon.
        OCTAGON (IconName): The :code:`octagon` icon.
        OCTAGON_FILLED (IconName): The :code:`octagon-filled` icon.
        OCTAGON_OFF (IconName): The :code:`octagon-off` icon.
        OCTAHEDRON (IconName): The :code:`octahedron` icon.
        OCTAHEDRON_OFF (IconName): The :code:`octahedron-off` icon.
        OCTAHEDRON_PLUS (IconName): The :code:`octahedron-plus` icon.
        OLD (IconName): The :code:`old` icon.
        OLYMPICS (IconName): The :code:`olympics` icon.
        OLYMPICS_OFF (IconName): The :code:`olympics-off` icon.
        OM (IconName): The :code:`om` icon.
        OMEGA (IconName): The :code:`omega` icon.
        OUTBOUND (IconName): The :code:`outbound` icon.
        OUTLET (IconName): The :code:`outlet` icon.
        OVAL (IconName): The :code:`oval` icon.
        OVAL_FILLED (IconName): The :code:`oval-filled` icon.
        OVAL_VERTICAL (IconName): The :code:`oval-vertical` icon.
        OVAL_VERTICAL_FILLED (IconName): The :code:`oval-vertical-filled` icon.
        OVERLINE (IconName): The :code:`overline` icon.
        PACKAGE (IconName): The :code:`package` icon.
        PACKAGE_EXPORT (IconName): The :code:`package-export` icon.
        PACKAGE_IMPORT (IconName): The :code:`package-import` icon.
        PACKAGE_OFF (IconName): The :code:`package-off` icon.
        PACKAGES (IconName): The :code:`packages` icon.
        PACMAN (IconName): The :code:`pacman` icon.
        PAGE_BREAK (IconName): The :code:`page-break` icon.
        PAINT (IconName): The :code:`paint` icon.
        PAINT_FILLED (IconName): The :code:`paint-filled` icon.
        PAINT_OFF (IconName): The :code:`paint-off` icon.
        PALETTE (IconName): The :code:`palette` icon.
        PALETTE_OFF (IconName): The :code:`palette-off` icon.
        PANORAMA_HORIZONTAL (IconName): The :code:`panorama-horizontal` icon.
        PANORAMA_HORIZONTAL_OFF (IconName): The :code:`panorama-horizontal-off` icon.
        PANORAMA_VERTICAL (IconName): The :code:`panorama-vertical` icon.
        PANORAMA_VERTICAL_OFF (IconName): The :code:`panorama-vertical-off` icon.
        PAPER_BAG (IconName): The :code:`paper-bag` icon.
        PAPER_BAG_OFF (IconName): The :code:`paper-bag-off` icon.
        PAPERCLIP (IconName): The :code:`paperclip` icon.
        PARACHUTE (IconName): The :code:`parachute` icon.
        PARACHUTE_OFF (IconName): The :code:`parachute-off` icon.
        PARENTHESES (IconName): The :code:`parentheses` icon.
        PARENTHESES_OFF (IconName): The :code:`parentheses-off` icon.
        PARKING (IconName): The :code:`parking` icon.
        PARKING_OFF (IconName): The :code:`parking-off` icon.
        PASSWORD (IconName): The :code:`password` icon.
        PAW (IconName): The :code:`paw` icon.
        PAW_FILLED (IconName): The :code:`paw-filled` icon.
        PAW_OFF (IconName): The :code:`paw-off` icon.
        PDF (IconName): The :code:`pdf` icon.
        PEACE (IconName): The :code:`peace` icon.
        PENCIL (IconName): The :code:`pencil` icon.
        PENCIL_MINUS (IconName): The :code:`pencil-minus` icon.
        PENCIL_OFF (IconName): The :code:`pencil-off` icon.
        PENCIL_PLUS (IconName): The :code:`pencil-plus` icon.
        PENNANT (IconName): The :code:`pennant` icon.
        PENNANT_2 (IconName): The :code:`pennant-2` icon.
        PENNANT_2_FILLED (IconName): The :code:`pennant-2-filled` icon.
        PENNANT_FILLED (IconName): The :code:`pennant-filled` icon.
        PENNANT_OFF (IconName): The :code:`pennant-off` icon.
        PENTAGON (IconName): The :code:`pentagon` icon.
        PENTAGON_FILLED (IconName): The :code:`pentagon-filled` icon.
        PENTAGON_OFF (IconName): The :code:`pentagon-off` icon.
        PENTAGRAM (IconName): The :code:`pentagram` icon.
        PEPPER (IconName): The :code:`pepper` icon.
        PEPPER_OFF (IconName): The :code:`pepper-off` icon.
        PERCENTAGE (IconName): The :code:`percentage` icon.
        PERFUME (IconName): The :code:`perfume` icon.
        PERSPECTIVE (IconName): The :code:`perspective` icon.
        PERSPECTIVE_OFF (IconName): The :code:`perspective-off` icon.
        PHONE (IconName): The :code:`phone` icon.
        PHONE_CALL (IconName): The :code:`phone-call` icon.
        PHONE_CALLING (IconName): The :code:`phone-calling` icon.
        PHONE_CHECK (IconName): The :code:`phone-check` icon.
        PHONE_FILLED (IconName): The :code:`phone-filled` icon.
        PHONE_INCOMING (IconName): The :code:`phone-incoming` icon.
        PHONE_OFF (IconName): The :code:`phone-off` icon.
        PHONE_OUTGOING (IconName): The :code:`phone-outgoing` icon.
        PHONE_PAUSE (IconName): The :code:`phone-pause` icon.
        PHONE_PLUS (IconName): The :code:`phone-plus` icon.
        PHONE_X (IconName): The :code:`phone-x` icon.
        PHOTO (IconName): The :code:`photo` icon.
        PHOTO_AI (IconName): The :code:`photo-ai` icon.
        PHOTO_BOLT (IconName): The :code:`photo-bolt` icon.
        PHOTO_CANCEL (IconName): The :code:`photo-cancel` icon.
        PHOTO_CHECK (IconName): The :code:`photo-check` icon.
        PHOTO_CODE (IconName): The :code:`photo-code` icon.
        PHOTO_COG (IconName): The :code:`photo-cog` icon.
        PHOTO_DOLLAR (IconName): The :code:`photo-dollar` icon.
        PHOTO_DOWN (IconName): The :code:`photo-down` icon.
        PHOTO_EDIT (IconName): The :code:`photo-edit` icon.
        PHOTO_EXCLAMATION (IconName): The :code:`photo-exclamation` icon.
        PHOTO_FILLED (IconName): The :code:`photo-filled` icon.
        PHOTO_HEART (IconName): The :code:`photo-heart` icon.
        PHOTO_MINUS (IconName): The :code:`photo-minus` icon.
        PHOTO_OFF (IconName): The :code:`photo-off` icon.
        PHOTO_PAUSE (IconName): The :code:`photo-pause` icon.
        PHOTO_PIN (IconName): The :code:`photo-pin` icon.
        PHOTO_PLUS (IconName): The :code:`photo-plus` icon.
        PHOTO_QUESTION (IconName): The :code:`photo-question` icon.
        PHOTO_SEARCH (IconName): The :code:`photo-search` icon.
        PHOTO_SENSOR (IconName): The :code:`photo-sensor` icon.
        PHOTO_SENSOR_2 (IconName): The :code:`photo-sensor-2` icon.
        PHOTO_SENSOR_3 (IconName): The :code:`photo-sensor-3` icon.
        PHOTO_SHARE (IconName): The :code:`photo-share` icon.
        PHOTO_SHIELD (IconName): The :code:`photo-shield` icon.
        PHOTO_STAR (IconName): The :code:`photo-star` icon.
        PHOTO_UP (IconName): The :code:`photo-up` icon.
        PHOTO_X (IconName): The :code:`photo-x` icon.
        PHYSOTHERAPIST (IconName): The :code:`physotherapist` icon.
        PIANO (IconName): The :code:`piano` icon.
        PICK (IconName): The :code:`pick` icon.
        PICTURE_IN_PICTURE (IconName): The :code:`picture-in-picture` icon.
        PICTURE_IN_PICTURE_OFF (IconName): The :code:`picture-in-picture-off` icon.
        PICTURE_IN_PICTURE_ON (IconName): The :code:`picture-in-picture-on` icon.
        PICTURE_IN_PICTURE_TOP (IconName): The :code:`picture-in-picture-top` icon.
        PIG (IconName): The :code:`pig` icon.
        PIG_MONEY (IconName): The :code:`pig-money` icon.
        PIG_OFF (IconName): The :code:`pig-off` icon.
        PILCROW (IconName): The :code:`pilcrow` icon.
        PILL (IconName): The :code:`pill` icon.
        PILL_OFF (IconName): The :code:`pill-off` icon.
        PILLS (IconName): The :code:`pills` icon.
        PIN (IconName): The :code:`pin` icon.
        PIN_FILLED (IconName): The :code:`pin-filled` icon.
        PING_PONG (IconName): The :code:`ping-pong` icon.
        PINNED (IconName): The :code:`pinned` icon.
        PINNED_FILLED (IconName): The :code:`pinned-filled` icon.
        PINNED_OFF (IconName): The :code:`pinned-off` icon.
        PIZZA (IconName): The :code:`pizza` icon.
        PIZZA_OFF (IconName): The :code:`pizza-off` icon.
        PLACEHOLDER (IconName): The :code:`placeholder` icon.
        PLANE (IconName): The :code:`plane` icon.
        PLANE_ARRIVAL (IconName): The :code:`plane-arrival` icon.
        PLANE_DEPARTURE (IconName): The :code:`plane-departure` icon.
        PLANE_INFLIGHT (IconName): The :code:`plane-inflight` icon.
        PLANE_OFF (IconName): The :code:`plane-off` icon.
        PLANE_TILT (IconName): The :code:`plane-tilt` icon.
        PLANET (IconName): The :code:`planet` icon.
        PLANET_OFF (IconName): The :code:`planet-off` icon.
        PLANT (IconName): The :code:`plant` icon.
        PLANT_2 (IconName): The :code:`plant-2` icon.
        PLANT_2_OFF (IconName): The :code:`plant-2-off` icon.
        PLANT_OFF (IconName): The :code:`plant-off` icon.
        PLAY_BASKETBALL (IconName): The :code:`play-basketball` icon.
        PLAY_CARD (IconName): The :code:`play-card` icon.
        PLAY_CARD_OFF (IconName): The :code:`play-card-off` icon.
        PLAY_FOOTBALL (IconName): The :code:`play-football` icon.
        PLAY_HANDBALL (IconName): The :code:`play-handball` icon.
        PLAY_VOLLEYBALL (IconName): The :code:`play-volleyball` icon.
        PLAYER_EJECT (IconName): The :code:`player-eject` icon.
        PLAYER_EJECT_FILLED (IconName): The :code:`player-eject-filled` icon.
        PLAYER_PAUSE (IconName): The :code:`player-pause` icon.
        PLAYER_PAUSE_FILLED (IconName): The :code:`player-pause-filled` icon.
        PLAYER_PLAY (IconName): The :code:`player-play` icon.
        PLAYER_PLAY_FILLED (IconName): The :code:`player-play-filled` icon.
        PLAYER_RECORD (IconName): The :code:`player-record` icon.
        PLAYER_RECORD_FILLED (IconName): The :code:`player-record-filled` icon.
        PLAYER_SKIP_BACK (IconName): The :code:`player-skip-back` icon.
        PLAYER_SKIP_BACK_FILLED (IconName): The :code:`player-skip-back-filled` icon.
        PLAYER_SKIP_FORWARD (IconName): The :code:`player-skip-forward` icon.
        PLAYER_SKIP_FORWARD_FILLED (IconName): The :code:`player-skip-forward-filled` icon.
        PLAYER_STOP (IconName): The :code:`player-stop` icon.
        PLAYER_STOP_FILLED (IconName): The :code:`player-stop-filled` icon.
        PLAYER_TRACK_NEXT (IconName): The :code:`player-track-next` icon.
        PLAYER_TRACK_NEXT_FILLED (IconName): The :code:`player-track-next-filled` icon.
        PLAYER_TRACK_PREV (IconName): The :code:`player-track-prev` icon.
        PLAYER_TRACK_PREV_FILLED (IconName): The :code:`player-track-prev-filled` icon.
        PLAYLIST (IconName): The :code:`playlist` icon.
        PLAYLIST_ADD (IconName): The :code:`playlist-add` icon.
        PLAYLIST_OFF (IconName): The :code:`playlist-off` icon.
        PLAYLIST_X (IconName): The :code:`playlist-x` icon.
        PLAYSTATION_CIRCLE (IconName): The :code:`playstation-circle` icon.
        PLAYSTATION_SQUARE (IconName): The :code:`playstation-square` icon.
        PLAYSTATION_TRIANGLE (IconName): The :code:`playstation-triangle` icon.
        PLAYSTATION_X (IconName): The :code:`playstation-x` icon.
        PLUG (IconName): The :code:`plug` icon.
        PLUG_CONNECTED (IconName): The :code:`plug-connected` icon.
        PLUG_CONNECTED_X (IconName): The :code:`plug-connected-x` icon.
        PLUG_OFF (IconName): The :code:`plug-off` icon.
        PLUG_X (IconName): The :code:`plug-x` icon.
        PLUS (IconName): The :code:`plus` icon.
        PLUS_EQUAL (IconName): The :code:`plus-equal` icon.
        PLUS_MINUS (IconName): The :code:`plus-minus` icon.
        PNG (IconName): The :code:`png` icon.
        PODIUM (IconName): The :code:`podium` icon.
        PODIUM_OFF (IconName): The :code:`podium-off` icon.
        POINT (IconName): The :code:`point` icon.
        POINT_FILLED (IconName): The :code:`point-filled` icon.
        POINT_OFF (IconName): The :code:`point-off` icon.
        POINTER (IconName): The :code:`pointer` icon.
        POINTER_BOLT (IconName): The :code:`pointer-bolt` icon.
        POINTER_CANCEL (IconName): The :code:`pointer-cancel` icon.
        POINTER_CHECK (IconName): The :code:`pointer-check` icon.
        POINTER_CODE (IconName): The :code:`pointer-code` icon.
        POINTER_COG (IconName): The :code:`pointer-cog` icon.
        POINTER_DOLLAR (IconName): The :code:`pointer-dollar` icon.
        POINTER_DOWN (IconName): The :code:`pointer-down` icon.
        POINTER_EXCLAMATION (IconName): The :code:`pointer-exclamation` icon.
        POINTER_HEART (IconName): The :code:`pointer-heart` icon.
        POINTER_MINUS (IconName): The :code:`pointer-minus` icon.
        POINTER_OFF (IconName): The :code:`pointer-off` icon.
        POINTER_PAUSE (IconName): The :code:`pointer-pause` icon.
        POINTER_PIN (IconName): The :code:`pointer-pin` icon.
        POINTER_PLUS (IconName): The :code:`pointer-plus` icon.
        POINTER_QUESTION (IconName): The :code:`pointer-question` icon.
        POINTER_SEARCH (IconName): The :code:`pointer-search` icon.
        POINTER_SHARE (IconName): The :code:`pointer-share` icon.
        POINTER_STAR (IconName): The :code:`pointer-star` icon.
        POINTER_UP (IconName): The :code:`pointer-up` icon.
        POINTER_X (IconName): The :code:`pointer-x` icon.
        POKEBALL (IconName): The :code:`pokeball` icon.
        POKEBALL_OFF (IconName): The :code:`pokeball-off` icon.
        POKER_CHIP (IconName): The :code:`poker-chip` icon.
        POLAROID (IconName): The :code:`polaroid` icon.
        POLAROID_FILLED (IconName): The :code:`polaroid-filled` icon.
        POLYGON (IconName): The :code:`polygon` icon.
        POLYGON_OFF (IconName): The :code:`polygon-off` icon.
        POO (IconName): The :code:`poo` icon.
        POOL (IconName): The :code:`pool` icon.
        POOL_OFF (IconName): The :code:`pool-off` icon.
        POWER (IconName): The :code:`power` icon.
        PRAY (IconName): The :code:`pray` icon.
        PREMIUM_RIGHTS (IconName): The :code:`premium-rights` icon.
        PRESCRIPTION (IconName): The :code:`prescription` icon.
        PRESENTATION (IconName): The :code:`presentation` icon.
        PRESENTATION_ANALYTICS (IconName): The :code:`presentation-analytics` icon.
        PRESENTATION_OFF (IconName): The :code:`presentation-off` icon.
        PRINTER (IconName): The :code:`printer` icon.
        PRINTER_OFF (IconName): The :code:`printer-off` icon.
        PRISM (IconName): The :code:`prism` icon.
        PRISM_OFF (IconName): The :code:`prism-off` icon.
        PRISM_PLUS (IconName): The :code:`prism-plus` icon.
        PRISON (IconName): The :code:`prison` icon.
        PROGRESS (IconName): The :code:`progress` icon.
        PROGRESS_ALERT (IconName): The :code:`progress-alert` icon.
        PROGRESS_BOLT (IconName): The :code:`progress-bolt` icon.
        PROGRESS_CHECK (IconName): The :code:`progress-check` icon.
        PROGRESS_DOWN (IconName): The :code:`progress-down` icon.
        PROGRESS_HELP (IconName): The :code:`progress-help` icon.
        PROGRESS_X (IconName): The :code:`progress-x` icon.
        PROMPT (IconName): The :code:`prompt` icon.
        PROPELLER (IconName): The :code:`propeller` icon.
        PROPELLER_OFF (IconName): The :code:`propeller-off` icon.
        PUMPKIN_SCARY (IconName): The :code:`pumpkin-scary` icon.
        PUZZLE (IconName): The :code:`puzzle` icon.
        PUZZLE_2 (IconName): The :code:`puzzle-2` icon.
        PUZZLE_FILLED (IconName): The :code:`puzzle-filled` icon.
        PUZZLE_OFF (IconName): The :code:`puzzle-off` icon.
        PYRAMID (IconName): The :code:`pyramid` icon.
        PYRAMID_OFF (IconName): The :code:`pyramid-off` icon.
        PYRAMID_PLUS (IconName): The :code:`pyramid-plus` icon.
        QRCODE (IconName): The :code:`qrcode` icon.
        QRCODE_OFF (IconName): The :code:`qrcode-off` icon.
        QUESTION_MARK (IconName): The :code:`question-mark` icon.
        QUOTE (IconName): The :code:`quote` icon.
        QUOTE_OFF (IconName): The :code:`quote-off` icon.
        RADAR (IconName): The :code:`radar` icon.
        RADAR_2 (IconName): The :code:`radar-2` icon.
        RADAR_OFF (IconName): The :code:`radar-off` icon.
        RADIO (IconName): The :code:`radio` icon.
        RADIO_OFF (IconName): The :code:`radio-off` icon.
        RADIOACTIVE (IconName): The :code:`radioactive` icon.
        RADIOACTIVE_FILLED (IconName): The :code:`radioactive-filled` icon.
        RADIOACTIVE_OFF (IconName): The :code:`radioactive-off` icon.
        RADIUS_BOTTOM_LEFT (IconName): The :code:`radius-bottom-left` icon.
        RADIUS_BOTTOM_RIGHT (IconName): The :code:`radius-bottom-right` icon.
        RADIUS_TOP_LEFT (IconName): The :code:`radius-top-left` icon.
        RADIUS_TOP_RIGHT (IconName): The :code:`radius-top-right` icon.
        RAINBOW (IconName): The :code:`rainbow` icon.
        RAINBOW_OFF (IconName): The :code:`rainbow-off` icon.
        RATING_12_PLUS (IconName): The :code:`rating-12-plus` icon.
        RATING_14_PLUS (IconName): The :code:`rating-14-plus` icon.
        RATING_16_PLUS (IconName): The :code:`rating-16-plus` icon.
        RATING_18_PLUS (IconName): The :code:`rating-18-plus` icon.
        RATING_21_PLUS (IconName): The :code:`rating-21-plus` icon.
        RAZOR (IconName): The :code:`razor` icon.
        RAZOR_ELECTRIC (IconName): The :code:`razor-electric` icon.
        RECEIPT (IconName): The :code:`receipt` icon.
        RECEIPT_2 (IconName): The :code:`receipt-2` icon.
        RECEIPT_OFF (IconName): The :code:`receipt-off` icon.
        RECEIPT_REFUND (IconName): The :code:`receipt-refund` icon.
        RECEIPT_TAX (IconName): The :code:`receipt-tax` icon.
        RECHARGING (IconName): The :code:`recharging` icon.
        RECORD_MAIL (IconName): The :code:`record-mail` icon.
        RECORD_MAIL_OFF (IconName): The :code:`record-mail-off` icon.
        RECTANGLE (IconName): The :code:`rectangle` icon.
        RECTANGLE_FILLED (IconName): The :code:`rectangle-filled` icon.
        RECTANGLE_ROUNDED_BOTTOM (IconName): The :code:`rectangle-rounded-bottom` icon.
        RECTANGLE_ROUNDED_TOP (IconName): The :code:`rectangle-rounded-top` icon.
        RECTANGLE_VERTICAL (IconName): The :code:`rectangle-vertical` icon.
        RECTANGLE_VERTICAL_FILLED (IconName): The :code:`rectangle-vertical-filled` icon.
        RECTANGULAR_PRISM (IconName): The :code:`rectangular-prism` icon.
        RECTANGULAR_PRISM_OFF (IconName): The :code:`rectangular-prism-off` icon.
        RECTANGULAR_PRISM_PLUS (IconName): The :code:`rectangular-prism-plus` icon.
        RECYCLE (IconName): The :code:`recycle` icon.
        RECYCLE_OFF (IconName): The :code:`recycle-off` icon.
        REFRESH (IconName): The :code:`refresh` icon.
        REFRESH_ALERT (IconName): The :code:`refresh-alert` icon.
        REFRESH_DOT (IconName): The :code:`refresh-dot` icon.
        REFRESH_OFF (IconName): The :code:`refresh-off` icon.
        REGEX (IconName): The :code:`regex` icon.
        REGEX_OFF (IconName): The :code:`regex-off` icon.
        REGISTERED (IconName): The :code:`registered` icon.
        RELATION_MANY_TO_MANY (IconName): The :code:`relation-many-to-many` icon.
        RELATION_ONE_TO_MANY (IconName): The :code:`relation-one-to-many` icon.
        RELATION_ONE_TO_ONE (IconName): The :code:`relation-one-to-one` icon.
        RELOAD (IconName): The :code:`reload` icon.
        REPEAT (IconName): The :code:`repeat` icon.
        REPEAT_OFF (IconName): The :code:`repeat-off` icon.
        REPEAT_ONCE (IconName): The :code:`repeat-once` icon.
        REPLACE (IconName): The :code:`replace` icon.
        REPLACE_FILLED (IconName): The :code:`replace-filled` icon.
        REPLACE_OFF (IconName): The :code:`replace-off` icon.
        REPORT (IconName): The :code:`report` icon.
        REPORT_ANALYTICS (IconName): The :code:`report-analytics` icon.
        REPORT_MEDICAL (IconName): The :code:`report-medical` icon.
        REPORT_MONEY (IconName): The :code:`report-money` icon.
        REPORT_OFF (IconName): The :code:`report-off` icon.
        REPORT_SEARCH (IconName): The :code:`report-search` icon.
        RESERVED_LINE (IconName): The :code:`reserved-line` icon.
        RESIZE (IconName): The :code:`resize` icon.
        RESTORE (IconName): The :code:`restore` icon.
        REWIND_BACKWARD_10 (IconName): The :code:`rewind-backward-10` icon.
        REWIND_BACKWARD_15 (IconName): The :code:`rewind-backward-15` icon.
        REWIND_BACKWARD_20 (IconName): The :code:`rewind-backward-20` icon.
        REWIND_BACKWARD_30 (IconName): The :code:`rewind-backward-30` icon.
        REWIND_BACKWARD_40 (IconName): The :code:`rewind-backward-40` icon.
        REWIND_BACKWARD_5 (IconName): The :code:`rewind-backward-5` icon.
        REWIND_BACKWARD_50 (IconName): The :code:`rewind-backward-50` icon.
        REWIND_BACKWARD_60 (IconName): The :code:`rewind-backward-60` icon.
        REWIND_FORWARD_10 (IconName): The :code:`rewind-forward-10` icon.
        REWIND_FORWARD_15 (IconName): The :code:`rewind-forward-15` icon.
        REWIND_FORWARD_20 (IconName): The :code:`rewind-forward-20` icon.
        REWIND_FORWARD_30 (IconName): The :code:`rewind-forward-30` icon.
        REWIND_FORWARD_40 (IconName): The :code:`rewind-forward-40` icon.
        REWIND_FORWARD_5 (IconName): The :code:`rewind-forward-5` icon.
        REWIND_FORWARD_50 (IconName): The :code:`rewind-forward-50` icon.
        REWIND_FORWARD_60 (IconName): The :code:`rewind-forward-60` icon.
        RIBBON_HEALTH (IconName): The :code:`ribbon-health` icon.
        RINGS (IconName): The :code:`rings` icon.
        RIPPLE (IconName): The :code:`ripple` icon.
        RIPPLE_OFF (IconName): The :code:`ripple-off` icon.
        ROAD (IconName): The :code:`road` icon.
        ROAD_OFF (IconName): The :code:`road-off` icon.
        ROAD_SIGN (IconName): The :code:`road-sign` icon.
        ROBOT (IconName): The :code:`robot` icon.
        ROBOT_OFF (IconName): The :code:`robot-off` icon.
        ROCKET (IconName): The :code:`rocket` icon.
        ROCKET_OFF (IconName): The :code:`rocket-off` icon.
        ROLLER_SKATING (IconName): The :code:`roller-skating` icon.
        ROLLERCOASTER (IconName): The :code:`rollercoaster` icon.
        ROLLERCOASTER_OFF (IconName): The :code:`rollercoaster-off` icon.
        ROSETTE (IconName): The :code:`rosette` icon.
        ROSETTE_FILLED (IconName): The :code:`rosette-filled` icon.
        ROSETTE_NUMBER_0 (IconName): The :code:`rosette-number-0` icon.
        ROSETTE_NUMBER_1 (IconName): The :code:`rosette-number-1` icon.
        ROSETTE_NUMBER_2 (IconName): The :code:`rosette-number-2` icon.
        ROSETTE_NUMBER_3 (IconName): The :code:`rosette-number-3` icon.
        ROSETTE_NUMBER_4 (IconName): The :code:`rosette-number-4` icon.
        ROSETTE_NUMBER_5 (IconName): The :code:`rosette-number-5` icon.
        ROSETTE_NUMBER_6 (IconName): The :code:`rosette-number-6` icon.
        ROSETTE_NUMBER_7 (IconName): The :code:`rosette-number-7` icon.
        ROSETTE_NUMBER_8 (IconName): The :code:`rosette-number-8` icon.
        ROSETTE_NUMBER_9 (IconName): The :code:`rosette-number-9` icon.
        ROTATE (IconName): The :code:`rotate` icon.
        ROTATE_2 (IconName): The :code:`rotate-2` icon.
        ROTATE_360 (IconName): The :code:`rotate-360` icon.
        ROTATE_CLOCKWISE (IconName): The :code:`rotate-clockwise` icon.
        ROTATE_CLOCKWISE_2 (IconName): The :code:`rotate-clockwise-2` icon.
        ROTATE_DOT (IconName): The :code:`rotate-dot` icon.
        ROTATE_RECTANGLE (IconName): The :code:`rotate-rectangle` icon.
        ROUTE (IconName): The :code:`route` icon.
        ROUTE_2 (IconName): The :code:`route-2` icon.
        ROUTE_OFF (IconName): The :code:`route-off` icon.
        ROUTER (IconName): The :code:`router` icon.
        ROUTER_OFF (IconName): The :code:`router-off` icon.
        ROW_INSERT_BOTTOM (IconName): The :code:`row-insert-bottom` icon.
        ROW_INSERT_TOP (IconName): The :code:`row-insert-top` icon.
        ROW_REMOVE (IconName): The :code:`row-remove` icon.
        RSS (IconName): The :code:`rss` icon.
        RUBBER_STAMP (IconName): The :code:`rubber-stamp` icon.
        RUBBER_STAMP_OFF (IconName): The :code:`rubber-stamp-off` icon.
        RULER (IconName): The :code:`ruler` icon.
        RULER_2 (IconName): The :code:`ruler-2` icon.
        RULER_2_OFF (IconName): The :code:`ruler-2-off` icon.
        RULER_3 (IconName): The :code:`ruler-3` icon.
        RULER_MEASURE (IconName): The :code:`ruler-measure` icon.
        RULER_OFF (IconName): The :code:`ruler-off` icon.
        RUN (IconName): The :code:`run` icon.
        S_TURN_DOWN (IconName): The :code:`s-turn-down` icon.
        S_TURN_LEFT (IconName): The :code:`s-turn-left` icon.
        S_TURN_RIGHT (IconName): The :code:`s-turn-right` icon.
        S_TURN_UP (IconName): The :code:`s-turn-up` icon.
        SAILBOAT (IconName): The :code:`sailboat` icon.
        SAILBOAT_2 (IconName): The :code:`sailboat-2` icon.
        SAILBOAT_OFF (IconName): The :code:`sailboat-off` icon.
        SALAD (IconName): The :code:`salad` icon.
        SALT (IconName): The :code:`salt` icon.
        SATELLITE (IconName): The :code:`satellite` icon.
        SATELLITE_OFF (IconName): The :code:`satellite-off` icon.
        SAUSAGE (IconName): The :code:`sausage` icon.
        SCALE (IconName): The :code:`scale` icon.
        SCALE_OFF (IconName): The :code:`scale-off` icon.
        SCALE_OUTLINE (IconName): The :code:`scale-outline` icon.
        SCALE_OUTLINE_OFF (IconName): The :code:`scale-outline-off` icon.
        SCAN (IconName): The :code:`scan` icon.
        SCAN_EYE (IconName): The :code:`scan-eye` icon.
        SCHEMA (IconName): The :code:`schema` icon.
        SCHEMA_OFF (IconName): The :code:`schema-off` icon.
        SCHOOL (IconName): The :code:`school` icon.
        SCHOOL_BELL (IconName): The :code:`school-bell` icon.
        SCHOOL_OFF (IconName): The :code:`school-off` icon.
        SCISSORS (IconName): The :code:`scissors` icon.
        SCISSORS_OFF (IconName): The :code:`scissors-off` icon.
        SCOOTER (IconName): The :code:`scooter` icon.
        SCOOTER_ELECTRIC (IconName): The :code:`scooter-electric` icon.
        SCOREBOARD (IconName): The :code:`scoreboard` icon.
        SCREEN_SHARE (IconName): The :code:`screen-share` icon.
        SCREEN_SHARE_OFF (IconName): The :code:`screen-share-off` icon.
        SCREENSHOT (IconName): The :code:`screenshot` icon.
        SCRIBBLE (IconName): The :code:`scribble` icon.
        SCRIBBLE_OFF (IconName): The :code:`scribble-off` icon.
        SCRIPT (IconName): The :code:`script` icon.
        SCRIPT_MINUS (IconName): The :code:`script-minus` icon.
        SCRIPT_PLUS (IconName): The :code:`script-plus` icon.
        SCRIPT_X (IconName): The :code:`script-x` icon.
        SCUBA_MASK (IconName): The :code:`scuba-mask` icon.
        SCUBA_MASK_OFF (IconName): The :code:`scuba-mask-off` icon.
        SDK (IconName): The :code:`sdk` icon.
        SEARCH (IconName): The :code:`search` icon.
        SEARCH_OFF (IconName): The :code:`search-off` icon.
        SECTION (IconName): The :code:`section` icon.
        SECTION_SIGN (IconName): The :code:`section-sign` icon.
        SEEDING (IconName): The :code:`seeding` icon.
        SEEDING_OFF (IconName): The :code:`seeding-off` icon.
        SELECT (IconName): The :code:`select` icon.
        SELECT_ALL (IconName): The :code:`select-all` icon.
        SELECTOR (IconName): The :code:`selector` icon.
        SEND (IconName): The :code:`send` icon.
        SEND_OFF (IconName): The :code:`send-off` icon.
        SEO (IconName): The :code:`seo` icon.
        SEPARATOR (IconName): The :code:`separator` icon.
        SEPARATOR_HORIZONTAL (IconName): The :code:`separator-horizontal` icon.
        SEPARATOR_VERTICAL (IconName): The :code:`separator-vertical` icon.
        SERVER (IconName): The :code:`server` icon.
        SERVER_2 (IconName): The :code:`server-2` icon.
        SERVER_BOLT (IconName): The :code:`server-bolt` icon.
        SERVER_COG (IconName): The :code:`server-cog` icon.
        SERVER_OFF (IconName): The :code:`server-off` icon.
        SERVICEMARK (IconName): The :code:`servicemark` icon.
        SETTINGS (IconName): The :code:`settings` icon.
        SETTINGS_2 (IconName): The :code:`settings-2` icon.
        SETTINGS_AUTOMATION (IconName): The :code:`settings-automation` icon.
        SETTINGS_BOLT (IconName): The :code:`settings-bolt` icon.
        SETTINGS_CANCEL (IconName): The :code:`settings-cancel` icon.
        SETTINGS_CHECK (IconName): The :code:`settings-check` icon.
        SETTINGS_CODE (IconName): The :code:`settings-code` icon.
        SETTINGS_COG (IconName): The :code:`settings-cog` icon.
        SETTINGS_DOLLAR (IconName): The :code:`settings-dollar` icon.
        SETTINGS_DOWN (IconName): The :code:`settings-down` icon.
        SETTINGS_EXCLAMATION (IconName): The :code:`settings-exclamation` icon.
        SETTINGS_FILLED (IconName): The :code:`settings-filled` icon.
        SETTINGS_HEART (IconName): The :code:`settings-heart` icon.
        SETTINGS_MINUS (IconName): The :code:`settings-minus` icon.
        SETTINGS_OFF (IconName): The :code:`settings-off` icon.
        SETTINGS_PAUSE (IconName): The :code:`settings-pause` icon.
        SETTINGS_PIN (IconName): The :code:`settings-pin` icon.
        SETTINGS_PLUS (IconName): The :code:`settings-plus` icon.
        SETTINGS_QUESTION (IconName): The :code:`settings-question` icon.
        SETTINGS_SEARCH (IconName): The :code:`settings-search` icon.
        SETTINGS_SHARE (IconName): The :code:`settings-share` icon.
        SETTINGS_STAR (IconName): The :code:`settings-star` icon.
        SETTINGS_UP (IconName): The :code:`settings-up` icon.
        SETTINGS_X (IconName): The :code:`settings-x` icon.
        SHADOW (IconName): The :code:`shadow` icon.
        SHADOW_OFF (IconName): The :code:`shadow-off` icon.
        SHAPE (IconName): The :code:`shape` icon.
        SHAPE_2 (IconName): The :code:`shape-2` icon.
        SHAPE_3 (IconName): The :code:`shape-3` icon.
        SHAPE_OFF (IconName): The :code:`shape-off` icon.
        SHARE (IconName): The :code:`share` icon.
        SHARE_2 (IconName): The :code:`share-2` icon.
        SHARE_3 (IconName): The :code:`share-3` icon.
        SHARE_OFF (IconName): The :code:`share-off` icon.
        SHI_JUMPING (IconName): The :code:`shi-jumping` icon.
        SHIELD (IconName): The :code:`shield` icon.
        SHIELD_BOLT (IconName): The :code:`shield-bolt` icon.
        SHIELD_CANCEL (IconName): The :code:`shield-cancel` icon.
        SHIELD_CHECK (IconName): The :code:`shield-check` icon.
        SHIELD_CHECK_FILLED (IconName): The :code:`shield-check-filled` icon.
        SHIELD_CHECKERED (IconName): The :code:`shield-checkered` icon.
        SHIELD_CHECKERED_FILLED (IconName): The :code:`shield-checkered-filled` icon.
        SHIELD_CHEVRON (IconName): The :code:`shield-chevron` icon.
        SHIELD_CODE (IconName): The :code:`shield-code` icon.
        SHIELD_COG (IconName): The :code:`shield-cog` icon.
        SHIELD_DOLLAR (IconName): The :code:`shield-dollar` icon.
        SHIELD_DOWN (IconName): The :code:`shield-down` icon.
        SHIELD_EXCLAMATION (IconName): The :code:`shield-exclamation` icon.
        SHIELD_FILLED (IconName): The :code:`shield-filled` icon.
        SHIELD_HALF (IconName): The :code:`shield-half` icon.
        SHIELD_HALF_FILLED (IconName): The :code:`shield-half-filled` icon.
        SHIELD_HEART (IconName): The :code:`shield-heart` icon.
        SHIELD_LOCK (IconName): The :code:`shield-lock` icon.
        SHIELD_LOCK_FILLED (IconName): The :code:`shield-lock-filled` icon.
        SHIELD_MINUS (IconName): The :code:`shield-minus` icon.
        SHIELD_OFF (IconName): The :code:`shield-off` icon.
        SHIELD_PAUSE (IconName): The :code:`shield-pause` icon.
        SHIELD_PIN (IconName): The :code:`shield-pin` icon.
        SHIELD_PLUS (IconName): The :code:`shield-plus` icon.
        SHIELD_QUESTION (IconName): The :code:`shield-question` icon.
        SHIELD_SEARCH (IconName): The :code:`shield-search` icon.
        SHIELD_SHARE (IconName): The :code:`shield-share` icon.
        SHIELD_STAR (IconName): The :code:`shield-star` icon.
        SHIELD_UP (IconName): The :code:`shield-up` icon.
        SHIELD_X (IconName): The :code:`shield-x` icon.
        SHIP (IconName): The :code:`ship` icon.
        SHIP_OFF (IconName): The :code:`ship-off` icon.
        SHIRT (IconName): The :code:`shirt` icon.
        SHIRT_FILLED (IconName): The :code:`shirt-filled` icon.
        SHIRT_OFF (IconName): The :code:`shirt-off` icon.
        SHIRT_SPORT (IconName): The :code:`shirt-sport` icon.
        SHOE (IconName): The :code:`shoe` icon.
        SHOE_OFF (IconName): The :code:`shoe-off` icon.
        SHOPPING_BAG (IconName): The :code:`shopping-bag` icon.
        SHOPPING_CART (IconName): The :code:`shopping-cart` icon.
        SHOPPING_CART_DISCOUNT (IconName): The :code:`shopping-cart-discount` icon.
        SHOPPING_CART_OFF (IconName): The :code:`shopping-cart-off` icon.
        SHOPPING_CART_PLUS (IconName): The :code:`shopping-cart-plus` icon.
        SHOPPING_CART_X (IconName): The :code:`shopping-cart-x` icon.
        SHOVEL (IconName): The :code:`shovel` icon.
        SHREDDER (IconName): The :code:`shredder` icon.
        SIGN_LEFT (IconName): The :code:`sign-left` icon.
        SIGN_LEFT_FILLED (IconName): The :code:`sign-left-filled` icon.
        SIGN_RIGHT (IconName): The :code:`sign-right` icon.
        SIGN_RIGHT_FILLED (IconName): The :code:`sign-right-filled` icon.
        SIGNAL_2G (IconName): The :code:`signal-2g` icon.
        SIGNAL_3G (IconName): The :code:`signal-3g` icon.
        SIGNAL_4G (IconName): The :code:`signal-4g` icon.
        SIGNAL_4G_PLUS (IconName): The :code:`signal-4g-plus` icon.
        SIGNAL_5G (IconName): The :code:`signal-5g` icon.
        SIGNAL_6G (IconName): The :code:`signal-6g` icon.
        SIGNAL_E (IconName): The :code:`signal-e` icon.
        SIGNAL_G (IconName): The :code:`signal-g` icon.
        SIGNAL_H (IconName): The :code:`signal-h` icon.
        SIGNAL_H_PLUS (IconName): The :code:`signal-h-plus` icon.
        SIGNAL_LTE (IconName): The :code:`signal-lte` icon.
        SIGNATURE (IconName): The :code:`signature` icon.
        SIGNATURE_OFF (IconName): The :code:`signature-off` icon.
        SITEMAP (IconName): The :code:`sitemap` icon.
        SITEMAP_OFF (IconName): The :code:`sitemap-off` icon.
        SKATEBOARD (IconName): The :code:`skateboard` icon.
        SKATEBOARD_OFF (IconName): The :code:`skateboard-off` icon.
        SKATEBOARDING (IconName): The :code:`skateboarding` icon.
        SKULL (IconName): The :code:`skull` icon.
        SLASH (IconName): The :code:`slash` icon.
        SLASHES (IconName): The :code:`slashes` icon.
        SLEIGH (IconName): The :code:`sleigh` icon.
        SLICE (IconName): The :code:`slice` icon.
        SLIDESHOW (IconName): The :code:`slideshow` icon.
        SMART_HOME (IconName): The :code:`smart-home` icon.
        SMART_HOME_OFF (IconName): The :code:`smart-home-off` icon.
        SMOKING (IconName): The :code:`smoking` icon.
        SMOKING_NO (IconName): The :code:`smoking-no` icon.
        SNOWFLAKE (IconName): The :code:`snowflake` icon.
        SNOWFLAKE_OFF (IconName): The :code:`snowflake-off` icon.
        SNOWMAN (IconName): The :code:`snowman` icon.
        SOCCER_FIELD (IconName): The :code:`soccer-field` icon.
        SOCIAL (IconName): The :code:`social` icon.
        SOCIAL_OFF (IconName): The :code:`social-off` icon.
        SOCK (IconName): The :code:`sock` icon.
        SOFA (IconName): The :code:`sofa` icon.
        SOFA_OFF (IconName): The :code:`sofa-off` icon.
        SOLAR_PANEL (IconName): The :code:`solar-panel` icon.
        SOLAR_PANEL_2 (IconName): The :code:`solar-panel-2` icon.
        SORT_0_9 (IconName): The :code:`sort-0-9` icon.
        SORT_9_0 (IconName): The :code:`sort-9-0` icon.
        SORT_A_Z (IconName): The :code:`sort-a-z` icon.
        SORT_ASCENDING (IconName): The :code:`sort-ascending` icon.
        SORT_ASCENDING_2 (IconName): The :code:`sort-ascending-2` icon.
        SORT_ASCENDING_LETTERS (IconName): The :code:`sort-ascending-letters` icon.
        SORT_ASCENDING_NUMBERS (IconName): The :code:`sort-ascending-numbers` icon.
        SORT_DESCENDING (IconName): The :code:`sort-descending` icon.
        SORT_DESCENDING_2 (IconName): The :code:`sort-descending-2` icon.
        SORT_DESCENDING_LETTERS (IconName): The :code:`sort-descending-letters` icon.
        SORT_DESCENDING_NUMBERS (IconName): The :code:`sort-descending-numbers` icon.
        SORT_Z_A (IconName): The :code:`sort-z-a` icon.
        SOS (IconName): The :code:`sos` icon.
        SOUP (IconName): The :code:`soup` icon.
        SOUP_OFF (IconName): The :code:`soup-off` icon.
        SOURCE_CODE (IconName): The :code:`source-code` icon.
        SPACE (IconName): The :code:`space` icon.
        SPACE_OFF (IconName): The :code:`space-off` icon.
        SPACING_HORIZONTAL (IconName): The :code:`spacing-horizontal` icon.
        SPACING_VERTICAL (IconName): The :code:`spacing-vertical` icon.
        SPADE (IconName): The :code:`spade` icon.
        SPADE_FILLED (IconName): The :code:`spade-filled` icon.
        SPARKLES (IconName): The :code:`sparkles` icon.
        SPEAKERPHONE (IconName): The :code:`speakerphone` icon.
        SPEEDBOAT (IconName): The :code:`speedboat` icon.
        SPHERE (IconName): The :code:`sphere` icon.
        SPHERE_OFF (IconName): The :code:`sphere-off` icon.
        SPHERE_PLUS (IconName): The :code:`sphere-plus` icon.
        SPIDER (IconName): The :code:`spider` icon.
        SPIRAL (IconName): The :code:`spiral` icon.
        SPIRAL_OFF (IconName): The :code:`spiral-off` icon.
        SPORT_BILLARD (IconName): The :code:`sport-billard` icon.
        SPRAY (IconName): The :code:`spray` icon.
        SPY (IconName): The :code:`spy` icon.
        SPY_OFF (IconName): The :code:`spy-off` icon.
        SQL (IconName): The :code:`sql` icon.
        SQUARE (IconName): The :code:`square` icon.
        SQUARE_0_FILLED (IconName): The :code:`square-0-filled` icon.
        SQUARE_1_FILLED (IconName): The :code:`square-1-filled` icon.
        SQUARE_2_FILLED (IconName): The :code:`square-2-filled` icon.
        SQUARE_3_FILLED (IconName): The :code:`square-3-filled` icon.
        SQUARE_4_FILLED (IconName): The :code:`square-4-filled` icon.
        SQUARE_5_FILLED (IconName): The :code:`square-5-filled` icon.
        SQUARE_6_FILLED (IconName): The :code:`square-6-filled` icon.
        SQUARE_7_FILLED (IconName): The :code:`square-7-filled` icon.
        SQUARE_8_FILLED (IconName): The :code:`square-8-filled` icon.
        SQUARE_9_FILLED (IconName): The :code:`square-9-filled` icon.
        SQUARE_ARROW_DOWN (IconName): The :code:`square-arrow-down` icon.
        SQUARE_ARROW_LEFT (IconName): The :code:`square-arrow-left` icon.
        SQUARE_ARROW_RIGHT (IconName): The :code:`square-arrow-right` icon.
        SQUARE_ARROW_UP (IconName): The :code:`square-arrow-up` icon.
        SQUARE_ASTERISK (IconName): The :code:`square-asterisk` icon.
        SQUARE_CHECK (IconName): The :code:`square-check` icon.
        SQUARE_CHECK_FILLED (IconName): The :code:`square-check-filled` icon.
        SQUARE_CHEVRON_DOWN (IconName): The :code:`square-chevron-down` icon.
        SQUARE_CHEVRON_LEFT (IconName): The :code:`square-chevron-left` icon.
        SQUARE_CHEVRON_RIGHT (IconName): The :code:`square-chevron-right` icon.
        SQUARE_CHEVRON_UP (IconName): The :code:`square-chevron-up` icon.
        SQUARE_CHEVRONS_DOWN (IconName): The :code:`square-chevrons-down` icon.
        SQUARE_CHEVRONS_LEFT (IconName): The :code:`square-chevrons-left` icon.
        SQUARE_CHEVRONS_RIGHT (IconName): The :code:`square-chevrons-right` icon.
        SQUARE_CHEVRONS_UP (IconName): The :code:`square-chevrons-up` icon.
        SQUARE_DOT (IconName): The :code:`square-dot` icon.
        SQUARE_F0 (IconName): The :code:`square-f0` icon.
        SQUARE_F0_FILLED (IconName): The :code:`square-f0-filled` icon.
        SQUARE_F1 (IconName): The :code:`square-f1` icon.
        SQUARE_F1_FILLED (IconName): The :code:`square-f1-filled` icon.
        SQUARE_F2 (IconName): The :code:`square-f2` icon.
        SQUARE_F2_FILLED (IconName): The :code:`square-f2-filled` icon.
        SQUARE_F3 (IconName): The :code:`square-f3` icon.
        SQUARE_F3_FILLED (IconName): The :code:`square-f3-filled` icon.
        SQUARE_F4 (IconName): The :code:`square-f4` icon.
        SQUARE_F4_FILLED (IconName): The :code:`square-f4-filled` icon.
        SQUARE_F5 (IconName): The :code:`square-f5` icon.
        SQUARE_F5_FILLED (IconName): The :code:`square-f5-filled` icon.
        SQUARE_F6 (IconName): The :code:`square-f6` icon.
        SQUARE_F6_FILLED (IconName): The :code:`square-f6-filled` icon.
        SQUARE_F7 (IconName): The :code:`square-f7` icon.
        SQUARE_F7_FILLED (IconName): The :code:`square-f7-filled` icon.
        SQUARE_F8 (IconName): The :code:`square-f8` icon.
        SQUARE_F8_FILLED (IconName): The :code:`square-f8-filled` icon.
        SQUARE_F9 (IconName): The :code:`square-f9` icon.
        SQUARE_F9_FILLED (IconName): The :code:`square-f9-filled` icon.
        SQUARE_FORBID (IconName): The :code:`square-forbid` icon.
        SQUARE_FORBID_2 (IconName): The :code:`square-forbid-2` icon.
        SQUARE_HALF (IconName): The :code:`square-half` icon.
        SQUARE_KEY (IconName): The :code:`square-key` icon.
        SQUARE_LETTER_A (IconName): The :code:`square-letter-a` icon.
        SQUARE_LETTER_B (IconName): The :code:`square-letter-b` icon.
        SQUARE_LETTER_C (IconName): The :code:`square-letter-c` icon.
        SQUARE_LETTER_D (IconName): The :code:`square-letter-d` icon.
        SQUARE_LETTER_E (IconName): The :code:`square-letter-e` icon.
        SQUARE_LETTER_F (IconName): The :code:`square-letter-f` icon.
        SQUARE_LETTER_G (IconName): The :code:`square-letter-g` icon.
        SQUARE_LETTER_H (IconName): The :code:`square-letter-h` icon.
        SQUARE_LETTER_I (IconName): The :code:`square-letter-i` icon.
        SQUARE_LETTER_J (IconName): The :code:`square-letter-j` icon.
        SQUARE_LETTER_K (IconName): The :code:`square-letter-k` icon.
        SQUARE_LETTER_L (IconName): The :code:`square-letter-l` icon.
        SQUARE_LETTER_M (IconName): The :code:`square-letter-m` icon.
        SQUARE_LETTER_N (IconName): The :code:`square-letter-n` icon.
        SQUARE_LETTER_O (IconName): The :code:`square-letter-o` icon.
        SQUARE_LETTER_P (IconName): The :code:`square-letter-p` icon.
        SQUARE_LETTER_Q (IconName): The :code:`square-letter-q` icon.
        SQUARE_LETTER_R (IconName): The :code:`square-letter-r` icon.
        SQUARE_LETTER_S (IconName): The :code:`square-letter-s` icon.
        SQUARE_LETTER_T (IconName): The :code:`square-letter-t` icon.
        SQUARE_LETTER_U (IconName): The :code:`square-letter-u` icon.
        SQUARE_LETTER_V (IconName): The :code:`square-letter-v` icon.
        SQUARE_LETTER_W (IconName): The :code:`square-letter-w` icon.
        SQUARE_LETTER_X (IconName): The :code:`square-letter-x` icon.
        SQUARE_LETTER_Y (IconName): The :code:`square-letter-y` icon.
        SQUARE_LETTER_Z (IconName): The :code:`square-letter-z` icon.
        SQUARE_MINUS (IconName): The :code:`square-minus` icon.
        SQUARE_NUMBER_0 (IconName): The :code:`square-number-0` icon.
        SQUARE_NUMBER_1 (IconName): The :code:`square-number-1` icon.
        SQUARE_NUMBER_2 (IconName): The :code:`square-number-2` icon.
        SQUARE_NUMBER_3 (IconName): The :code:`square-number-3` icon.
        SQUARE_NUMBER_4 (IconName): The :code:`square-number-4` icon.
        SQUARE_NUMBER_5 (IconName): The :code:`square-number-5` icon.
        SQUARE_NUMBER_6 (IconName): The :code:`square-number-6` icon.
        SQUARE_NUMBER_7 (IconName): The :code:`square-number-7` icon.
        SQUARE_NUMBER_8 (IconName): The :code:`square-number-8` icon.
        SQUARE_NUMBER_9 (IconName): The :code:`square-number-9` icon.
        SQUARE_OFF (IconName): The :code:`square-off` icon.
        SQUARE_PLUS (IconName): The :code:`square-plus` icon.
        SQUARE_ROOT (IconName): The :code:`square-root` icon.
        SQUARE_ROOT_2 (IconName): The :code:`square-root-2` icon.
        SQUARE_ROTATED (IconName): The :code:`square-rotated` icon.
        SQUARE_ROTATED_FILLED (IconName): The :code:`square-rotated-filled` icon.
        SQUARE_ROTATED_FORBID (IconName): The :code:`square-rotated-forbid` icon.
        SQUARE_ROTATED_FORBID_2 (IconName): The :code:`square-rotated-forbid-2` icon.
        SQUARE_ROTATED_OFF (IconName): The :code:`square-rotated-off` icon.
        SQUARE_ROUNDED (IconName): The :code:`square-rounded` icon.
        SQUARE_ROUNDED_ARROW_DOWN (IconName): The :code:`square-rounded-arrow-down` icon.
        SQUARE_ROUNDED_ARROW_DOWN_FILLED (IconName): The :code:`square-rounded-arrow-down-filled` icon.
        SQUARE_ROUNDED_ARROW_LEFT (IconName): The :code:`square-rounded-arrow-left` icon.
        SQUARE_ROUNDED_ARROW_LEFT_FILLED (IconName): The :code:`square-rounded-arrow-left-filled` icon.
        SQUARE_ROUNDED_ARROW_RIGHT (IconName): The :code:`square-rounded-arrow-right` icon.
        SQUARE_ROUNDED_ARROW_RIGHT_FILLED (IconName): The :code:`square-rounded-arrow-right-filled` icon.
        SQUARE_ROUNDED_ARROW_UP (IconName): The :code:`square-rounded-arrow-up` icon.
        SQUARE_ROUNDED_ARROW_UP_FILLED (IconName): The :code:`square-rounded-arrow-up-filled` icon.
        SQUARE_ROUNDED_CHECK (IconName): The :code:`square-rounded-check` icon.
        SQUARE_ROUNDED_CHECK_FILLED (IconName): The :code:`square-rounded-check-filled` icon.
        SQUARE_ROUNDED_CHEVRON_DOWN (IconName): The :code:`square-rounded-chevron-down` icon.
        SQUARE_ROUNDED_CHEVRON_DOWN_FILLED (IconName): The :code:`square-rounded-chevron-down-filled` icon.
        SQUARE_ROUNDED_CHEVRON_LEFT (IconName): The :code:`square-rounded-chevron-left` icon.
        SQUARE_ROUNDED_CHEVRON_LEFT_FILLED (IconName): The :code:`square-rounded-chevron-left-filled` icon.
        SQUARE_ROUNDED_CHEVRON_RIGHT (IconName): The :code:`square-rounded-chevron-right` icon.
        SQUARE_ROUNDED_CHEVRON_RIGHT_FILLED (IconName): The :code:`square-rounded-chevron-right-filled` icon.
        SQUARE_ROUNDED_CHEVRON_UP (IconName): The :code:`square-rounded-chevron-up` icon.
        SQUARE_ROUNDED_CHEVRON_UP_FILLED (IconName): The :code:`square-rounded-chevron-up-filled` icon.
        SQUARE_ROUNDED_CHEVRONS_DOWN (IconName): The :code:`square-rounded-chevrons-down` icon.
        SQUARE_ROUNDED_CHEVRONS_DOWN_FILLED (IconName): The :code:`square-rounded-chevrons-down-filled` icon.
        SQUARE_ROUNDED_CHEVRONS_LEFT (IconName): The :code:`square-rounded-chevrons-left` icon.
        SQUARE_ROUNDED_CHEVRONS_LEFT_FILLED (IconName): The :code:`square-rounded-chevrons-left-filled` icon.
        SQUARE_ROUNDED_CHEVRONS_RIGHT (IconName): The :code:`square-rounded-chevrons-right` icon.
        SQUARE_ROUNDED_CHEVRONS_RIGHT_FILLED (IconName): The :code:`square-rounded-chevrons-right-filled` icon.
        SQUARE_ROUNDED_CHEVRONS_UP (IconName): The :code:`square-rounded-chevrons-up` icon.
        SQUARE_ROUNDED_CHEVRONS_UP_FILLED (IconName): The :code:`square-rounded-chevrons-up-filled` icon.
        SQUARE_ROUNDED_FILLED (IconName): The :code:`square-rounded-filled` icon.
        SQUARE_ROUNDED_LETTER_A (IconName): The :code:`square-rounded-letter-a` icon.
        SQUARE_ROUNDED_LETTER_B (IconName): The :code:`square-rounded-letter-b` icon.
        SQUARE_ROUNDED_LETTER_C (IconName): The :code:`square-rounded-letter-c` icon.
        SQUARE_ROUNDED_LETTER_D (IconName): The :code:`square-rounded-letter-d` icon.
        SQUARE_ROUNDED_LETTER_E (IconName): The :code:`square-rounded-letter-e` icon.
        SQUARE_ROUNDED_LETTER_F (IconName): The :code:`square-rounded-letter-f` icon.
        SQUARE_ROUNDED_LETTER_G (IconName): The :code:`square-rounded-letter-g` icon.
        SQUARE_ROUNDED_LETTER_H (IconName): The :code:`square-rounded-letter-h` icon.
        SQUARE_ROUNDED_LETTER_I (IconName): The :code:`square-rounded-letter-i` icon.
        SQUARE_ROUNDED_LETTER_J (IconName): The :code:`square-rounded-letter-j` icon.
        SQUARE_ROUNDED_LETTER_K (IconName): The :code:`square-rounded-letter-k` icon.
        SQUARE_ROUNDED_LETTER_L (IconName): The :code:`square-rounded-letter-l` icon.
        SQUARE_ROUNDED_LETTER_M (IconName): The :code:`square-rounded-letter-m` icon.
        SQUARE_ROUNDED_LETTER_N (IconName): The :code:`square-rounded-letter-n` icon.
        SQUARE_ROUNDED_LETTER_O (IconName): The :code:`square-rounded-letter-o` icon.
        SQUARE_ROUNDED_LETTER_P (IconName): The :code:`square-rounded-letter-p` icon.
        SQUARE_ROUNDED_LETTER_Q (IconName): The :code:`square-rounded-letter-q` icon.
        SQUARE_ROUNDED_LETTER_R (IconName): The :code:`square-rounded-letter-r` icon.
        SQUARE_ROUNDED_LETTER_S (IconName): The :code:`square-rounded-letter-s` icon.
        SQUARE_ROUNDED_LETTER_T (IconName): The :code:`square-rounded-letter-t` icon.
        SQUARE_ROUNDED_LETTER_U (IconName): The :code:`square-rounded-letter-u` icon.
        SQUARE_ROUNDED_LETTER_V (IconName): The :code:`square-rounded-letter-v` icon.
        SQUARE_ROUNDED_LETTER_W (IconName): The :code:`square-rounded-letter-w` icon.
        SQUARE_ROUNDED_LETTER_X (IconName): The :code:`square-rounded-letter-x` icon.
        SQUARE_ROUNDED_LETTER_Y (IconName): The :code:`square-rounded-letter-y` icon.
        SQUARE_ROUNDED_LETTER_Z (IconName): The :code:`square-rounded-letter-z` icon.
        SQUARE_ROUNDED_MINUS (IconName): The :code:`square-rounded-minus` icon.
        SQUARE_ROUNDED_NUMBER_0 (IconName): The :code:`square-rounded-number-0` icon.
        SQUARE_ROUNDED_NUMBER_0_FILLED (IconName): The :code:`square-rounded-number-0-filled` icon.
        SQUARE_ROUNDED_NUMBER_1 (IconName): The :code:`square-rounded-number-1` icon.
        SQUARE_ROUNDED_NUMBER_1_FILLED (IconName): The :code:`square-rounded-number-1-filled` icon.
        SQUARE_ROUNDED_NUMBER_2 (IconName): The :code:`square-rounded-number-2` icon.
        SQUARE_ROUNDED_NUMBER_2_FILLED (IconName): The :code:`square-rounded-number-2-filled` icon.
        SQUARE_ROUNDED_NUMBER_3 (IconName): The :code:`square-rounded-number-3` icon.
        SQUARE_ROUNDED_NUMBER_3_FILLED (IconName): The :code:`square-rounded-number-3-filled` icon.
        SQUARE_ROUNDED_NUMBER_4 (IconName): The :code:`square-rounded-number-4` icon.
        SQUARE_ROUNDED_NUMBER_4_FILLED (IconName): The :code:`square-rounded-number-4-filled` icon.
        SQUARE_ROUNDED_NUMBER_5 (IconName): The :code:`square-rounded-number-5` icon.
        SQUARE_ROUNDED_NUMBER_5_FILLED (IconName): The :code:`square-rounded-number-5-filled` icon.
        SQUARE_ROUNDED_NUMBER_6 (IconName): The :code:`square-rounded-number-6` icon.
        SQUARE_ROUNDED_NUMBER_6_FILLED (IconName): The :code:`square-rounded-number-6-filled` icon.
        SQUARE_ROUNDED_NUMBER_7 (IconName): The :code:`square-rounded-number-7` icon.
        SQUARE_ROUNDED_NUMBER_7_FILLED (IconName): The :code:`square-rounded-number-7-filled` icon.
        SQUARE_ROUNDED_NUMBER_8 (IconName): The :code:`square-rounded-number-8` icon.
        SQUARE_ROUNDED_NUMBER_8_FILLED (IconName): The :code:`square-rounded-number-8-filled` icon.
        SQUARE_ROUNDED_NUMBER_9 (IconName): The :code:`square-rounded-number-9` icon.
        SQUARE_ROUNDED_NUMBER_9_FILLED (IconName): The :code:`square-rounded-number-9-filled` icon.
        SQUARE_ROUNDED_PLUS (IconName): The :code:`square-rounded-plus` icon.
        SQUARE_ROUNDED_PLUS_FILLED (IconName): The :code:`square-rounded-plus-filled` icon.
        SQUARE_ROUNDED_X (IconName): The :code:`square-rounded-x` icon.
        SQUARE_ROUNDED_X_FILLED (IconName): The :code:`square-rounded-x-filled` icon.
        SQUARE_TOGGLE (IconName): The :code:`square-toggle` icon.
        SQUARE_TOGGLE_HORIZONTAL (IconName): The :code:`square-toggle-horizontal` icon.
        SQUARE_X (IconName): The :code:`square-x` icon.
        SQUARES_DIAGONAL (IconName): The :code:`squares-diagonal` icon.
        SQUARES_FILLED (IconName): The :code:`squares-filled` icon.
        STACK (IconName): The :code:`stack` icon.
        STACK_2 (IconName): The :code:`stack-2` icon.
        STACK_3 (IconName): The :code:`stack-3` icon.
        STACK_POP (IconName): The :code:`stack-pop` icon.
        STACK_PUSH (IconName): The :code:`stack-push` icon.
        STAIRS (IconName): The :code:`stairs` icon.
        STAIRS_DOWN (IconName): The :code:`stairs-down` icon.
        STAIRS_UP (IconName): The :code:`stairs-up` icon.
        STAR (IconName): The :code:`star` icon.
        STAR_FILLED (IconName): The :code:`star-filled` icon.
        STAR_HALF (IconName): The :code:`star-half` icon.
        STAR_HALF_FILLED (IconName): The :code:`star-half-filled` icon.
        STAR_OFF (IconName): The :code:`star-off` icon.
        STARS (IconName): The :code:`stars` icon.
        STARS_FILLED (IconName): The :code:`stars-filled` icon.
        STARS_OFF (IconName): The :code:`stars-off` icon.
        STATUS_CHANGE (IconName): The :code:`status-change` icon.
        STEAM (IconName): The :code:`steam` icon.
        STEERING_WHEEL (IconName): The :code:`steering-wheel` icon.
        STEERING_WHEEL_OFF (IconName): The :code:`steering-wheel-off` icon.
        STEP_INTO (IconName): The :code:`step-into` icon.
        STEP_OUT (IconName): The :code:`step-out` icon.
        STEREO_GLASSES (IconName): The :code:`stereo-glasses` icon.
        STETHOSCOPE (IconName): The :code:`stethoscope` icon.
        STETHOSCOPE_OFF (IconName): The :code:`stethoscope-off` icon.
        STICKER (IconName): The :code:`sticker` icon.
        STORM (IconName): The :code:`storm` icon.
        STORM_OFF (IconName): The :code:`storm-off` icon.
        STRETCHING (IconName): The :code:`stretching` icon.
        STRETCHING_2 (IconName): The :code:`stretching-2` icon.
        STRIKETHROUGH (IconName): The :code:`strikethrough` icon.
        SUBMARINE (IconName): The :code:`submarine` icon.
        SUBSCRIPT (IconName): The :code:`subscript` icon.
        SUBTASK (IconName): The :code:`subtask` icon.
        SUM (IconName): The :code:`sum` icon.
        SUM_OFF (IconName): The :code:`sum-off` icon.
        SUN (IconName): The :code:`sun` icon.
        SUN_FILLED (IconName): The :code:`sun-filled` icon.
        SUN_HIGH (IconName): The :code:`sun-high` icon.
        SUN_LOW (IconName): The :code:`sun-low` icon.
        SUN_MOON (IconName): The :code:`sun-moon` icon.
        SUN_OFF (IconName): The :code:`sun-off` icon.
        SUN_WIND (IconName): The :code:`sun-wind` icon.
        SUNGLASSES (IconName): The :code:`sunglasses` icon.
        SUNRISE (IconName): The :code:`sunrise` icon.
        SUNSET (IconName): The :code:`sunset` icon.
        SUNSET_2 (IconName): The :code:`sunset-2` icon.
        SUPERSCRIPT (IconName): The :code:`superscript` icon.
        SVG (IconName): The :code:`svg` icon.
        SWIMMING (IconName): The :code:`swimming` icon.
        SWIPE (IconName): The :code:`swipe` icon.
        SWITCH (IconName): The :code:`switch` icon.
        SWITCH_2 (IconName): The :code:`switch-2` icon.
        SWITCH_3 (IconName): The :code:`switch-3` icon.
        SWITCH_HORIZONTAL (IconName): The :code:`switch-horizontal` icon.
        SWITCH_VERTICAL (IconName): The :code:`switch-vertical` icon.
        SWORD (IconName): The :code:`sword` icon.
        SWORD_OFF (IconName): The :code:`sword-off` icon.
        SWORDS (IconName): The :code:`swords` icon.
        TABLE (IconName): The :code:`table` icon.
        TABLE_ALIAS (IconName): The :code:`table-alias` icon.
        TABLE_COLUMN (IconName): The :code:`table-column` icon.
        TABLE_DOWN (IconName): The :code:`table-down` icon.
        TABLE_EXPORT (IconName): The :code:`table-export` icon.
        TABLE_FILLED (IconName): The :code:`table-filled` icon.
        TABLE_HEART (IconName): The :code:`table-heart` icon.
        TABLE_IMPORT (IconName): The :code:`table-import` icon.
        TABLE_MINUS (IconName): The :code:`table-minus` icon.
        TABLE_OFF (IconName): The :code:`table-off` icon.
        TABLE_OPTIONS (IconName): The :code:`table-options` icon.
        TABLE_PLUS (IconName): The :code:`table-plus` icon.
        TABLE_ROW (IconName): The :code:`table-row` icon.
        TABLE_SHARE (IconName): The :code:`table-share` icon.
        TABLE_SHORTCUT (IconName): The :code:`table-shortcut` icon.
        TAG (IconName): The :code:`tag` icon.
        TAG_OFF (IconName): The :code:`tag-off` icon.
        TAGS (IconName): The :code:`tags` icon.
        TAGS_OFF (IconName): The :code:`tags-off` icon.
        TALLYMARK_1 (IconName): The :code:`tallymark-1` icon.
        TALLYMARK_2 (IconName): The :code:`tallymark-2` icon.
        TALLYMARK_3 (IconName): The :code:`tallymark-3` icon.
        TALLYMARK_4 (IconName): The :code:`tallymark-4` icon.
        TALLYMARKS (IconName): The :code:`tallymarks` icon.
        TANK (IconName): The :code:`tank` icon.
        TARGET (IconName): The :code:`target` icon.
        TARGET_ARROW (IconName): The :code:`target-arrow` icon.
        TARGET_OFF (IconName): The :code:`target-off` icon.
        TEAPOT (IconName): The :code:`teapot` icon.
        TELESCOPE (IconName): The :code:`telescope` icon.
        TELESCOPE_OFF (IconName): The :code:`telescope-off` icon.
        TEMPERATURE (IconName): The :code:`temperature` icon.
        TEMPERATURE_CELSIUS (IconName): The :code:`temperature-celsius` icon.
        TEMPERATURE_FAHRENHEIT (IconName): The :code:`temperature-fahrenheit` icon.
        TEMPERATURE_MINUS (IconName): The :code:`temperature-minus` icon.
        TEMPERATURE_OFF (IconName): The :code:`temperature-off` icon.
        TEMPERATURE_PLUS (IconName): The :code:`temperature-plus` icon.
        TEMPLATE (IconName): The :code:`template` icon.
        TEMPLATE_OFF (IconName): The :code:`template-off` icon.
        TENT (IconName): The :code:`tent` icon.
        TENT_OFF (IconName): The :code:`tent-off` icon.
        TERMINAL (IconName): The :code:`terminal` icon.
        TERMINAL_2 (IconName): The :code:`terminal-2` icon.
        TEST_PIPE (IconName): The :code:`test-pipe` icon.
        TEST_PIPE_2 (IconName): The :code:`test-pipe-2` icon.
        TEST_PIPE_OFF (IconName): The :code:`test-pipe-off` icon.
        TEX (IconName): The :code:`tex` icon.
        TEXT_CAPTION (IconName): The :code:`text-caption` icon.
        TEXT_COLOR (IconName): The :code:`text-color` icon.
        TEXT_DECREASE (IconName): The :code:`text-decrease` icon.
        TEXT_DIRECTION_LTR (IconName): The :code:`text-direction-ltr` icon.
        TEXT_DIRECTION_RTL (IconName): The :code:`text-direction-rtl` icon.
        TEXT_INCREASE (IconName): The :code:`text-increase` icon.
        TEXT_ORIENTATION (IconName): The :code:`text-orientation` icon.
        TEXT_PLUS (IconName): The :code:`text-plus` icon.
        TEXT_RECOGNITION (IconName): The :code:`text-recognition` icon.
        TEXT_RESIZE (IconName): The :code:`text-resize` icon.
        TEXT_SIZE (IconName): The :code:`text-size` icon.
        TEXT_SPELLCHECK (IconName): The :code:`text-spellcheck` icon.
        TEXT_WRAP (IconName): The :code:`text-wrap` icon.
        TEXT_WRAP_DISABLED (IconName): The :code:`text-wrap-disabled` icon.
        TEXTURE (IconName): The :code:`texture` icon.
        THEATER (IconName): The :code:`theater` icon.
        THERMOMETER (IconName): The :code:`thermometer` icon.
        THUMB_DOWN (IconName): The :code:`thumb-down` icon.
        THUMB_DOWN_FILLED (IconName): The :code:`thumb-down-filled` icon.
        THUMB_DOWN_OFF (IconName): The :code:`thumb-down-off` icon.
        THUMB_UP (IconName): The :code:`thumb-up` icon.
        THUMB_UP_FILLED (IconName): The :code:`thumb-up-filled` icon.
        THUMB_UP_OFF (IconName): The :code:`thumb-up-off` icon.
        TIC_TAC (IconName): The :code:`tic-tac` icon.
        TICKET (IconName): The :code:`ticket` icon.
        TICKET_OFF (IconName): The :code:`ticket-off` icon.
        TIE (IconName): The :code:`tie` icon.
        TILDE (IconName): The :code:`tilde` icon.
        TILT_SHIFT (IconName): The :code:`tilt-shift` icon.
        TILT_SHIFT_OFF (IconName): The :code:`tilt-shift-off` icon.
        TIME_DURATION_0 (IconName): The :code:`time-duration-0` icon.
        TIME_DURATION_10 (IconName): The :code:`time-duration-10` icon.
        TIME_DURATION_15 (IconName): The :code:`time-duration-15` icon.
        TIME_DURATION_30 (IconName): The :code:`time-duration-30` icon.
        TIME_DURATION_45 (IconName): The :code:`time-duration-45` icon.
        TIME_DURATION_5 (IconName): The :code:`time-duration-5` icon.
        TIME_DURATION_60 (IconName): The :code:`time-duration-60` icon.
        TIME_DURATION_90 (IconName): The :code:`time-duration-90` icon.
        TIME_DURATION_OFF (IconName): The :code:`time-duration-off` icon.
        TIMELINE (IconName): The :code:`timeline` icon.
        TIMELINE_EVENT (IconName): The :code:`timeline-event` icon.
        TIMELINE_EVENT_EXCLAMATION (IconName): The :code:`timeline-event-exclamation` icon.
        TIMELINE_EVENT_MINUS (IconName): The :code:`timeline-event-minus` icon.
        TIMELINE_EVENT_PLUS (IconName): The :code:`timeline-event-plus` icon.
        TIMELINE_EVENT_TEXT (IconName): The :code:`timeline-event-text` icon.
        TIMELINE_EVENT_X (IconName): The :code:`timeline-event-x` icon.
        TIR (IconName): The :code:`tir` icon.
        TOGGLE_LEFT (IconName): The :code:`toggle-left` icon.
        TOGGLE_RIGHT (IconName): The :code:`toggle-right` icon.
        TOILET_PAPER (IconName): The :code:`toilet-paper` icon.
        TOILET_PAPER_OFF (IconName): The :code:`toilet-paper-off` icon.
        TOML (IconName): The :code:`toml` icon.
        TOOL (IconName): The :code:`tool` icon.
        TOOLS (IconName): The :code:`tools` icon.
        TOOLS_KITCHEN (IconName): The :code:`tools-kitchen` icon.
        TOOLS_KITCHEN_2 (IconName): The :code:`tools-kitchen-2` icon.
        TOOLS_KITCHEN_2_OFF (IconName): The :code:`tools-kitchen-2-off` icon.
        TOOLS_KITCHEN_OFF (IconName): The :code:`tools-kitchen-off` icon.
        TOOLS_OFF (IconName): The :code:`tools-off` icon.
        TOOLTIP (IconName): The :code:`tooltip` icon.
        TOPOLOGY_BUS (IconName): The :code:`topology-bus` icon.
        TOPOLOGY_COMPLEX (IconName): The :code:`topology-complex` icon.
        TOPOLOGY_FULL (IconName): The :code:`topology-full` icon.
        TOPOLOGY_FULL_HIERARCHY (IconName): The :code:`topology-full-hierarchy` icon.
        TOPOLOGY_RING (IconName): The :code:`topology-ring` icon.
        TOPOLOGY_RING_2 (IconName): The :code:`topology-ring-2` icon.
        TOPOLOGY_RING_3 (IconName): The :code:`topology-ring-3` icon.
        TOPOLOGY_STAR (IconName): The :code:`topology-star` icon.
        TOPOLOGY_STAR_2 (IconName): The :code:`topology-star-2` icon.
        TOPOLOGY_STAR_3 (IconName): The :code:`topology-star-3` icon.
        TOPOLOGY_STAR_RING (IconName): The :code:`topology-star-ring` icon.
        TOPOLOGY_STAR_RING_2 (IconName): The :code:`topology-star-ring-2` icon.
        TOPOLOGY_STAR_RING_3 (IconName): The :code:`topology-star-ring-3` icon.
        TORII (IconName): The :code:`torii` icon.
        TORNADO (IconName): The :code:`tornado` icon.
        TOURNAMENT (IconName): The :code:`tournament` icon.
        TOWER (IconName): The :code:`tower` icon.
        TOWER_OFF (IconName): The :code:`tower-off` icon.
        TRACK (IconName): The :code:`track` icon.
        TRACTOR (IconName): The :code:`tractor` icon.
        TRADEMARK (IconName): The :code:`trademark` icon.
        TRAFFIC_CONE (IconName): The :code:`traffic-cone` icon.
        TRAFFIC_CONE_OFF (IconName): The :code:`traffic-cone-off` icon.
        TRAFFIC_LIGHTS (IconName): The :code:`traffic-lights` icon.
        TRAFFIC_LIGHTS_OFF (IconName): The :code:`traffic-lights-off` icon.
        TRAIN (IconName): The :code:`train` icon.
        TRANSFER_IN (IconName): The :code:`transfer-in` icon.
        TRANSFER_OUT (IconName): The :code:`transfer-out` icon.
        TRANSFORM (IconName): The :code:`transform` icon.
        TRANSFORM_FILLED (IconName): The :code:`transform-filled` icon.
        TRANSITION_BOTTOM (IconName): The :code:`transition-bottom` icon.
        TRANSITION_LEFT (IconName): The :code:`transition-left` icon.
        TRANSITION_RIGHT (IconName): The :code:`transition-right` icon.
        TRANSITION_TOP (IconName): The :code:`transition-top` icon.
        TRASH (IconName): The :code:`trash` icon.
        TRASH_FILLED (IconName): The :code:`trash-filled` icon.
        TRASH_OFF (IconName): The :code:`trash-off` icon.
        TRASH_X (IconName): The :code:`trash-x` icon.
        TRASH_X_FILLED (IconName): The :code:`trash-x-filled` icon.
        TREADMILL (IconName): The :code:`treadmill` icon.
        TREE (IconName): The :code:`tree` icon.
        TREES (IconName): The :code:`trees` icon.
        TREKKING (IconName): The :code:`trekking` icon.
        TRENDING_DOWN (IconName): The :code:`trending-down` icon.
        TRENDING_DOWN_2 (IconName): The :code:`trending-down-2` icon.
        TRENDING_DOWN_3 (IconName): The :code:`trending-down-3` icon.
        TRENDING_UP (IconName): The :code:`trending-up` icon.
        TRENDING_UP_2 (IconName): The :code:`trending-up-2` icon.
        TRENDING_UP_3 (IconName): The :code:`trending-up-3` icon.
        TRIANGLE (IconName): The :code:`triangle` icon.
        TRIANGLE_FILLED (IconName): The :code:`triangle-filled` icon.
        TRIANGLE_INVERTED (IconName): The :code:`triangle-inverted` icon.
        TRIANGLE_INVERTED_FILLED (IconName): The :code:`triangle-inverted-filled` icon.
        TRIANGLE_OFF (IconName): The :code:`triangle-off` icon.
        TRIANGLE_SQUARE_CIRCLE (IconName): The :code:`triangle-square-circle` icon.
        TRIANGLES (IconName): The :code:`triangles` icon.
        TRIDENT (IconName): The :code:`trident` icon.
        TROLLEY (IconName): The :code:`trolley` icon.
        TROPHY (IconName): The :code:`trophy` icon.
        TROPHY_FILLED (IconName): The :code:`trophy-filled` icon.
        TROPHY_OFF (IconName): The :code:`trophy-off` icon.
        TROWEL (IconName): The :code:`trowel` icon.
        TRUCK (IconName): The :code:`truck` icon.
        TRUCK_DELIVERY (IconName): The :code:`truck-delivery` icon.
        TRUCK_LOADING (IconName): The :code:`truck-loading` icon.
        TRUCK_OFF (IconName): The :code:`truck-off` icon.
        TRUCK_RETURN (IconName): The :code:`truck-return` icon.
        TXT (IconName): The :code:`txt` icon.
        TYPOGRAPHY (IconName): The :code:`typography` icon.
        TYPOGRAPHY_OFF (IconName): The :code:`typography-off` icon.
        UFO (IconName): The :code:`ufo` icon.
        UFO_OFF (IconName): The :code:`ufo-off` icon.
        UMBRELLA (IconName): The :code:`umbrella` icon.
        UMBRELLA_FILLED (IconName): The :code:`umbrella-filled` icon.
        UMBRELLA_OFF (IconName): The :code:`umbrella-off` icon.
        UNDERLINE (IconName): The :code:`underline` icon.
        UNLINK (IconName): The :code:`unlink` icon.
        UPLOAD (IconName): The :code:`upload` icon.
        URGENT (IconName): The :code:`urgent` icon.
        USB (IconName): The :code:`usb` icon.
        USER (IconName): The :code:`user` icon.
        USER_BOLT (IconName): The :code:`user-bolt` icon.
        USER_CANCEL (IconName): The :code:`user-cancel` icon.
        USER_CHECK (IconName): The :code:`user-check` icon.
        USER_CIRCLE (IconName): The :code:`user-circle` icon.
        USER_CODE (IconName): The :code:`user-code` icon.
        USER_COG (IconName): The :code:`user-cog` icon.
        USER_DOLLAR (IconName): The :code:`user-dollar` icon.
        USER_DOWN (IconName): The :code:`user-down` icon.
        USER_EDIT (IconName): The :code:`user-edit` icon.
        USER_EXCLAMATION (IconName): The :code:`user-exclamation` icon.
        USER_HEART (IconName): The :code:`user-heart` icon.
        USER_MINUS (IconName): The :code:`user-minus` icon.
        USER_OFF (IconName): The :code:`user-off` icon.
        USER_PAUSE (IconName): The :code:`user-pause` icon.
        USER_PIN (IconName): The :code:`user-pin` icon.
        USER_PLUS (IconName): The :code:`user-plus` icon.
        USER_QUESTION (IconName): The :code:`user-question` icon.
        USER_SEARCH (IconName): The :code:`user-search` icon.
        USER_SHARE (IconName): The :code:`user-share` icon.
        USER_SHIELD (IconName): The :code:`user-shield` icon.
        USER_STAR (IconName): The :code:`user-star` icon.
        USER_UP (IconName): The :code:`user-up` icon.
        USER_X (IconName): The :code:`user-x` icon.
        USERS (IconName): The :code:`users` icon.
        USERS_GROUP (IconName): The :code:`users-group` icon.
        USERS_MINUS (IconName): The :code:`users-minus` icon.
        USERS_PLUS (IconName): The :code:`users-plus` icon.
        UV_INDEX (IconName): The :code:`uv-index` icon.
        UX_CIRCLE (IconName): The :code:`ux-circle` icon.
        VACCINE (IconName): The :code:`vaccine` icon.
        VACCINE_BOTTLE (IconName): The :code:`vaccine-bottle` icon.
        VACCINE_BOTTLE_OFF (IconName): The :code:`vaccine-bottle-off` icon.
        VACCINE_OFF (IconName): The :code:`vaccine-off` icon.
        VACUUM_CLEANER (IconName): The :code:`vacuum-cleaner` icon.
        VARIABLE (IconName): The :code:`variable` icon.
        VARIABLE_MINUS (IconName): The :code:`variable-minus` icon.
        VARIABLE_OFF (IconName): The :code:`variable-off` icon.
        VARIABLE_PLUS (IconName): The :code:`variable-plus` icon.
        VECTOR (IconName): The :code:`vector` icon.
        VECTOR_BEZIER (IconName): The :code:`vector-bezier` icon.
        VECTOR_BEZIER_2 (IconName): The :code:`vector-bezier-2` icon.
        VECTOR_BEZIER_ARC (IconName): The :code:`vector-bezier-arc` icon.
        VECTOR_BEZIER_CIRCLE (IconName): The :code:`vector-bezier-circle` icon.
        VECTOR_OFF (IconName): The :code:`vector-off` icon.
        VECTOR_SPLINE (IconName): The :code:`vector-spline` icon.
        VECTOR_TRIANGLE (IconName): The :code:`vector-triangle` icon.
        VECTOR_TRIANGLE_OFF (IconName): The :code:`vector-triangle-off` icon.
        VENUS (IconName): The :code:`venus` icon.
        VERSIONS (IconName): The :code:`versions` icon.
        VERSIONS_FILLED (IconName): The :code:`versions-filled` icon.
        VERSIONS_OFF (IconName): The :code:`versions-off` icon.
        VIDEO (IconName): The :code:`video` icon.
        VIDEO_MINUS (IconName): The :code:`video-minus` icon.
        VIDEO_OFF (IconName): The :code:`video-off` icon.
        VIDEO_PLUS (IconName): The :code:`video-plus` icon.
        VIEW_360 (IconName): The :code:`view-360` icon.
        VIEW_360_OFF (IconName): The :code:`view-360-off` icon.
        VIEWFINDER (IconName): The :code:`viewfinder` icon.
        VIEWFINDER_OFF (IconName): The :code:`viewfinder-off` icon.
        VIEWPORT_NARROW (IconName): The :code:`viewport-narrow` icon.
        VIEWPORT_WIDE (IconName): The :code:`viewport-wide` icon.
        VINYL (IconName): The :code:`vinyl` icon.
        VIP (IconName): The :code:`vip` icon.
        VIP_OFF (IconName): The :code:`vip-off` icon.
        VIRUS (IconName): The :code:`virus` icon.
        VIRUS_OFF (IconName): The :code:`virus-off` icon.
        VIRUS_SEARCH (IconName): The :code:`virus-search` icon.
        VOCABULARY (IconName): The :code:`vocabulary` icon.
        VOCABULARY_OFF (IconName): The :code:`vocabulary-off` icon.
        VOLCANO (IconName): The :code:`volcano` icon.
        VOLUME (IconName): The :code:`volume` icon.
        VOLUME_2 (IconName): The :code:`volume-2` icon.
        VOLUME_3 (IconName): The :code:`volume-3` icon.
        VOLUME_OFF (IconName): The :code:`volume-off` icon.
        WALK (IconName): The :code:`walk` icon.
        WALL (IconName): The :code:`wall` icon.
        WALL_OFF (IconName): The :code:`wall-off` icon.
        WALLET (IconName): The :code:`wallet` icon.
        WALLET_OFF (IconName): The :code:`wallet-off` icon.
        WALLPAPER (IconName): The :code:`wallpaper` icon.
        WALLPAPER_OFF (IconName): The :code:`wallpaper-off` icon.
        WAND (IconName): The :code:`wand` icon.
        WAND_OFF (IconName): The :code:`wand-off` icon.
        WASH (IconName): The :code:`wash` icon.
        WASH_DRY (IconName): The :code:`wash-dry` icon.
        WASH_DRY_1 (IconName): The :code:`wash-dry-1` icon.
        WASH_DRY_2 (IconName): The :code:`wash-dry-2` icon.
        WASH_DRY_3 (IconName): The :code:`wash-dry-3` icon.
        WASH_DRY_A (IconName): The :code:`wash-dry-a` icon.
        WASH_DRY_DIP (IconName): The :code:`wash-dry-dip` icon.
        WASH_DRY_F (IconName): The :code:`wash-dry-f` icon.
        WASH_DRY_FLAT (IconName): The :code:`wash-dry-flat` icon.
        WASH_DRY_HANG (IconName): The :code:`wash-dry-hang` icon.
        WASH_DRY_OFF (IconName): The :code:`wash-dry-off` icon.
        WASH_DRY_P (IconName): The :code:`wash-dry-p` icon.
        WASH_DRY_SHADE (IconName): The :code:`wash-dry-shade` icon.
        WASH_DRY_W (IconName): The :code:`wash-dry-w` icon.
        WASH_DRYCLEAN (IconName): The :code:`wash-dryclean` icon.
        WASH_DRYCLEAN_OFF (IconName): The :code:`wash-dryclean-off` icon.
        WASH_ECO (IconName): The :code:`wash-eco` icon.
        WASH_GENTLE (IconName): The :code:`wash-gentle` icon.
        WASH_HAND (IconName): The :code:`wash-hand` icon.
        WASH_MACHINE (IconName): The :code:`wash-machine` icon.
        WASH_OFF (IconName): The :code:`wash-off` icon.
        WASH_PRESS (IconName): The :code:`wash-press` icon.
        WASH_TEMPERATURE_1 (IconName): The :code:`wash-temperature-1` icon.
        WASH_TEMPERATURE_2 (IconName): The :code:`wash-temperature-2` icon.
        WASH_TEMPERATURE_3 (IconName): The :code:`wash-temperature-3` icon.
        WASH_TEMPERATURE_4 (IconName): The :code:`wash-temperature-4` icon.
        WASH_TEMPERATURE_5 (IconName): The :code:`wash-temperature-5` icon.
        WASH_TEMPERATURE_6 (IconName): The :code:`wash-temperature-6` icon.
        WASH_TUMBLE_DRY (IconName): The :code:`wash-tumble-dry` icon.
        WASH_TUMBLE_OFF (IconName): The :code:`wash-tumble-off` icon.
        WATERPOLO (IconName): The :code:`waterpolo` icon.
        WAVE_SAW_TOOL (IconName): The :code:`wave-saw-tool` icon.
        WAVE_SINE (IconName): The :code:`wave-sine` icon.
        WAVE_SQUARE (IconName): The :code:`wave-square` icon.
        WEBHOOK (IconName): The :code:`webhook` icon.
        WEBHOOK_OFF (IconName): The :code:`webhook-off` icon.
        WEIGHT (IconName): The :code:`weight` icon.
        WHEELCHAIR (IconName): The :code:`wheelchair` icon.
        WHEELCHAIR_OFF (IconName): The :code:`wheelchair-off` icon.
        WHIRL (IconName): The :code:`whirl` icon.
        WIFI (IconName): The :code:`wifi` icon.
        WIFI_0 (IconName): The :code:`wifi-0` icon.
        WIFI_1 (IconName): The :code:`wifi-1` icon.
        WIFI_2 (IconName): The :code:`wifi-2` icon.
        WIFI_OFF (IconName): The :code:`wifi-off` icon.
        WIND (IconName): The :code:`wind` icon.
        WIND_OFF (IconName): The :code:`wind-off` icon.
        WINDMILL (IconName): The :code:`windmill` icon.
        WINDMILL_FILLED (IconName): The :code:`windmill-filled` icon.
        WINDMILL_OFF (IconName): The :code:`windmill-off` icon.
        WINDOW (IconName): The :code:`window` icon.
        WINDOW_MAXIMIZE (IconName): The :code:`window-maximize` icon.
        WINDOW_MINIMIZE (IconName): The :code:`window-minimize` icon.
        WINDOW_OFF (IconName): The :code:`window-off` icon.
        WINDSOCK (IconName): The :code:`windsock` icon.
        WIPER (IconName): The :code:`wiper` icon.
        WIPER_WASH (IconName): The :code:`wiper-wash` icon.
        WOMAN (IconName): The :code:`woman` icon.
        WOOD (IconName): The :code:`wood` icon.
        WORLD (IconName): The :code:`world` icon.
        WORLD_BOLT (IconName): The :code:`world-bolt` icon.
        WORLD_CANCEL (IconName): The :code:`world-cancel` icon.
        WORLD_CHECK (IconName): The :code:`world-check` icon.
        WORLD_CODE (IconName): The :code:`world-code` icon.
        WORLD_COG (IconName): The :code:`world-cog` icon.
        WORLD_DOLLAR (IconName): The :code:`world-dollar` icon.
        WORLD_DOWN (IconName): The :code:`world-down` icon.
        WORLD_DOWNLOAD (IconName): The :code:`world-download` icon.
        WORLD_EXCLAMATION (IconName): The :code:`world-exclamation` icon.
        WORLD_HEART (IconName): The :code:`world-heart` icon.
        WORLD_LATITUDE (IconName): The :code:`world-latitude` icon.
        WORLD_LONGITUDE (IconName): The :code:`world-longitude` icon.
        WORLD_MINUS (IconName): The :code:`world-minus` icon.
        WORLD_OFF (IconName): The :code:`world-off` icon.
        WORLD_PAUSE (IconName): The :code:`world-pause` icon.
        WORLD_PIN (IconName): The :code:`world-pin` icon.
        WORLD_PLUS (IconName): The :code:`world-plus` icon.
        WORLD_QUESTION (IconName): The :code:`world-question` icon.
        WORLD_SEARCH (IconName): The :code:`world-search` icon.
        WORLD_SHARE (IconName): The :code:`world-share` icon.
        WORLD_STAR (IconName): The :code:`world-star` icon.
        WORLD_UP (IconName): The :code:`world-up` icon.
        WORLD_UPLOAD (IconName): The :code:`world-upload` icon.
        WORLD_WWW (IconName): The :code:`world-www` icon.
        WORLD_X (IconName): The :code:`world-x` icon.
        WRECKING_BALL (IconName): The :code:`wrecking-ball` icon.
        WRITING (IconName): The :code:`writing` icon.
        WRITING_OFF (IconName): The :code:`writing-off` icon.
        WRITING_SIGN (IconName): The :code:`writing-sign` icon.
        WRITING_SIGN_OFF (IconName): The :code:`writing-sign-off` icon.
        X (IconName): The :code:`x` icon.
        XBOX_A (IconName): The :code:`xbox-a` icon.
        XBOX_B (IconName): The :code:`xbox-b` icon.
        XBOX_X (IconName): The :code:`xbox-x` icon.
        XBOX_Y (IconName): The :code:`xbox-y` icon.
        XD (IconName): The :code:`xd` icon.
        YIN_YANG (IconName): The :code:`yin-yang` icon.
        YIN_YANG_FILLED (IconName): The :code:`yin-yang-filled` icon.
        YOGA (IconName): The :code:`yoga` icon.
        ZEPPELIN (IconName): The :code:`zeppelin` icon.
        ZEPPELIN_OFF (IconName): The :code:`zeppelin-off` icon.
        ZIP (IconName): The :code:`zip` icon.
        ZODIAC_AQUARIUS (IconName): The :code:`zodiac-aquarius` icon.
        ZODIAC_ARIES (IconName): The :code:`zodiac-aries` icon.
        ZODIAC_CANCER (IconName): The :code:`zodiac-cancer` icon.
        ZODIAC_CAPRICORN (IconName): The :code:`zodiac-capricorn` icon.
        ZODIAC_GEMINI (IconName): The :code:`zodiac-gemini` icon.
        ZODIAC_LEO (IconName): The :code:`zodiac-leo` icon.
        ZODIAC_LIBRA (IconName): The :code:`zodiac-libra` icon.
        ZODIAC_PISCES (IconName): The :code:`zodiac-pisces` icon.
        ZODIAC_SAGITTARIUS (IconName): The :code:`zodiac-sagittarius` icon.
        ZODIAC_SCORPIO (IconName): The :code:`zodiac-scorpio` icon.
        ZODIAC_TAURUS (IconName): The :code:`zodiac-taurus` icon.
        ZODIAC_VIRGO (IconName): The :code:`zodiac-virgo` icon.
        ZOOM_CANCEL (IconName): The :code:`zoom-cancel` icon.
        ZOOM_CHECK (IconName): The :code:`zoom-check` icon.
        ZOOM_CHECK_FILLED (IconName): The :code:`zoom-check-filled` icon.
        ZOOM_CODE (IconName): The :code:`zoom-code` icon.
        ZOOM_EXCLAMATION (IconName): The :code:`zoom-exclamation` icon.
        ZOOM_FILLED (IconName): The :code:`zoom-filled` icon.
        ZOOM_IN (IconName): The :code:`zoom-in` icon.
        ZOOM_IN_AREA (IconName): The :code:`zoom-in-area` icon.
        ZOOM_IN_AREA_FILLED (IconName): The :code:`zoom-in-area-filled` icon.
        ZOOM_IN_FILLED (IconName): The :code:`zoom-in-filled` icon.
        ZOOM_MONEY (IconName): The :code:`zoom-money` icon.
        ZOOM_OUT (IconName): The :code:`zoom-out` icon.
        ZOOM_OUT_AREA (IconName): The :code:`zoom-out-area` icon.
        ZOOM_OUT_FILLED (IconName): The :code:`zoom-out-filled` icon.
        ZOOM_PAN (IconName): The :code:`zoom-pan` icon.
        ZOOM_QUESTION (IconName): The :code:`zoom-question` icon.
        ZOOM_REPLACE (IconName): The :code:`zoom-replace` icon.
        ZOOM_RESET (IconName): The :code:`zoom-reset` icon.
        ZZZ (IconName): The :code:`zzz` icon.
        ZZZ_OFF (IconName): The :code:`zzz-off` icon.
    """
