<a id="mypy-boto3-mediaconnect"></a>

# mypy-boto3-mediaconnect

[![PyPI - mypy-boto3-mediaconnect](https://img.shields.io/pypi/v/mypy-boto3-mediaconnect.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediaconnect)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mediaconnect.svg?color=blue)](https://pypi.org/project/mypy-boto3-mediaconnect)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-mediaconnect?color=blue)](https://pypistats.org/packages/mypy-boto3-mediaconnect)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MediaConnect 1.18.25](https://boto3.amazonaws.com/v1/documentation/api/1.18.25/reference/services/mediaconnect.html#MediaConnect)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-mediaconnect docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediaconnect/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-mediaconnect](#mypy-boto3-mediaconnect)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `MediaConnect` service.

```bash
python -m pip install boto3-stubs[mediaconnect]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mediaconnect]` in your environment:
  `python -m pip install 'boto3-stubs[mediaconnect]'`

Both type checking and auto-complete should work for `MediaConnect` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[mediaconnect]` in your environment:
  `python -m pip install 'boto3-stubs[mediaconnect]'`

Both type checking and auto-complete should work for `MediaConnect` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mediaconnect]` in your environment:
  `python -m pip install 'boto3-stubs[mediaconnect]'`
- Run `mypy` as usual

Type checking should work for `MediaConnect` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mediaconnect]` in your environment:
  `python -m pip install 'boto3-stubs[mediaconnect]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MediaConnect` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`MediaConnectClient` provides annotations for `boto3.client("mediaconnect")`.

```python
import boto3

from mypy_boto3_mediaconnect import MediaConnectClient

client: MediaConnectClient = boto3.client("mediaconnect")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MediaConnectClient = session.client("mediaconnect")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_mediaconnect.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_mediaconnect import MediaConnectClient
from mypy_boto3_mediaconnect.paginator import (
    ListEntitlementsPaginator,
    ListFlowsPaginator,
    ListOfferingsPaginator,
    ListReservationsPaginator,
)

client: MediaConnectClient = boto3.client("mediaconnect")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_entitlements_paginator: ListEntitlementsPaginator = client.get_paginator("list_entitlements")
list_flows_paginator: ListFlowsPaginator = client.get_paginator("list_flows")
list_offerings_paginator: ListOfferingsPaginator = client.get_paginator("list_offerings")
list_reservations_paginator: ListReservationsPaginator = client.get_paginator("list_reservations")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_mediaconnect.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_mediaconnect import MediaConnectClient
from mypy_boto3_mediaconnect.waiter import (
    FlowActiveWaiter,
    FlowDeletedWaiter,
    FlowStandbyWaiter,
)

client: MediaConnectClient = boto3.client("mediaconnect")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
flow_active_waiter: FlowActiveWaiter = client.get_waiter("flow_active")
flow_deleted_waiter: FlowDeletedWaiter = client.get_waiter("flow_deleted")
flow_standby_waiter: FlowStandbyWaiter = client.get_waiter("flow_standby")
```

<a id="literals"></a>

### Literals

`mypy_boto3_mediaconnect.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_mediaconnect.literals import (
    AlgorithmType,
    ColorimetryType,
    DurationUnitsType,
    EncoderProfileType,
    EncodingNameType,
    EntitlementStatusType,
    FailoverModeType,
    FlowActiveWaiterName,
    FlowDeletedWaiterName,
    FlowStandbyWaiterName,
    KeyTypeType,
    ListEntitlementsPaginatorName,
    ListFlowsPaginatorName,
    ListOfferingsPaginatorName,
    ListReservationsPaginatorName,
    MediaStreamTypeType,
    NetworkInterfaceTypeType,
    PriceUnitsType,
    ProtocolType,
    RangeType,
    ReservationStateType,
    ResourceTypeType,
    ScanModeType,
    SourceTypeType,
    StateType,
    StatusType,
    TcsType,
)

def check_value(value: AlgorithmType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_mediaconnect.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_mediaconnect.type_defs import (
    AddFlowMediaStreamsRequestRequestTypeDef,
    AddFlowMediaStreamsResponseTypeDef,
    AddFlowOutputsRequestRequestTypeDef,
    AddFlowOutputsResponseTypeDef,
    AddFlowSourcesRequestRequestTypeDef,
    AddFlowSourcesResponseTypeDef,
    AddFlowVpcInterfacesRequestRequestTypeDef,
    AddFlowVpcInterfacesResponseTypeDef,
    AddMediaStreamRequestTypeDef,
    AddOutputRequestTypeDef,
    CreateFlowRequestRequestTypeDef,
    CreateFlowResponseTypeDef,
    DeleteFlowRequestRequestTypeDef,
    DeleteFlowResponseTypeDef,
    DescribeFlowRequestRequestTypeDef,
    DescribeFlowResponseTypeDef,
    DescribeOfferingRequestRequestTypeDef,
    DescribeOfferingResponseTypeDef,
    DescribeReservationRequestRequestTypeDef,
    DescribeReservationResponseTypeDef,
    DestinationConfigurationRequestTypeDef,
    DestinationConfigurationTypeDef,
    EncodingParametersRequestTypeDef,
    EncodingParametersTypeDef,
    EncryptionTypeDef,
    EntitlementTypeDef,
    FailoverConfigTypeDef,
    FlowTypeDef,
    FmtpRequestTypeDef,
    FmtpTypeDef,
    GrantEntitlementRequestTypeDef,
    GrantFlowEntitlementsRequestRequestTypeDef,
    GrantFlowEntitlementsResponseTypeDef,
    InputConfigurationRequestTypeDef,
    InputConfigurationTypeDef,
    InterfaceRequestTypeDef,
    InterfaceTypeDef,
    ListEntitlementsRequestRequestTypeDef,
    ListEntitlementsResponseTypeDef,
    ListFlowsRequestRequestTypeDef,
    ListFlowsResponseTypeDef,
    ListOfferingsRequestRequestTypeDef,
    ListOfferingsResponseTypeDef,
    ListReservationsRequestRequestTypeDef,
    ListReservationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListedEntitlementTypeDef,
    ListedFlowTypeDef,
    MediaStreamAttributesRequestTypeDef,
    MediaStreamAttributesTypeDef,
    MediaStreamOutputConfigurationRequestTypeDef,
    MediaStreamOutputConfigurationTypeDef,
    MediaStreamSourceConfigurationRequestTypeDef,
    MediaStreamSourceConfigurationTypeDef,
    MediaStreamTypeDef,
    MessagesTypeDef,
    OfferingTypeDef,
    OutputTypeDef,
    PaginatorConfigTypeDef,
    PurchaseOfferingRequestRequestTypeDef,
    PurchaseOfferingResponseTypeDef,
    RemoveFlowMediaStreamRequestRequestTypeDef,
    RemoveFlowMediaStreamResponseTypeDef,
    RemoveFlowOutputRequestRequestTypeDef,
    RemoveFlowOutputResponseTypeDef,
    RemoveFlowSourceRequestRequestTypeDef,
    RemoveFlowSourceResponseTypeDef,
    RemoveFlowVpcInterfaceRequestRequestTypeDef,
    RemoveFlowVpcInterfaceResponseTypeDef,
    ReservationTypeDef,
    ResourceSpecificationTypeDef,
    ResponseMetadataTypeDef,
    RevokeFlowEntitlementRequestRequestTypeDef,
    RevokeFlowEntitlementResponseTypeDef,
    SetSourceRequestTypeDef,
    SourcePriorityTypeDef,
    SourceTypeDef,
    StartFlowRequestRequestTypeDef,
    StartFlowResponseTypeDef,
    StopFlowRequestRequestTypeDef,
    StopFlowResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TransportTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateEncryptionTypeDef,
    UpdateFailoverConfigTypeDef,
    UpdateFlowEntitlementRequestRequestTypeDef,
    UpdateFlowEntitlementResponseTypeDef,
    UpdateFlowMediaStreamRequestRequestTypeDef,
    UpdateFlowMediaStreamResponseTypeDef,
    UpdateFlowOutputRequestRequestTypeDef,
    UpdateFlowOutputResponseTypeDef,
    UpdateFlowRequestRequestTypeDef,
    UpdateFlowResponseTypeDef,
    UpdateFlowSourceRequestRequestTypeDef,
    UpdateFlowSourceResponseTypeDef,
    VpcInterfaceAttachmentTypeDef,
    VpcInterfaceRequestTypeDef,
    VpcInterfaceTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddFlowMediaStreamsRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-mediaconnect` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-mediaconnect docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_mediaconnect/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
