from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from grader_service.api.models.base_model import Model
from grader_service.api.models.assignment_settings import AssignmentSettings
from grader_service.api import util

from grader_service.api.models.assignment_settings import AssignmentSettings  # noqa: E501

class Assignment(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, id=None, name=None, status=None, points=None, settings=None):  # noqa: E501
        """Assignment - a model defined in OpenAPI

        :param id: The id of this Assignment.  # noqa: E501
        :type id: int
        :param name: The name of this Assignment.  # noqa: E501
        :type name: str
        :param status: The status of this Assignment.  # noqa: E501
        :type status: str
        :param points: The points of this Assignment.  # noqa: E501
        :type points: float
        :param settings: The settings of this Assignment.  # noqa: E501
        :type settings: AssignmentSettings
        """
        self.openapi_types = {
            'id': int,
            'name': str,
            'status': str,
            'points': float,
            'settings': AssignmentSettings
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'status': 'status',
            'points': 'points',
            'settings': 'settings'
        }

        self._id = id
        self._name = name
        self._status = status
        self._points = points
        self._settings = settings

    @classmethod
    def from_dict(cls, dikt) -> 'Assignment':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Assignment of this Assignment.  # noqa: E501
        :rtype: Assignment
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> int:
        """Gets the id of this Assignment.


        :return: The id of this Assignment.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id: int):
        """Sets the id of this Assignment.


        :param id: The id of this Assignment.
        :type id: int
        """

        self._id = id

    @property
    def name(self) -> str:
        """Gets the name of this Assignment.


        :return: The name of this Assignment.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this Assignment.


        :param name: The name of this Assignment.
        :type name: str
        """

        self._name = name

    @property
    def status(self) -> str:
        """Gets the status of this Assignment.


        :return: The status of this Assignment.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str):
        """Sets the status of this Assignment.


        :param status: The status of this Assignment.
        :type status: str
        """
        allowed_values = ["created", "pushed", "released", "complete"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def points(self) -> float:
        """Gets the points of this Assignment.


        :return: The points of this Assignment.
        :rtype: float
        """
        return self._points

    @points.setter
    def points(self, points: float):
        """Sets the points of this Assignment.


        :param points: The points of this Assignment.
        :type points: float
        """

        self._points = points

    @property
    def settings(self) -> AssignmentSettings:
        """Gets the settings of this Assignment.


        :return: The settings of this Assignment.
        :rtype: AssignmentSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings: AssignmentSettings):
        """Sets the settings of this Assignment.


        :param settings: The settings of this Assignment.
        :type settings: AssignmentSettings
        """

        self._settings = settings
