from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from grader_service.api.models.base_model import Model
from grader_service.api.models.auto_status import AutoStatus
from grader_service.api.models.feedback_status import FeedbackStatus
from grader_service.api.models.manual_status import ManualStatus
from grader_service.api import util

from grader_service.api.models.auto_status import AutoStatus  # noqa: E501
from grader_service.api.models.feedback_status import FeedbackStatus  # noqa: E501
from grader_service.api.models.manual_status import ManualStatus  # noqa: E501

class Submission(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, id=None, submitted_at=None, auto_status=None, manual_status=None, user_id=None, user_display_name=None, grading_score=None, score_scaling=None, score=None, assignid=None, commit_hash=None, feedback_status=None, edited=None):  # noqa: E501
        """Submission - a model defined in OpenAPI

        :param id: The id of this Submission.  # noqa: E501
        :type id: int
        :param submitted_at: The submitted_at of this Submission.  # noqa: E501
        :type submitted_at: datetime
        :param auto_status: The auto_status of this Submission.  # noqa: E501
        :type auto_status: AutoStatus
        :param manual_status: The manual_status of this Submission.  # noqa: E501
        :type manual_status: ManualStatus
        :param user_id: The user_id of this Submission.  # noqa: E501
        :type user_id: int
        :param user_display_name: The user_display_name of this Submission.  # noqa: E501
        :type user_display_name: str
        :param grading_score: The grading_score of this Submission.  # noqa: E501
        :type grading_score: float
        :param score_scaling: The score_scaling of this Submission.  # noqa: E501
        :type score_scaling: float
        :param score: The score of this Submission.  # noqa: E501
        :type score: float
        :param assignid: The assignid of this Submission.  # noqa: E501
        :type assignid: int
        :param commit_hash: The commit_hash of this Submission.  # noqa: E501
        :type commit_hash: str
        :param feedback_status: The feedback_status of this Submission.  # noqa: E501
        :type feedback_status: FeedbackStatus
        :param edited: The edited of this Submission.  # noqa: E501
        :type edited: bool
        """
        self.openapi_types = {
            'id': int,
            'submitted_at': datetime,
            'auto_status': AutoStatus,
            'manual_status': ManualStatus,
            'user_id': int,
            'user_display_name': str,
            'grading_score': float,
            'score_scaling': float,
            'score': float,
            'assignid': int,
            'commit_hash': str,
            'feedback_status': FeedbackStatus,
            'edited': bool
        }

        self.attribute_map = {
            'id': 'id',
            'submitted_at': 'submitted_at',
            'auto_status': 'auto_status',
            'manual_status': 'manual_status',
            'user_id': 'user_id',
            'user_display_name': 'user_display_name',
            'grading_score': 'grading_score',
            'score_scaling': 'score_scaling',
            'score': 'score',
            'assignid': 'assignid',
            'commit_hash': 'commit_hash',
            'feedback_status': 'feedback_status',
            'edited': 'edited'
        }

        self._id = id
        self._submitted_at = submitted_at
        self._auto_status = auto_status
        self._manual_status = manual_status
        self._user_id = user_id
        self._user_display_name = user_display_name
        self._grading_score = grading_score
        self._score_scaling = score_scaling
        self._score = score
        self._assignid = assignid
        self._commit_hash = commit_hash
        self._feedback_status = feedback_status
        self._edited = edited

    @classmethod
    def from_dict(cls, dikt) -> 'Submission':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Submission of this Submission.  # noqa: E501
        :rtype: Submission
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> int:
        """Gets the id of this Submission.


        :return: The id of this Submission.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id: int):
        """Sets the id of this Submission.


        :param id: The id of this Submission.
        :type id: int
        """

        self._id = id

    @property
    def submitted_at(self) -> datetime:
        """Gets the submitted_at of this Submission.


        :return: The submitted_at of this Submission.
        :rtype: datetime
        """
        return self._submitted_at

    @submitted_at.setter
    def submitted_at(self, submitted_at: datetime):
        """Sets the submitted_at of this Submission.


        :param submitted_at: The submitted_at of this Submission.
        :type submitted_at: datetime
        """

        self._submitted_at = submitted_at

    @property
    def auto_status(self) -> AutoStatus:
        """Gets the auto_status of this Submission.


        :return: The auto_status of this Submission.
        :rtype: AutoStatus
        """
        return self._auto_status

    @auto_status.setter
    def auto_status(self, auto_status: AutoStatus):
        """Sets the auto_status of this Submission.


        :param auto_status: The auto_status of this Submission.
        :type auto_status: AutoStatus
        """

        self._auto_status = auto_status

    @property
    def manual_status(self) -> ManualStatus:
        """Gets the manual_status of this Submission.


        :return: The manual_status of this Submission.
        :rtype: ManualStatus
        """
        return self._manual_status

    @manual_status.setter
    def manual_status(self, manual_status: ManualStatus):
        """Sets the manual_status of this Submission.


        :param manual_status: The manual_status of this Submission.
        :type manual_status: ManualStatus
        """

        self._manual_status = manual_status

    @property
    def user_id(self) -> int:
        """Gets the user_id of this Submission.


        :return: The user_id of this Submission.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: int):
        """Sets the user_id of this Submission.


        :param user_id: The user_id of this Submission.
        :type user_id: int
        """

        self._user_id = user_id

    @property
    def user_display_name(self) -> str:
        """Gets the user_display_name of this Submission.


        :return: The user_display_name of this Submission.
        :rtype: str
        """
        return self._user_display_name

    @user_display_name.setter
    def user_display_name(self, user_display_name: str):
        """Sets the user_display_name of this Submission.


        :param user_display_name: The user_display_name of this Submission.
        :type user_display_name: str
        """

        self._user_display_name = user_display_name

    @property
    def grading_score(self) -> float:
        """Gets the grading_score of this Submission.


        :return: The grading_score of this Submission.
        :rtype: float
        """
        return self._grading_score

    @grading_score.setter
    def grading_score(self, grading_score: float):
        """Sets the grading_score of this Submission.


        :param grading_score: The grading_score of this Submission.
        :type grading_score: float
        """

        self._grading_score = grading_score

    @property
    def score_scaling(self) -> float:
        """Gets the score_scaling of this Submission.


        :return: The score_scaling of this Submission.
        :rtype: float
        """
        return self._score_scaling

    @score_scaling.setter
    def score_scaling(self, score_scaling: float):
        """Sets the score_scaling of this Submission.


        :param score_scaling: The score_scaling of this Submission.
        :type score_scaling: float
        """
        if score_scaling is not None and score_scaling > 1.0:  # noqa: E501
            raise ValueError("Invalid value for `score_scaling`, must be a value less than or equal to `1.0`")  # noqa: E501
        if score_scaling is not None and score_scaling < 0.0:  # noqa: E501
            raise ValueError("Invalid value for `score_scaling`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._score_scaling = score_scaling

    @property
    def score(self) -> float:
        """Gets the score of this Submission.


        :return: The score of this Submission.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score: float):
        """Sets the score of this Submission.


        :param score: The score of this Submission.
        :type score: float
        """

        self._score = score

    @property
    def assignid(self) -> int:
        """Gets the assignid of this Submission.


        :return: The assignid of this Submission.
        :rtype: int
        """
        return self._assignid

    @assignid.setter
    def assignid(self, assignid: int):
        """Sets the assignid of this Submission.


        :param assignid: The assignid of this Submission.
        :type assignid: int
        """

        self._assignid = assignid

    @property
    def commit_hash(self) -> str:
        """Gets the commit_hash of this Submission.


        :return: The commit_hash of this Submission.
        :rtype: str
        """
        return self._commit_hash

    @commit_hash.setter
    def commit_hash(self, commit_hash: str):
        """Sets the commit_hash of this Submission.


        :param commit_hash: The commit_hash of this Submission.
        :type commit_hash: str
        """

        self._commit_hash = commit_hash

    @property
    def feedback_status(self) -> FeedbackStatus:
        """Gets the feedback_status of this Submission.


        :return: The feedback_status of this Submission.
        :rtype: FeedbackStatus
        """
        return self._feedback_status

    @feedback_status.setter
    def feedback_status(self, feedback_status: FeedbackStatus):
        """Sets the feedback_status of this Submission.


        :param feedback_status: The feedback_status of this Submission.
        :type feedback_status: FeedbackStatus
        """

        self._feedback_status = feedback_status

    @property
    def edited(self) -> bool:
        """Gets the edited of this Submission.


        :return: The edited of this Submission.
        :rtype: bool
        """
        return self._edited

    @edited.setter
    def edited(self, edited: bool):
        """Sets the edited of this Submission.


        :param edited: The edited of this Submission.
        :type edited: bool
        """

        self._edited = edited
