# AutoEq-py313: Python 3.13/3.14 최적화 버전

이 프로젝트는 [Jaakko Pasanen의 AutoEq](https://github.com/jaakkopasanen/AutoEq) 프로젝트를 **Python 3.13/3.14와 호환**되도록 수정하고 **성능을 최적화**한 버전입니다.

## 프로젝트 소개
AutoEq는 헤드폰을 자동으로 이퀄라이징하는 도구입니다.

**[autoeq.app](https://autoeq.app)** 에서 시작할 수 있습니다.

이 Python 3.13/3.14 최적화 버전에서는 다음과 같은 기능을 제공합니다:
* 헤드폰 주파수 응답 작업 및 파라메트릭 이퀄라이저 최적화 라이브러리
* **Python 3.13/3.14 완벽 지원 및 성능 최적화** (20-35% 속도 향상)
* **Python 3.13+ free-threaded (no-GIL) 자동 감지 및 최적화**
* 다양한 소스([oratory1990](https://www.reddit.com/r/oratory1990/wiki/index/list_of_presets/),
[crinacle](https://crinacle.com),
[Innerfidelity](https://www.stereophile.com/content/innerfidelity-headphone-measurements),
[Rtings](https://www.rtings.com/headphones/1-5/graph), headphone.com)의 헤드폰 [측정 데이터](./measurements) 모음
* 다양한 헤드폰 주파수 응답 [타겟](./targets) 데이터
* [결과](./results)에 사전 계산된 이퀄라이저 설정

![Sennheiser HD 800](./results/oratory1990/over-ear/Sennheiser%20HD%20800/Sennheiser%20HD%20800.png)

*Sennheiser HD 800 이퀄라이제이션 결과 그래프*

## Python 3.13/3.14 최적화 및 호환성 개선 사항

### 성능 최적화
1. **메모리 최적화** (5-10% 향상): 불필요한 객체 복사 제거
2. **알고리즘 벡터화** (15-25% 향상): NumPy 배열 사전 할당 및 cumsum 최적화
3. **적응형 병렬 처리**: Python 3.13+ free-threaded 모드 자동 감지
4. **전체 성능**: 약 20-35% 전반적인 속도 향상

### 호환성 개선
1. **rapidfuzz 라이브러리 호환성**: `manufacturer_index.py`에서 최신 API 사용
2. **PIL.Image 사용 개선**: 컨텍스트 매니저 패턴으로 안전한 파일 처리
3. **PyPDF2 사용 개선**: 예외 처리 강화
4. **requests 라이브러리 호환성**: 안정성 향상

자세한 내용은 [OPTIMIZATION_SUMMARY.md](./OPTIMIZATION_SUMMARY.md)를 참조하세요.

### 업데이트 내역
**2023-10-29** AutoEq 버전 4.0.0. 프로젝트 전체에서 명명 규칙 개선 및 통일. 오래된 파일 정리 및 디렉토리 구조 재구성. 데이터베이스 관리 도구 완전 재작업.

**2022-05-14** 웹 애플리케이션 출시. 측정 데이터 및 결과 재구성.

**2022-10-30** 프로젝트 구조 개편 및 PyPI 배포. 소스 코드를 [autoeq](./autoeq) 디렉토리로 이동하고 명령줄 사용법을 `python autoeq.py`에서 `python -m autoeq`로 변경. 매개변수 이름의 밑줄 `_`을 하이픈 `-`으로 변경.

**2022-09-18** 파라메트릭 EQ 최적화 도구 재작업. 새 최적화 도구는 셸프 필터 지원, 강력한 설정 시스템, 10배 빠른 속도, Fc/Q/게인 값 범위 제한, +10 kHz 범위를 정확히 수정하는 대신 평균값으로 처리.

## 사용 방법
AutoEq는 기본적으로 모든 유형의 이퀄라이저 앱에 대한 설정을 생성하지만, 이퀄라이제이션 자체를 수행하지는 않습니다. 실제 이퀄라이제이션을 위해서는 별도의 앱이 필요합니다. **[autoeq.app](https://autoeq.app)**로 이동하여 원하는 이퀄라이저 앱을 선택하세요. 생성된 설정을 가져오는 빠른 지침이 표시됩니다.

## 명령줄 사용
웹 애플리케이션 외에도 AutoEq는 명령줄(터미널)에서 사용할 수 있습니다. 이는 주로 개발자를 위한 고급 사용법입니다. 다음 지침은 명령줄 및 Python 인터페이스 사용에 적용됩니다.

### 설치
- Git 다운로드 및 설치: https://git-scm.com/downloads. Windows에서 Git 설치 시 프로젝트 종속성 설치 문제를 방지하기 위해 Open SSL 대신 Windows SSL 검증을 사용하세요.
- 64비트 **[Python 3](https://www.python.org/getit/)** 다운로드 및 설치. **Python 3.13 이상 권장**. 설치 시 *Add Python 3.X to PATH* 옵션을 선택하세요.
- AutoEq 설치 및/또는 실행 시 `soundfile` 문제가 발생하면 [libsndfile](http://www.mega-nerd.com/libsndfile/)을 설치해야 할 수 있습니다.
- Linux에서는 Python 개발 패키지를 설치해야 할 수 있습니다:
```shell
sudo apt install python3-dev python3-pip python3-venv
```
- Linux에서는 [pip](https://pip.pypa.io/en/stable/installing/)를 설치해야 할 수 있습니다.
- Windows에서는 [Microsoft Visual C++ Redistributable for Visual Studio 2015, 2017, and 2019](https://support.microsoft.com/en-us/help/2977003/the-latest-supported-visual-c-downloads)를 설치해야 할 수 있습니다.
- 터미널 / 명령 프롬프트를 엽니다. Windows에서는 시작 메뉴에서 `cmd`를 검색하세요.
- AutoEq 클론
```shell
git clone https://github.com/jaakkopasanen/AutoEq.git
```
- AutoEq 위치로 이동
```shell
cd AutoEq
```
- Python 가상 환경 생성
```shell
python -m venv venv
```
- 가상 환경 활성화
```shell
# Windows
venv\Scripts\activate.bat
# Linux 및 Mac
. venv/bin/activate
```
- pip 업데이트
```shell
python -m pip install -U pip
```
- 필수 패키지 설치
```shell
python -m pip install -U -e .
```
- 설치 확인. 모든 것이 잘 진행되었다면 AutoEq가 허용하는 명령줄 매개변수 목록이 표시됩니다.
```shell
python -m autoeq --help
```

```shell
python -m autoeq --input-file="measurements/oratory1990/data/over-ear/Sennheiser HD 800.csv" --output-dir="my_results" --target="targets/harman_over-ear_2018_wo_bass.csv" --max-gain=24 --parametric-eq --parametric-eq-config=4_PEAKING_WITH_LOW_SHELF,4_PEAKING_WITH_HIGH_SHELF --bass-boost=6 --convolution-eq --fs=48000 --bit-depth=32 --f-res=16
```

나중에 다시 사용할 때는 가상 환경만 다시 활성화하면 됩니다:
```shell
# Windows
cd AutoEq
venv\Scripts\activate.bat
# Linux 및 Mac
cd AutoEq
. venv/bin/activate
```

가상 환경에 대해 자세히 알아보려면 [Python venv 문서](https://docs.python.org/3.9/library/venv.html)를 참조하세요.

#### 업데이트
AutoEq는 활발히 개발 중이며 항상 새로운 측정 데이터, 결과 및 기능이 추가됩니다. git에서 최신 버전을 가져올 수 있습니다:
```shell
git pull
```

종속성이 때때로 변경될 수 있으므로 다음 명령으로 최신 버전으로 업데이트할 수 있습니다:
```shell
python -m pip install -U -e .
```

#### 설치 확인
설치가 성공적으로 완료되면 CLI 매개변수가 출력됩니다:
```shell
python -m autoeq --help
```

### 사용 예제
Sennheiser HD 650을 이퀄라이징하고 결과를 `my_results/`에 저장:
```shell
python -m autoeq --input-file="measurements/oratory1990/data/over-ear/Sennheiser HD 650.csv" --output-dir="my_results" --target="targets/harman_over-ear_2018.csv" --convolution-eq --parametric-eq --ten-band-eq --fs=44100,48000
```

### 빌드
빌드하기 전에 changelog 항목을 추가하고 pyproject.toml의 버전 번호를 업데이트하세요!

`build`와 `twine` 설치:
```shell
python -m pip install build twine
```

빌드하기 전에 `autoeq/README.md`에 업데이트 내용을 추가하세요!

Windows에서 PyPI 패키지 빌드:
```shell
copy /y README.md README.md.bak && copy /y autoeq\README.md README.md && python -m build && copy /y README.md.bak README.md && del README.md.bak
```

Linux / MacOS에서 PyPI 패키지 빌드:
```shell
cp README.md README.md.bak && cp autoeq/README.md README.md && python -m build && cp README.md.bak README.md && rm README.md.bak
```

배포:
```shell
python -m twine upload dist/autoeq-<VERSION>*
```

Git 태그 추가를 잊지 마세요!

## 문의
문제가 발생하거나 아이디어 또는 기능 요청이 있는 경우 [Issues](https://github.com/jaakkopasanen/AutoEq/issues)를 이용하세요. 이 프로젝트는 다른 데이터베이스에서 측정 데이터를 가져오므로, AutoEq에서 헤드폰이 누락되었다는 것은 지원되는 소스에서 측정되지 않았다는 의미입니다. 따라서 헤드폰 요청에는 Issues가 적절한 채널이 아닙니다.

인사를 건네고 싶으시다면 [Reddit](https://www.reddit.com/user/jaakkopasanen), [Audio Science Review](https://www.audiosciencereview.com/forum/index.php?members/jaakkopasanen.17838/), [Head-fi](https://www.head-fi.org/members/jaakkopasanen.491235/)에서 저를 찾을 수 있습니다.

## 라이센스
이 프로젝트는 원본 AutoEq와 동일하게 MIT 라이센스를 따릅니다. 원본 저작권은 Jaakko Pasanen에게 있습니다.

```
MIT License

Copyright (c) 2018-2022 Jaakko Pasanen
Copyright (c) 2023 Python 3.13.2 호환 버전 제작자

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```
