# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BigQueryCredentialArgs', 'BigQueryCredential']

@pulumi.input_type
class BigQueryCredentialArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[_builtins.str],
                 num_threads: pulumi.Input[_builtins.int],
                 project_id: pulumi.Input[_builtins.int],
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a BigQueryCredential resource.
        :param pulumi.Input[_builtins.str] dataset: Default dataset name
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the BigQuery credential in
        :param pulumi.Input[_builtins.bool] is_active: Whether the BigQuery credential is active
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[_builtins.str]:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[_builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the BigQuery credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)


@pulumi.input_type
class _BigQueryCredentialState:
    def __init__(__self__, *,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering BigQueryCredential resources.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] dataset: Default dataset name
        :param pulumi.Input[_builtins.bool] is_active: Whether the BigQuery credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the BigQuery credential in
        """
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the BigQuery credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("dbtcloud:index/bigQueryCredential:BigQueryCredential")
class BigQueryCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Bigquery credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        my_credential = dbtcloud.BigQueryCredential("my_credential",
            project_id=dbt_project["id"],
            dataset="my_bq_dataset",
            num_threads=16)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_bigquery_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_bigquery_credential.my_credential

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/bigQueryCredential:BigQueryCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/bigQueryCredential:BigQueryCredential my_credential 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dataset: Default dataset name
        :param pulumi.Input[_builtins.bool] is_active: Whether the BigQuery credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the BigQuery credential in
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BigQueryCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Bigquery credential resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        my_credential = dbtcloud.BigQueryCredential("my_credential",
            project_id=dbt_project["id"],
            dataset="my_bq_dataset",
            num_threads=16)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_bigquery_credential.my_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_bigquery_credential.my_credential

          id = "12345:5678"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/bigQueryCredential:BigQueryCredential my_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/bigQueryCredential:BigQueryCredential my_credential 12345:5678
        ```

        :param str resource_name: The name of the resource.
        :param BigQueryCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BigQueryCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BigQueryCredentialArgs.__new__(BigQueryCredentialArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["is_active"] = is_active
            if num_threads is None and not opts.urn:
                raise TypeError("Missing required property 'num_threads'")
            __props__.__dict__["num_threads"] = num_threads
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["credential_id"] = None
        super(BigQueryCredential, __self__).__init__(
            'dbtcloud:index/bigQueryCredential:BigQueryCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            dataset: Optional[pulumi.Input[_builtins.str]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            num_threads: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'BigQueryCredential':
        """
        Get an existing BigQueryCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] dataset: Default dataset name
        :param pulumi.Input[_builtins.bool] is_active: Whether the BigQuery credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the BigQuery credential in
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BigQueryCredentialState.__new__(_BigQueryCredentialState)

        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["num_threads"] = num_threads
        __props__.__dict__["project_id"] = project_id
        return BigQueryCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[_builtins.str]:
        """
        Default dataset name
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the BigQuery credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Output[_builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the BigQuery credential in
        """
        return pulumi.get(self, "project_id")

