# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ExtendedAttributesArgs', 'ExtendedAttributes']

@pulumi.input_type
class ExtendedAttributesArgs:
    def __init__(__self__, *,
                 extended_attributes: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.int],
                 state: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ExtendedAttributes resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the extended attributes in
        :param pulumi.Input[_builtins.int] state: The state of the extended attributes (1 = active, 2 = inactive)
        """
        pulumi.set(__self__, "extended_attributes", extended_attributes)
        pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "extended_attributes")

    @extended_attributes.setter
    def extended_attributes(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extended_attributes", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the extended attributes in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The state of the extended attributes (1 = active, 2 = inactive)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ExtendedAttributesState:
    def __init__(__self__, *,
                 extended_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ExtendedAttributes resources.
        :param pulumi.Input[_builtins.int] extended_attributes_id: Extended attributes ID
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the extended attributes in
        :param pulumi.Input[_builtins.int] state: The state of the extended attributes (1 = active, 2 = inactive)
        """
        if extended_attributes is not None:
            pulumi.set(__self__, "extended_attributes", extended_attributes)
        if extended_attributes_id is not None:
            pulumi.set(__self__, "extended_attributes_id", extended_attributes_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "extended_attributes")

    @extended_attributes.setter
    def extended_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extended_attributes", value)

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Extended attributes ID
        """
        return pulumi.get(self, "extended_attributes_id")

    @extended_attributes_id.setter
    def extended_attributes_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_attributes_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the extended attributes in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The state of the extended attributes (1 = active, 2 = inactive)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("dbtcloud:index/extendedAttributes:ExtendedAttributes")
class ExtendedAttributes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extended_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Extended attributes resource

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_dbtcloud as dbtcloud

        # extended_attributes can be set as a raw JSON string or encoded with Terraform's `jsonencode()` function
        # we recommend using `jsonencode()` to avoid Terraform reporting changes due to whitespaces or keys ordering
        my_attributes = dbtcloud.ExtendedAttributes("my_attributes",
            extended_attributes=json.dumps({
                "type": "databricks",
                "catalog": "dbt_catalog",
                "http_path": "/sql/your/http/path",
                "my_nested_field": {
                    "subfield": "my_value",
                },
            }),
            project_id=dbt_project["id"])
        issue_depl = dbtcloud.Environment("issue_depl",
            dbt_version="latest",
            name="My environment",
            project_id=dbt_project["id"],
            type="deployment",
            use_custom_branch=False,
            credential_id=dbt_credential_id,
            deployment_type="production",
            extended_attributes_id=my_attributes.extended_attributes_id)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_extended_attributes.test_extended_attributes

          id = "project_id_id:extended_attributes_id"

        }

        import {

          to = dbtcloud_extended_attributes.test_extended_attributes

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/extendedAttributes:ExtendedAttributes test_extended_attributes "project_id_id:extended_attributes_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/extendedAttributes:ExtendedAttributes test_extended_attributes 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the extended attributes in
        :param pulumi.Input[_builtins.int] state: The state of the extended attributes (1 = active, 2 = inactive)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtendedAttributesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Extended attributes resource

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_dbtcloud as dbtcloud

        # extended_attributes can be set as a raw JSON string or encoded with Terraform's `jsonencode()` function
        # we recommend using `jsonencode()` to avoid Terraform reporting changes due to whitespaces or keys ordering
        my_attributes = dbtcloud.ExtendedAttributes("my_attributes",
            extended_attributes=json.dumps({
                "type": "databricks",
                "catalog": "dbt_catalog",
                "http_path": "/sql/your/http/path",
                "my_nested_field": {
                    "subfield": "my_value",
                },
            }),
            project_id=dbt_project["id"])
        issue_depl = dbtcloud.Environment("issue_depl",
            dbt_version="latest",
            name="My environment",
            project_id=dbt_project["id"],
            type="deployment",
            use_custom_branch=False,
            credential_id=dbt_credential_id,
            deployment_type="production",
            extended_attributes_id=my_attributes.extended_attributes_id)
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_extended_attributes.test_extended_attributes

          id = "project_id_id:extended_attributes_id"

        }

        import {

          to = dbtcloud_extended_attributes.test_extended_attributes

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/extendedAttributes:ExtendedAttributes test_extended_attributes "project_id_id:extended_attributes_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/extendedAttributes:ExtendedAttributes test_extended_attributes 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param ExtendedAttributesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtendedAttributesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extended_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtendedAttributesArgs.__new__(ExtendedAttributesArgs)

            if extended_attributes is None and not opts.urn:
                raise TypeError("Missing required property 'extended_attributes'")
            __props__.__dict__["extended_attributes"] = extended_attributes
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = state
            __props__.__dict__["extended_attributes_id"] = None
        super(ExtendedAttributes, __self__).__init__(
            'dbtcloud:index/extendedAttributes:ExtendedAttributes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            extended_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            extended_attributes_id: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.int]] = None) -> 'ExtendedAttributes':
        """
        Get an existing ExtendedAttributes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] extended_attributes_id: Extended attributes ID
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the extended attributes in
        :param pulumi.Input[_builtins.int] state: The state of the extended attributes (1 = active, 2 = inactive)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtendedAttributesState.__new__(_ExtendedAttributesState)

        __props__.__dict__["extended_attributes"] = extended_attributes
        __props__.__dict__["extended_attributes_id"] = extended_attributes_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        return ExtendedAttributes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="extendedAttributes")
    def extended_attributes(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "extended_attributes")

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> pulumi.Output[_builtins.int]:
        """
        Extended attributes ID
        """
        return pulumi.get(self, "extended_attributes_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the extended attributes in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.int]:
        """
        The state of the extended attributes (1 = active, 2 = inactive)
        """
        return pulumi.get(self, "state")

