# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    """
    A collection of values returned by getEnvironment.
    """
    def __init__(__self__, connection_id=None, credentials_id=None, custom_branch=None, dbt_version=None, deployment_type=None, enable_model_query_history=None, environment_id=None, extended_attributes_id=None, id=None, name=None, project_id=None, type=None, use_custom_branch=None):
        if connection_id and not isinstance(connection_id, int):
            raise TypeError("Expected argument 'connection_id' to be a int")
        pulumi.set(__self__, "connection_id", connection_id)
        if credentials_id and not isinstance(credentials_id, int):
            raise TypeError("Expected argument 'credentials_id' to be a int")
        pulumi.set(__self__, "credentials_id", credentials_id)
        if custom_branch and not isinstance(custom_branch, str):
            raise TypeError("Expected argument 'custom_branch' to be a str")
        pulumi.set(__self__, "custom_branch", custom_branch)
        if dbt_version and not isinstance(dbt_version, str):
            raise TypeError("Expected argument 'dbt_version' to be a str")
        pulumi.set(__self__, "dbt_version", dbt_version)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if enable_model_query_history and not isinstance(enable_model_query_history, bool):
            raise TypeError("Expected argument 'enable_model_query_history' to be a bool")
        pulumi.set(__self__, "enable_model_query_history", enable_model_query_history)
        if environment_id and not isinstance(environment_id, int):
            raise TypeError("Expected argument 'environment_id' to be a int")
        pulumi.set(__self__, "environment_id", environment_id)
        if extended_attributes_id and not isinstance(extended_attributes_id, int):
            raise TypeError("Expected argument 'extended_attributes_id' to be a int")
        pulumi.set(__self__, "extended_attributes_id", extended_attributes_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if use_custom_branch and not isinstance(use_custom_branch, bool):
            raise TypeError("Expected argument 'use_custom_branch' to be a bool")
        pulumi.set(__self__, "use_custom_branch", use_custom_branch)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> _builtins.int:
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="credentialsId")
    def credentials_id(self) -> _builtins.int:
        """
        Credential ID for this environment. A credential is not required for development environments, as dbt Cloud defaults to the user's credentials, but deployment environments will have this.
        """
        return pulumi.get(self, "credentials_id")

    @_builtins.property
    @pulumi.getter(name="customBranch")
    def custom_branch(self) -> _builtins.str:
        """
        The custom branch name to use
        """
        return pulumi.get(self, "custom_branch")

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> _builtins.str:
        """
        Version number of dbt to use in this environment.
        """
        return pulumi.get(self, "dbt_version")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        """
        The type of deployment environment (currently 'production', 'staging' or empty)
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="enableModelQueryHistory")
    def enable_model_query_history(self) -> _builtins.bool:
        """
        Whether model query history is on
        """
        return pulumi.get(self, "enable_model_query_history")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.int:
        """
        The ID of the environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="extendedAttributesId")
    def extended_attributes_id(self) -> _builtins.int:
        """
        The ID of the extended attributes applied
        """
        return pulumi.get(self, "extended_attributes_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        The project ID to which the environment belongs
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of environment (must be either development or deployment)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="useCustomBranch")
    def use_custom_branch(self) -> _builtins.bool:
        """
        Whether to use a custom git branch in this environment
        """
        return pulumi.get(self, "use_custom_branch")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            connection_id=self.connection_id,
            credentials_id=self.credentials_id,
            custom_branch=self.custom_branch,
            dbt_version=self.dbt_version,
            deployment_type=self.deployment_type,
            enable_model_query_history=self.enable_model_query_history,
            environment_id=self.environment_id,
            extended_attributes_id=self.extended_attributes_id,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            type=self.type,
            use_custom_branch=self.use_custom_branch)


def get_environment(environment_id: Optional[_builtins.int] = None,
                    project_id: Optional[_builtins.int] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Retrieve data for a single environment


    :param _builtins.int environment_id: The ID of the environment
    :param _builtins.int project_id: The project ID to which the environment belongs
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getEnvironment:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        connection_id=pulumi.get(__ret__, 'connection_id'),
        credentials_id=pulumi.get(__ret__, 'credentials_id'),
        custom_branch=pulumi.get(__ret__, 'custom_branch'),
        dbt_version=pulumi.get(__ret__, 'dbt_version'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        enable_model_query_history=pulumi.get(__ret__, 'enable_model_query_history'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        extended_attributes_id=pulumi.get(__ret__, 'extended_attributes_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        type=pulumi.get(__ret__, 'type'),
        use_custom_branch=pulumi.get(__ret__, 'use_custom_branch'))
def get_environment_output(environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                           project_id: Optional[pulumi.Input[_builtins.int]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Retrieve data for a single environment


    :param _builtins.int environment_id: The ID of the environment
    :param _builtins.int project_id: The project ID to which the environment belongs
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getEnvironment:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult)
    return __ret__.apply(lambda __response__: GetEnvironmentResult(
        connection_id=pulumi.get(__response__, 'connection_id'),
        credentials_id=pulumi.get(__response__, 'credentials_id'),
        custom_branch=pulumi.get(__response__, 'custom_branch'),
        dbt_version=pulumi.get(__response__, 'dbt_version'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        enable_model_query_history=pulumi.get(__response__, 'enable_model_query_history'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        extended_attributes_id=pulumi.get(__response__, 'extended_attributes_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        type=pulumi.get(__response__, 'type'),
        use_custom_branch=pulumi.get(__response__, 'use_custom_branch')))
