# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEnvironmentVariableResult',
    'AwaitableGetEnvironmentVariableResult',
    'get_environment_variable',
    'get_environment_variable_output',
]

@pulumi.output_type
class GetEnvironmentVariableResult:
    """
    A collection of values returned by getEnvironmentVariable.
    """
    def __init__(__self__, environment_values=None, id=None, name=None, project_id=None):
        if environment_values and not isinstance(environment_values, dict):
            raise TypeError("Expected argument 'environment_values' to be a dict")
        pulumi.set(__self__, "environment_values", environment_values)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="environmentValues")
    def environment_values(self) -> Mapping[str, _builtins.str]:
        """
        Map from environment names to respective variable value, a special key `project` should be set for the project default variable value. This field is not set as sensitive so take precautions when using secret environment variables.
        """
        return pulumi.get(self, "environment_values")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource. Contains the project ID and the environment variable ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the environment variable in
        """
        return pulumi.get(self, "project_id")


class AwaitableGetEnvironmentVariableResult(GetEnvironmentVariableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentVariableResult(
            environment_values=self.environment_values,
            id=self.id,
            name=self.name,
            project_id=self.project_id)


def get_environment_variable(name: Optional[_builtins.str] = None,
                             project_id: Optional[_builtins.int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentVariableResult:
    """
    Environment variable credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_var = dbtcloud.get_environment_variable(project_id=70403103985068,
        name="DBT_MY_PARTIAL_VAR")
    ```


    :param _builtins.str name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
    :param _builtins.int project_id: Project ID to create the environment variable in
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getEnvironmentVariable:getEnvironmentVariable', __args__, opts=opts, typ=GetEnvironmentVariableResult).value

    return AwaitableGetEnvironmentVariableResult(
        environment_values=pulumi.get(__ret__, 'environment_values'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_environment_variable_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                    project_id: Optional[pulumi.Input[_builtins.int]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentVariableResult]:
    """
    Environment variable credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    my_var = dbtcloud.get_environment_variable(project_id=70403103985068,
        name="DBT_MY_PARTIAL_VAR")
    ```


    :param _builtins.str name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
    :param _builtins.int project_id: Project ID to create the environment variable in
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getEnvironmentVariable:getEnvironmentVariable', __args__, opts=opts, typ=GetEnvironmentVariableResult)
    return __ret__.apply(lambda __response__: GetEnvironmentVariableResult(
        environment_values=pulumi.get(__response__, 'environment_values'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id')))
