# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, azure_active_directory_project_id=None, azure_active_directory_repository_id=None, azure_bypass_webhook_registration_failure=None, deploy_key=None, fetch_deploy_key=None, git_clone_strategy=None, github_installation_id=None, gitlab_project_id=None, id=None, is_active=None, private_link_endpoint_id=None, project_id=None, pull_request_url_template=None, remote_url=None, repository_credentials_id=None, repository_id=None):
        if azure_active_directory_project_id and not isinstance(azure_active_directory_project_id, str):
            raise TypeError("Expected argument 'azure_active_directory_project_id' to be a str")
        pulumi.set(__self__, "azure_active_directory_project_id", azure_active_directory_project_id)
        if azure_active_directory_repository_id and not isinstance(azure_active_directory_repository_id, str):
            raise TypeError("Expected argument 'azure_active_directory_repository_id' to be a str")
        pulumi.set(__self__, "azure_active_directory_repository_id", azure_active_directory_repository_id)
        if azure_bypass_webhook_registration_failure and not isinstance(azure_bypass_webhook_registration_failure, bool):
            raise TypeError("Expected argument 'azure_bypass_webhook_registration_failure' to be a bool")
        pulumi.set(__self__, "azure_bypass_webhook_registration_failure", azure_bypass_webhook_registration_failure)
        if deploy_key and not isinstance(deploy_key, str):
            raise TypeError("Expected argument 'deploy_key' to be a str")
        pulumi.set(__self__, "deploy_key", deploy_key)
        if fetch_deploy_key and not isinstance(fetch_deploy_key, bool):
            raise TypeError("Expected argument 'fetch_deploy_key' to be a bool")
        pulumi.set(__self__, "fetch_deploy_key", fetch_deploy_key)
        if git_clone_strategy and not isinstance(git_clone_strategy, str):
            raise TypeError("Expected argument 'git_clone_strategy' to be a str")
        pulumi.set(__self__, "git_clone_strategy", git_clone_strategy)
        if github_installation_id and not isinstance(github_installation_id, int):
            raise TypeError("Expected argument 'github_installation_id' to be a int")
        pulumi.set(__self__, "github_installation_id", github_installation_id)
        if gitlab_project_id and not isinstance(gitlab_project_id, int):
            raise TypeError("Expected argument 'gitlab_project_id' to be a int")
        pulumi.set(__self__, "gitlab_project_id", gitlab_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if private_link_endpoint_id and not isinstance(private_link_endpoint_id, str):
            raise TypeError("Expected argument 'private_link_endpoint_id' to be a str")
        pulumi.set(__self__, "private_link_endpoint_id", private_link_endpoint_id)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if pull_request_url_template and not isinstance(pull_request_url_template, str):
            raise TypeError("Expected argument 'pull_request_url_template' to be a str")
        pulumi.set(__self__, "pull_request_url_template", pull_request_url_template)
        if remote_url and not isinstance(remote_url, str):
            raise TypeError("Expected argument 'remote_url' to be a str")
        pulumi.set(__self__, "remote_url", remote_url)
        if repository_credentials_id and not isinstance(repository_credentials_id, int):
            raise TypeError("Expected argument 'repository_credentials_id' to be a int")
        pulumi.set(__self__, "repository_credentials_id", repository_credentials_id)
        if repository_id and not isinstance(repository_id, int):
            raise TypeError("Expected argument 'repository_id' to be a int")
        pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryProjectId")
    def azure_active_directory_project_id(self) -> _builtins.str:
        """
        The Azure Dev Ops project ID
        """
        return pulumi.get(self, "azure_active_directory_project_id")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryRepositoryId")
    def azure_active_directory_repository_id(self) -> _builtins.str:
        """
        The Azure Dev Ops repository ID
        """
        return pulumi.get(self, "azure_active_directory_repository_id")

    @_builtins.property
    @pulumi.getter(name="azureBypassWebhookRegistrationFailure")
    def azure_bypass_webhook_registration_failure(self) -> _builtins.bool:
        """
        If set to False (the default), the connection will fail if the service user doesn't have access to set webhooks
        """
        return pulumi.get(self, "azure_bypass_webhook_registration_failure")

    @_builtins.property
    @pulumi.getter(name="deployKey")
    def deploy_key(self) -> _builtins.str:
        """
        Public key generated by dbt when using `deploy_key` clone strategy
        """
        return pulumi.get(self, "deploy_key")

    @_builtins.property
    @pulumi.getter(name="fetchDeployKey")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future version of the provider. The key is always fetched when the clone strategy is `deploy_key`""")
    def fetch_deploy_key(self) -> _builtins.bool:
        """
        Whether we should return the public deploy key
        """
        return pulumi.get(self, "fetch_deploy_key")

    @_builtins.property
    @pulumi.getter(name="gitCloneStrategy")
    def git_clone_strategy(self) -> _builtins.str:
        """
        Git clone strategy for the repository
        """
        return pulumi.get(self, "git_clone_strategy")

    @_builtins.property
    @pulumi.getter(name="githubInstallationId")
    def github_installation_id(self) -> _builtins.int:
        """
        Identifier for the GitHub installation
        """
        return pulumi.get(self, "github_installation_id")

    @_builtins.property
    @pulumi.getter(name="gitlabProjectId")
    def gitlab_project_id(self) -> _builtins.int:
        """
        Identifier for the Gitlab project
        """
        return pulumi.get(self, "gitlab_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> _builtins.bool:
        """
        Whether the repository is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> _builtins.str:
        """
        Identifier for the PrivateLink endpoint.
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID to create the repository in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pullRequestUrlTemplate")
    def pull_request_url_template(self) -> _builtins.str:
        """
        The pull request URL template to be used when opening a pull request from within dbt Cloud's IDE
        """
        return pulumi.get(self, "pull_request_url_template")

    @_builtins.property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> _builtins.str:
        """
        Git URL for the repository or <Group>/<Project> for Gitlab
        """
        return pulumi.get(self, "remote_url")

    @_builtins.property
    @pulumi.getter(name="repositoryCredentialsId")
    def repository_credentials_id(self) -> _builtins.int:
        """
        Credentials ID for the repository (From the repository side not the dbt Cloud ID)
        """
        return pulumi.get(self, "repository_credentials_id")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.int:
        """
        ID for the repository
        """
        return pulumi.get(self, "repository_id")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            azure_active_directory_project_id=self.azure_active_directory_project_id,
            azure_active_directory_repository_id=self.azure_active_directory_repository_id,
            azure_bypass_webhook_registration_failure=self.azure_bypass_webhook_registration_failure,
            deploy_key=self.deploy_key,
            fetch_deploy_key=self.fetch_deploy_key,
            git_clone_strategy=self.git_clone_strategy,
            github_installation_id=self.github_installation_id,
            gitlab_project_id=self.gitlab_project_id,
            id=self.id,
            is_active=self.is_active,
            private_link_endpoint_id=self.private_link_endpoint_id,
            project_id=self.project_id,
            pull_request_url_template=self.pull_request_url_template,
            remote_url=self.remote_url,
            repository_credentials_id=self.repository_credentials_id,
            repository_id=self.repository_id)


def get_repository(fetch_deploy_key: Optional[_builtins.bool] = None,
                   project_id: Optional[_builtins.int] = None,
                   repository_id: Optional[_builtins.int] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    Retrieve data for a single repository


    :param _builtins.bool fetch_deploy_key: Whether we should return the public deploy key
    :param _builtins.int project_id: Project ID to create the repository in
    :param _builtins.int repository_id: ID for the repository
    """
    __args__ = dict()
    __args__['fetchDeployKey'] = fetch_deploy_key
    __args__['projectId'] = project_id
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        azure_active_directory_project_id=pulumi.get(__ret__, 'azure_active_directory_project_id'),
        azure_active_directory_repository_id=pulumi.get(__ret__, 'azure_active_directory_repository_id'),
        azure_bypass_webhook_registration_failure=pulumi.get(__ret__, 'azure_bypass_webhook_registration_failure'),
        deploy_key=pulumi.get(__ret__, 'deploy_key'),
        fetch_deploy_key=pulumi.get(__ret__, 'fetch_deploy_key'),
        git_clone_strategy=pulumi.get(__ret__, 'git_clone_strategy'),
        github_installation_id=pulumi.get(__ret__, 'github_installation_id'),
        gitlab_project_id=pulumi.get(__ret__, 'gitlab_project_id'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        private_link_endpoint_id=pulumi.get(__ret__, 'private_link_endpoint_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        pull_request_url_template=pulumi.get(__ret__, 'pull_request_url_template'),
        remote_url=pulumi.get(__ret__, 'remote_url'),
        repository_credentials_id=pulumi.get(__ret__, 'repository_credentials_id'),
        repository_id=pulumi.get(__ret__, 'repository_id'))
def get_repository_output(fetch_deploy_key: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                          project_id: Optional[pulumi.Input[_builtins.int]] = None,
                          repository_id: Optional[pulumi.Input[_builtins.int]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    Retrieve data for a single repository


    :param _builtins.bool fetch_deploy_key: Whether we should return the public deploy key
    :param _builtins.int project_id: Project ID to create the repository in
    :param _builtins.int repository_id: ID for the repository
    """
    __args__ = dict()
    __args__['fetchDeployKey'] = fetch_deploy_key
    __args__['projectId'] = project_id
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult)
    return __ret__.apply(lambda __response__: GetRepositoryResult(
        azure_active_directory_project_id=pulumi.get(__response__, 'azure_active_directory_project_id'),
        azure_active_directory_repository_id=pulumi.get(__response__, 'azure_active_directory_repository_id'),
        azure_bypass_webhook_registration_failure=pulumi.get(__response__, 'azure_bypass_webhook_registration_failure'),
        deploy_key=pulumi.get(__response__, 'deploy_key'),
        fetch_deploy_key=pulumi.get(__response__, 'fetch_deploy_key'),
        git_clone_strategy=pulumi.get(__response__, 'git_clone_strategy'),
        github_installation_id=pulumi.get(__response__, 'github_installation_id'),
        gitlab_project_id=pulumi.get(__response__, 'gitlab_project_id'),
        id=pulumi.get(__response__, 'id'),
        is_active=pulumi.get(__response__, 'is_active'),
        private_link_endpoint_id=pulumi.get(__response__, 'private_link_endpoint_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        pull_request_url_template=pulumi.get(__response__, 'pull_request_url_template'),
        remote_url=pulumi.get(__response__, 'remote_url'),
        repository_credentials_id=pulumi.get(__response__, 'repository_credentials_id'),
        repository_id=pulumi.get(__response__, 'repository_id')))
