# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetStarburstCredentialResult',
    'AwaitableGetStarburstCredentialResult',
    'get_starburst_credential',
    'get_starburst_credential_output',
]

@pulumi.output_type
class GetStarburstCredentialResult:
    """
    A collection of values returned by getStarburstCredential.
    """
    def __init__(__self__, credential_id=None, database=None, id=None, project_id=None, schema=None):
        if credential_id and not isinstance(credential_id, int):
            raise TypeError("Expected argument 'credential_id' to be a int")
        pulumi.set(__self__, "credential_id", credential_id)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> _builtins.int:
        """
        Credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The catalog to connect to
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")


class AwaitableGetStarburstCredentialResult(GetStarburstCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStarburstCredentialResult(
            credential_id=self.credential_id,
            database=self.database,
            id=self.id,
            project_id=self.project_id,
            schema=self.schema)


def get_starburst_credential(credential_id: Optional[_builtins.int] = None,
                             project_id: Optional[_builtins.int] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStarburstCredentialResult:
    """
    Starburst/Trino credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    example = dbtcloud.get_starburst_credential(project_id=123,
        credential_id=456)
    ```


    :param _builtins.int credential_id: Credential ID
    :param _builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getStarburstCredential:getStarburstCredential', __args__, opts=opts, typ=GetStarburstCredentialResult).value

    return AwaitableGetStarburstCredentialResult(
        credential_id=pulumi.get(__ret__, 'credential_id'),
        database=pulumi.get(__ret__, 'database'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schema=pulumi.get(__ret__, 'schema'))
def get_starburst_credential_output(credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                                    project_id: Optional[pulumi.Input[_builtins.int]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStarburstCredentialResult]:
    """
    Starburst/Trino credential data source

    ## Example Usage

    ```python
    import pulumi
    import pulumi_dbtcloud as dbtcloud

    example = dbtcloud.get_starburst_credential(project_id=123,
        credential_id=456)
    ```


    :param _builtins.int credential_id: Credential ID
    :param _builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getStarburstCredential:getStarburstCredential', __args__, opts=opts, typ=GetStarburstCredentialResult)
    return __ret__.apply(lambda __response__: GetStarburstCredentialResult(
        credential_id=pulumi.get(__response__, 'credential_id'),
        database=pulumi.get(__response__, 'database'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        schema=pulumi.get(__response__, 'schema')))
