# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSynapseCredentialResult',
    'AwaitableGetSynapseCredentialResult',
    'get_synapse_credential',
    'get_synapse_credential_output',
]

@pulumi.output_type
class GetSynapseCredentialResult:
    """
    A collection of values returned by getSynapseCredential.
    """
    def __init__(__self__, adapter_type=None, authentication=None, client_id=None, credential_id=None, id=None, project_id=None, schema=None, schema_authorization=None, tenant_id=None, user=None):
        if adapter_type and not isinstance(adapter_type, str):
            raise TypeError("Expected argument 'adapter_type' to be a str")
        pulumi.set(__self__, "adapter_type", adapter_type)
        if authentication and not isinstance(authentication, str):
            raise TypeError("Expected argument 'authentication' to be a str")
        pulumi.set(__self__, "authentication", authentication)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if credential_id and not isinstance(credential_id, int):
            raise TypeError("Expected argument 'credential_id' to be a int")
        pulumi.set(__self__, "credential_id", credential_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if schema_authorization and not isinstance(schema_authorization, str):
            raise TypeError("Expected argument 'schema_authorization' to be a str")
        pulumi.set(__self__, "schema_authorization", schema_authorization)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if user and not isinstance(user, str):
            raise TypeError("Expected argument 'user' to be a str")
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="adapterType")
    def adapter_type(self) -> _builtins.str:
        """
        The type of the adapter (synapse)
        """
        return pulumi.get(self, "adapter_type")

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> _builtins.str:
        """
        Authentication type (SQL, ActiveDirectoryPassword, ServicePrincipal)
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID of the Azure Active Directory service principal. This is only used when connecting to Azure SQL with an AAD service principal.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> _builtins.int:
        """
        Credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this data source. Contains the project ID and the credential ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.int:
        """
        Project ID
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The schema where to create the dbt models
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaAuthorization")
    def schema_authorization(self) -> _builtins.str:
        """
        Optionally set this to the principal who should own the schemas created by dbt
        """
        return pulumi.get(self, "schema_authorization")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The tenant ID of the Azure Active Directory instance. This is only used when connecting to Azure SQL with a service principal.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The username of the Synapse account to connect to. Only used when connection with AD user/pass
        """
        return pulumi.get(self, "user")


class AwaitableGetSynapseCredentialResult(GetSynapseCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSynapseCredentialResult(
            adapter_type=self.adapter_type,
            authentication=self.authentication,
            client_id=self.client_id,
            credential_id=self.credential_id,
            id=self.id,
            project_id=self.project_id,
            schema=self.schema,
            schema_authorization=self.schema_authorization,
            tenant_id=self.tenant_id,
            user=self.user)


def get_synapse_credential(credential_id: Optional[_builtins.int] = None,
                           project_id: Optional[_builtins.int] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSynapseCredentialResult:
    """
    Synapse credential data source.


    :param _builtins.int credential_id: Credential ID
    :param _builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('dbtcloud:index/getSynapseCredential:getSynapseCredential', __args__, opts=opts, typ=GetSynapseCredentialResult).value

    return AwaitableGetSynapseCredentialResult(
        adapter_type=pulumi.get(__ret__, 'adapter_type'),
        authentication=pulumi.get(__ret__, 'authentication'),
        client_id=pulumi.get(__ret__, 'client_id'),
        credential_id=pulumi.get(__ret__, 'credential_id'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        schema=pulumi.get(__ret__, 'schema'),
        schema_authorization=pulumi.get(__ret__, 'schema_authorization'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        user=pulumi.get(__ret__, 'user'))
def get_synapse_credential_output(credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                                  project_id: Optional[pulumi.Input[_builtins.int]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSynapseCredentialResult]:
    """
    Synapse credential data source.


    :param _builtins.int credential_id: Credential ID
    :param _builtins.int project_id: Project ID
    """
    __args__ = dict()
    __args__['credentialId'] = credential_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('dbtcloud:index/getSynapseCredential:getSynapseCredential', __args__, opts=opts, typ=GetSynapseCredentialResult)
    return __ret__.apply(lambda __response__: GetSynapseCredentialResult(
        adapter_type=pulumi.get(__response__, 'adapter_type'),
        authentication=pulumi.get(__response__, 'authentication'),
        client_id=pulumi.get(__response__, 'client_id'),
        credential_id=pulumi.get(__response__, 'credential_id'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        schema=pulumi.get(__response__, 'schema'),
        schema_authorization=pulumi.get(__response__, 'schema_authorization'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        user=pulumi.get(__response__, 'user')))
